#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include <signal.h>
#include <sys/ipc.h>
#include <sys/msg.h>

/* #define DEBUG 1 */

/* +++ Message Typen +++ */
#define MSG_ANFORDERUNG 1	/* Anforderung zur Belegung eines B Kanals */
#define MSG_FREIGABE 2		/* Signalisierung der Freigabe des B Kanals */
#define MSG_ALIVE 3		/* ALIVE Meldung einer existierenden IP Verbindung */
#define MSG_CHECK 4		/* Aufforderung zur Untersuchung der Situation */
#define MSG_STATE 5		/* Aufforderung zur Zustandsbeschreibung */
#define MSG_QUIT 6		/* Aufforderung zur Beendigung des Serverprozesses  */


/* +++ Service Typen +++ */
#define FAX_SERVICE "FAX"	/* FAX Service */
#define SMS_SERVICE "SMS"	/* SMS Service */
#define BMFT_SERVICE "BMFT"	/* BMFT Service */
#define LMS_IP_SERVICE "LMS-IP"	/* IP Service (geschuetzte Verbindung */
#define B_CHANNEL "B-CHANNEL"	/* B Channel Service */




#define WQKEY 500
#define RQKEY 501
static int wqid= -1;
static int rqid= -1;

/*------------------------------------------------------------------------
   int lms_create_msgq()

   Aufgabe:
   --------
   Anlegen einer neuen Message-Queue.
   Wenn bereits eine Message-Queue besteht wird sie gel|scht und neu angelegt.
   Wird vom channeld aufgerufen.

   Parameter:
   ----------

   Returnwerte:
   ------------
   >= 0 OK
   -1   Fehler (Fehlerursache in errno)
----------------------------------------------------------------------*/
int lms_create_msgq()
{

   wqid=msgget(WQKEY, IPC_PRIVATE|0666);

#ifdef DEBUG
if(wqid < 0) printf("\nOpen Write Message-Queue failed!\n"); fflush(stdout);
#endif

   if(wqid < 0) return (-1);

   rqid=msgget(RQKEY, IPC_PRIVATE|0666);

#ifdef DEBUG
if(rqid < 0) printf("\nOpen Read Message-Queue failed!\n"); fflush(stdout);
#endif

   if(rqid < 0) return (-1);

   return(0);
}
/*------------------------------------------------------------------------ */
static void get_server_state()
{
int pid;

typedef struct {
char type;
int aktiv;
char bezeichnung[40];
} interface_nachricht;

typedef struct {
char type;
int aktiv;
char service[20];
char partner[40];
char von[40];
char bis[40];
char interface[40];
} reservierung_nachricht;

typedef struct {
char type;
char service[20];
char partner[40];
char interface[40];
char created[40];
int counter;
int pid;
} dienst_nachricht;

typedef struct {
char type;
int number_of_b_kanaele;
int freie_b_kanaele;
} b_cannal_nachricht;

struct {
long mtype;
char mtext[400];
} msg;

interface_nachricht *ptr_interface;
reservierung_nachricht *ptr_reservierung;
dienst_nachricht *ptr_dienst;
b_cannal_nachricht *ptr_b_cannal;
int rc;



pid=getpid();

ptr_interface=(interface_nachricht *) msg.mtext;
ptr_reservierung=(reservierung_nachricht *) msg.mtext;
ptr_dienst=(dienst_nachricht *) msg.mtext;
ptr_b_cannal=(b_cannal_nachricht *) msg.mtext;

while(1)	{

 rc = msgrcv(rqid,(struct msgbuf *)&msg,400, pid,0);
 if(rc < 0) return;

if(msg.mtext[0] == 10)
{
printf("\nEnde Server State Info\n"); fflush(stdout);
break;
}

if(msg.mtext[0] == 1)
{
printf("\nInterface Info %s", ptr_interface->bezeichnung); 

if(ptr_interface->aktiv) printf(" AKTIV"); else printf(" DEACTIV");
fflush(stdout);
continue;

}

if(msg.mtext[0] == 2)
{
printf("\nReservierung Info"); 

printf("\nService: %s Partner: %s von: %s bis: %s Interface: %s",
	ptr_reservierung->service,
	ptr_reservierung->partner,
	ptr_reservierung->von,
	ptr_reservierung->bis,
	ptr_reservierung->interface
	);

if(ptr_reservierung->aktiv) printf(" ACTIV"); else printf(" DEACTIV");

fflush(stdout);

continue;
}

if(msg.mtext[0] == 3)
{
printf("\nDienst Info"); 

printf("\nService: %s Partner: %s created: %s PID: %d Counter: %d Interface: %s",
	ptr_dienst->service,
	ptr_dienst->partner,
	ptr_dienst->created,
	ptr_dienst->pid,
	ptr_dienst->counter,
	ptr_dienst->interface
	);


fflush(stdout);

continue;
}

if(msg.mtext[0] == 4)
{

printf("\nAnzahl der B Kanaele: %d Frei(%d)\n",
	ptr_b_cannal->number_of_b_kanaele,
	ptr_b_cannal->freie_b_kanaele
	);


fflush(stdout);

}

continue;
		}

}
/*------------------------------------------------------------------------ */
typedef struct {
char service[40];
char partner[40];
char pid[10];
char user[40];
} snd_nachricht;

typedef struct {
char code[1];
} rcv_nachricht;

typedef struct {
long mtype;
snd_nachricht mtext;
} snd_queuemessage;

typedef struct {
long mtype;
rcv_nachricht mtext;
} rcv_queuemessage;

int lms_request(mtype, service, partner, user )
int mtype;
char *service;
char *partner;
char *user;
{
int pid;
int rc;
snd_queuemessage snd_msg;
rcv_queuemessage rcv_msg;

if(wqid < 0) return(-1);

#ifdef DEBUG
printf("\nLMS Request PID: %d",getpid()); fflush(stdout);
#endif


snd_msg.mtype=mtype;
pid=getpid();

if(
	mtype == MSG_ANFORDERUNG  &&
	strcmp(service,B_CHANNEL) == 0
) pid=0;

sprintf(snd_msg.mtext.pid,"%d",pid);
strcpy(snd_msg.mtext.service,service);
strcpy(snd_msg.mtext.partner,partner);
strcpy(snd_msg.mtext.user,user);

 rc = msgsnd(wqid,(struct msgbuf *)&snd_msg,sizeof(snd_nachricht), 0);
 if (rc < 0)
 {

 
#ifdef DEBUG
printf("\nSend Message-Queue failed!\n"); fflush(stdout);
#endif
   return(-1);
 }


 if(mtype == MSG_STATE)
{
get_server_state();
return;
}

 if(mtype == MSG_ANFORDERUNG && strcmp(service,B_CHANNEL))
 {

 if(rqid < 0) return(-1);


 rc = msgrcv(rqid,(struct msgbuf *)&rcv_msg,sizeof(rcv_nachricht), pid,0);
 if(rc < 0) return(-1);

 if(rcv_msg.mtext.code[0] == 1) return(-1); else return(0);
}
else
{
 return (0);
}

}
/* ********************************************************************* */
