#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>

#define FILE_SERVER_CFG "server.cfg"
#define MAX_TOKEN 30

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifdef R_UNIXWARE
#include <isdn/l_lib.h>
#endif

#include <pds/pdsisdn.h>
#include <pds/fetsrv.h>
#include "alived.h"

#define MSG_ANFORDERUNG 1	/* Anforderung zur Belegung eines B Kanals */
#define MSG_FREIGABE 2		/* Signalisierung der Freigabe des B Kanals */
#define MSG_ALIVE 3		/* ALIVE Meldung einer existierenden IP Verbindung */
#define MSG_CHECK 4		/* Aufforderung zur Untersuchung der Situation */
#define MSG_STATE 5		/* Aufforderung zur Zustandsbeschreibung */
#define MSG_QUIT 6		/* Aufforderung zur Beendigung des Serverprozesses  */

#define LMS_IP_SERVICE "LMS-IP"	/* IP Service (geschuetzte Verbindung */

extern int lms_request(int, char *, char *, char *);
extern int lms_create_msgq();


extern void send_alive(char *DeviceName, char *EAZ, char *Service, char *Rufnummer);
int get_host_by_ip          TB_PROTO(( unsigned long, char * ));
int prepare_d_alive(int rnr);
int send_d_alive(int rnr);
int end_d_alive(int fd);
int get_d_al_telno(unsigned long ip,robys_d_al_hd_typ **callp);
int init_d_alive_rec(int *fd,robys_d_al_hd_typ **callp);
int fill_my_info(void);
int process_d_alive(int fd,robys_d_al_hd_typ *callp,char *buffer);
int init_isdn(void);
int is_online               TB_PROTO(( int ));
char *hostbytelno(char *telno);
char *isi_bindir;
char *get_escape(char **escape);

extern int    	      debug,xdebug,xxdebug;
extern time_t         t;
extern int            sessmaxcnt;
extern int            fdcnt,d_al_fd;
extern char           tt[100];
extern struct servent srvalive_service;
extern struct servent sessalive_service;
extern struct servent killer_service;
extern int            alivesock;
extern int            srvalivesock;
extern int            killersock;
extern char           serverinfo[BUFSIZE];
extern struct pollfd  fds[2];
extern robys_d_al_hd_typ    d_al_callp;

extern fetsrvstat_typ       r_list[MAX_ROUTER];
extern sessionlist_typ      sessionlist[MAX_SESSIONS];
extern rem_sessionlist_typ  rem_sesslist[MAX_SESSIONS];
extern ziel_router_typ      ziel_router[MAX_ROUTER];
extern IsdnHostInfo         My_info;




struct token {
char name[30];
char value[40];
};

static time_t server_cfg_modify_date= 0;

struct server_cfg {
int belegt;
char sektion[40];
int count_of_token;
struct token tokens[MAX_TOKEN];
} *server_cfgs;
static int count_of_server_cfg=0;


/*--------------------------------------------------------------------*/

/*
typedef struct

{
   char  hostname[23];
   char  bez     [31];
   int   art;
   int   loeschen;
   char  login;
   char  nummer  [ISDN_MAX_RNR][ISDN_LEN_RUFNUMMER+1];
   char  ports   [ISDN_MAX_RNR][15];
   char  nrkz    [ISDN_MAX_RNR][3];
   char  ipadr   [16];
   char  ipadrf  [16];
   char  ipprot  [16];
   int   mintime;
   int   blocktime;
   char  vjhc;
   char  callback;
   char  out;
   char  euroisdn;
   int   lms_von;
   int   lms_bis;
}
   IsdnHost;
*/

/*
typedef struct
{ char          telno[16];
  char          hostname[16];
  unsigned short chargeticks;
  unsigned short dummy;
  unsigned long outcharge,
                incharge,
                outpkt,
                inpkt,
                outbytes,
                inbytes;
  char		d_alive_telno[16];
} IsdnHostInfo;
*/


/*************************************************************/
int prepare_d_alive(int rnr)
{
robys_d_al_hd_typ *callp;



callp = (robys_d_al_hd_typ *) malloc( 
	sizeof(robys_d_al_hd_typ) 
	);


if(callp == NULL) 
{
fprintf(stderr,"alived: alloc  t_call error prepare_d_alive\n");
return(0);
}


callp->DeviceName[0]=0;  
callp->EAZ[0]=0; 
callp->Service[0]=0; 
callp->Rufnummer[0]=0;

 if (!get_host_by_ip(ziel_router[rnr].ip,ziel_router[rnr].hostname))
 {
    fprintf (stderr,"alived: konnte Hostname von Ziel-ISDN-Router %s nicht bestimmen!\n",inet_ntoa(ziel_router[rnr].ip));
    return(0);
 }

callp->DeviceName[0]=0;  /* get next free isdn tty */
callp->EAZ[0]=0; 	/* abgehende Rufnummer at&E... */
callp->Service[0]=0; 	/* additional Info ats19=... */
callp->Rufnummer[0]=0;	/* Zielnummer atd=... */

/* Hier muessen die D Kanal Parameter zum Router ziel_router[rnr].ip bestimmt werden */
ziel_router[rnr].d_al_hand = callp;
return(1);
}

/*************************************************************/
int send_d_alive(int rnr)
{


 send_alive(
	ziel_router[rnr].d_al_hand->DeviceName, 
	ziel_router[rnr].d_al_hand->EAZ, 
	ziel_router[rnr].d_al_hand->Service, 
	ziel_router[rnr].d_al_hand->Rufnummer
	);


 return(0);
}

/*************************************************************************/
/* Diese Funktion wird nicht benutzt */
int get_d_al_telno(unsigned long ip,robys_d_al_hd_typ **callp)
{
 return (1);
}


/*************************************************************/
/*
Diese Funktion hat keine Bedeutung, da kein spezieller D Alive Empfang eingestellt wird!
*/
int fill_my_info(void)
{

    My_info.hostname[0];
    My_info.telno[0];
    My_info.d_alive_telno[0];


 if (debug)
 {
    fprintf(stderr,"My_info.hostname      = %s\n",My_info.hostname);
    fprintf(stderr,"My_info.telno         = %s\n",My_info.telno);
    fprintf(stderr,"My_info.d_alive_telno = %s\n",My_info.d_alive_telno);
 }
 return(1);
}

/*************************************************************/
/* Wird nicht benutzt */
int init_d_alive_rec(int *fd,robys_d_al_hd_typ **callp)
{
 return (1);
}


/*************************************************************/
/*
Diese Funktion hat keine Bedeutung, da der alived Server nur ueber
einen Deskr. pollt!
*/
int process_d_alive(int fd,robys_d_al_hd_typ *callp,char *buffer)
{
 return (1);
}


/*************************************************************/
static void read_server_cfg()
{
struct server_cfg *ptr;
int count;
char c;
int section;
int offset;
char zeile[200];
int fp;
int rc;
struct stat stat_buffer;

rc=stat(FILE_SERVER_CFG,&stat_buffer);
if(rc) return;


if(server_cfg_modify_date == stat_buffer.st_mtime) return;

server_cfg_modify_date = stat_buffer.st_mtime;

if(server_cfgs != NULL) free(server_cfgs);
server_cfgs = NULL;
count_of_server_cfg=0;


fp=open(FILE_SERVER_CFG,O_RDONLY);
if(fp < 0) return;

/* printf("\nOpen OK"); fflush(stdout); */

count_of_server_cfg=0;
server_cfgs= NULL;
count=0;
section=0;
offset=0;

while(1)	{
rc=read(fp,&c,1);
if(rc != 1) break;

if(c == '\n')
{
zeile[offset]=0;

offset=0;

if(section == 0 && zeile[0] == '[')
{
zeile[strlen(zeile) -1]=0;

/* printf("\nSection %s", &zeile[1]); */

if(count_of_server_cfg >= count)
{
int i;

server_cfgs= realloc(server_cfgs, 
	sizeof(struct server_cfg) * (count + 100) );

if(server_cfgs == NULL)
{
count_of_server_cfg=0;
return;
}

for(i=count; i< count+100; i++)
{
(server_cfgs+i)->belegt=0;
}

count+=100;
}
ptr= (server_cfgs+count_of_server_cfg);



ptr->belegt=1;
ptr->count_of_token=0;
strcpy(ptr->sektion,&zeile[1]);
count_of_server_cfg++;

section=1;
continue;
}

if(zeile[0] == 0 && section)
{
section=0;
}


if(section == 0) continue;
{
int i;

for(i=0; i< strlen(zeile); i++)
{
if(zeile[i] == '=') break;
}

if (i == strlen(zeile) ) continue;
if(ptr->count_of_token < MAX_TOKEN)
{
zeile[i]=0;
strcpy(ptr->tokens[ptr->count_of_token].name,zeile);
strcpy(ptr->tokens[ptr->count_of_token].value, &zeile[i+1]);
/* printf("\nToken: %s Value: <%s>",zeile,&zeile[i+1]); */
ptr->count_of_token++;
}


}


continue;
}


if(offset > 39) continue;
zeile[offset]=c;
offset++;
		}


if(section)
{
section=0;
}

close(fp);
}
/*************************************************************/
/*
*/
static void isdn_konf_lesen()
{
if(count_of_server_cfg==0) server_cfgs = NULL; 

read_server_cfg();
}
/*************************************************************/
int init_isdn(void)
{
static int first_time=1;

 if (first_time)
 {
    first_time = 0;
    if (debug)
       fprintf (stderr,"Initialisierung der ISDN-Bereiche\n");

    isdn_konf_lesen();
    fill_my_info();
 }

 return (1);
}
/* ********************************************************************* */
/* 
Test, ist der Anschluss <phone> aktiv, d.h. in der phone Liste enthalten
Das Device /dev/isdninfo liefert folgende Informationen:
Name der ISDN Schnittstelle + Anzahl der B Kanaele je ISDN Schnittstelle 
idmap:  Tel0 Tel0 - -
chmap:  0 1 -1 -1 
usage:  2 0 0 0 
flags:  1 ? ? ? 
phone:  141 ??? ??? ??? 
*/

static int found_phone(phone)
char *phone;
{
char name[80];
int i,offset;
char buffer[10000];
int fp;
int rc;
char c;
int nl;
int mode;

fp=open("/dev/isdninfo",O_RDONLY|O_NONBLOCK);
if(fp < 0) return(0);


/* 
Lesen vom device und Analyse der gelesenen Daten 
Der Output muss in den Puffer passen!!! max: 9999 Bytes
*/

offset=0;
while(1)
{
rc=read(fp,&buffer[offset],4096);
if(rc <= 0) break;
if(offset+rc > 10000) break;
offset+=rc;
}

close(fp);

buffer[offset]=0;



/* Analyse der gelesen Info's */
nl=0;

for(i=0; i<strlen(buffer); i++)	{
if(buffer[i] == '\n') nl++;
if(nl == 5) break;
				}

if( i == strlen(buffer)) return(0);



/* Positionierung nach Tabuator */

for(; i<strlen(buffer); i++)	{
if(buffer[i] == '\t') break;
				}

if( i == strlen(buffer)) return(0);


/* Nun die Tel. Nr suchen */
mode=0;
offset=0;

for(; i<strlen(buffer); i++)	{

if(mode == 0)
{
if(buffer[i] == ' ') continue;
if(buffer[i] == '\t') continue;
if(buffer[i] == '\n') continue;
mode=1;
}

if(mode)
{

if(
	buffer[i] == ' ' ||
	buffer[i] == '\t' ||
	buffer[i] == '\n'
	) 
{
mode=0;
name[offset]=0;

if(strcmp(name,phone) == 0) return(1);
offset=0;
continue;
}

name[offset]= buffer[i];
offset++;

}

				}

if(mode && offset)
{
mode=0;
name[offset]=0;

if(strcmp(name,phone) == 0) return(1);
}

return(0);

}
/*************************************************************/
/*
Verarbeitung des B Kanal Trace (analog der Funktion zur Ermittlung der ISDN Kanalinformationen)
Router[rnr] --> Rufnummer --> In der Menge der Rufnnummern die einem B Kanal zugeordnet sind?
*/
int is_online(int rnr)
{
int rw;

 if (xxdebug)
 {
    fprintf (stderr,"alived: vor is_online\n");
 }

 if (ziel_router[rnr].hostname[0] == 0)
 {
    fprintf (stderr,"Hostname von Zielrouter %s ist nicht bekannt!\n",
             inet_ntoa(ziel_router[rnr].ip));
    return (-1);
 }


rw=found_phone(ziel_router[rnr].iptelno);

if (xdebug)
    if (rw)
       fprintf (stderr,"alived: Router %s ist online!\n",ziel_router[rnr].hostname);
    else
       fprintf (stderr,"alived: Router %s ist NICHT online!\n",ziel_router[rnr].hostname);

return(rw);
}

/*************************************************************/
/* 
Diese Funktion ist wichtig:
Tel.- Nr. ---> Rechnername
*/
char *hostbytelno(char *telno)
{
	return("");
}

/*************************************************************/
/*
Wird ueberarbeitet!
*/
char *get_escape(char **escape)
{
	return("");
}
/*************************************************************/
/*
Fuer das Versenden von D Alive's ist kein Deskriptor offen, daher
hier auch keine Funktionalitaet notwendig.
*/
int end_d_alive(int fd)
{
    return (0);
}
/*************************************************************/
static int init_queue_to_channel_d()
{
static int status = -1;

if(status != -1) return(status);
status=lms_create_msgq();

return(status);
}
/*************************************************************/
int isdn_lms_stop(char *partner)
{
if(init_queue_to_channel_d()) return(1);

lms_request(MSG_FREIGABE, LMS_IP_SERVICE, partner, "...");
return(0);
}
/*************************************************************/
int isdn_lms_start(char *partner)
{
if(init_queue_to_channel_d()) return(1);
lms_request(MSG_ANFORDERUNG, LMS_IP_SERVICE, partner, "...");
return(0);
}
/*************************************************************/
/*
Bestimmung der Tel. Nr die einem Ziel Router zugeordnet wurde.
Diese Funktion wurde eingefuehrt, fuer den is_online Test.
*/
int get_ip_telno(int rnr)
{
ziel_router[rnr].iptelno[0]=0;
if (ziel_router[rnr].hostname[0] == 0) return(0);

/*
get_telno_from_konfiguration(
	ziel_router[rnr].hostname,
	ziel_router[rnr].iptelno
	);
*/
return(0);
}
/***************************************************************************/
unsigned long get_router(unsigned long unix_ip)
{
 static unsigned long timeout=0;
 static int firsttime=1;
 static struct
 {
   unsigned long zielnetz;
   unsigned long gateway;
   int           is_gw;
 } route[200];
 unsigned long now=time(0);
 unsigned long zielnetmask;
 char *fname={"/usr/tmp/routelist"};
 char *param={" -nr | grep '\\.' | grep U >"};
 char command[100];
 char *zielnet;
 FILE *fptr;
 char buf[200];
 int  res,rn;
 struct stat statbuf;

 if (firsttime || (now > timeout))
 {      /* nur isdn-routen, die Used sind */
    strcpy (command,"/bin/netstat");
    if (stat(command,&statbuf))
    {
          fprintf (stderr, "alived: konnte 'netstat' nicht finden!\n");
          return (0);
    }

    sprintf (buf,"%s%s%s",command,param,fname);
    res=system(buf); /*achtung roby */
    if (res)
    {
       fprintf (stderr, "alived: %s fehlgeschlagen\n",buf);
       return (0);
    }
    fptr = fopen(fname,"rb+");
    if (!fptr)
    {
       fprintf (stderr, "alived: konnte %s nicht |ffnen!\n",fname);
       return (0);
    }

    rn=0;
    while (fgets(buf,200,fptr))
    {
       buf[15] = 0;
       route[rn].is_gw = 0;
       route[rn].zielnetz = 0;
       route[rn].zielnetz = get_nwaddr(buf);
       if (route[rn].zielnetz == 0)
          continue;

       { /* interactive und unixware */
          buf[16+15] = 0;
          route[rn].gateway = inet_addr(&buf[16]);
       }
       if (route[rn].gateway == 0)
       {
          route[rn].zielnetz = 0;
          continue;
       }
       if (buf[49] == 'G')
          route[rn].is_gw = 1;
       rn++;
    }
    fclose (fptr);
    if (firsttime)
       timeout = now + 30;  /* falls sich die tabellen beim weiteren hochfahren noch dndern */
    else
       timeout = now + 300; /* falls sich die routen {ndern */
    firsttime = 0;
 }
 /* ab hier sind in route alle direkt erreichbaren Router und die dar}ber
    erreichbaren Netze verf}gbar */

 /* zundchst alle direkt erreichbaren durchsuchen */
 for (rn=0;route[rn].zielnetz != 0; rn++)
 {
    if (unix_ip == route[rn].gateway)
       return(route[rn].gateway);
 }

 /* nun die erreichbaren netze durchsuchen, und den Router f}r das Zielnetz
    zur}ckgeben */

 for (rn=0;route[rn].zielnetz != 0; rn++)
 {
    zielnet=(char *)&(route[rn].zielnetz);
    /*   zielnetmask = 0xffffffff; wird von gcc angemeckert */
    /*
    memset (&zielnetmask,0xff,4);
    */
    zielnetmask = 0xffffffffUL;
    if (!zielnet[3])
       zielnetmask = 0xffffff;
    if (!zielnet[2])
       zielnetmask = 0xffff;
    if (!zielnet[1])
       zielnetmask = 0xff;
    if ((unix_ip & zielnetmask) == (route[rn].zielnetz))
       if (route[rn].is_gw)
          return(route[rn].gateway);
       else
          return(unix_ip);
 }

 /* hat nicht geklappt */
 return (0);
}
/*************************************************************/
/* Durchsuchen der Sektions nach einer identischen IP Adresse */
static int get_ip_from_konfiguration(unsigned long ip, char *	hostname)
{
unsigned long ip_adresse;
struct server_cfg *ptr;
int i,j;

for(i=0; i< count_of_server_cfg; i++)		{
ptr= (server_cfgs+i);


for(j=0; j < ptr->count_of_token; j++)
{
if(strcmp(ptr->tokens[j].name, "IpAdresse")) continue;

if(ptr->tokens[j].value[0] == 0) continue;

ip_adresse=inet_addr(ptr->tokens[j].value);
if(ip_adresse == ip)
{
strcpy(hostname,ptr->sektion); 

/*
printf("\nSektion: %s",ptr->sektion); fflush(stdout);
printf("\nToken: %s Value: <%s> Adresse: %x", 
	ptr->tokens[j].name, ptr->tokens[j].value,ip_adresse);
*/

return(1);
}

}
						}
return(0);
}
/*************************************************************************/
/*
Return: 1 Hostname found
Return: 0 Hostname not found
*/
int get_host_by_ip(unsigned long ip,char *hostname)
{
unsigned long router_ip;

/* Ermittlung der IP Nummer des zugehoerigen Routers */
router_ip = get_router(ip);

/* Bezeichnung des Routers aus den Konfigurations Daten ermitteln */

*(hostname)=0;
return(get_ip_from_konfiguration( router_ip, hostname));
}
/*************************************************************/
static unsigned long bcast_addr=0;
static unsigned long lo_bcast_addr=0;

unsigned long get_broadcast_addr(int type)
{
unsigned long adr;
int i,j;
int mode;
char buffer[300];
FILE *fp;
char command[200];

switch(type)	{
case 0:
  	return(inet_addr("127.0.0.1")); 
	if(lo_bcast_addr) return(lo_bcast_addr);
	break;
default:
	if(bcast_addr) 
	{
	return(bcast_addr);
	}
	break;
		}


sprintf(command,"ifconfig > /usr/tmp/ifconfig_output");
system(command);

fp=fopen("/usr/tmp/ifconfig_output","rb+");
if(fp == NULL) return(0);

mode=0;
while(fgets(buffer,200,fp))
{

if(mode == 0)
{

switch(type)	{
case 0: if(memcmp(buffer,"l0 ",3)) continue;
default: if(memcmp(buffer,"eth0 ",5)) continue;
		}

mode=1;
}


if(mode)
{
for(i=0; i< strlen(buffer); i++)	{
if(memcmp(&buffer[i],"Bcast:",6)) continue;
i+=6;
j=i;
for(j=i; buffer[j] != ' '; j++);
buffer[j]=0;

fclose(fp);

switch(type)	{
case 0: adr=lo_bcast_addr= inet_addr(&buffer[i]);
default: adr=bcast_addr= inet_addr(&buffer[i]);
		}

return(adr);
					}
}


}

fclose(fp);

return(0);
}
/*************************************************************/
