#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include <signal.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <errno.h>
#include "lms.h"



#define DEBUG 1 


/* +++++++++++++++ Message Queue Identifier's +++++++++++++++++++++++ */
#define RQKEY 500
#define WQKEY 501



/* ++++++++++++++ Konstanten, fuer die Speicherreservierung ++++++++ */
#define MAX_ROUTE 20
#define MAX_ALIVE_TIME_DIFF 1000
#define MAX_ISDN_SS 20
#define MAX_INTERFACES 20
#define MAX_RESERVIERUNGEN 40
#define MAX_DIENSTE 20



/* +++ IP Interface Informationen +++ */
typedef struct {
int status;		/* 0/1 1: gueltige Information */
int aktiv;		/* 0/1 1: Das Interface ist momentan aktiv. */
char bezeichnung[80];	/* Interfacebezeichnung */
char incoming[40];	/* Incoming Number */
char outgoing[40];	/* Outgoing Number */
} INTERFACE;

/* Array der Interfaces */
static INTERFACE interfaces[MAX_INTERFACES];



/* +++ Reservierungsinformationen +++ */

typedef struct {
int status;		/* 0/1 1: gueltige Information*/
char service[20]; 	/* FAX, SMS, CITY, IP, BMFT */
char partner[80];	/* Partnerbezeichnung */
int von_hh;		/* Startzeit der Reservierung */
int von_min;		/* Startzeit der Reservierung */
int bis_hh;		/* Endezeit der Reservierung */
int bis_min;		/* Endezeit der Reservierung */
int aktiv;		/* 0/1 1: Die Reservierung ist momentan aktiv. */
INTERFACE *interface;	/* reserviertes Interface */
char user[40];		/* Benutzerbezeichnung */
} RESERVIERUNG;

/* Array fuer die Reservierungen */
static RESERVIERUNG reservierungen[MAX_RESERVIERUNGEN];




/* +++ Informationen ber die aktiven Dienste +++ */

typedef struct {
int status;		/* 0/1 1: gueltige Information*/
char service[20]; 	/* FAX, SMS, CITY, IP, BMFT */
char partner[80];	/* Partneridentifikation */
INTERFACE *interface;	/* benutzes IP Interface */
time_t von;		/* Zeitpunkt seitdem der Dienst aktiv ist. */
time_t alive;		/* Zeitpunkt seitdem letzten ALIVE (geschutzte IP-Verb.). */
int mode;		/* benutzt fuer die Berechnung der freien B Kanaele */
int pid;		/* Prozessnummer */
char user[80];		/* Benutzerbezeichnung */
int counter;		/* Zaehler */
} DIENST;

static DIENST dienste[MAX_DIENSTE];


/* +++ Informationen ber die ISDN-Schnittstellen +++ */

typedef struct {
char bezeichnung[80];	/* Bezeichnung der ISDN SS */
int b_kanaele;		/* Anzahl der verfuegbaren B Kanaele am ISDN Anschluss */
} ISDN_SS;


			/* ISDN SS array */
static ISDN_SS ISDN[MAX_ISDN_SS];

			/* Anzahl der ISDN Schnittstellen */
static int number_of_isdn_ss=0;
			/* Anzahl der gesamten B Kanaele im System */
static int number_of_b_kanaele=0;

			/* Anzahl der gesamten noch frei verfuegbaren B Kanaele im System */
static int freie_b_kanaele=0;

			/* Message Queue Deskriptoren */
static int rqid;	/* Read Queue Deskriptor */
static int wqid;	/* Write Queue Deskriptor */


			/* PID des CLOCK Prozesses */
static int clock_prozess;


/* ++++ Struktur zur Speicherung der routing Info +++++ */
/* Diese Struktur bildet die Basis zur Interfacebestimmung bei IP Anmeldungen */
struct {
int status;		/* 0/1   1: belegt */
int use_gateway;	/* [FLAG G gesetzt] */	
char destination[30];	/* Destination */
char gateway[30];	/* Gateway */
char genmask[30];	/* Genmask */
char iface[40];		/* Use Interface */
int was_deleted;	/* Die Route wurde nach dem ifconfig down geloescht. */
} mem_route[MAX_ROUTE];

/* ++++ Struktur zur Speicherung der routing Info (Momentaufnahme) +++++ */
/* 
   Diese Struktur wird benutzt, um bei der Aktivierung von Interfaces die
   entsprechenden routen setzen zu koenneni (Abgleich mit mem_route).
*/ 
struct {
int status;		/* 0/1   1: belegt */
int use_gateway;	/* [FLAG G gesetzt] */
char destination[30];	/* Destination */
char gateway[30];	/* Gateway */
char genmask[30]; 	/* Genmask */
char iface[40];		/* Use Interface */
} ist_route[MAX_ROUTE];


/* Prototyping */
static void aktivierung_route(char *);
static int speicherung_ist_ip_routen();


/* +++ Message Data fuer die Generierung der Server Status Info +++ */

/* ********************************************************************* */
/* Grundinitialisierung der route info's */
static void init_route_info()
{
int i;

#ifdef DEBUG
printf("\nINIT MEM_ROUTE\n"); fflush(stdout);
#endif

for(i=0; i< MAX_ROUTE; i++)		{
mem_route[i].status=0;
					}
}
/* ********************************************************************* */
/* Grundinitialisierung der route info's (Momentaufnahme) */
static void init_ist_route_info()
{
int i;

for(i=0; i< MAX_ROUTE; i++)		{
ist_route[i].status=0;
					}
}
/* ********************************************************************* */
/* Eintragen einer route info (Momentaufnahme) */
static void insert_route_info(destination, gateway, genmask, iface, use_gateway)
char *destination;
char *gateway;
char *genmask;
char *iface;
int use_gateway;
{
int i;

#ifdef DEBUG
printf("\nINSERT MEM_ROUTE %s",destination); fflush(stdout);
#endif

for(i=0; i< MAX_ROUTE; i++)		{
if(mem_route[i].status == 0) continue;

if(strcmp(mem_route[i].destination,destination) == 0) 
{
if(
	strcmp(mem_route[i].gateway,gateway) == 0  &&
	strcmp(mem_route[i].iface,iface) == 0  &&
	strcmp(mem_route[i].genmask,genmask) == 0 
   )
	{
	return;
	}
	else
	{
	/* Loeschen der Info? */
	if(mem_route[i].was_deleted) return;
	mem_route[i].status = 0;
	}
}

					}


for(i=0; i< MAX_ROUTE; i++)		{
if(mem_route[i].status) continue;
mem_route[i].status=1;
strcpy(mem_route[i].destination,destination);
strcpy(mem_route[i].gateway,gateway);
strcpy(mem_route[i].genmask,genmask);
strcpy(mem_route[i].iface,iface);
mem_route[i].use_gateway=use_gateway;
mem_route[i].was_deleted=0;	
return;
					}


}
/* ********************************************************************* */
/* Eintragen einer route info (Momentaufnahme) */
static void insert_ist_route_info(destination, gateway, genmask, iface, use_gateway)
char *destination;
char *gateway;
char *genmask;
char *iface;
int use_gateway;
{
int i;

for(i=0; i< MAX_ROUTE; i++)		{
if(ist_route[i].status == 0) continue;

if(strcmp(ist_route[i].destination,destination) == 0) 
{
if(
	strcmp(ist_route[i].gateway,gateway) == 0  &&
	strcmp(ist_route[i].iface,iface) == 0  &&
	strcmp(ist_route[i].genmask,genmask) == 0 
   )
	{
	return;
	}
	else
	{
	/* Loeschen der Info */
	ist_route[i].status = 0;
	}
}

					}


for(i=0; i< MAX_ROUTE; i++)		{
if(ist_route[i].status) continue;

#ifdef DEBUG
printf("\nInsert IST ROUTE TABLE Destination: %s",destination);
printf("\nGateway %s",gateway);
printf("\nGenmask %s",genmask);
printf("\nIface %s\n",iface);
#endif

strcpy(ist_route[i].destination,destination);
strcpy(ist_route[i].gateway,gateway);
strcpy(ist_route[i].genmask,genmask);
strcpy(ist_route[i].iface,iface);
ist_route[i].use_gateway=use_gateway;
ist_route[i].status=1;
return;
					}


}
/*------------------------------------------------------------------------
   int lms_create_msgq()

   Aufgabe:
   --------
   Anlegen einer neuen Message-Queue.
   Wenn bereits eine Message-Queue besteht wird sie geloescht und neu angelegt.

   Parameter:
   ----------

   Returnwerte:
   ------------
   = 0  OK 
   -1   Fehler (Fehlerursache in errno)
----------------------------------------------------------------------*/
int lms_create_msgq()
{
 struct msqid_ds buf;

   /* Existiert die Queue, dann entfernen der Queue */
   if ((rqid=msgget(RQKEY, IPC_PRIVATE|0666)) != -1)
      msgctl(rqid, IPC_RMID, &buf);

   /* Anlegen der Queue */
   rqid=msgget(RQKEY, IPC_CREAT|0666);
   if(rqid < 0) return(-1);

   /* Existiert die Queue, dann entfernen der Queue */
   if ((wqid=msgget(WQKEY, IPC_PRIVATE|0666)) != -1)
      msgctl(wqid, IPC_RMID, &buf);

   /* Anlegen der Queue */
   wqid=msgget(WQKEY, IPC_CREAT|0666);
   if(wqid < 0) return(-1);



   return(0);
}


/*------------------------------------------------------------------------
   int remove_msgq()

   Aufgabe:
   --------
   Entfernen der Message-Queue.

   Parameter:
   ----------
   msgqid  ID der Queue

   Returnwerte:
   ------------
   0    OK
   -1   Fehler (Fehlerursache in errno)
----------------------------------------------------------------------*/
int remove_msgq()
{
 struct msqid_ds buf;

   if(rqid >= 0) msgctl(rqid, IPC_RMID, &buf);
   if(wqid >= 0) msgctl(wqid, IPC_RMID, &buf);

   rqid= -1;
   wqid= -1;

   return (0);
}

/* ********************************************************************* */
/*
Grundinitialisierung der IP Interface Info's 
*/
static void init_interfaces()
{
int i;

for(i=0; i < MAX_INTERFACES; i++)	{
interfaces[i].status=0;
					}

}
/* ********************************************************************* */
/*
Grundinitialisierung der Reservierungs Info's 
*/
static void init_reservierungen()
{
int i;

for(i=0; i < MAX_RESERVIERUNGEN; i++)	{
reservierungen[i].status=0;
					}

}
/* ********************************************************************* */
/*
Kennzeichnung Interface <bezeichnung> ist aktiv.
*/
static void aktiv_interface(bezeichnung)
char *bezeichnung;
{
int i;
char commando[200];

#ifdef DEBUG
printf("\nAktivierung Interface: %s", bezeichnung); 
fflush(stdout);
#endif

for(i=0; i < MAX_INTERFACES; i++)	{

/* Interface-Struktur-Element ermitteln */
if(
	interfaces[i].status  &&
	strcmp(interfaces[i].bezeichnung, bezeichnung) == 0
  )
{
char filename[200];

/* Aktivierung des Interfaces: ifconfig <bezeichnung> up */

sprintf(commando,"ifconfig %s up", interfaces[i].bezeichnung);
system(commando);

/* Aktivierung der Routen die sich auf jenes Interface beziehen. */
aktivierung_route(interfaces[i].bezeichnung);

/* Interface ist aktiv! */
interfaces[i].aktiv =1;
return;
}

					}



}
/* ********************************************************************* */
/* Eintragen eines Interfaces: Bezeichnung + Rufnummern */
static void insert_interface(bezeichnung,incoming, outgoing)
char *bezeichnung;
char *incoming;
char *outgoing;
{
int i;

for(i=0; i < MAX_INTERFACES; i++)	{

if(
	interfaces[i].status  &&
	strcmp(interfaces[i].bezeichnung, bezeichnung) == 0
  )
{
/* Ueberschreiben der Info */
interfaces[i].aktiv =1;
strcpy(interfaces[i].incoming, incoming);
strcpy(interfaces[i].outgoing, outgoing);
return;
}

					}


/* Suche nach freien Platz in interfaces[] */

for(i=0; i < MAX_INTERFACES; i++)	{


if(interfaces[i].status == 0)
{
/* Neuen Eintrag vornehmen */
interfaces[i].status =1;
interfaces[i].aktiv =1;
strcpy(interfaces[i].bezeichnung, bezeichnung);
strcpy(interfaces[i].incoming, incoming);
strcpy(interfaces[i].outgoing, outgoing);
return;
}

					}


}
/* ********************************************************************* */
/*
Ermittlung der routen die durch den ifconfig Befehl geloescht wurden.
Vergleich mem_route[] mit ist_route[], liefert die Info fuer jene Routen
die durch den ifconfig down Befehl passiert wurden.
*/
static void markierung_del_route(s)
char *s;
{
int i,j;

for(i=0; i< MAX_ROUTE; i++)		{
if(mem_route[i].status == 0) continue;

if(strcmp(mem_route[i].iface,s) == 0) 
{
/* Ist die Route noch aktiv (ist_route[] enthaelt dir route noch?) ? */

for(j=0; j< MAX_ROUTE; j++)		{
if(ist_route[j].status == 0) continue;
if(strcmp(ist_route[j].iface,s)) continue;

if(
	strcmp(ist_route[j].gateway,mem_route[i].gateway) == 0  &&
	strcmp(ist_route[j].iface,mem_route[i].iface) == 0  &&
	strcmp(ist_route[j].genmask,mem_route[i].genmask) == 0 
   ) break;

					}


if(j< MAX_ROUTE) continue;

#ifdef DEBUG
printf("\nDie Route %s %s wurde geloescht durch den ifconfig down Befehl",
	mem_route[i].destination,
	mem_route[i].iface );
fflush(stdout);
#endif

/* Kennzeichnung, die Route wurde geloescht */
mem_route[i].was_deleted=1;
}

					}
}
/* ********************************************************************* */
/*
Kennzeichnung Interface <bezeichnung> ist deaktiv.
*/
static void deaktiv_interface(bezeichnung)
char *bezeichnung;
{
int i;
char commando[120];

#ifdef DEBUG
printf("\nPassivierung Interface: %s", bezeichnung); 
fflush(stdout);
#endif

for(i=0; i < MAX_INTERFACES; i++)	{

if(
	interfaces[i].status  &&
	strcmp(interfaces[i].bezeichnung, bezeichnung) == 0
  )
{

/* das Interface abschalten */
sprintf(commando,"ifconfig %s down", interfaces[i].bezeichnung);
system(commando);

/* Merker auf deaktiv setzen */
interfaces[i].aktiv = 0;

/* Ermittlung der momentan verfuegbaren routen --> ist_route[] */
{
char filename[200];
char commando[200];

sprintf(filename,"/tmp/route_%d.lst",getpid());

sprintf(commando,"route -n > %s",filename);
system(commando);


/* Initialisierung ist_route[] */
init_ist_route_info();


/* Analyse des Output und Speicherung in ist_route[] */
speicherung_ist_ip_routen();


/* Ermittlung der geloschten routen */
markierung_del_route(interfaces[i].bezeichnung);

/* Loeschen der Output Datei */
unlink(filename);
}



return;
}

					}


}
/* ********************************************************************* */
/* Identifizeurung des Interfaces aus der partner Bezeichnung: Rufnummer */
static INTERFACE *ber_b_interface(partner)
char *partner;
{
int i;

/* Durchsuchen interfaces[] */

for(i=0; i < MAX_INTERFACES; i++)	{

if(
	interfaces[i].status  &&
	strcmp(interfaces[i].incoming, partner) == 0
  )
{
/* Das Interface wurde identifiziert */
return(&interfaces[i]);
}

if(
	interfaces[i].status  &&
	strcmp(interfaces[i].outgoing, partner) == 0
  )
{

/* Das Interface wurde identifiziert */
return(&interfaces[i]);
}

					}

/* Das Interface konnte nicht bestimmt werden */
return(NULL);
}
/* ********************************************************************* */
/* 
Die Ip Adresse <adresse> wird zerlegt in 4 Bestandteile die durch einen
Punkt voneinander getrennt sind.
*/

static void ber_ip_adresse(adresse, ip1,ip2,ip3, ip4)
char *adresse;
unsigned char *ip1;
unsigned char *ip2;
unsigned char *ip3;
unsigned char *ip4;
{
int value;
char wert[40];
int stelle,i,j;

stelle=0;
*ip1=0;
*ip2=0;
*ip3=0;
*ip4=0;

j=0;

for(i=0; i<strlen(adresse); i++)		{
if(*(adresse+i) == '.')
{
wert[j]=0;
/* printf("\n<%s>",wert);  */
sscanf(wert,"%d",&value);


switch(stelle)	{
case 0:
	*ip1 = value;
	break;
case 1:
	*ip2 = value;
	break;
case 2:
	*ip3 = value;
	break;
case 3:
	*ip4 = value;
	break;
		}
j=0;
stelle++;
continue;
}
wert[j]= *(adresse+i);
j++;
						}
}
/* ********************************************************************* */
/*
Input: /tmp/ifconfig_<pid>.lst

eth0      Link encap:10Mbps Ethernet  HWaddr 00:00:C0:C2:29:53
          inet addr:192.68.2.19  Bcast:192.68.2.255  Mask:255.255.255.0
          UP BROADCAST RUNNING MULTICAST  MTU:1500  Metric:1
          RX packets:32708 errors:0 dropped:0 overruns:0
          TX packets:17315 errors:0 dropped:0 overruns:0
          Interrupt:10 Base address:0x310 Memory:cc000-d0000 

	adresse: zu vergleichende Adresse


Return: 0/1    0: nicht als ip Interface identifiziert
	name: Bezeichnung des identifizierten Interfaces

Fuer den Vergleich werden die Attribute inet addr: und Mask: verwendet.

*/


static int ident_ip_interface(adresse,name)
char *adresse;
char *name;
{
int adr_ip1,adr_ip2,adr_ip3, adr_ip4;
unsigned char inet_ip1,inet_ip2,inet_ip3, inet_ip4;
unsigned char mask_ip1,mask_ip2,mask_ip3, mask_ip4;
int i;
char interface_name[80];
char filename[80];
char inet_addr[80];
char inet_mask[80];
int mode;
int offset,rc;
char buffer[400];
int fp;


/* Das Ergebnis-Namensfeld initialisieren */
*(name)=0;

sprintf(filename,"/tmp/ifconfig_%d.lst",getpid());
fp=open(filename,O_RDWR);
if(fp < 0) return(0);



mode=0;
offset=0;

while(1)		{
rc=read(fp,&buffer[offset],1);
if(rc != 1) break;
if(buffer[offset] == 0x0a)
{
buffer[offset] = 0;
/* printf("\n%s",buffer); */

offset=0;
switch(mode)		{
case 0:
	/* Interface Bezeichnung speichern */
	strcpy(interface_name,"");

	for(i=0; i<strlen(buffer); i++)
	{
	if(buffer[i] == ' ') break;
	}

	buffer[i] = 0;

	strcpy(interface_name,buffer);
	mode=1;
	break;
case 1:
	strcpy(inet_mask,"255.255.255.255");
	strcpy(inet_addr,"0.0.0.0");

	/* inet addr: und Mask: ermitteln */
	for(i=0; i<strlen(buffer); i++)	{

	if(memcmp(&buffer[i],"inet addr:",10) == 0)
	{
	int j,k;

	j=0;

	for(k=i+10; k<strlen(buffer); k++)
	{
	if(buffer[k] == ' ') break;
	inet_addr[j]=buffer[k];
	j++;
	}

	inet_addr[j]=0;
	}

	if(memcmp(&buffer[i],"Mask:",5) == 0)
	{
	int j,k;

	j=0;

	for(k=i+5; k<strlen(buffer); k++)
	{
	if(buffer[k] == ' ') break;
	inet_mask[j]=buffer[k];
	j++;
	}

	inet_mask[j]=0;
	}



				}

/*
	printf("\nAdresse: %s Interface: %s inet addr: %s Mask: %s",
	adresse,
	interface_name,
	inet_addr,
	inet_mask
	);
*/

	/* Die IP Adressen in Einzelteile zerlegen */

	ber_ip_adresse(adresse, &adr_ip1,&adr_ip2,&adr_ip3, &adr_ip4);
	strcat(inet_addr,".");
	ber_ip_adresse(inet_addr, &inet_ip1,&inet_ip2,&inet_ip3, &inet_ip4);
	strcat(inet_mask,".");
	ber_ip_adresse(inet_mask, &mask_ip1,&mask_ip2,&mask_ip3, &mask_ip4); 

/*
	printf("\n%d %d %d", (unsigned char )adr_ip1, mask_ip1, inet_ip1);
	printf("\n%d %d %d", adr_ip2, mask_ip2, inet_ip2);
	printf("\n%d %d %d", adr_ip3, mask_ip3, inet_ip3);
	printf("\n%d %d %d", adr_ip4, mask_ip4, inet_ip4);
*/

	/* Die Maskierungen vornehmen */
	adr_ip1 = adr_ip1 & mask_ip1;
	adr_ip2 = adr_ip2 & mask_ip2;
	adr_ip3 = adr_ip3 & mask_ip3;
	adr_ip4 = adr_ip4 & mask_ip4;

	inet_ip1 = inet_ip1 & mask_ip1;
	inet_ip2 = inet_ip2 & mask_ip2;
	inet_ip3 = inet_ip3 & mask_ip3;
	inet_ip4 = inet_ip4 & mask_ip4;

	/* Jetzt der Vergleich */
	if(
	adr_ip1 == inet_ip1 &&
	adr_ip2 == inet_ip2 &&
	adr_ip3 == inet_ip3 &&
	adr_ip4 == inet_ip4
	)
	{

	/* Die IP Adressen gehoeren zum gleichen Netzwerk */
	strcpy(name,interface_name);
	close(fp);

	/* signalisiert, gefunden */
	return(1);
	}
	mode=2;
	break;
default:
	if(strlen(buffer) == 0) mode=0;
	break;
			}
continue;
}
offset++;

			}

close(fp);
return(0);

}
/* ********************************************************************* */
/*
Identifizerung einer Route

Input:
	adresse IP adresse zu der eine passende Route ermittelt werden soll
	mem_route[] Die im Server gespeicherten Routen

Output:
	0/1 	0: keine passende Route gefunden
	name: Die Bezeichnung des Interfaces dass mit der Route verbunden ist


*/

static int ident_ip_route(adresse,name)
char *adresse;
char *name;
{
int adr_ip1,adr_ip2,adr_ip3, adr_ip4;
unsigned char inet_ip1,inet_ip2,inet_ip3, inet_ip4;
unsigned char mask_ip1,mask_ip2,mask_ip3, mask_ip4;
int i;
char interface_name[80];
char filename[80];
char destination[80];
char gateway[80];
char genmask[80];
int rc;


/* Initalisierung des Interfacenamens */
*(name)=0;



/* Alle Eintrage in mem_route[] untersuchen */

for(i=0; i< MAX_ROUTE; i++)		{
if(mem_route[i].status == 0) continue;

strcpy(destination,mem_route[i].destination);
strcpy(gateway,mem_route[i].gateway);
strcpy(genmask,mem_route[i].genmask);
strcpy(interface_name,mem_route[i].iface);

/*
printf("\nInterface: <%s>",interface_name); 
printf("\nDestination <%s>",destination);
printf("\nGateway <%s>",gateway);
printf("\nGenmask <%s>",genmask);
*/

/* Die zu identifizierende Ip-Adresse in Einzelteile zerlegen */
ber_ip_adresse(adresse, &adr_ip1,&adr_ip2,&adr_ip3, &adr_ip4);

/* Genmask IP in Einzelteile zerlegen */
strcat(genmask,".");
ber_ip_adresse(genmask, &mask_ip1,&mask_ip2,&mask_ip3, &mask_ip4); 

/* Destination IP in Einzelteile zerlegen */
strcat(destination,".");
ber_ip_adresse(destination, &inet_ip1,&inet_ip2,&inet_ip3, &inet_ip4);


	/* Maskierungen vornehmen */

	adr_ip1 = adr_ip1 & mask_ip1;
	adr_ip2 = adr_ip2 & mask_ip2;
	adr_ip3 = adr_ip3 & mask_ip3;
	adr_ip4 = adr_ip4 & mask_ip4;

	inet_ip1 = inet_ip1 & mask_ip1;
	inet_ip2 = inet_ip2 & mask_ip2;
	inet_ip3 = inet_ip3 & mask_ip3;
	inet_ip4 = inet_ip4 & mask_ip4;


	/* Jetzt der Vergleich */
	if(
	adr_ip1 == inet_ip1 &&
	adr_ip2 == inet_ip2 &&
	adr_ip3 == inet_ip3 &&
	adr_ip4 == inet_ip4 &&
	( adr_ip1 || adr_ip2 || adr_ip3 || adr_ip4)
	)
	{
	/* Die Route wurde identifiziert! */
	strcpy(name,interface_name);
	return(1);
	}


						}
						/* End of FOR */

/* Keine passende Route gefunden */
return(0);
}
/* ********************************************************************* */
/*
Ermittlung der Route Info's

Input:
	Datei: /tmp/route_<pid>.lst

Kernel IP routing table
Destination     Gateway         Genmask         Flags Metric Ref    Use Iface
192.68.2.0      0.0.0.0         255.255.255.0   U     0      0       50 eth0
192.168.10.0    192.68.2.32     255.255.255.0   UG    0      0        0 eth0
127.0.0.0       0.0.0.0         255.0.0.0       U     0      0        1 lo

Output:
	mem_route[] 


*/
static int speicherung_ip_routen()
{
int i;
char interface_name[80];
char filename[80];
char destination[80];
char gateway[80];
char genmask[80];
int mode;
int mode1;
int offset,rc;
char buffer[400];
int fp;
int points;
int use_gateway;

sprintf(filename,"/tmp/route_%d.lst",getpid());
fp=open(filename,O_RDWR);
if(fp < 0) return(0);


mode=0;
offset=0;

while(1)		{
rc=read(fp,&buffer[offset],1);
if(rc != 1) break;
if(buffer[offset] == 0x0a)
{
buffer[offset] = 0;

points=0;
for(i=0; i<strlen(buffer); i++)
{
if(buffer[i] == '.') points++;
}

if(points == 9)
{
int j;


/* printf("\n%s",buffer);  */

for(i=strlen(buffer)-1; i>0; i--)	{
if(buffer[i]== ' ') break;
					}

strcpy(interface_name,&buffer[i+1]);

j=0;
points=0;
for(i=0; i<strlen(buffer); i++)	{
if(buffer[i]== ' ' && points==3) break;
if(buffer[i]== '.') points++;
if(buffer[i]== ' ') continue;
if(buffer[i]== 9) continue;
destination[j]= buffer[i];
j++;
				}

destination[j]= 0;


j=0;
points=0;
for(; i<strlen(buffer); i++)	{
if(buffer[i]== ' ' && points==3) break;
if(buffer[i]== '.') points++;
if(buffer[i]== ' ') continue;
if(buffer[i]== 9) continue;
gateway[j]= buffer[i];
j++;
				}

gateway[j]= 0;



j=0;
points=0;
for(; i<strlen(buffer); i++)	{
if(buffer[i]== ' ' && points==3) break;
if(buffer[i]== '.') points++;
if(buffer[i]== ' ') continue;
if(buffer[i]== 9) continue;
genmask[j]= buffer[i];
j++;
				}

genmask[j]= 0;

use_gateway=0;

mode1=0;
for(; i<strlen(buffer); i++)	{
if(buffer[i]== ' ' && mode1) break;
if(buffer[i] != ' ') mode1=1;

if(buffer[i]== 'G')
{
use_gateway=1;
break;
}
				}

#ifdef DEBUG
printf("\nInterface: <%s>",interface_name); 
printf("\nDestination <%s>",destination);
printf("\nGateway <%s>",gateway);
printf("\nGenmask <%s>",genmask);
printf("\nuse Gateway <%d>\n",use_gateway);
fflush(stdout);
#endif


insert_route_info(destination, gateway, genmask, interface_name, use_gateway);
}

offset=0;
continue;
}
offset++;
			}
close(fp);
return(0);
}
/* ********************************************************************* */
/*
Ermittlung der Route Info's

Input:
	Datei: /tmp/route_<pid>.lst

Kernel IP routing table
Destination     Gateway         Genmask         Flags Metric Ref    Use Iface
192.68.2.0      0.0.0.0         255.255.255.0   U     0      0       50 eth0
192.168.10.0    192.68.2.32     255.255.255.0   UG    0      0        0 eth0
127.0.0.0       0.0.0.0         255.0.0.0       U     0      0        1 lo

Output:
	ist_route[] 


*/

static int speicherung_ist_ip_routen()
{
int i;
char interface_name[80];
char filename[80];
char destination[80];
char gateway[80];
char genmask[80];
int mode;
int mode1;
int offset,rc;
char buffer[400];
int fp;
int points;
int use_gateway;

sprintf(filename,"/tmp/route_%d.lst",getpid());
fp=open(filename,O_RDWR);
if(fp < 0) return(0);


mode=0;
offset=0;

while(1)		{
rc=read(fp,&buffer[offset],1);
if(rc != 1) break;
if(buffer[offset] == 0x0a)
{
buffer[offset] = 0;

points=0;
for(i=0; i<strlen(buffer); i++)
{
if(buffer[i] == '.') points++;
}

if(points == 9)
{
int j;


/* printf("\n%s",buffer);  */

for(i=strlen(buffer)-1; i>0; i--)	{
if(buffer[i]== ' ') break;
					}

strcpy(interface_name,&buffer[i+1]);

j=0;
points=0;
for(i=0; i<strlen(buffer); i++)	{
if(buffer[i]== ' ' && points==3) break;
if(buffer[i]== '.') points++;
if(buffer[i]== ' ') continue;
if(buffer[i]== 9) continue;
destination[j]= buffer[i];
j++;
				}

destination[j]= 0;


j=0;
points=0;
for(; i<strlen(buffer); i++)	{
if(buffer[i]== ' ' && points==3) break;
if(buffer[i]== '.') points++;
if(buffer[i]== ' ') continue;
if(buffer[i]== 9) continue;
gateway[j]= buffer[i];
j++;
				}

gateway[j]= 0;



j=0;
points=0;
for(; i<strlen(buffer); i++)	{
if(buffer[i]== ' ' && points==3) break;
if(buffer[i]== '.') points++;
if(buffer[i]== ' ') continue;
if(buffer[i]== 9) continue;
genmask[j]= buffer[i];
j++;
				}

genmask[j]= 0;

use_gateway=0;

mode1=0;
for(; i<strlen(buffer); i++)	{
if(buffer[i]== ' ' && mode1) break;
if(buffer[i] != ' ') mode1=1;

if(buffer[i]== 'G')
{
use_gateway=1;
break;
}
				}

#ifdef DEBUG
printf("\nInterface: <%s>",interface_name); 
printf("\nDestination <%s>",destination);
printf("\nGateway <%s>",gateway);
printf("\nGenmask <%s>",genmask);
printf("\nuse Gateway <%d>\n",use_gateway);
fflush(stdout);
#endif

/* Eintragen der Route in ist_route[] */
insert_ist_route_info(destination, gateway, genmask, interface_name, use_gateway);
}

offset=0;
continue;
}
offset++;
			}
close(fp);
return(0);
}
/* ********************************************************************* */
/* 
Fuer ein Interface die Routen wieder setzen 
Input: 	s: Interface Bezeichnung
	mem_route[] Die im Server gespeicherten Routen
	Die Route muss als geloscht markiert worden sein!

Output: 
	Abarbeitug von route Befehlen:
	route add -net ... netmask ... dev <s>
	| route add -net ... gw netmask ... dev <s>

*/

static void aktivierung_route(s)
char *s;
{
char commando[300];
int i,j;

#ifdef DEBUG
printf("\nAKTIVIERUNG Interface %s, ggf. route einstellen.",s);
fflush(stdout);
#endif

for(i=0; i< MAX_ROUTE; i++)		{
if(mem_route[i].status == 0) continue;

#ifdef DEBUG
printf("\nMEM_ROUTE Interface %s", mem_route[i].iface); fflush(stdout);
#endif

/* Route passt zur Interface-Bezeichnung? */
if(strcmp(mem_route[i].iface,s)) continue;

/* Ist die Route als geloescht markiert? */
if(mem_route[i].was_deleted == 0) continue;

/* Losch-Flag zuruecksetzen */
mem_route[i].was_deleted = 0;

/* Fallunterscheidung user gateway */
if(mem_route[i].use_gateway == 0)
{
sprintf(commando,"route add -net %s netmask %s dev %s",
	mem_route[i].destination,
	mem_route[i].genmask,
	mem_route[i].iface
	);
}
else
{
sprintf(commando,"route add -net %s gw %s netmask %s dev %s",
	mem_route[i].destination,
	mem_route[i].gateway,
	mem_route[i].genmask,
	mem_route[i].iface
	);
}

#ifdef DEBUG
printf("\n%s\n",commando); fflush(stdout);
#endif

/* Abarbeitung des route Befehls */
system(commando); 
					}

}
/* ********************************************************************* */
/*
Kann ein IP Interface der Adresse zugeordnet werden?
Input:
	adresse

Output:	0/1	0: es konnte kein IP Interface ermittelt werden
	name:	Interface-Bezeichnung
*/
static int ber_ip_interface(adresse, name)
char *adresse;
char *name;
{
int rc;
char commando[200];
char filename_1[200];
char filename_2[200];
char tbuf[80];



sprintf(filename_1,"/tmp/ifconfig_%d.lst",getpid());
sprintf(filename_2,"/tmp/route_%d.lst",getpid());

sprintf(commando,"ifconfig > %s",filename_1);
system(commando);
sprintf(commando,"route -n > %s",filename_2);
system(commando);

/* 
Die Route Info speichern in mem_route[] 
Ist eine Route bereits in mem_route enthalten, dann nicht das Loesch Flag zuruecksetzen! 
*/
speicherung_ip_routen();

strcpy(tbuf,adresse);
strcat(tbuf,".");

/* 
Versuch, eine Route zu identifizieren -->  <adresse> muss einer ip adresse entsprechen
*/
if(ident_ip_route(tbuf,name)) 
{
/* Das Interface wurde ueber eine Route ermittelt. */
unlink(filename_1);
unlink(filename_2);
return(1);
}


/* 
Das Interface kann durch die Untersuchung des Outputs des ifconfig Befehls bestimmt
werden (inet addr: Mask:)?
*/
rc=ident_ip_interface(tbuf,name);

unlink(filename_1);
unlink(filename_2);

return(rc);
}
/* ********************************************************************* */
/*
Ermittle das IP Interface zu einer zu schuetzenden IP Verbindung ueber die
Partnerbezeichnung <partner>.

Input:	partner:	Bezeichnung des Zielsystems

Output:
	Zeiger auf Interface Struktur
	| NULL --> es konnte kein Interface bestimmt werden
*/
static INTERFACE *ber_lms_interface(partner)
char *partner;
{
int i;
char name[80];

#ifdef DEBUG
printf("\nber_lms_interface: %s",partner); fflush(stdout);
#endif


/* Bestimmung der Interface-bezeichnung --> <name> setzen */
if(ber_ip_interface(partner, name) == 0) return(NULL);

#ifdef DEBUG
printf("\ninterface found: %s",name); fflush(stdout);
#endif

/* die Struktur interfaces[] vergleichen mit <name> */
for(i=0; i < MAX_INTERFACES; i++)	{

if(
	interfaces[i].status  &&
	strcmp(interfaces[i].bezeichnung, name) == 0
  )
{
/* zeiger auf interfaces[] zurueckgeben */
return(&interfaces[i]);
}


					}

/* Interface konnte nicht gefunden werden! */
return(NULL);
}
/* ********************************************************************* */
/*
Eintragen einer zeitlichen Reservierung eines Dienstes
*/
static void insert_reservierung(service, partner, user, von_hh, von_min, bis_hh, bis_min)
char *service;
char *partner;
char *user;
int von_hh;
int von_min;
int bis_hh;
int bis_min;
{
int i;


for(i=0; i < MAX_RESERVIERUNGEN; i++)	{
if(reservierungen[i].status == 0)
{
reservierungen[i].status = 1;
reservierungen[i].aktiv = 0;
strcpy(reservierungen[i].service,service);
strcpy(reservierungen[i].partner,partner);
strcpy(reservierungen[i].user,user);
reservierungen[i].von_hh=von_hh;
reservierungen[i].von_min=von_min;
reservierungen[i].bis_hh=bis_hh;
reservierungen[i].bis_min=bis_min;
reservierungen[i].interface=NULL;


if(
	strcmp(service, B_CHANNEL)  == 0
   )
{

/* 
Ermittlung des zugehoerigen Interfaces
Vergleich der Rufnummer <partner> mit incoming bzw outcoming
*/
reservierungen[i].interface = ber_b_interface(partner);
}

if(
	strcmp(service, LMS_IP_SERVICE)  == 0
   )
{

/* 
Reservierung einer geschuetzen IP Verbindung  
Ermittlung des zugehoerigen IP Interfaces
Vergleich <partner> mit Route Info's und ifconfig Output
*/
reservierungen[i].interface = ber_lms_interface(partner);
}



return;
}
					}

}
/* ********************************************************************* */
/*
Eine ISDN Schnittstelle dem Server bekanntmachen:
	Bezeichnung, Anzahl der B Kanaele an der ISDN-SS
*/
static void insert_isdn_ss(bezeichnung, b_kanaele)
char *bezeichnung;
int b_kanaele;
{

#ifdef DEBUG
printf("\nISDN SS %s mit %d B Kanaelen.",bezeichnung, b_kanaele);
fflush(stdout);
#endif

if(number_of_isdn_ss == MAX_ISDN_SS)
{
return;
}

strcpy(ISDN[number_of_isdn_ss].bezeichnung, bezeichnung);
ISDN[number_of_isdn_ss].b_kanaele= b_kanaele;

number_of_isdn_ss++;
}
/* ********************************************************************* */
/*
Einen aktiven Dienst registrieren

Input:
	service:	kennzeichnet den Diensttyp
	partner:	Kennzeichnet den Partner (Adresse)
	user:		Benutzerbezeichnung
	pid:		Prozessidentifikation des Prozesses, der den Dienst angefordert
			hatte
*/
static void insert_dienst(service, partner, user, pid)
char *service;
char *partner;
char *user;
int pid;
{
int i;


/* 
Fuer eine zu schuetzende IP Verbindungen kann keine Prozessueberwachung eingestellt 
werden, da mehrere Anforderungen auf den gleichen LMS_IP_SERVICE-Dienst
fuehren kennen!
*/

if(strcmp(service, LMS_IP_SERVICE)  == 0) pid=0;

/* fuer ungeschuetze IP Verbindung ist die PID nicht relevant? */
if(strcmp(service, B_CHANNEL)  == 0) pid=0;

/* Test, ist der B Kanal ueber LMS schon reserviert? */
if(strcmp(service, LMS_IP_SERVICE)  == 0)
{

#ifdef DEBUG
printf("\nTest, wird das gleiche IP Interface durch die LMS Verbindung belegt!");
fflush(stdout);
#endif

for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status ==0) continue;
if(strcmp(dienste[i].service,service)) continue;
if(dienste[i].interface != ber_lms_interface(partner)) continue;

#ifdef DEBUG
printf("\nDas IP Interface wurde bereits ueber eine LMS Verbindung belegt!");
fflush(stdout);
#endif

/* Nur den Dienst: Counter INCR. */
dienste[i].counter++;
return;
				}
}

/* Dienst eintragen */
for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status) continue;
strcpy(dienste[i].service, service);
strcpy(dienste[i].partner, partner);
strcpy(dienste[i].user, user);
dienste[i].counter=1;
dienste[i].pid=pid;
dienste[i].von=time(0);
dienste[i].alive=time(0);
dienste[i].interface=NULL;

/* Das Interface bestimmen */

if(
	strcmp(service, B_CHANNEL)  == 0
   )
{
dienste[i].interface = ber_b_interface(partner);
}

if(
	strcmp(service, LMS_IP_SERVICE)  == 0 
   )
{
dienste[i].interface = ber_lms_interface(partner);
}

/* Als belegt kennzeichnen */
dienste[i].status=1;
return;
				}

}
/* ********************************************************************* */
/*
Ein Dienst Ende wurde erkannt

Input: service, partner
Output: dienste[] modifiziert
*/
static void ende_dienst(service, partner)
char *service;
char *partner;
{
int i;

for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status == 0) continue;
if(strcmp(dienste[i].service, service)) continue;
if(strcmp(dienste[i].partner, partner)) continue;

/* Nur den Counter DECR.? */
if(dienste[i].counter > 1)
{
dienste[i].counter--;
return;
}

/* Den Diensteintrag als geloescht markieren */
dienste[i].status = 0;
return;
				}

}
/* ********************************************************************* */
/*
Berechnung der max. verfuegbaren B Kanaele im System
*/
static void ber_count_of_b_kanaele()
{
int i;


number_of_b_kanaele=0;

for(i=0; i< number_of_isdn_ss; i++)
{
number_of_b_kanaele+= ISDN[i].b_kanaele;
}

/* Alle B Kanaele werden als freie B Kanaele gekennzeichnet */
freie_b_kanaele= number_of_b_kanaele;
}
/* ********************************************************************* */
/*
Berechnung der momentan noch freien B Kanaele
*/
static void ber_freie_b_kanaele()
{
int benutzte_b_kanaele;
int found;
int i,j;

benutzte_b_kanaele=0;


/* Dienst initialisieren Bearbeitungsmode? */
for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status == 0) continue;
dienste[i].mode=0;
				}


/* eingetragene Dienste untersuchen */
for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status == 0) continue;

/* bereits verarbeitet? */
if(dienste[i].mode) continue;

dienste[i].mode=1;

/* Alle Dienste auf dem gleichen Interface als bearbeitet markieren! */
for(j=0; j< MAX_DIENSTE; j++)	{
if(i==j) continue;
if(dienste[j].status == 0) continue;
if(dienste[j].interface == NULL) continue;
if(dienste[j].mode) continue;
if(dienste[j].interface != dienste[i].interface) continue;

/* 
Dieser Dienst geht nicht mehr in die Berechnung der freien B Kanaele ein,
da ein Interface max. ein B Kanal belegen kann
*/

dienste[j].mode=1;
				}

/* Ein B Kanal belegt */
benutzte_b_kanaele++;
				}

/* Die aktiven Reservierungen muessen auch beruecksichtigt werden! */
for(i=0; i < MAX_RESERVIERUNGEN; i++)	{
if(reservierungen[i].status == 0) continue;
if(reservierungen[i].aktiv == 0) continue;

/* lauft ein Dienst auf dem gleichen Interface? */
found=0;
for(j=0; j< MAX_DIENSTE; j++)	{
if(dienste[j].status == 0) continue;
if(dienste[j].interface == NULL) continue;
if(dienste[j].interface != reservierungen[i].interface) continue;
found=1;
break;
				}

if(found) continue;

/* Einen B Kanal frei halten fuer diese Reservierung */
benutzte_b_kanaele++;
					}


/*
Berechnung der freien B Kanaele aus der Summe der belegten und max. verfuegbaren
B-Kanaele.
*/

freie_b_kanaele = number_of_b_kanaele - benutzte_b_kanaele;

if(freie_b_kanaele < 0) freie_b_kanaele=0;

}
/* ********************************************************************* */
/*

Analyse des Outputs des Kommandos "isdnctrl list all":

Input:
	Current setup of interface 'isdn0':

	EAZ/MSN:                2
	Phone number(s):
	  Outgoing:	            00421346562
	  Incoming:	            00421346562
	Secure:        	        off
	Callback:               off
	Reject before Callback: on
	Callback-delay:         2
	Dialmax:                5
	Hangup-Timeout:         20
	Incoming-Hangup:        off
	ChargeHangup:           off
	Charge-Units:           0
	Charge-Interval:        0
	Layer-2-Protocol:       hdlc
	Layer-3-Protocol:       trans
	Encapsulation:          rawip
	Slave Interface:        None
	Slave delay:            10
	Slave trigger:          6000 cps
	Master Interface:       None
	Pre-Bound to:           Nothing
	PPP-Bound to:           Nothing


output:
	interfaces[] modifiziert
*/

static void get_interface_state()
{
char commando[200];
char filename[80];
char interface_name[80];
char incoming[40];
char outgoing[40];
char txt1[200];
char txt2[200];
char txt3[200];
int mode;
int offset,rc;
char buffer[400];
int fp;

sprintf(filename,"/tmp/interfaces_%d.lst",getpid());

sprintf(commando,"isdnctrl list all > %s",filename);
system(commando);
fp=open(filename,O_RDWR);
if(fp < 0) return;


strcpy(txt1,"Current setup of interface ");
strcpy(txt2,"  Outgoing:	            ");
strcpy(txt3,"  Incoming:	            ");

mode=0;
offset=0;

while(1)		{
rc=read(fp,&buffer[offset],1);
if(rc != 1) break;
if(buffer[offset] == 0x0a)
{
buffer[offset] = 0;
offset=0;


switch(mode)		{
case 0:
	if(memcmp(txt1,buffer,strlen(txt1)) == 0)
	{
	strcpy(interface_name,&buffer[strlen(txt1)+1]);
	interface_name[strlen(interface_name)-2]=0;
	mode=1;
	}
	break;
case 1:
	if(memcmp(txt2,buffer,strlen(txt2)) == 0)
	{
	strcpy(outgoing,&buffer[strlen(txt2)]);
	mode=2;
	}
	break;
case 2:
	if(memcmp(txt3,buffer,strlen(txt3)) == 0)
	{
	strcpy(incoming, &buffer[strlen(txt3)]);

#ifdef DEBUG
	printf("<%s> <%s> <%s>\n",interface_name, outgoing, incoming);
	fflush(stdout);
#endif

	/* Einfuegen der Interface Bezeichnung */
	insert_interface(interface_name, incoming, outgoing);
	mode=0;
	}
	break;
			}
continue;
}
offset++;

			}

close(fp);

unlink(filename);
}
/* ********************************************************************* */
/*
Ausgabe des Interface Zustandes zu Diagnosezwecken ueber die Message Queue
*/
static void print_interface_state(pid)
int pid;
{

typedef struct {
char type;
int aktiv;
char bezeichnung[40];
} snd_nachricht;

struct {
long mtype;
snd_nachricht mtext;
} msg;

int i;


for(i=0; i < MAX_INTERFACES; i++)	{


if(interfaces[i].status == 0) continue;

msg.mtype= pid;
msg.mtext.type = 1;
msg.mtext.aktiv = interfaces[i].aktiv;
memcpy(msg.mtext.bezeichnung, interfaces[i].bezeichnung,40);
msgsnd(wqid,(struct msgbuf *)&msg,sizeof(snd_nachricht), 0);

					}	

}
/* ********************************************************************* */
/*
Ausgabe der Reservierungsmatrix zu Diagnosezwecken ueber die Message Queue
*/
static void print_reservierungen(pid)
int pid;
{
int i;
typedef struct {
char type;
int aktiv;
char service[20];
char partner[40];
char von[40];
char bis[40];
char interface[40];
} snd_nachricht;

struct {
long mtype;
snd_nachricht mtext;
} msg;

for(i=0; i < MAX_RESERVIERUNGEN; i++)	{

if(reservierungen[i].status == 0) continue;

msg.mtype= pid;
msg.mtext.type = 2;

sprintf(msg.mtext.von,"%.2d:%.2d", 
	reservierungen[i].von_hh,
	reservierungen[i].von_min);

sprintf(msg.mtext.bis,"%.2d:%.2d", 
	reservierungen[i].bis_hh,
	reservierungen[i].bis_min);

msg.mtext.interface[0]=0;
memcpy(msg.mtext.service, reservierungen[i].service,20);
memcpy(msg.mtext.partner, reservierungen[i].partner,40);


if(reservierungen[i].interface != NULL) 
{
memcpy(msg.mtext.interface, reservierungen[i].interface->bezeichnung,40);
}

msg.mtext.aktiv = reservierungen[i].aktiv;
msgsnd(wqid,(struct msgbuf *)&msg,sizeof(snd_nachricht), 0);

					}	

}
/* ********************************************************************* */
/*
Ausgabe der aktiven Dienste zu Diagnosezwecken ueber die Message Queue
*/
static void print_dienste(pid)
int pid;
{
typedef struct {
char type;
char service[20];
char partner[40];
char interface[40];
char created[40];
int counter;
int pid;
} snd_nachricht;

struct {
long mtype;
snd_nachricht mtext;
} msg;

int i;
struct tm tm1;

msg.mtype= pid;
msg.mtext.type = 3;


for(i=0; i < MAX_DIENSTE; i++)	{

if(dienste[i].status == 0) continue;

msg.mtext.interface[0]=0;
memcpy(msg.mtext.service, dienste[i].service,20);
memcpy(msg.mtext.partner, dienste[i].partner,40);
msg.mtext.pid=dienste[i].pid;
msg.mtext.counter=dienste[i].counter;



tm1 = *localtime(&dienste[i].von);
sprintf(msg.mtext.created,"%.2d/%.2d/%d %.2d:%.2d:%.2d", 
	tm1.tm_mday, tm1.tm_mon, tm1.tm_year, tm1.tm_hour, tm1.tm_min, tm1.tm_sec);

if(strcmp(dienste[i].service, LMS_IP_SERVICE ) == 0)
{
/*
tm1 = *localtime(&dienste[i].alive);
printf(" last alive: %.2d/%.2d/%d %.2d:%.2d:%.2d", 
	tm1.tm_mday, tm1.tm_mon, tm1.tm_year, tm1.tm_hour, tm1.tm_min, tm1.tm_sec);
*/
}


if(dienste[i].interface != NULL)
{
memcpy(msg.mtext.interface, dienste[i].interface->bezeichnung,40);
}
	
msgsnd(wqid,(struct msgbuf *)&msg,sizeof(snd_nachricht), 0);
					}	

}
/* ********************************************************************* */
/*
Ausgabe der B Kanal Counter zu Diagnosezwecken ueber die Message Queue
*/
static void print_b_kanal_status(pid)
int pid;
{
typedef struct {
char type;
int number_of_b_kanaele;
int freie_b_kanaele;
} snd_nachricht;

struct {
long mtype;
snd_nachricht mtext;
} msg;

msg.mtype= pid;
msg.mtext.type = 4;
msg.mtext.number_of_b_kanaele=number_of_b_kanaele;
msg.mtext.freie_b_kanaele=freie_b_kanaele;
msgsnd(wqid,(struct msgbuf *)&msg,sizeof(snd_nachricht), 0);

}
/* ********************************************************************* */
/*
Generierung von Diagnosedaten ueber die Message Queue an den Prozess <pid>
*/
/* Ausgabe des Server Zustands */
static void print_server_state(pid)
int pid;
{
typedef struct {
char type;
} snd_nachricht;

struct {
long mtype;
snd_nachricht mtext;
} msg;


if(wqid < 0) return;
if(pid <= 0 ) return;

print_interface_state(pid);
print_reservierungen(pid);
print_dienste(pid);
print_b_kanal_status(pid);



msg.mtype= pid;
msg.mtext.type = 10;
msgsnd(wqid,(struct msgbuf *)&msg,sizeof(snd_nachricht), 0);



}
/* ********************************************************************* */
/*
Test, kann die Anforderung mit OK bestaetigt werden?
0: OK
1: FALSE
*/
static int check_anforderung( service, partner )
char *service;
char *partner;
{

/* ungeschuetzte IP Anforderungen sind stets ungetestet */
if(strcmp(service, B_CHANNEL ) == 0) 
{
int i;
INTERFACE *ptr;


/* IP Service? */
ptr = ber_b_interface(partner);
if(ptr == NULL) return(1);


/* Existiert eine angemeldete LMS Verbindung fr jenes IP Interface? */
for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status == 0) continue;
if(strcmp(dienste[i].service, LMS_IP_SERVICE)) continue;
if(dienste[i].interface != ptr) continue;

/* zugehoerigen LMS-IP Dienst gefunden, also keine neue B Kanalreservierung! */
return(1);
				}

/* Ressource fuer ungeschuetzte IP Verbindung reservieren */
return(0);
}


/* geschuteze IP Verbindung? */
if(strcmp(service, LMS_IP_SERVICE ) == 0)
{
int i;
INTERFACE *ptr;

/* Ist das Interface aktiv? */
ptr = ber_lms_interface(partner);
if(ptr == NULL)
{
#ifdef DEBUG
printf("\nFuer die LMS Verbindung %s konnte das Interface nicht bestimmt werden!",partner);
fflush(stdout);
#endif

return(1);
}

if(ptr->aktiv == 0)
{

#ifdef DEBUG
printf("\nDas Interface %s ist nicht verfuegbar!",ptr->bezeichnung);
fflush(stdout);
#endif

return(1);
}



for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status == 0) continue;
if(strcmp(dienste[i].service, LMS_IP_SERVICE)) continue;
if(dienste[i].interface != ptr) continue;

/* Gleiches Interface gefunden, also keine neue B Kanalreservierung notwendig! */
return(0);
				}


}

/* Ein freier B Kanal verfuegbar? */
if(freie_b_kanaele > 0) return(0);
return(1);


}
/* ********************************************************************* */
/*
Sende Ablehnung der Anforderung an den Prozess <pid>
B_CHANNEL Anforderungen (ungeschuetze IP Verbindungen) werden nicht quittiert!
*/
static void send_ignore_message(pid, service, partner)
int pid;
char *service;
char *partner;
{
struct {
long mtype;
char mtext[10];
} msg;

if(pid == 0) return;
if(strcmp(service, B_CHANNEL) == 0) return;

#ifdef DEBUG
printf("\nIgnorieren der Dienst-Anforderung. PID: %d",pid); fflush(stdout);
#endif

if(wqid < 0) return;

msg.mtype= pid;
msg.mtext[0]= 1;

msgsnd(wqid,(struct msgbuf *)&msg,1, 0);

}
/* ********************************************************************* */
/*
Sende Akzeptierung der Anforderung an den Prozess <pid>
B_CHANNEL Anforderungen (ungeschuetze IP Verbindungen) werden nicht quittiert!
*/
static void send_accept_message(pid, service, partner)
int pid;
char *service;
char *partner;
{
struct {
long mtype;
char mtext[10];
} msg;



if(pid == 0) return;

if(strcmp(service, B_CHANNEL ) == 0) return;

#ifdef DEBUG
printf("\nAkzeptierung der Dienst-Anforderung. PID: %d",pid); fflush(stdout);
#endif

if(wqid < 0) return;

msg.mtype= pid;
msg.mtext[0]= 2;

msgsnd(wqid,(struct msgbuf *)&msg,1, 0);
}
/* ********************************************************************* */
/*
Es trat ein B Kanal Engpass aus, d.h. muessen die IP Interfaces deaktiviert werden,
damit keine ungeschuetzten IP Verbindungen auftreten koennen!
Das Interface darf natuerlich keinem aktiven Dienst oder einer Reservierung
zugeordnet sein!
*/
static void passivierung_interfaces()
{
int i,j,found;

for(i=0; i < MAX_INTERFACES; i++)	{
if(interfaces[i].status==0) continue;
if(interfaces[i].aktiv==0) continue;

/* Ist das Interface in Benutzung? */
found=0;

for(j=0; j < MAX_DIENSTE; j++)	{
if(dienste[j].status==0) continue;
if(dienste[j].interface == &interfaces[i]) 
{
found=1;
break;
}

				}

if(found) continue;


/* Ist das Interface einer Reservierung zugewiesen? */
found=0;

for(j=0; j < MAX_RESERVIERUNGEN; j++)			{
if(reservierungen[j].status == 0) continue;
if(reservierungen[j].aktiv == 0) continue;
if(reservierungen[j].interface == &interfaces[i])
{
found=1;
break;
}
							}


if(found) continue;

/* Jetzt dektiviere das Interface */
deaktiv_interface(interfaces[i].bezeichnung);


					}


}
/* ********************************************************************* */
/*
Der B Kanal Engpass wurde aufgehoben.
Aktiviere die Interfaces die vorher deaktiviert wurden.
*/
static void aktivierung_interfaces()
{
int i;

for(i=0; i < MAX_INTERFACES; i++)	{
if(interfaces[i].status==0) continue;
if(interfaces[i].aktiv) continue;

/* Jetzt das Interface aktivieren */
aktiv_interface(interfaces[i].bezeichnung);

					}


}
/* ********************************************************************* */
/*
Die Reservierungsmatrix zeitlich bewerten.
Reservierungen werden als aktiv bzw. deaktiv gekennzeichnet.
*/
static void check_reservierungen()
{
int im_zeitbereich;
int i;
struct tm tm1;
time_t now;

now=time(0);

tm1 = *localtime(&now);

for(i=0; i < MAX_RESERVIERUNGEN; i++)			{
if(reservierungen[i].status == 0) continue;

im_zeitbereich=1;


if( im_zeitbereich && tm1.tm_hour < reservierungen[i].von_hh)
	im_zeitbereich=0;


if( im_zeitbereich && tm1.tm_hour == reservierungen[i].von_hh
	&& tm1.tm_min < reservierungen[i].von_min)
		im_zeitbereich=0;

if( im_zeitbereich && tm1.tm_hour > reservierungen[i].bis_hh)
	im_zeitbereich=0;

if( im_zeitbereich && tm1.tm_hour == reservierungen[i].bis_hh 
	&& tm1.tm_min > reservierungen[i].bis_min)
		im_zeitbereich=0;

if(im_zeitbereich)
						{

if(reservierungen[i].aktiv == 0)
{

#ifdef DEBUG
printf("\nDie Reservierung %s %s wird auf aktiv gesetzt!",
	reservierungen[i].service, reservierungen[i].partner);
fflush(stdout);
#endif

}

reservierungen[i].aktiv = 1;
						}
else
						{

if(reservierungen[i].aktiv)
{

#ifdef DEBUG
printf("\nDie Reservierung %s %s ist nicht nehr aktiv!",
	reservierungen[i].service, reservierungen[i].partner);
fflush(stdout);
#endif

}

reservierungen[i].aktiv = 0;
						}

							}

}
/* ********************************************************************* */
/*
Momentan nicht benutzt (Aufgabe des alived)
*/
static void set_alive_data(service, partner)
char *service;
char *partner;
{
int i;
time_t now;

now = time(0);


/* Dienst bereits eingetragen? */
for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status == 0) continue;
if(strcmp(dienste[i].service, service)) continue;
if(strcmp(dienste[i].partner, partner)) continue;
dienste[i].alive=now;
				}

}
/* ********************************************************************* */
/*
Momentan nicht benutzt (Aufgabe des alived)
*/
static void check_alives()
{
int i;
time_t now;

now=time(0);

for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status == 0) continue;
if(strcmp(dienste[i].service, LMS_IP_SERVICE)) continue;

if((now - dienste[i].alive) > MAX_ALIVE_TIME_DIFF)
{

#ifdef DEBUG
printf("\nDienst %s %s ausbleibendes alive Signal erkannt",
	dienste[i].service, 
	dienste[i].partner);
fflush(stdout);

#endif

dienste[i].status = 0;

ber_freie_b_kanaele();
aktivierung_interfaces();
}



				}

}
/* ********************************************************************* */
/*
Fuer den Prozess <pid> alle Messages aus der write queue entfernen.
*/
static void rm_msg_for_pid(pid)
int pid;
{
int rc;

struct {
long mtype;
char mtext[400];
} msg;

while(1)	{
 rc = msgrcv(wqid,(struct msgbuf *)&msg,400, pid, IPC_NOWAIT);
if(rc <= 0) break;
		}
}
/* ********************************************************************* */
/*
Untersuchung, existiert der Prozess der den Dienst ausgeloest hat?
*/
static void check_pid()
{
int i;

for(i=0; i< MAX_DIENSTE; i++)	{
if(dienste[i].status == 0) continue;
if(dienste[i].pid == 0) continue;


if(kill(dienste[i].pid,0) < 0)
{

#ifdef DEBUG
printf("\nDienst %s %s PID: %d , Prozessende erkannt!",
	dienste[i].service, 
	dienste[i].partner,
	dienste[i].pid);
fflush(stdout);

#endif

/* Das laeuft nur zur Sicherheit ab, falls noch Messages fuer diesen Prozess existieren */
rm_msg_for_pid(dienste[i].pid);

/* Dienst als geloescht markieren */
dienste[i].status = 0;

ber_freie_b_kanaele();
aktivierung_interfaces();
}



				}

}
/* ********************************************************************* */
/* Routine zur Auswertung der eingehenden Meldungen */
static void receive_message(mtype, service, partner, user, pid)
int mtype;
char *service;
char *partner;
char *user;
int pid;
{
int old_freie_b_kanaele;

check_pid(); 
/* check_alives();  */

check_reservierungen();
ber_freie_b_kanaele();

switch(mtype)	{
case MSG_ANFORDERUNG:

#ifdef DEBUG
	printf("\nAnforderung zur Belegung eines B Kanals Service: %s Partner: %s", 
		service, partner); fflush(stdout);
#endif


	if(check_anforderung( service, partner ))
	{

#ifdef DEBUG
	printf("\nCheck ANFORDERUNG schlug fehl!"); fflush(stdout);
#endif

	send_ignore_message(pid, service, partner);
	break;
	}

	old_freie_b_kanaele=freie_b_kanaele;

	insert_dienst(service, partner, user, pid);

	ber_freie_b_kanaele();

	if(old_freie_b_kanaele != freie_b_kanaele && freie_b_kanaele == 0)
	{
	passivierung_interfaces();
	}


	send_accept_message(pid, service, partner);
	break;

case MSG_FREIGABE:

#ifdef DEBUG
	printf("\nSignalisierung der Freigabe eines B Kanal Service: %s Partner: %s", 
		service, partner); fflush(stdout);
#endif


	old_freie_b_kanaele=freie_b_kanaele;


	ende_dienst(service, partner);
	ber_freie_b_kanaele();



	if(old_freie_b_kanaele != freie_b_kanaele && old_freie_b_kanaele == 0 && freie_b_kanaele)
	{
	aktivierung_interfaces();
	}

	break;

case MSG_ALIVE:

#ifdef DEBUG
	printf("\nAlive Meldung Service: %s Partner: %s", 
		service, partner); fflush(stdout);
#endif

	set_alive_data(service, partner);
	break;

case MSG_CHECK:

#ifdef DEBUG
	printf("\nMessage received: MSG_CHECK"); fflush(stdout);
#endif

	break;

case MSG_STATE:

#ifdef DEBUG
	printf("\nAufforderung zur Zustandsbeschreibung"); fflush(stdout);
#endif

	print_server_state(pid);
	break;

case MSG_QUIT:

#ifdef DEBUG
	printf("\nAufforderung zur Beendigung des Serverprozesses"); fflush(stdout);
#endif

	printf("\nBeendigung des Serverprozesses"); fflush(stdout);
        remove_msgq ();
	kill(clock_prozess,9);
	exit(1);
	break;

default:
	printf("\ninvalid Messagetype received"); fflush(stdout);
	break;

	}

}
/* ********************************************************************* */
int init_queue()
{
 if(lms_create_msgq() < 0)
 {
    printf("\nFehler beim Anlegen der Queue's\n"); fflush(stdout);
    exit (-1);
 }

 return (0);
}

/* *********************************************************************** */
/* 
Lesen einer Message von der Lese Queue und Auswertung der Message 
Return: 1: OK(Get next Message)
Return: 0: ERROR(Program Ende)
*/

/* Message Struktur */
typedef struct {
char service[40];	/* Servicebezeichnung */ 
char partner[40];	/* Partnerbezeichnung */
char pid[10];		/* Prozessnummer */
char user[40];		/* Benutzerbezeichnung */
} nachricht;

typedef struct {
long mtype;		/* Message Typ */
nachricht mtext;	/* Message DATA */
} queuemessage;

static int serve_queue()
{
 int len;
 int pid;
 queuemessage msg;

 /* Message Queue Deskriptor gueltig? */
 if(rqid < 0) return(0);

 /* Lesen einer Message */
 len = msgrcv(rqid,(struct msgbuf *)&msg,sizeof(nachricht), 0,0);
 if (len <= 0)
 {
   /* ungueltige Message Laenge */
   return(0);
 }

#ifdef DEBUG
printf("\nReceive Message from Queue: %d LEN: %d",msg.mtype,len);
fflush(stdout);
#endif

/* Auswertung der eingetroffenen Message */
sscanf(msg.mtext.pid,"%d",&pid);
receive_message(msg.mtype, msg.mtext.service, msg.mtext.partner, msg.mtext.user, pid);

return (1);
}
/* ********************************************************************* */
/* 
Ermittlung der ISDN Anschluesse 
Das Device /dev/isdninfo liefert folgende Informationen:
Name der ISDN Schnittstelle + Anzahl der B Kanaele je ISDN Schnittstelle 
idmap:  Tel0 Tel0 - -
chmap:  0 1 -1 -1 
usage:  2 0 0 0 
flags:  1 ? ? ? 
phone:  141 ??? ??? ??? 
*/

static void ber_isdn_anschl()
{
char mem_ss_name[80];
char ss_name[80];
int i,offset,offset1,offset2;
char buffer[10000];
char zeile1[4000];
char zeile2[4000];
int fp;
int b_counter;
int mode,rc;
char c;

fp=open("/dev/isdninfo",O_RDONLY|O_NONBLOCK);
if(fp < 0) return;


/* 
Lesen vom device und Analyse der gelesenen Daten 
Der Output muss in den Puffer passen!!! max: 9999 Bytes
*/

offset=0;
while(1)
{
rc=read(fp,&buffer[offset],4096);
if(rc <= 0) break;
if(offset+rc > 10000) break;
offset+=rc;
}


/* Analyse der gelesen Info's */
/* Die ersten beiden Zeilen selektieren */

mode=0;
offset1=offset2=0;
for(i=0; i<offset; i++)			{

c=buffer[i];

switch(mode)	{
case 0:
	if(c == '\n') { mode++; zeile1[offset1]=0; break; }
	zeile1[offset1]=c; offset1++;
	break;
case 1:
	if(c == '\n') { mode++; zeile2[offset2]=0; break; }
	zeile2[offset2]=c; offset2++;
	break;
		}

if(mode == 2) break;
					}

close(fp);


/* Auswertung zeile1[] und zeile[2] */
/* gleichnamige ISDN SS Namen werden zusammengefasst */

offset=mode=0;
mem_ss_name[0]=0;
b_counter=0;

for(i=6; i<strlen(zeile1); i++)	{
if(zeile1[i] == 9) zeile1[i] = ' ';

if(zeile1[i] == ' ')
{

if(mode)
{
ss_name[offset]=0;

if(strcmp(mem_ss_name,ss_name) == 0)
{

/* INCR. B Kanal Counter */
b_counter++;
}
else
{

if(mem_ss_name[0] != 0)
{
/* Einfuegen der ISDN Schnittstelle in die Struktur ISDN_SS[] */
insert_isdn_ss(mem_ss_name, b_counter); 
}

strcpy(mem_ss_name,ss_name);
b_counter=1;
}

offset=0;
}

mode=0;
continue;
}

if(zeile1[i] == '-' && mode == 0) 
{

if(mem_ss_name[0] != 0)
{
/* Einfuegen der ISDN Schnittstelle in die Struktur ISDN_SS[] */
insert_isdn_ss(mem_ss_name, b_counter); 
}

break;
}

if(zeile1[i] != ' ')
{
mode=1;
ss_name[offset]= zeile1[i];
offset++;
}

				}


}
/* ********************************************************************* */
static void catch_alarm	( void );
main()
{
char filename[200];
char commando[200];

/* Initialisierung der route info's */
init_route_info();

/* Anzahl der ISDN SS auf Null setzen */
number_of_isdn_ss=0;

printf("\nLMS Server by PDS GmbH 1997\n"); fflush(stdout);


/* Ermittlung der route Info's in die Datei /tmp/route_<pid>.lst */
sprintf(filename,"/tmp/route_%d.lst",getpid());
sprintf(commando,"route -n > %s",filename);
system(commando);

/* Analyse der gewonnenen route Info's */
speicherung_ip_routen();

/* Loeschen der route Info's: Datei /tmp/route_<pid>.lst */
unlink(filename);


/* Signale ignorieren, da Server Prozess */
signal(SIGHUP, SIG_IGN);
signal(SIGINT, SIG_IGN);



/* Die Nachrichtenwarteschlangen einrichten: Lese+Schreib Queue */
init_queue();

/* Die Interface Strukturen initialisieren */
init_interfaces();

/* Die Reservierungsstrukturen initalisieren */
init_reservierungen();


/* Ermittlung der ISDN Anschluesse */
ber_isdn_anschl();


/* Berechnung der im System momentan verfuegbaren B Kanaele */
ber_count_of_b_kanaele();

/* ermittlung der Interface Zustaende */
get_interface_state();


/* Einrichtung des Zeitgeberprozesses */
clock_prozess = fork();

if(clock_prozess == 0)
{
/* Signalbehandlung einrichten */
signal (SIGALRM, (void*) catch_alarm);
alarm (10);
while(1);
}



/* Warte auf Message aus Lese queue */
while(serve_queue());

}

/* ********************************************************************* */
/* Signalbehandlung fuer Zeitgeber Prozess */
static void catch_alarm()
{
int rc;
queuemessage msg;


if(rqid >= 0)		{


/* 
   Erzeuge Message: MSG_CHECK (ueberpruefung der Prozess Status fuer die aktiven Dienste)
   in die Lese queue
*/
msg.mtype= MSG_CHECK;
sprintf(msg.mtext.pid,"%d",0);
strcpy(msg.mtext.service,"");
strcpy(msg.mtext.partner,"");
strcpy(msg.mtext.user,"");

msgsnd(rqid,(struct msgbuf *)&msg,sizeof(nachricht), 0);
			}


/* Signalbehandlung wieder aktivieren */
alarm (10);
signal (SIGALRM, (void*) catch_alarm); 


}
/* ********************************************************************* */
