#ifndef FETSRVH
#define FETSRVH

#ifndef FALSE
#define FALSE             0
#define TRUE              1
#endif

#define FETSERVER_TIMEOUT 4
#define FETSERVER_REXMIT  4

#define FETSERVER_PRINT_TIMEOUT 36000   /* 10 std */

#define FETALIVE_SOCK	  6666
#define FETSRV_SOCK	  6667
#define SRVALIVE_SOCK	  6668

#define KE_SERVER_ALIVE   0x2608      /* FETSRV -> SRVALIVE_SOCK */
#define KE_SESSION_START  0x2812      /* FET    -> FETALIVE_SOCK */
#define KE_SESSION_ALIVE  0x2605
#define KE_SESSION_STOP   0x1308
#define KE_CHARGE_ASK     0x1104
#define KE_CHARGE_MESS    0x0712
#define KE_NO_CHARGE_MESS 0x0713      /* 25.04.96 JH */
#define KE_ALIVED_MESS    0x1111
#define KE_D_CHAN_ALIVE   0x1803
#define KE_SERVERSTAT     0x1212
#define KE_ISDNSRV_ALIVE  0x2504
#define KE_FETSTAT_ASK    0x1902
#define KE_FETSTAT_ACK    0x2002
#define KE_FETSTAT_ERR    0x2003
#define KE_KILL_FET_REG   0x0001
#define KE_KILL_FETJOBS   0x0002
#define KE_KILL_FET_END   0x0003
#define KE_FET_GETNAME    0x0100        /* fet_getname anfrage an alived */
#define KE_FET_GIVENAME   0x0101        /* fet_getname antwort von alived */


#define PRSTAT_READY      0
#define PRSTAT_PORTBUSY   1
#define PRSTAT_NOPAPER    2
#define PRSTAT_FAILURE    3
#define PRSTAT_PAPFAIL    4
#define PRSTAT_PRINTAK    5
#define PRSTAT_NOPORT     6
#define PRSTAT_OFFLINE    7
#define PRSTAT_FETOFF     64
#define PRSTAT_SRVBUSY    128

#define OP_ACK            0             /*allg. quittung */
#define OP_PRINT_TFTP_REQ 1             /*Druckanfrage mit TFTP-Filetransfer */
#define OP_PRINT_REQ      2             /*Druckanfrage mit FETSERVER-Transfer */
#define OP_PRINT_OK       3             /*Druckjob fertig */
#define OP_DOWNLD_REQ     4             /*Download-Anfrage */
#define OP_DOWNLD_OK      5             /*Download fertig */
#define OP_UPLD_REQ       6             /*Upload-Anfrage */
#define OP_UPLD_OK        7             /*Upload fertig  */
#define OP_DATA           8             /*Daten          */
#define OP_DATA_OK        9             /*Daten bis Paketnr. ok */
#define OP_ERROR          10            /*Fehler (NR., Text)    */

/* B-Kanal-Zustnde */
#define B_IDLE            0             /* Frei */
#define B_OUTCON          1             /* aktiver Verbindungsaufbau */
#define B_INCON           2             /* passiver Verbindungsaufbau */
#define B_CONNECT         3             /* belegt, verbunden */
#define B_OUTREL          4             /* aktiver Verbindungsabbau */
#define B_INREL           5             /* passiver Verbindungsabbau */
#define B_FAKE            6             /* unbekannter Zustand */

typedef struct
{ char          telno[16];
  char          hostname[16];
  unsigned short chargeticks;
  unsigned short dummy;
  unsigned long outcharge,
                incharge,
                outpkt,
                inpkt,
                outbytes,
                inbytes;
  char		d_alive_telno[16];
} IsdnHostInfo;

typedef struct
{ unsigned char  ip_adr[4];
  unsigned short IsdnHostIndex;
  char           pktbytes[16];
  /*
  unsigned long  outpkt,
                 inpkt,
                 outbytes,
                 inbytes;
		 */
} LocalHostInfo;

typedef struct
{ unsigned char  ip_adr[4];
  unsigned short timeout;
  unsigned char  alive;
  unsigned char  seq;
  unsigned short socket;
} FetInfo;

typedef struct
{
  unsigned char fetip[4];
  unsigned char printinfo[10];
  unsigned char timeout[2];
}
PrintInfo;

#endif

#ifndef  TB_PROTO
#ifdef __STDC__
#define TB_PROTO(ARGS) ARGS
#else
#define TB_PROTO(ARGS) ()
#endif
#endif

/* Einige Prototypen f}r Interactive
**

extern int socket		TB_PROTO (( int, int, int ));
extern int connect		TB_PROTO (( int, struct sockaddr *, int ));

*/

#define  bzero(a, b)		memset(a, 0, b)
#define  bcopy(a, b, c)		memcpy(b, a, c)
