/*******************************************************************************
**
** FET-Server-Status-Deamon
**
** hlt die Druckerstati aller laufender FETs bereit
*******************************************************************************/

#include <stdio.h>
#include <unistd.h> 
#include <sys/types.h>
#include <errno.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
/* #include <stropts.h> */
#include <sys/poll.h>

#include "fetsrv.h"

/* Prototyping
** 18.03.86 Mi
*/

extern int check_srvlist	TB_PROTO(( void ));
extern int get_alivesock	TB_PROTO(( struct sockaddr_in *, int * ));
extern int get_srvalivesock	TB_PROTO(( struct sockaddr_in *, int * ));
extern int get_srvsock		TB_PROTO(( struct sockaddr_in *, int * ));
extern int main			TB_PROTO(( int, char ** ));
extern int process_data		TB_PROTO(( char *, int, struct sockaddr_in ));
extern int send_servinfo_to_alived	TB_PROTO(( void ));

#define SRV_LAN_TIMEOUT         15
#define SRV_ISDN_TIMEOUT        90      /* mu grer als 70 s sein,
                                           routeralive alle 70s kommt */
#define SRVLIST_UPDATE_TIMEOUT  2       /* sooft wird die FETserverliste */

#define RLEN       2048
#define MAXFETS    200

typedef struct
{
  long   ip;
  char   portstat[10];
  long   lasttime;
  char   router_no[35];
} fetstat_typ;
/*--------------------------------------------------------------------*/
int          debug = 1;
int	     xdebug = 1;
int          sendit_to_alived=0;
int          alivesock;
struct sockaddr_in srvremote,aliveremote,alivedremote;

fetstat_typ  srvstat[MAXFETS];
/*--------------------------------------------------------------------*/
extern char *sys_errlist[];
/*--------------------------------------------------------------------*/

int check_srvlist	TB_PROTO(( void ));
int get_alivesock	TB_PROTO(( struct sockaddr_in *, int * ));
int get_srvalivesock	TB_PROTO(( struct sockaddr_in *, int * ));
int get_srvsock	TB_PROTO(( struct sockaddr_in *, int * ));
int process_data	TB_PROTO(( char *, int, struct sockaddr_in ));
int send_servinfo_to_alived	TB_PROTO(( void ));
/*--------------------------------------------------------------------*/

int main(argc,argv)
int argc;
char *argv[];

{
int                received, sent, srvalivesock,
                   srvsock,rcode,srvnr;
size_t		   addrlen;
char               buffer[RLEN];
char               anfrage_buf[RLEN];
char               answer[100];
unsigned short     r_kennung,s_kennung;
struct   pollfd    fds[2];

   if (argc > 1)
      debug = 1;
   else
      debug = 0;

   if (argc > 2)
      xdebug = 1;
   else
      xdebug = 0;

   setuid(0); /* owner root */
   freopen("/dev/null","r",stdin);
   freopen("/dev/null","w",stdout);

   addrlen = sizeof(struct sockaddr_in);

   if (!get_srvalivesock(&aliveremote,&srvalivesock))
      exit (1);

   if (!get_srvsock(&srvremote,&srvsock))
      exit (1);

   if (!get_alivesock(&alivedremote,&alivesock))
      exit (1);

   fds[0].fd     = srvalivesock;
   fds[0].events = POLLIN;
   fds[1].fd     = srvsock;
   fds[1].events = POLLIN;

   while(1)
   {
      check_srvlist();
      if (sendit_to_alived)
         send_servinfo_to_alived();
      rcode = poll (fds,2,SRVLIST_UPDATE_TIMEOUT * 1000);
      if (rcode == 0)
         continue;
      if (rcode < 0)
      {
	 if (errno == EAGAIN)
	    continue;

         fprintf(stderr,"%s: Fehler beim poll(),%s,errno=%d\n",argv[0],sys_errlist[errno],errno);
	 sleep (1);
	 continue;
      }
      /* jetzt ist mal wieder ein paket da */

      if (fds[0].revents & POLLIN) /* wars ein Server-Alive ?*/
      {
         received = recvfrom (srvalivesock, buffer, RLEN, 0 , (struct sockaddr * ) &aliveremote, &addrlen);

         if (received > 0)
         {
            process_data (buffer,received,aliveremote);
         }
         else
         {
	    fprintf(stderr,"recvfrom(srvalivesock) error: %s\n",sys_errlist[errno]);
            exit (1);
         }
      }

      if (fds[1].revents & POLLIN) /* wars eine Server-Status-Anfrage ?*/
      {
         received = recvfrom (srvsock, anfrage_buf, RLEN, 0 , (struct sockaddr * ) &srvremote, &addrlen);
         if (received > 0)
         {
            /* War es eine Anfrage?*/
            bcopy (anfrage_buf,&r_kennung,2);
            if (r_kennung != KE_FETSTAT_ASK)
            {
               if (debug)
                  fprintf (stderr,"fetstatd: Ungltige Anfragekennung erhalten!\n");

               s_kennung = KE_FETSTAT_ERR;
               bcopy (&s_kennung,answer,2);
               *((unsigned short *)&answer[2]) = 1;
               strcpy (&answer[4],"fetstatd: Ungltige Anfragekennung erhalten!\n");
               s_kennung = KE_FETSTAT_ERR;
               bcopy (&s_kennung,answer,2);

               sent = sendto (srvsock, (char *)answer, sizeof(answer), 0 , (struct sockaddr * ) &srvremote, addrlen);

               if (sent < 0)
               {
                  fprintf(stderr,"%s, error in sendto(), errno=%d\n",argv[0],errno);
                  exit (1);
               }

               continue;
            }

            /* Es war eine Anfrage */
            if (debug)
            {
	       fprintf(stderr,"Serveranfrage fuer FET %ld.%ld.%ld.%ld\n",
                    (*((unsigned long*)(&anfrage_buf[2])) & 0x000000ff),
		    (*((unsigned long*)(&anfrage_buf[2])) & 0x0000ff00) >>8,
		    (*((unsigned long*)(&anfrage_buf[2])) & 0x00ff0000) >>16,
                    (*((unsigned long*)(&anfrage_buf[2])) & 0xff000000) >>24);
	    }
            for (srvnr = 0;srvnr < MAXFETS;srvnr++)
            {
               if ((*((long *)&anfrage_buf[2])) == srvstat[srvnr].ip)
               {
                  s_kennung = KE_FETSTAT_ACK;
                  bcopy (&s_kennung,answer,2);
                  bcopy (srvstat[srvnr].portstat,&answer[2],10);
                  break;
               }
            }

            if (srvnr == MAXFETS)  /* befragte IP-Adresse nicht gefunden */
            {
               if (debug)
                  fprintf (stderr,"Gewuenschtes FET nicht in Liste gefunden!\n");

               s_kennung = KE_FETSTAT_ERR;
               bcopy (&s_kennung,answer,2);
               *((unsigned short *)&answer[2]) = 1;
               strcpy (&answer[4],"FET-Server nicht aktiv!\n");
            }

            sent = sendto (srvsock, (char *)answer, sizeof(answer), 0 , (struct sockaddr * ) &srvremote, addrlen);

            if (sent < 0)
            {
               fprintf(stderr,"%s, error in sendto(), errno=%d\n",argv[0],errno);
               exit (1);
            }
         }
         else
         {
	    fprintf(stderr,"recvfrom(srvsock) error: %s\n",sys_errlist[errno]);
            exit (1);
         }
      }

      if (((fds[0].revents & POLLIN) || (fds[1].revents & POLLIN)) == 0)
      {
         fprintf (stderr,"!!!!! Falscher Alarm von Poll !!!!!\n");
      }
   }
}

/***************************************************************************/
int check_srvlist ()
{
 int   srvnr;
 struct in_addr in;
 long  act_time;
 static long lasttime = 0;
 char   tt[50];


 act_time = time(0);
 if (lasttime == 0)
    lasttime = act_time;

 if (((act_time - lasttime) > 5) || ((act_time - lasttime) < 0))
 { /* die unix uhr wurde verstellt */
    if (debug)
       fprintf (stderr, "! Die Unix-Uhrzeit wurde gestellt, alle Timer neu gesetzt!\n");
    for (srvnr = 0;srvnr < MAXFETS;srvnr++)
    {
       if (srvstat[srvnr].ip != 0)
          srvstat[srvnr].lasttime = act_time;
    }
 }

 for (srvnr = 0;srvnr < MAXFETS;srvnr++)
 {
    if (srvstat[srvnr].ip != 0)
    {
       if (srvstat[srvnr].router_no[0])  /* ist ber isdn */
       {
          if ((act_time - srvstat[srvnr].lasttime) > SRV_ISDN_TIMEOUT)
          {
             if (debug)
	     {  
		in.s_addr = srvstat[srvnr].ip;
		strcpy (tt, (char*) ctime(&act_time));
		tt[24]=0;
                fprintf (stderr,"%s | ISDN-FET %s Timeout !!!!!!!!!!!\n",tt,inet_ntoa(in));
	     }

             srvstat[srvnr].ip = 0;
             sendit_to_alived = 1;
          }
       }
       else
       {
          if ((act_time - srvstat[srvnr].lasttime) > SRV_LAN_TIMEOUT)
          {
             if (debug)
	     {  
		in.s_addr = srvstat[srvnr].ip;
		strcpy (tt, (char*) ctime(&act_time));
		tt[24]=0;
                fprintf (stderr,"%s | LAN-FET %s Timeout !!!!!!!!!!!\n",tt,inet_ntoa(in));
	     }
             srvstat[srvnr].ip = 0;
             sendit_to_alived = 1;
          }
       }
    }
    else
    {
       continue;
    }
 }
lasttime = act_time;
return(1);
}


/***************************************************************************/
int process_data (buffer,buflen,remote)
char               *buffer;
int                 buflen;
struct sockaddr_in  remote;

{
 unsigned short r_kennung,i;
 int            srvnr;
 PrintInfo      *PrintInfoList;
 unsigned short *NumPrintInfos;
 char           router_no[35];
 struct in_addr in;
 char		tt[50];


 bcopy (buffer,(char*)&r_kennung,2);
 switch (r_kennung)
 {
    case KE_SERVER_ALIVE:
       /* FET-IP in Liste suchen */
       for (srvnr = 0;srvnr < MAXFETS;srvnr++)
       {
          if (remote.sin_addr.s_addr == srvstat[srvnr].ip)
          {
             if (( buflen - 2) > 10)
                fprintf (stderr,"FET-SERVER-ALIVE-Daten zu lang, nur 10 Bytes verwendet!\n");
             if (memcmp(&buffer[2],srvstat[srvnr].portstat,10))
             {
                bcopy (&buffer[2],srvstat[srvnr].portstat,10);
                sendit_to_alived = 1;
             }
             srvstat[srvnr].lasttime = time(0);
             srvstat[srvnr].router_no[0] = 0;
             if (xdebug)
	     {
	        in.s_addr = srvstat[srvnr].ip;
		strcpy (tt, (char*) ctime(&srvstat[srvnr].lasttime));
		tt[24]=0;
                fprintf (stderr,"%s | LAN-FET %s lebt!\n",tt,inet_ntoa(in));
	     }
             break;
          }
       }
       if (srvnr == MAXFETS) /* fet war noch nicht in der Liste */
       {                     /* dann den ersten freien Platz suchen */
          for (srvnr = 0;srvnr < MAXFETS;srvnr++)
          {
             if (srvstat[srvnr].ip == 0)
             {               /* freien Platz gefunden */
                if (( buflen - 2) > 10)
                   fprintf (stderr,"FET-SERVER-ALIVE-Daten zu lang, nur 10 Bytes verwendet!\n");
                bcopy (&buffer[2],srvstat[srvnr].portstat,10);
                srvstat[srvnr].ip = in.s_addr = remote.sin_addr.s_addr;
                srvstat[srvnr].lasttime = time(0);
                srvstat[srvnr].router_no[0] = 0;
                sendit_to_alived = 1;
                if (debug)
		{
		   strcpy(tt, (char*) ctime(&srvstat[srvnr].lasttime));
		   tt[24]=0;
                   fprintf (stderr,"%s | LAN-FET %s neu angelegt!\n",tt,inet_ntoa(in));
		}
                break;
             }
          }
          if (srvnr == MAXFETS)  /* ist die Liste bereits voll */
          {
             fprintf (stderr,"FETSTATD: SERVER-Liste ist voll!\n");
          }
       }
       break;

    case KE_ISDNSRV_ALIVE:
       strcpy (router_no,&buffer[2]);
       NumPrintInfos = (unsigned short *)&buffer[37];
       PrintInfoList = (PrintInfo *)&buffer[39];

       /* zunchst alle rausschmeissen, die mal drin waren und jetzt nicht mehr drin sind */
       for (srvnr = 0;srvnr < MAXFETS;srvnr++)
       {
          if (srvstat[srvnr].ip && (!strcmp (srvstat[srvnr].router_no,router_no)))
          {
             for (i=0;i<*NumPrintInfos;i++)
             {
                if (*((long*)PrintInfoList[i].fetip) == srvstat[srvnr].ip)
                   break;  /* ok, ist drin und wird nachher aktualisiert */
             }

             if (i == *NumPrintInfos) /* fet war nicht mehr in der Liste */
             {                     /* dann fet ruasschmeissen */
                if (debug)
		{
		   in.s_addr = (long) srvstat[srvnr].ip;
/* Mi 10.03.96
                   fprintf (stderr, "ISDN-Router meldet: FET %s ist jetzt raus\n", inet_ntoa(srvstat[srvnr].ip));
*/
                   fprintf (stderr, "ISDN-Router meldet: FET %s ist jetzt raus\n", inet_ntoa(in));
		}
                srvstat[srvnr].ip = 0L;
                sendit_to_alived = 1;
             }
          }
       }

       if (*NumPrintInfos == 0)
       {  /* alived wurde gerade gestartet und htte gerne den aktuellen stand */
          sendit_to_alived = 1;
       }

       for (i=0;i<*NumPrintInfos;i++)
       {
          for (srvnr = 0;srvnr < MAXFETS;srvnr++)
          {
             if (*((long*)PrintInfoList[i].fetip) == srvstat[srvnr].ip)
             {
                if (memcmp(PrintInfoList[i].printinfo,srvstat[srvnr].portstat,10))
                {
                    bcopy (PrintInfoList[i].printinfo,srvstat[srvnr].portstat,10);
                    sendit_to_alived = 1;
                }
                srvstat[srvnr].lasttime = time(0);
                strcpy (srvstat[srvnr].router_no, router_no);
                if (xdebug)
		{
		   in.s_addr = srvstat[srvnr].ip;
		   strcpy (tt, (char*) ctime(&srvstat[srvnr].lasttime));
		   tt[24]=0;
                   fprintf (stderr,"%s | ISDN-FET %s lebt!\n",tt, (char*) inet_ntoa(in));
		}
                break;
             }
          }
          if (srvnr == MAXFETS) /* fet war noch nicht in der Liste */
          {                     /* dann den ersten freien Platz suchen */
             for (srvnr = 0;srvnr < MAXFETS;srvnr++)
             {
                if (srvstat[srvnr].ip == 0)
                {               /* freien Platz gefunden */
                   bcopy (PrintInfoList[i].printinfo,srvstat[srvnr].portstat,10);
                   srvstat[srvnr].ip = in.s_addr = *((long*)PrintInfoList[i].fetip);
                   srvstat[srvnr].lasttime = time(0);
                   strcpy (srvstat[srvnr].router_no, router_no);
                   sendit_to_alived = 1;
                   if (debug)
		   {
		      strcpy (tt, (char*) ctime(&srvstat[srvnr].lasttime));
		      tt[24]=0;
                      fprintf (stderr,"%s | Neues ISDN-FET %s vom Router %s !\n",tt, (char*) inet_ntoa(in),router_no );
		   }
                   break;
                }
             }
             if (srvnr == MAXFETS)  /* ist die Liste bereits voll */
             {
                fprintf (stderr,"FETSTATD: SERVER-Liste ist voll!\n");
             }
          }
       }
       break;

    default:
       if (debug)
          fprintf (stderr,"Message mit ungltiger Kennung erhalten (%4x)\n",r_kennung);
       return (0);
 }

 return (1);
}

/**********************************************************************/
int get_srvalivesock (remote,sock)

struct sockaddr_in *remote;
int                *sock;

{
size_t              addrlen;
struct servent     *service;

   if ((*sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
      fprintf(stderr,"error in socket(), %s\n",sys_errlist[errno]);
      exit(1);
   }

   bzero(remote, sizeof(struct sockaddr_in));

   if ((service = getservbyname("serveralive", "udp")) == NULL)
   {
      fprintf(stderr,"error in getservbyname(), %s\n",sys_errlist[errno]);
      return (0);
   }

   remote->sin_family = AF_INET;
   remote->sin_addr.s_addr = INADDR_ANY;
   remote->sin_port = service->s_port;

   addrlen = sizeof(struct sockaddr_in);

   if (bind (*sock, (struct sockaddr * ) remote, addrlen) < 0)
   {
      fprintf(stderr,"error in bind(), %s\n",sys_errlist[errno]);
      return (0);
   }

   return (1);
}

/**********************************************************************/
int get_srvsock (remote,sock)

struct sockaddr_in *remote;
int                *sock;

{
size_t              addrlen;
struct servent     *service;

   if ((*sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
      fprintf(stderr,"error in socket(), %s\n",sys_errlist[errno]);
      exit(1);
   }

   bzero(remote, sizeof(struct sockaddr_in));

   if ((service = getservbyname("fetserver", "udp")) == NULL)
   {
      fprintf(stderr,"error in getservbyname(), %s\n",sys_errlist[errno]);
      return (0);
   }

   remote->sin_family = AF_INET;
   remote->sin_addr.s_addr = INADDR_ANY;
   remote->sin_port = service->s_port;

   addrlen = sizeof(struct sockaddr_in);

   if (bind (*sock, (struct sockaddr * ) remote, addrlen) < 0)
   {
      fprintf(stderr,"error in bind(), %s\n",sys_errlist[errno]);
      return (0);
   }

   return (1);
}

/**********************************************************************/
int get_alivesock (remote,sock)

struct sockaddr_in *remote;
int                *sock;

{
struct servent     *service;

   if ((*sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
      fprintf(stderr,"error in socket(), %s\n",sys_errlist[errno]);
      exit(1);
   }

   bzero(remote, sizeof(struct sockaddr_in));

   if ((service = getservbyname("alive", "udp")) == NULL)
   {
      fprintf(stderr,"error in getservbyname(alive), %s\n",sys_errlist[errno]);
      return (0);
   }

   remote->sin_family = AF_INET;
   remote->sin_addr.s_addr = htonl(0x7f000001);  /*IP-local */
   remote->sin_port = service->s_port;
   return (1);
}

int send_servinfo_to_alived()
{
 char data[2048];
 unsigned short *kennung=(unsigned short *)data;
 unsigned short *NumPrintInfos=&kennung[1];
 PrintInfo      *srv_info=(PrintInfo*)&NumPrintInfos[1];
 int            srvnr,datalen,rcode;
 size_t         addrlen;

 sendit_to_alived = 0;
 *kennung = KE_SERVERSTAT;
 *NumPrintInfos = 0;
 addrlen = sizeof(alivedremote);
 for (srvnr=0;srvnr<MAXFETS;srvnr++)
 {
    if (srvstat[srvnr].ip)
    {
       memcpy ((void*)srv_info[*NumPrintInfos].fetip,&(srvstat[srvnr].ip),4);
       memcpy ((void*)srv_info[*NumPrintInfos].printinfo,srvstat[srvnr].portstat,10);
       (*NumPrintInfos)++;
    }
 }

 datalen = sizeof (*kennung) + sizeof (*NumPrintInfos) +
           (*NumPrintInfos * sizeof(PrintInfo));
 rcode = sendto (alivesock, data, datalen, 0 , (struct sockaddr * ) &alivedremote, addrlen);
 if (rcode < 0)
 {
    fprintf(stderr,"fetstatd: error in sendto(send_servinfo_to_alived), %s\n",sys_errlist[errno]);
    return (0);
 }
 if (xdebug)
    fprintf(stderr,"Serverinfo an alived verschickt!\n");

 return(1);
}
