#ifndef ISDN_RESC_H
#define ISDN_RESC_H

#define QKEY         1104
#define MAX_DYNPORTS 40
#define MAX_MSGLEN   4096

#define IT_ANFRAGE   1   /* info-typ b-kanal-anfrage */
#define IT_FREIGABE  2   /* info-typ b-kanal-freigabe*/
#define IT_GETSTAT   3   /* info-typ zum Holen statistischer Infos*/
#define IT_AENDERN   4   /* info-typ b-kanal-userinfos aendern */
#define IT_LMSSTART  5   /* info-typ LMS-Verbindung gestartet */
#define IT_LMSSTOP   6   /* info-typ LMS-Verbindung beendet */
#define IT_UPTIMERES 7   /* info-typ neue Zeit-Reservierung liegt vor */

typedef struct
{
   long   connid;
   short  status;
   /*
   char   lms_partner[32];
   */ /* wenn eine lms-reservierung, dann partnername */
   short  bchanid;     /* 0 = nicht bekannt, 1, 2, ... */
   char   date[32];
   short  outgoing;
   short  charge;      /* gebhren */
   char   loc_addr[32];
   char   rem_addr[32];
   char   partner[32];
   char   service[32];
   long   cause;
   time_t time;
} B_status_typ;

typedef struct
{
   int    reserved;    /* wurde der Kanal durch anfrage reserviert */
   int    lms;         /* es ist eine lms-verbindung */
   int    lms_start;   /* lms_start_eingegangen */
   int    timeres;     /* wurde aufgrund zeit reserviert */
   long   pid;
   char   user[21];
   char   progbez [21];
   char   name    [15];
   char   partner [21];
   time_t seit;
} reserve_typ;

typedef struct
{
  char   partner[32]; /* isdn-teilnehmername */
  int    von;         /* beginn der tglichen reservierung */
  int    bis;         /* ende der tglichen reservierung */
} timeres_typ;

typedef struct
{
   char  progbez [21];
   char  name    [15];
   char  partner [21];
   char  user    [21];
   int   lms;
   int   chan_cnt;
} anfrage_typ;

typedef struct
{
   int  port;
   int  pid;
} isdn_aendern_typ;

typedef struct
{
   int   port;
} freigabe_typ;

typedef struct
{
   int dummy;
} stat_typ;

typedef struct
{
   int dummy;
} update_typ;

typedef struct
{
   B_status_typ  bstat;
   reserve_typ   res;
   int           bchans;
} stat_a_typ;

typedef struct
{
   char partner[40];
} lmsstart_typ;

typedef struct
{
   char partner[40];
} lmsstop_typ;

typedef struct
{
   int   port;
} anfrage_a_typ;


typedef union
{
   char           mtext[MAX_MSGLEN]; /* nakte daten */
   anfrage_typ    anfr;      /* infotyp anfrage */
   anfrage_a_typ  anfr_a;    /* antwort auf infotyp anfrage */
   stat_typ       stat;      /* infotyp hole statistische Infos */
   stat_a_typ     stat_a;    /* infotyp mit statistischen infos */
   isdn_aendern_typ    aend;      /* infotyp aendern */
   freigabe_typ   frei;      /* infotyp freigabe */
   update_typ     upd;
   lmsstart_typ   lms_start; /* infotyp begin einer lms-verbindung */
   lmsstop_typ    lms_stop;  /* infotyp begin einer lms-verbindung */
   int            res;       /* ergebnis diverser infos */
} msg_data;

typedef struct
{
   long     mtype;
   long     pid;
   long     infotyp;
   msg_data data;
} msg_typ;

typedef struct
{
  int      kanal;
  char     dienst[20];
  char     progbez[20];
  char     user[20];
  char     seit[20];
  char     gegen[20];
} line_typ;

#endif /* ISDN_RESC_H */
