#ifndef _H_ISDNFAX
#define _H_ISDNFAX

#ifndef  TB_PROTO
#ifdef __STDC__
#define TB_PROTO(ARGS) ARGS
#else
#define TB_PROTO(ARGS) ()
#endif
#endif

#ifndef EOT
#define EOT '\0'
#endif

#ifdef R_UNIXWARE
#define  OSICOM_REL   "PDS.03.04.01"
#else
#define  OSICOM_REL   "PDS.03.04.01"
#endif

#ifndef UNIX_REL4
#define UNIX_REL4 (access("/proc",0)==0)
#endif


#define  ISDN_DIALCODES   "W"

/* hinrichs 11.06.96 */
#include <sys/poll.h>
#include <time.h>
/* L{ngen-Definition von Variablen
**
**
*/

#define ISDN_PATH_LEN       	512
#define ISDN_FILE_LEN       	512
#define ISDN_BUF_LEN        	512
#define ISDN_LEN_GROUP		4096
#define ISDN_MAX_ANSCHLUESSE	12
#define ISDN_LEN_RUFNUMMER		31
#define ISDN_NAME_LEN              32    /* Siehe pdsfax.h = NAME_LEN           */

#define  MAX_KOPFZL             70
#define  MAX_FAXE               999
#define  MAX_GRP                45    /* Max. Anzahl Gruppenteilnehmer       */

#define uchar unsigned char


/* Verzeichnisse aus BinTec-Software
**
*/

#define ISDN_PATH_HOSTS            "/usr/isi/config/hosts"
#define ISDN_HOSTS_TEMP		"/usr/isi/config/hosts.neu"

/* Unterverzeichnisse und deren Dateien in ../pds/isdn
**
*/

#define ISDN_SERVER_PRG		"prg/isdn_jobsend"
#define ISDN_SERVER_PID 	"pid/server"
#define ISDN_OCSCA_PRG		"ositel/bin/ocs_ca"
#define ISDN_OCSLA_PRG		"ositel/bin/ocs_la"
#define ISDN_OCSCA_PID		"pid/ocs_ca"
#define ISDN_OCSLA_PID		"pid/ocs_la"
#define ISDN_SERVER_FIFO	"fifos/server"
#define ISDN_DOKUMENTE          "dokumente"
#define ISDN_STATUS             "status"
#define ISDN_CMD_PRG            "prg/isdn_cmd"
#define ISDN_OSITELBIN          "ositel/bin"
#define ISDN_OSITELAPPLI        "ositel/appli"
#define ISDN_SENDTDD            "sendtdd"
#define ISDN_RECTDD             "empfang"
#define ISDN_RECSTATUS          "empfang/status"
#define ISDN_FAXFILE            "faxfiles"
#define ISDN_DXJ_SEITEN         "dateien/dxjseiten"
#define ISDN_TESTFAX		"dateien/test.pcx"

/* Unterverzeichnisse und deren Dateien in ../oli/pds/fax
**
*/

#define  F_LOGO                 "logo"
#define  F_BENUTZER             "benutzer"
#define  F_KOEPFE               "koepfe"
#define  F_GRUPPEN              "gruppen"

/* Unterverzeichnisse und deren Dateien in ../daten/isdn
**
*/

#define ISDN_LOGBUCH		"logbuch"
#define ISDN_KONFIGURATION		"konfiguration"
#define ISDN_FAXNUMMER   		"faxnummer"
#define ISDN_CITYRUFNR             "cityrufnr"
#define ISDN_SMSNR   	        "smsnr"
#define ISDN_EMPFANGSNR            "empfangsnr"
#define ISDN_TRANSFERNR            "transfernr"
#define ISDN_PDSHOSTS              "hosts"

#define ISDN_LOGGRP		"bekannte"

/* Standard-IP-Protokollart
**
*/

#define ISDN_STD_IPPROT		"tcp/ip3"
#define ISDN_STD_FV64S 		"fv"



/*--------------------------------------------------------------------------
** KONFIGURATION
**
** Beschreibung der Einzelstrukturen f}r die Konfiguration
** Die Daten werden als ASCII-Datei in $BASIS/daten/isdn/konfiguration
** abgespeichert.
*/

struct   isdn_konf_allgemein      /* Allgemeine Konfigurationsdaten          */
{                                 /* ALLGEMEIN                               */

   char  waehrung[6];             /* Bezeichnung der Landeswaehrung          */
				  /* --> /etc/default/isi                    */
   int   preis_einh;              /* Preis pro Gebuehreneinheit vvnn         */
				  /* PREIS=vvnn                              */
   char  amtsholung[5];           /* Ziffern f}r die Amtsholung              */
				  /* --> /etc/default/isi                    */
   char  fernamt[5];              /* Anwahl Fernamt                          */
				  /* --> /etc/default/isi                    */
   char  ausland[5];              /* Anwahl Auslandsgespr{che                */
				  /* --> /etc/default/isi                    */
   char  vorwahl_nat[11];         /* Eigene Vorwahl ohne f}hrenden Nullen    */
			          /* VORWAHL_NAT=xx                          */
   char  vorwahl_int[11];         /* L{nderkennziffer z.B. 49                */
				  /* VORWAHL_INT=xx                          */

   char  iescape  [5];
   char  inational[5];
   char  iinternat[5];

   char  myhost   [23];           /* Eigener Hostname                        */
				  /* --> /etc/default/isi		     */

   char  empfang;                 /* Empfangs-LA-starten                     */
				  /* EMPFANGS-LA=J oder N                    */
};

struct   isdn_konf_ressourcen     /*                                         */
{                                 /*                                         */
   int   reskanal [24];           /* Anzahl der res. Kan{le pro Stunde       */
};

struct   isdn_konf_fax

{
   char  pfad  [ISDN_PATH_LEN];   /* Abweichender Pfad f}r die Faxdateien   */
				  /* FAXDIR=                                */
   char  header[33];              /* Absender in der Faxkopfzeile           */
                                  /* FAXHEADER=                             */
   char  faxid [33];              /* ID in der Faxkopfzeile                 */
                                  /* FAXID=                                 */
   char  g4;                      /* Erster Versuch mit G4-Modus            */
                                  /* FAXG4=J/N                              */
   int   wartezeit;               /* Wartezeit in Sek zwischen 2 Versuchen  */
                                  /* FAXWARTEZEIT=xx                        */
   int   wiederholungen;          /* Anzahl ]bertragungswiederholungen      */
                                  /* FAXWIEDERHLG=xx                        */
   int   aufloesung;              /* 1=100LPI 2=200LPI                      */
                                  /* FAXAUFLOESUNG=x                        */
   char  admin [15];              /*                                        */
                                  /* FAXADMIN=aaa                           */
   int   nachttarif;              /* Beginn des Nachttarifs z.B. 1700       */
                                  /* FAXNACHT=xxxx                          */
   int   leitungen;               /* Anzahl max. Sendungen parallel         */
                                  /* FAXLEITUNGEN=xxxx                      */
   char  monitor;                 /* J=Detalliertes Protokoll Faxserver     */
                                  /* FAXMONITOR=J   	                    */
   char  empfang;                 /* J=Faxempfang Gruppe 3                  */
                                  /* FAXEMPFANG=J   	                    */
   char  drucker[15];             /* Druckername f}r automa. Ausgabe Faxe   */
                                  /* FAXDRUCKER     	                    */
   int   ecm;	                  /* Fehlerkorrektur bei ]bertragung */
				  /* FAXECM=1 / 0 */
   char  dropt[256];              /* Druckereinstellung eing. Faxe          */
				  /* FAXDROPT				    */
};

struct   isdn_konf_dxj

{
   char  kennung    [13];         /* Teilnehmerkennung                     */
				  /* DXJKENNUNG=aaa                        */
   char  mitbenutzer[5];          /* Mitbenutzerkennung                    */
                                  /* DXJMITBENU=aaa                        */
   uchar kennwort   [15];         /* Pers|nliches Kennwort                 */
				  /* DXJPASSW=aaa                          */
   int   trennung;                /* Trennung der Verbindung nach xx Min.  */
				  /* DXJTRENNUNG=xxx                       */
   char  zugang     [12];	  /* Rufnummer des Netzknotens             */
				  /* DXJKNOTEN=xxx                         */
};

struct   isdn_konf_sms

{
   char  d1_isdn;      		  /* Zugang }ber ISDN J=JA,N=Analog        */
				  /* SMSD1ISDN=aaa                         */
   char  d1_smscenter[21];	  /* Alternativ-Rufnummer Servicecenter    */
				  /* SMSD1CENTER=                          */
   char  d1_warten;       	  /* Warten auf Best{tigung                */
				  /* SMSD1WARTEN=J/N                       */
   char  d2_isdn;      		  /* Zugang }ber ISDN J=JA,N=Analog        */
				  /* SMSD2ISDN=aaa                         */
   char  d2_smscenter[21];	  /* Alternativ-Rufnummer Servicecenter    */
				  /* SMSD2CENTER=                          */
   char  d2_warten;       	  /* Warten auf Best{tigung                */
				  /* SMSD2WARTEN=J/N                       */
   char  eplus_isdn;   		  /* Zugang }ber ISDN J=JA,N=Analog        */
				  /* SMSE+ISDN=aaa                         */
   char  eplus_smscenter[21];	  /* Alternativ-Rufnummer Servicecenter    */
				  /* SMSE+CENTER=                          */
   char  eplus_warten;       	  /* Warten auf Best{tigung                */
				  /* SMSE+WARTEN=J/N                       */
};

typedef struct

{
   char   gelesen,
          tooldir   [ISDN_PATH_LEN],
          datendir  [ISDN_PATH_LEN],
	  ofaxdir   [ISDN_PATH_LEN],
          remotehost[15];

   struct isdn_konf_allgemein   allg;
   struct isdn_konf_ressourcen  res;
   struct isdn_konf_dxj         dxj;
   struct isdn_konf_fax         fax;
   struct isdn_konf_sms         sms;
}
   isdn_konfiguration;


/*------------------------------------------------------------------------------
** /usr/isi/config/oards
**------------------------------------------------------------------------------
**
**
*/

#define  ISDN_MAX_BOARDS   15

typedef struct

{
   char  kartentyp [21];
   int   kartennr;
   char  protokoll [21];
   char  optionen  [51];
}
   IsiBoards;

/*------------------------------------------------------------------------------
** /usr/isi/config/ipif
**------------------------------------------------------------------------------
**
**
*/

#define  ISDN_MAX_IPIF   99

typedef struct

{
   char  net       [16];
   char  bez       [31];
   char  typ       [15];
   char  addr      [16];
   char  netmask   [16];
   int   mtu;
}
   IsiIpif;

/*------------------------------------------------------------------------------
** NACHRICHTEN AN DEN SERVER
**
** Struct fuer die Uebergaben der Neuigkeiten isdn_cmd -> isdn_server
*/

typedef struct

{
   uchar statusfile [15];
   int   was;
   int   pid;
}
   isdn_server_news;


/* Defines f}r "was"
**
*/

#define ISDN_CREATE     0
#define ISDN_DELETED    1
#define ISDN_DELETE     2
#define ISDN_DEBUG_ON   3
#define ISDN_DEBUG_OFF  4
#define ISDN_ENDE       5



/* --------------------------------------------------------------------------
** JOB-STATUS
**
*/

typedef struct

{
   char  statusfile[15];               /* Name der Statusdatei                */
   int   action;                       /* Siehe Defines                       */
   int   typ;                          /* F_FAX, F_CITYRUF, F_TRANSFER        */
   long  nummer;                       /* Faxnummer                           */
   long  create_time;
   long  acc_time;
   long  time;
   int   status;                       /* siehe defines S_XXXXX               */
   int   diagnostic;                   /* siehe defines D_XXXXX               */
   int   priority;                     /* 0=Hoch,7=Niedrig                    */
   uchar destination [ISDN_LEN_RUFNUMMER+1];
   uchar comment     [ISDN_NAME_LEN+1];
   uchar to_whom     [ISDN_NAME_LEN+1];
   uchar from_whom   [ISDN_NAME_LEN+1];
   uchar user        [ISDN_NAME_LEN+1];
   long  timetosend1;
   long  timetosend;
   int   retrytime;
   int   duration;
   int   pages;
   int   retries;
   int   maxretries;
   uchar cityrufnum  [ISDN_NAME_LEN+1];
   uchar cityruftext [81];
   int   resolution;
   int   fax_typ;
   int   charging_units;
   char  cil[129];
   long  speed_used;
   int   ecm;
   int   ecm_used;
}
   Isdnjobstatus;

/* --------------------------------------------------------------------------
** Paramterblock fr SMS
**
*/

typedef struct
{
 char smsc[33];        /* Nummer der SMSC, optional */
 int  conn_mode;       /* Art der Verbindung zum SMSC, 0 = MODEM, 1 = ISDN */
 int  wait_note;       /* wenn = 1 dann wird max 40 s auf notification gewartet */
 int  save_time;       /* max anzahl stunden, die das smsc die message speichert */
 char message[1001];   /* Kurzmitteilung */
 char orig[17];        /* Tel.nr des Absenders */
 char dest[17];        /* Zielnummer mit Vorwahl */
 char messid[20];      /* Message-ID bei D1 */
 int  send_lim;        /* Maximale Anzahl Messages je Session */
 int  quer_lim;        /* Maximale Anzahl Status-Queries je Session */
 int  dele_lim;        /* Maximale Anzahl Delete-Messages je Session */
 int  result;          /* ergebnis des gesamten Versuchs, 0 = OK */
 int  retry;           /* wenn true, dann ist ein spterer Versuch sinnvoll */
 int  cause;           /* isdn-cause, grund fr 'keine Verbindung' mit SMSC */
 int  t_errno;         /* tli-fehler */
 int  errno;           /* fehler */
 int  ec;              /* error code von SMSC */
 int  duration;        /* Dauer des Versuches */
 int  trn;             /* transaction-reference-number = Anzahl Versuche -1 */
 int  more_to_send;    /* flagge, es sind noch messages zu senden */
 int  ackflag;         /* flagge, letze aktion wurde besttigt */
 char result_str[400]; /* Klartextmeldung des Sendeversuches */
 char sendezeit[30];   /* Uhrzeit als String */
 int  gebuehr;         /* anzahl der angefallenen Gebhreneinheiten */
} sms_typ;

/* --------------------------------------------------------------------------
** Paramterblock fr Senden von Binaerdateien
**
*/

typedef struct
{
/* Eingangsparameter */
 char sourcepath[512];
 char telno[40];
/* Ausgangsparameter */
 int  result;
 char result_str[400];
 int  diagnostic;
 int  errno;
 int  t_errno;
 int  cause;
 int  retry;
 int  duration;
 int  charge;
} xmt_typ;

/* --------------------------------------------------------------------------
** Paramterblock fr Senden von G3-Faxdatein
**
*/

typedef struct
{
/* Eingangsparameter */
 char sourcepath[512];
 char telno[40];
 char ident[20];
 char headline[80];
 int  ecm;		/* Fehlerkorrektur bei ]bertragung */
/* Ausgangsparameter */
 int  result;
 char result_str[400];
 int  diagnostic;
 int  seiten_ges;
 int  seiten_xmt;
 int  errno;
 int  t_errno;
 int  cause;
 int  retry;
 int  duration;
 int  charge;
 int  speed_used;
 int  ecm_used;		/* Fehlerkorrektur bei ]bertragung verwendet*/
 char rem_ident[21];
} ifax_typ;

/*------------------------------------------------------------------------------
** Parameterstruktur fr fax_convert
**------------------------------------------------------------------------------
**
*/

typedef struct

{
   char  filename[256];
   int   filetype;        /* F_ASCII, F_XXXXX */
}
docinfo_typ;

/*------------------------------------------------------------------------------
** Defines fuer die Dateiformate
*/

#define  F_ASCII        (1)           /* Format ASCII                         */
#define  F_FFF          (2)           /* Ferrari-Fax-Format                   */
#define  F_PCX          (3)           /* PCX                                  */
#define  F_ASCII_132    (4)           /* Format ASCII mit 132 Zeichen/Zeile   */
#define  F_POSTSCRIPT   (5)           /* Postscript  */
#define  F_SFF          (6)           /* Standard Fax Format                  */
#define  F_PCL          (7)           /* PCL Druck Datei                      */
#define  F_BFT          (8)           /* Binaerdaten                          */

/*------------------------------------------------------------------------------
** Defines fuer den Wert "status"
**
*/

#define  S_HOLD         (1)
#define  S_FEHLER       (2)           /* Abbruch nach Error -> diagnostic     */
#define  S_READY_2_SENT (3)           /* Bereit zum Senden                    */
#define  S_SENDING      (4)           /* Fax wird gesendet                    */
#define  S_SENT         (5)           /* Fax wurde gesendet                   */
#define  S_READY_2_REC  (6)           /* Bereit zum Empfangen                 */
#define  S_RECEIVING    (7)           /* Empfaengt                            */
#define  S_RECEIVED     (8)           /* Empfangen                            */
#define  S_INCOMMING    (9)           /* Eingehender Ruf durch Senden         */
#define  S_READY_2_LOAD (10)          /* Download                             */
#define  S_LOADING      (11)          /* Download wird durchgefuehrt          */
#define  S_LOADED       (12)          /* Download abgeschlossen               */
#define  S_READY_2_CONF (13)          /* Laden EEPROM                         */
#define  S_CONFIGURING  (14)          /* Laden wird durchgefuehrt             */
#define  S_CONFIGURED   (15)          /* Laden abgeschlossen                  */
#define  S_READY_2_TALK (16)          /* Bereit zum Dialog (Cityruf)          */
#define  S_TALKING      (17)          /* Dialog wird durchgefuehrt            */
#define  S_TALKED       (18)          /* Dialog abgeschlossen                 */
#define  S_NORETRY      (19)          /* Weiterer Versuch nicht sinnvoll */
#define  S_KEINRETRY    (19)          /* jetzt ok, wegen neuem pdsmenu */

#define  S_DELETED      (1000)        /* PDS-Eigen                            */

/*------------------------------------------------------------------------------
** Defines fuer den Wert "diagnostic"
** G3-Fehler
*/

#define  D_OK           (0)
#define  D_NO_DIALTONE  (1)           /* Kein Waehlton durch die Amtsleitung  */
#define  D_AB_DIALTONE  (2)           /* Waehlton zu kurz                     */
#define  D_OCCUPIED     (3)           /* Besetzt                              */
#define  D_NO_ANSWER    (4)           /* Keine Antwort                        */
#define  D_LOOP_LOST    (5)           /* Kein Schleifenstrom                  */
#define  D_SENDING      (6)           /* Karte Sendet bereits                 */
#define  D_DIALTIMEOUT  (7)           /* Timeout beim Waehlen                 */
#define  D_NEG_CONFIRM  (8)           /* Negative Bestaetigung                */
#define  D_FTT_ONLY     (9)           /* Schlechte Leitungsqualitaet          */
#define  D_TX_TIMEOUT   (10)          /* Timeout beim Senden                  */
#define  D_OFF_HOOK     (11)          /* Die Leitung fuer die Karte ist belegt*/
#define  D_DIAL_LOCKED  (12)          /* Karte gesperrt                       */
#define  D_TX_ABORTED   (13)          /* Lokale Unterbrechung                 */
#define  D_RETRY_ERROR  (14)          /* Gegenstelle reagiert nicht           */
#define  D_DISCONNECT   (15)          /* Uebertragung durch Gegenstelle unter */
#define  D_ABORTED      (16)          /* Uebertragung abgebrochen             */
#define  D_NOTCOMPATIB  (17)          /* Nicht Faxkomp. Antwort               */

/* ISDN-Fehler     -> D_XXX = (LA_ERR_XXX + 19)
** CA-Fehler*/
#define  D_PROTO        (20)
#define  D_NOCHAN       (21)
#define  D_INTERN       (22)
#define  D_CAPFIT       (23)
#define  D_NOTACEPT     (24)
#define  D_NODTAM       (25)
#define  D_NOSERV       (26)
#define  D_OPNFIL       (27)
#define  D_CMDSESS      (28)
#define  D_UNEXPID      (29)
#define  D_WRITFIL      (30)
#define  D_TRIGREQ      (31)
#define  D_BADKONT      (32)

/*D-Kanal-Fehler*/
#define  D_NOPHYS       (33)
#define  D_NOBCHAN      (34)
#define  D_NOLAY1       (35)
#define  D_BADSERV      (36)
#define  D_LOCKED       (37)
#define  D_OCCUPIE      (38)
#define  D_NOPARTN      (39)
#define  D_NOAVAIL      (40)
#define  D_NOANSWE      (41)
#define  D_DISCHAR      (42)
#define  D_NOINCAL      (43)
#define  D_NETLOAD      (44)
/*FAX-Fehler*/
#define  D_NOFAX        (45)
#define  D_BADLINE      (46)
#define  D_TOOSLOW      (47)
#define  D_BADKOMM      (48)
#define  D_CONCLOS      (49)
#define  D_CONBROK      (50)
#define  D_BADMODE      (51)
#define  D_DATAFAI      (52)
#define  D_NOT30        (53)
/*
#define  D_LA_USER      (54)
#define  D_LA_SYS       (55)
*/
#define  D_UNKNOWN      (56)
#define  D_ACTINT       (57)

/* SMS-Errors
**
*/

#define  D_SMS_NOCONN   (70)         /* Keine Verbindung mit SMSC  */
#define  D_SMS_TLIERR   (71)         /* TLI-Fehler */
#define  D_SMS_SMSCERR  (72)         /* Fehlermeldung vom SMSC */


/* FAX-Convert-Errors */
#define	D_CANNOT_MALLOC		       (81)
#define D_CANNOT_OPEN_TMP_FILE	       (82)
#define D_INVALID_FAX_HANDLE	       (83)
#define D_CANNOT_OPEN_TEXT_FILE	       (84)
#define D_CANNOT_READ_FILE	       (85)
#define D_CANNOT_FIND_BEGIN_DATA       (86)
#define D_CANNOT_FIND_END_DATA	       (87)
#define D_GRAPHIC_TOO_BIG	       (88)
#define D_CANNOT_CREATE_PAGE_JOB       (89)
#define D_GRAPHIC_CONVERT_ERROR        (90)
#define D_TEXT_CONVERT_ERROR           (91)
#define D_CANNOT_GET_BASIS             (92)
#define D_UNKNOWN_CONVERT_ERROR        (93)

/* Fehler im Zusammenhang mit der Hardware
**
*/

#define  D_DISSIG_FAIL  (100)         /* Disconnect after signal failed       */
#define  D_NO_CONNECT   (101)         /* Keine Verbindung zur Fax-Karte       */
#define  D_DISC_FAILED  (102)         /* Disconnect failed                    */
#define  D_INTERNAL     (103)         /* Interner Error (Nicht spezifiert)    */
#define  D_WRITE_ERROR  (104)         /* Empfang: Schreibfehler Datei         */

/* Modem-Errors
**
*/

#define  D_MOD_TIMEOUT  (200)         /* Funkruf - Fehler                     */
#define  D_MOD_ERROR    (201)         /* Funkruf - Abgelehnt                  */
#define  D_MOD_DISC     (202)         /* Funkruf - Abbruch                    */


/*------------------------------------------------------------------------------
** Druckmoeglichkeiten in lprg/isdn_ausgabe.c
**
*/

#define  ISDN_DRUCK_JOURNAL 0
#define  ISDN_DRUCK_TELEFAX 1
#define  ISDN_LOE_ALLE      3
#define  ISDN_DRUCK_ALLES   4


/* Standard Cityrufzugang
**
*/

#define  ISDN_CITYRUF_ZUGANG "01691"

/* Returnwerte von isdn_protokoll()
**
*/

#define ISDN_PROT_FV	0
#define ISDN_PROT_1TR6	1
#define ISDN_PROT_DSS1	2


/* Define um den Statuswert von wait() zu analysieren
**
*/

#define LOWBYTE(b)   ((b) & 0xff)
#define EXITWERT(b)  (LOWBYTE((b) >> 8))


/* WEISS
typedef struct

{
   char  name       [15];
   char  bezeichnung[ISDN_NAME_LEN+1];
   char  empfaenger [MAX_GRP][31];
   char  nummer     [MAX_GRP][20];
}
Faxgruppe;
*/



/*------------------------------------------------------------------------------
** pds/fax/koepfe/xx
**
**
**
*/

/* WEISS
typedef struct
{
   char  bezeichnung[26];
   char  kopfzeile  [MAX_KOPFZL][81];
   int   anz_zeilen;
   char  neueseite;

   char  logo       [15];
   char  filler     [100];
}
Faxkoepfe;
*/

/*------------------------------------------------------------------------------
** Interne Struktur zum Einlesen der Hosttabelle
**
**
**
*/

#define ISDN_MAX_ART  	8
#define ISDN_MAX_RNR  	15

#define ISDN_ART_UNIX 	 	1
#define ISDN_ART_FETCOM 	2
#define ISDN_ART_IPUNIX 	3
#define ISDN_ART_DOSROUT 	4
#define ISDN_ART_MODEM 		5
#define ISDN_ART_MOBIL     	6
#define ISDN_ART_IPUNIXFV  	7
#define ISDN_ART_MODEM_7  	8

/*
#define ISDN_ART_IMODEM 	8
#define ISDN_ART_TA 		9
*/

typedef struct

{
   char  hostname[23];
   char  bez     [31];
   int   art;
   int   loeschen;
   char  login;
   char  nummer  [ISDN_MAX_RNR][ISDN_LEN_RUFNUMMER+1];
   char  ports   [ISDN_MAX_RNR][15];
   char  nrkz    [ISDN_MAX_RNR][3];
   char  ipadr   [16];
   char  ipadrf  [16];
   char  ipprot  [16];
   int   mintime;
   int   blocktime;
   char  vjhc;
   char  callback;
   char  out;
   char  euroisdn;
   int   lms_von;
   int   lms_bis;
}
   IsdnHost;



/* -----------------------------------------------------------------------------
** TDD-Behandlung
**
**
*/

#define  MAX_DATAFILES   50           /* Max. Anzahl Datenfiles in einer TDD  */
#define  CIL_LEN         129          /* Max. Lnge eines CIL-Strings */

/*------------------------------------------------------------------------------
** Jobtypen,Auftragsarten
**
*/

#define  JT_SENDFAX    	0
#define  JT_CITYRUF   	1
#define  JT_SENDFILE  	2
#define  JT_REMOTEJOB  	3
#define  JT_SMS_D2      4
#define  JT_SMS_D1      5
#define  JT_SMS_EPLUS   6

#define  ISDN_FAX          0
#define  ISDN_CITYRUF      1
#define  ISDN_TRANSFER     2

/*------------------------------------------------------------------------------
** Servicetype beim Faxen
**
*/

#define  FT_G4G3  1
#define  FT_G3    2
#define  FT_G4    3
#define  FT_BFT   4

/*------------------------------------------------------------------------------
** "function"-Arten
**
*/

#define  FU_SF	 1
#define  FU_RF	 2
#define  FU_SB	 3
#define  FU_RB	 4
#define  FU_REC 5
#define  FU_URQ 6
#define  FU_URS 7
#define  FU_UI	 8
#define  FU_SC	 9
#define  FU_SCC 10
#define  FU_CCI 11
#define  FU_CI	 12

#define  FU_SF_STR  "SEND_FAX"
#define  FU_RF_STR  "RECEIVE_FAX"
#define  FU_SB_STR  "SEND_BFT"
#define  FU_RB_STR  "RECEIVE_BFT"
#define  FU_REC_STR "RECEIVER"
#define  FU_URQ_STR "UPDATE_REQ"
#define  FU_URS_STR "UPDATE_RESP"
#define  FU_UI_STR  "UPDATE_IND"
#define  FU_SC_STR  "SEND_CMD"
#define  FU_SCC_STR "SEND_CMD_CB"
#define  FU_CCI_STR "CMD_CB_IND"
#define  FU_CI_STR  "CMD_IND"

/*------------------------------------------------------------------------------
** LA-Stati in TDD nach ocs_la
**
*/

#define  LA_STAT_OK    0
#define  LA_STAT_FAIL  1
#define  LA_STAT_PFAIL 2
#define  LA_STAT_UNDEF 3
#define  LA_STAT_NOTSET 4


/*------------------------------------------------------------------------------
** LA-Return-Werte
**
*/

#define   LAR_OK         0
#define   LAR_USER_ERR   254
#define   LAR_SYS_ERR    255


/*------------------------------------------------------------------------------
** LA-Fehler in TDD nach ocs_la
**
*/

#define  LA_ERR_OK        0

/*CA-Fehler*/
#define  LA_ERR_PROTO     1
#define  LA_ERR_NOCHAN    2
#define  LA_ERR_INTERN    3
#define  LA_ERR_CAPFIT    4
#define  LA_ERR_NOTACEPT  5
#define  LA_ERR_NODTAM    6
#define  LA_ERR_NOSERV    7
#define  LA_ERR_OPNFIL    8
#define  LA_ERR_CMDSESS   9
#define  LA_ERR_UNEXPID  10
#define  LA_ERR_WRITFIL  11
#define  LA_ERR_TRIGREQ  12
#define  LA_ERR_BADKONT  13

/*D-Kanal-Fehler*/
#define  LA_ERR_NOPHYS   14
#define  LA_ERR_NOBCHAN  15
#define  LA_ERR_NOLAY1   16
#define  LA_ERR_BADSERV  17
#define  LA_ERR_LOCKED   18
#define  LA_ERR_OCCUPIE  19
#define  LA_ERR_NOPARTN  20
#define  LA_ERR_NOAVAIL  21
#define  LA_ERR_NOANSWE  22
#define  LA_ERR_DISCHAR  23
#define  LA_ERR_NOINCAL  24
#define  LA_ERR_NETLOAD  25
/*FAX-Fehler*/
#define  LA_ERR_NOFAX    26
#define  LA_ERR_BADLINE  27
#define  LA_ERR_TOOSLOW  28
#define  LA_ERR_BADKOMM  29
#define  LA_ERR_CONCLOS  30
#define  LA_ERR_CONBROK  31
#define  LA_ERR_BADMODE  32
#define  LA_ERR_DATAFAI  33
#define  LA_ERR_NOT30    34

#define  LA_ERR_LAUSER   35
#define  LA_ERR_LASYS    36
#define  LA_ERR_LAUNK    37
#define  LA_ERR_INT      38



/*------------------------------------------------------------------------------
** FAX-Quelldateitypen
**
*/

#define  FQ_ASCII80     0
#define  FQ_ASCII132    1
#define  FQ_PCX         2

/*------------------------------------------------------------------------------
** Defines fr den ISDN-Filetransfer
**
*/
#define FTXFER_SERVICE     "filetrans"
#define FT_DATALEN       4000
#define FTOP_ACK         0             /*allg. quittung */
#define FTOP_DATA        1             /*Daten          */
#define FTOP_ERROR       2             /*Fehler (NR., Text)    */

/*------------------------------------------------------------------------------
** Defines fr den G3-Faxversand
**
*/
#define FAX_SERVICE     "fax"



/*------------------------------------------------------------------------------
** Struct fr die Infos bezglich TDD-Files und LA-Prozesse
**
*/

typedef struct

{
   int   fax_typ;                      /* FT_G3, FT_G4 ,FT_G4_G3, FT_BFT */
   int   g3_resolution;                /* P_200LPI, P_100LPI */
   long  time;
   int   duration;
   FILE  *tddfile;                     /* TDD-Datei */
   char  tddfilename [ISDN_FILE_LEN+1];   /* TDD-Dateiname	*/
   int   tdd_function;                 /* function in tdd */
   int   tddlines;                     /* Zeilenanzahl in der urpr. TDD-Datei*/
   int   la_status;                    /* Status nach erfolgereicher LA*/
   char  comm_id     [33];     	      /* ID-String f}r korrespond. Conn.  */
   char  faxfilename [ISDN_FILE_LEN+1];  /* Dateiname der T4 oder T6-Datei   */
   char  datafilename[MAX_DATAFILES][ISDN_FILE_LEN+1]; /* Datendateinamen       */
   int   dataformat[MAX_DATAFILES];    /* Datendateiformate                */
   char  la_datafilename[MAX_DATAFILES][ISDN_FILE_LEN+1]; /* Datendateinamen von LA*/
   char  la_origname[MAX_DATAFILES][ISDN_FILE_LEN+1]; /* Originaldateinamen von LA*/
   int   la_filestatus[MAX_DATAFILES]; /* Status einer Datei bei SEND_CMD_CB*/
   char  la_cil[MAX_DATAFILES][CIL_LEN+1]; /* communication id line je datei  */
   char  la_address[ISDN_LEN_RUFNUMMER+1];           /* Empf{nger-Nummer von LA   */
   int   la_error;                         /* Fehler von LA */
   int   la_service;                  /* verwendeter FAX-Typ (G3 od. G4) */
   int   la_g3_speed;                 /* verwendeter FAX-G3 Baudrate */
   int   charging_units;
   char  remoteid [40];               /* Remote-ID-Zeile       */
}
   tddinfo_typ;


/*-------------------------------------------------------------------------*/

extern char  *isdnTextStatus[];
extern isdn_konfiguration Isdnk;

extern isdn_konfiguration Isdnkonf;
extern char *IsdnTextStatus[];

#include <pds/isdn_resc.h>

#ifdef __STDC__
extern struct t_call *isi_filloptions (char *, struct t_call *);
extern char          *isi_cause(int);
#else
extern struct t_call *isi_filloptions ();
extern char   *isi_cause();
#endif


#endif
