#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <termios.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <errno.h>
#include <netdb.h>
#include <netinet/in.h>
#include <pds/fetsrv.h>

#define DEBUG 1

static struct servent sessalive_service;
static int alivesock;

typedef struct {
long request;		/* Request-Typ */
char local_number[20];	/* lokale Rufnummer */
char ext_number[20];	/* externe Rufnummer */
char eaz[10];		/* EAZ */
char service[20];	/* Service-Id. */
} ALIVEDATA;

static char EAZ[20];
static char Service[20];
static char DeviceName[200];

/*  ***************************************************************** */
static int create_socket()
{
int rundfunk;

rundfunk=1;

   if ((alivesock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
   {
      printf("error in socket(), errno=%d\n",errno);
      return (0);
   }

   if (setsockopt (alivesock,SOL_SOCKET,SO_BROADCAST,(char *)&rundfunk,
                                                      sizeof (rundfunk)))
   {
      fprintf(stderr,"setsockopt(),%s\n",sys_errlist[errno]);
      return (0);
   }

return(1);
}
/*  ***************************************************************** */
static int get_services()
{
struct servent *service;

   if ((service = getservbyname("alive", "udp")) == NULL)
   {
      printf("error in getservbyname(), errno=%d\n",errno);
      fflush(stdout);
      return (0);
   }
   else
      memcpy (&sessalive_service,service,sizeof (struct servent));

return(1);
}
/*  ***************************************************************** */
#define BUFSIZE 100
int send_aliveinfo(Rufnummer)
char *Rufnummer;
{
char buffer[BUFSIZE];
unsigned short kennung;

struct sockaddr_in remote;
int                addrlen,rcode;

kennung = KE_D_CHAN_ALIVE;

memset (buffer, 0, BUFSIZE);
memcpy (buffer, &kennung, 2);
strcpy (&buffer[52],Rufnummer);




 memset(&remote, 0,sizeof(remote));
 remote.sin_family = AF_INET;
 /* remote.sin_addr.s_addr = htonl(0x7f000001);  */ /*local */ 
 remote.sin_addr.s_addr = inet_addr("127.0.0.1");
 remote.sin_port = sessalive_service.s_port;
 addrlen = sizeof(remote);

 rcode = sendto (alivesock, &buffer, sizeof(buffer), 0 ,(struct sockaddr *)&remote, addrlen);
 if (rcode < 0)
 {
    fprintf(stderr,"error in sendto(),errno= %d %s\n",errno,sys_errlist[errno]);
    return (0);
 }

 return (1);
}
/*  ***************************************************************** */
static int rcv_packet(fd, pattern, sec)
int fd;
char *pattern;
int sec;
{
static void timer_interrupt(int);
int offset;
int len;
int rc;
int k;
char buffer[1024];


len=strlen(pattern);
offset=0;

while(1)					{

if (sec) 
{
alarm(sec * 1000);
signal(SIGALRM, timer_interrupt);
}

rc= read(fd,(char *)&buffer[offset],1);
buffer[offset+1]=0;


if (sec) alarm(0);

if(rc != 1) return(1);


offset++;
if(offset == 1000) break;

#ifdef DEBUG
printf("\n%s",buffer); fflush(stdout);
#endif

if(offset < len) continue;

for(k=0; k< offset; k++)	{
if(memcmp(&buffer[k], pattern, len) == 0) 
{
return(0);
}
				}
						}



return(1);
}
/*  ***************************************************************** */
static void tty_init(fd)
int fd;
{
int status;
struct termios term;

status=tcgetattr(fd, &term);

if(status)
{
return;
}

term.c_iflag &= ~( ICRNL );
term.c_cflag &= ~( CLOCAL );
term.c_cflag |=  ( CRTSCTS);
term.c_oflag &=  ~( OPOST);
term.c_lflag &=  ~( ISIG ); 
term.c_lflag &=  ~( ICANON ); 
term.c_lflag &=  ~( ECHO ); 
term.c_lflag &=  ~( ECHOE ); 
term.c_lflag &=  ~( ECHOK ); 
term.c_lflag &=  ~( IEXTEN ); 


term.c_cc[5]=1;

tcsetattr(fd,TCSAFLUSH, &term);

}

/*  ***************************************************************** */
static int atCmd(fd,commando)
int fd;
char *commando;
{
return(write(fd,commando,strlen(commando)));
}
/*  ***************************************************************** */
static int rcv_caller(fp, telno, sec)
int fp;
char *telno;
int sec;
{
static void timer_interrupt(int);
int offset;
int len;
int rc;
int k;
char buffer[300];

*telno=0;



offset=0;


while(1)					{


if(sec)
{
alarm(sec * 1000);
signal(SIGALRM, timer_interrupt);
}

rc= read(fp,(char *)&buffer[offset],1);
buffer[offset+1]=0;

if (sec) alarm(0);

if(rc != 1) return(1);


#ifdef DEBUG
printf("\n%s",buffer); fflush(stdout);
#endif

if(buffer[offset] == 0x0d)
{
buffer[offset] = 0;
strcpy(telno,buffer);
return(0);
}

offset++;
if(offset == 39) break;
						}



return(1);
}
/*  ***************************************************************** */
static int recv_ruf_nummer(fd)
int fd;
{
int rcode;
char at_commando[80];
char Rufnummer[80];

if(rcv_packet(fd,"CALLER NUMBER: ", 0)) return(0);
if(rcv_caller(fd,Rufnummer, 2)) return(0);

printf("\nRufnummer empf. %s",Rufnummer); fflush(stdout);

sprintf(at_commando,"ATH\r");
rcode = atCmd(fd, at_commando);

/* printf("\nRufnummer <%s> empfangen.",Rufnummer); fflush(stdout); */
/* ALIVE Info von <Rufnummer> empfangen */
send_aliveinfo(Rufnummer);
return(0);
}
/*  ***************************************************************** */
main(argc, argv)
int argc;
char *argv[];
{
int rcode;
char at_commando[200];
int fd;

if(get_services() == 0) exit(1);
if(create_socket() == 0) exit(1);
send_aliveinfo("...");
exit(1);

if(argc != 4) exit(1);

if(get_services() == 0) exit(1);

if(create_socket() == 0) exit(1);

strcpy(DeviceName,argv[1]);
strcpy(EAZ,argv[2]);
strcpy(Service,argv[3]);

fd= open(DeviceName,O_RDWR);
if(fd < 0) exit(1);

tty_init(fd);

sprintf(at_commando,"at&F\r");
rcode = atCmd(fd,at_commando);
if(rcv_packet(fd,"OK", 2)) exit(1);

sprintf(at_commando,"atE0\r");
rcode = atCmd(fd, at_commando);
if(rcv_packet(fd,"OK", 2)) exit(1);

sprintf(at_commando,"at&X0\r");
rcode = atCmd(fd, at_commando);
if(rcv_packet(fd,"OK", 2)) exit(1);

sprintf(at_commando,"at&E%s\r",EAZ);
rcode = atCmd(fd, at_commando);
if(rcv_packet(fd,"OK", 2)) exit(1);

sprintf(at_commando,"ats14=3\r");
rcode = atCmd(fd, at_commando);
if(rcv_packet(fd,"OK", 2)) exit(1);

sprintf(at_commando,"ats19=%s\r",Service);
rcode = atCmd(fd, at_commando);
if(rcv_packet(fd,"OK", 2)) exit(1);


while(1)	{
if(recv_ruf_nummer(fd)) break;;
		}
}
/*  ***************************************************************** */
static void timer_interrupt(sig_nr)
int sig_nr;
{
}
/*  ***************************************************************** */
