#include <stdio.h>
#include <string.h>
#include <tiffio.h>

main(int argc, char **argv)
{
TIFF* tif;

if(argc != 9) { 
	printf("\nsettiff: invalid parameters"); 
	fflush(stdout);
	exit(1);
}


tif = TIFFOpen(argv[1], "r+");

if (!tif) {
	printf("\nTIFFOpen() failed."); fflush(stdout);
	exit(1);
    }




    if (TIFFSetField(tif, TIFFTAG_DATETIME, argv[2]) != 1) {
	printf("\nSET TIFFTAG_DATETIME: %s failed",argv[2]);
	fflush(stdout);
    }


    if (TIFFSetField(tif, TIFFTAG_HOSTCOMPUTER, argv[3]) != 1) {
	printf("\nSET TIFFTAG_HOSTCOMPUTER: %s failed",argv[3]);
	fflush(stdout);
    }

    if (TIFFSetField(tif, TIFFTAG_SOFTWARE, argv[4]) != 1) {
	printf("\nSET TIFFTAG_SOFTWARE: %s failed",argv[4]);
	fflush(stdout);
    }

    if (TIFFSetField(tif, TIFFTAG_IMAGEDESCRIPTION, argv[5]) != 1) {
	printf("\nSET TIFFTAG_IMAGEDESCRIPTION: %s failed",argv[5]);
	fflush(stdout);
    }

    if (TIFFSetField(tif, TIFFTAG_MAKE, argv[6]) != 1) {
	printf("\nSET TIFFTAG_MAKE: %s failed",argv[6]);
	fflush(stdout);
    }

    if (TIFFSetField(tif, TIFFTAG_MODEL, argv[7]) != 1) {
	printf("\nSET TIFFTAG_MODEL: %s failed",argv[7]);
	fflush(stdout);
    }

    if (TIFFSetField(tif, TIFFTAG_FAXRECVTIME, argv[8]) != 1) {
	printf("\nSET TIFFTAG_FAXRECVTIME: %s failed",argv[8]);
	fflush(stdout);
    }




    if(TIFFWriteDirectory(tif)) {
    printf("\nTIFFWriteDirectory is OK!"); fflush(stdout);
    }

    TIFFFlushData(tif);
    TIFFFlush(tif);
    TIFFClose(tif);

}
