// Code generated by kube-linter template codegen. DO NOT EDIT.
//go:build !templatecodegen
// +build !templatecodegen

package params

import (
	"fmt"
	"strings"

	"golang.stackrox.io/kube-linter/pkg/check"
	"golang.stackrox.io/kube-linter/pkg/templates/util"
)

var (
	// Use some imports in case they don't get used otherwise.
	_ = util.MustParseParameterDesc

	requirementsTypeParamDesc = util.MustParseParameterDesc(`{
	"Name": "requirementsType",
	"Type": "string",
	"Description": "The type of requirement. Use any to apply to both requests and limits.",
	"Examples": null,
	"Enum": [
		"request",
		"limit",
		"any"
	],
	"SubParameters": null,
	"ArrayElemType": "",
	"Required": true,
	"NoRegex": false,
	"NotNegatable": false,
	"XXXStructFieldName": "RequirementsType",
	"XXXIsPointer": false
}
`)

	lowerBoundMillisParamDesc = util.MustParseParameterDesc(`{
	"Name": "lowerBoundMillis",
	"Type": "integer",
	"Description": "The lower bound of the requirement (inclusive), specified as a number of milli-cores. If not specified, it is treated as a lower bound of zero.",
	"Examples": null,
	"Enum": null,
	"SubParameters": null,
	"ArrayElemType": "",
	"Required": false,
	"NoRegex": false,
	"NotNegatable": false,
	"XXXStructFieldName": "LowerBoundMillis",
	"XXXIsPointer": false
}
`)

	upperBoundMillisParamDesc = util.MustParseParameterDesc(`{
	"Name": "upperBoundMillis",
	"Type": "integer",
	"Description": "The upper bound of the requirement (inclusive), specified as a number of milli-cores. If not specified, it is treated as \"no upper bound\".",
	"Examples": null,
	"Enum": null,
	"SubParameters": null,
	"ArrayElemType": "",
	"Required": false,
	"NoRegex": false,
	"NotNegatable": false,
	"XXXStructFieldName": "UpperBoundMillis",
	"XXXIsPointer": true
}
`)

	ParamDescs = []check.ParameterDesc{
		requirementsTypeParamDesc,
		lowerBoundMillisParamDesc,
		upperBoundMillisParamDesc,
	}
)

func (p *Params) Validate() error {
	var validationErrors []string
	if p.RequirementsType == "" {
		validationErrors = append(validationErrors, "required param requirementsType not found")
	}
	var found bool
	for _, allowedValue := range []string{
		"request",
		"limit",
		"any",
	}{
		if p.RequirementsType == allowedValue {
			found = true
			break
		}
	}
	if !found {
		validationErrors = append(validationErrors, fmt.Sprintf("param requirementsType has invalid value %q, must be one of [request limit any]", p.RequirementsType))
	}
	if len(validationErrors) > 0 {
		return fmt.Errorf("invalid parameters: %s", strings.Join(validationErrors, ", "))
    }
	return nil
}

// ParseAndValidate instantiates a Params object out of the passed map[string]interface{},
// validates it, and returns it.
// The return type is interface{} to satisfy the type in the Template struct.
func ParseAndValidate(m map[string]interface{}) (interface{}, error) {
	var p Params
	if err := util.DecodeMapStructure(m, &p); err != nil {
		return nil, err
	}
	if err := p.Validate(); err != nil {
		return nil, err
	}
	return p, nil
}

// WrapInstantiateFunc is a convenience wrapper that wraps an untyped instantiate function
// into a typed one.
func WrapInstantiateFunc(f func(p Params) (check.Func, error)) func(interface{}) (check.Func, error) {
	return func(paramsInt interface{}) (check.Func, error) {
		return f(paramsInt.(Params))
	}
}
