# Changelog

- [Changelog](#changelog)
- [v1.0.4](#v104)
- [v1.0.3](#v103)
- [v1.0.2](#v102)
- [v1.0.1](#v101)
- [v1.0.0](#v100)
- [v0.8.3](#v083)
- [v0.8.2](#v082)
- [v0.8.1](#v081)
- [v0.8.0](#v080)
- [v0.7.5](#v075)
- [v0.7.4](#v074)
- [v0.7.3](#v073)
- [v0.7.2](#v072)
- [v0.7.1](#v071)
- [v0.7.0](#v070)
- [v0.6.3](#v063)
- [v0.6.2](#v062)
- [v0.6.1](#v061)
- [v0.6.0](#v060)
- [v0.5.4](#v054)
- [v0.5.3](#v053)
- [v0.5.2](#v052)
- [v0.5.1](#v051)
- [v0.5.0](#v050)
- [v0.4.1](#v041)
- [v0.4.0](#v040)
- [v0.3.1](#v031)
- [v0.3.0](#v030)
- [v0.2.1](#v021)
- [v0.2.0](#v020)
- [v0.1.1](#v011)
- [v0.1](#v01)

# v1.0.4

Added
- Added filtering for C++ exception handling internals during printing. This cleans up output from current exceptions
  and std::terminate traces.

Fixed:
- Fixed reported version number for cpptrace

Other:
- Bumped default libdwarf to 2.1.0
- Updated stacktrace output for the cpptrace terminate handler
- Updated demo program

# v1.0.3

Added:
- Added line indicator to make source code snippets in case colors aren't being used
- Added column indicator to source code snippets
- Added 32-bit ARM support for StackWalk64 https://github.com/jeremy-rifkin/cpptrace/pull/271 (@Xottab-DUTY)

# v1.0.2

Added:
- Added `break_before_filename` formatting option https://github.com/jeremy-rifkin/cpptrace/issues/259 (@codeinred)

Fixes:
- Fixed 32-bit clang-cl build
- Fixed build on gcc 4.8.5
- Fixed StackWalk64 for 64-bit arm https://github.com/jeremy-rifkin/cpptrace/pull/270 (@mcourteaux)
- Fixed compatibility issue with cmake versions before 3.23

Other:
- Added a couple notes to the README

# v1.0.1

Added:
- Added from-current-exception utility for SEH on windows (`CPPTRACE_SEH_TRY`/`CPPTRACE_SEH_EXCEPT`)

Fixes:
- Fixed a static assert without a message causing issues on some C++11 builds
- Fixed build 32-bit build on linux
- Fixed from-current-exception system for 32-bit windows where SEH behaves much differently
- Fixed clang-cl build

# v1.0.0

Major changes:
- Overhauled how the from-current-exception system and `CPPTRACE_TRY`/`CPPTRACE_CATCH` macros work. They now check the
  thrown exception type against the type the catch accepts to decide whether or not to collect a trace. This eliminates
  the need for The `TRYZ`/`CATCHZ` variants of the macros as now the normal macro is equally zero-overhead. As such, the
  `Z` variants have been removed.

Breaking changes:
- `CPPTRACE_TRYZ` and `CPPTRACE_CATCHZ` have been removed, change uses to `CPPTRACE_TRY`/`CPPTRACE_CATCH`
- `CPPTRACE_TRY`/`CPPTRACE_CATCH` macros no longer support multiple handlers and `CPPTRACE_CATCH_ALT` has been removed.
  Instead, use `cpptrace::try_catch`.
  > **Details**
  >
  > Author's note: I apologize for this non-trivial breaking change, however, it allows for a much improved
  > implementation of the from-current-exception system. The impact should be [very minimal](https://github.com/search?type=code&q=%2F%5CbCPPTRACE_CATCH_ALT%5Cb%2F+language%3Ac%2B%2B+-is%3Afork+-repo%3Ajeremy-rifkin%2Fcpptrace+-path%3Afrom_current.hpp)
  > for most codebases.
  >
  > Transitioning to `cpptrace::try_catch` is straightforward:
  > <table>
  > <thead>
  > <tr>
  > <td>
  > Before
  > </td>
  > <td>
  > Now
  > </td>
  > </tr>
  > </thead>
  > <tbody>
  > <tr>
  > <td>

  > ```cpp
  > CPPTRACE_TRY {
  >     foo();
  > } CPPTRACE_CATCH(const std::logic_error& e) {
  >     handle_logic_error(e);
  > } CPPTRACE_CATCH_ALT(const std::exception& e) {
  >     handle_exception(e);
  > } CPPTRACE_CATCH_ALT(...) {
  >     handle_unknown_exception();
  > }
  > ```

  > </td>
  > <td>

  > ```cpp
  > cpptrace::try_catch(
  >     [&] { // try block
  >         foo();
  >     },
  >     [&] (const std::runtime_error& e) {
  >         handle_logic_error(e);
  >     },
  >     [&] (const std::exception& e) {
  >         handle_exception(e);
  >     },
  >     [&] () { // `catch(...)`
  >         handle_unknown_exception();
  >     }
  > );
  > ```

  > </td>
  > </tr>
  > </tbody>
  > </table>
  >
  > Please note as well that code such as the following, which was valid before, will still compile now but may report a
  > misleading trace. The second catch handler will work but it cpptrace won't know about the handler's type and won't
  > collect a trace that doesn't match the first handler's type, `std::logic_error`.
  >
  > ```cpp
  > CPPTRACE_TRY {
  >     foo();
  > } CPPTRACE_CATCH(const std::logic_error& e) {
  >     ...
  > } catch(const std::exception& e) {
  >     ...
  > }
  > ```

Potentially-breaking changes:
- This version of cpptrace reworks the public interface to use an inline ABI versioning namespace. All symbols in the
  public interface are now secretly in the `cpptrace::v1` namespace. This is an ABI break, but any ABI mismatch will
  result in linker errors instead of silent bugs. This change is an effort to allow future evolution of cpptrace in a
  way that respects ABI.
- This version fixes a problem with returns from `CPPTRACE_TRY` blocks on windows. Unfortunately, this macro has to use
  an IILE on windows and as such `return` statements won't properly return from the enclosing function. This was a
  footgun and now `return` statements in `CPPTRACE_TRY` blocks are prevented from compiling on windows.

Added
- Added `cpptrace::try_catch` for handling multiple alternatives with access to current exception traces
- Added `cpptrace::rethrow` utility for rethrowing exceptions from `CPPTRACE_CATCH` while preserving the stacktrace https://github.com/jeremy-rifkin/cpptrace/issues/214
- Added utilities for getting the current trace from the last rethrow point
  (`cpptrace::raw_trace_from_current_exception_rethrow`, `cpptrace::from_current_exception_rethrow`,
  `cpptrace::current_exception_was_rethrown`)
- Added a logger system to allow cpptrace to report errors in a configurable manner. By default, cpptrace doesn't log
  anything. The following functions can be used to change this: (`cpptrace::set_log_level`,
  `cpptrace::set_log_callback`, and `cpptrace::use_default_stderr_logger`)
- Added `cpptrace::basename` utility
- Added `cpptrace::prettify_type` utility
- Added `cpptrace::prune_symbol` utility
- Added formatter option for symbol formatting (`cpptrace::formatter::symbols`)
- Added `cpptrace::detail::lazy_trace_holder::is_resolved`
- Added support for C++20 modules https://github.com/jeremy-rifkin/cpptrace/pull/248
- Added `cpptrace::load_symbols_for_file` to support DLLs loaded at runtime when using dbghelp https://github.com/jeremy-rifkin/cpptrace/pull/247

Removed
- Removed `CPPTRACE_TRYZ` and `CPPTRACE_CATCHZ` macros
- Removed the `CPPTRACE_CATCH_ALT` macro

Fixed
- Fixed a problem where `CPPTRACE_TRY` blocks could contain `return` statements but not return on windows due to an IILE. This is now an error. https://github.com/jeremy-rifkin/cpptrace/issues/245
- Fixed cases where cpptrace could print to stderr on internal errors without the user desiring so https://github.com/jeremy-rifkin/cpptrace/issues/234
- Fixed a couple internal locking mistakes
- Fixed a couple of code paths that could be susceptible to static init order issues
- Fixed bug with loading elf symbol tables that contain zero-sized entries
- Fixed an incorrect assertion regarding looking up symbols at program counters that reside before any seen subprogram DIE https://github.com/jeremy-rifkin/cpptrace/issues/250
- Fixed issue with `cpptrace::stacktrace::to_string()` ending with a newline on empty traces

Other
- Marked some paths in `CPPTRACE_CATCH` and `CPPTRACE_CATCHZ` as unreachable to improve usability in cases where the
  compiler may warn about missing returns.
- Improved resilience to libdwarf errors https://github.com/jeremy-rifkin/cpptrace/pull/251
- Removed internal use of `std::is_trivial` which is deprecated in C++26 https://github.com/jeremy-rifkin/cpptrace/issues/236
- Bumped libdwarf to 2.0.0
- Added `--address` flag for internal symbol table tool
- Various internal work to improve the codebase and reduce complexity

# v0.8.3

Added:
- Added basic JIT support https://github.com/jeremy-rifkin/cpptrace/issues/226
- Added `cpptrace::formatter::transform` https://github.com/jeremy-rifkin/cpptrace/issues/227
- Added support for gcc 4.8.5 https://github.com/jeremy-rifkin/cpptrace/issues/220

Fixed:
- Fixed bug related to calling `dwarf_dealloc` on strings from `dwarf_formstring` and `dwarf_diename` https://github.com/davea42/libdwarf-code/issues/279
- Fixed incorrect cmake version variable https://github.com/jeremy-rifkin/cpptrace/issues/231
- Fixed `address_mode::none` not working https://github.com/jeremy-rifkin/cpptrace/issues/221
- Fixed use of `-Wall` for clang-cl

Other:
- Added ARM CI
- Miscellaneous work on supporting old compilers
- Updated cpptrace cmake target configuration to not add public compile definitions
- Internal refactoring, cleanup, and code improvements

# v0.8.2

Fixed:
- Fixed printing of internal error messages when an object file can't be loaded, mainly affecting MacOS https://github.com/jeremy-rifkin/cpptrace/issues/217

Other:
- Bumped zstd via FetchContent to 1.5.7

# v0.8.1

Fixed:
- Fixed compile error on msvc https://github.com/jeremy-rifkin/cpptrace/issues/215

Added:
- Added `cpptrace::can_get_safe_object_frame()`

Breaking changes:
- Renamed ctrace's `can_signal_safe_unwind` to `ctrace_can_signal_safe_unwind`. This was an oversight. Apologies for
  including a breaking change in a patch release. Github code search suggests this API isn't used in public code, at
  least.

Other:
- Added CI workflow to test on old msvc
- Made some internal improvements on robustness and cleanliness

# v0.8.0

Added:
- Added support for resolving symbols from elf and mach-o symbol tables, allowing function names to be resolved even in
  a build that doesn't include debug information https://github.com/jeremy-rifkin/cpptrace/issues/201
- Added a configurable stack trace formatter https://github.com/jeremy-rifkin/cpptrace/issues/164
- Added configuration options for the libdwarf back-end that can be used to lower memory usage on memory-constrained
  systems https://github.com/jeremy-rifkin/cpptrace/issues/193
- Added `cpptrace::nullable<T>::null_value`
- Made `cpptrace::nullable<T>` member functions conditionally `constexpr` where possible

Fixed:
- Fixed handling of `SymInitialize` when other code has already called `SymInitialize`. `SymInitialize` must only be
  called once per handle and cpptrace now attempts to duplicate the current process handle to avoid conflicts.
  https://github.com/jeremy-rifkin/cpptrace/issues/204
- Fixed a couple of locking edge cases surrounding dbghelp functions
- Fixed improper deallocation of `dwarf_errmsg` in the libdwarf back-end

Breaking changes:
- `cpptrace::get_snippet` previously included a newline at the end but it now does not. This also affects the behavior
  of trace formatting with snippets enabled.

Other:
- Significantly improved memory usage and performance of the libdwarf back-end
- Improved implementation and organization of internal utility types, such as `optional` and `Result`
- Improved trace printing and formatting implementation
- Added unit tests for library internal utilities
- Added logic to the cxxabi demangler to ensure external names begin with `_Z` or `__Z` before attempting to demangle
- Added various internal tools and abstractions to improve maintainability and clarity
- Various internal improvements for robustness
- Added a small handful of utility tool programs that are useful for continued development, maintenance, and debugging
- Improved library CI setup
- Marked the `CPPTRACE_BUILD_BENCHMARK` option as advanced

# v0.7.5

Fixed:
- Fixed missing `<typeinfo>` include https://github.com/jeremy-rifkin/cpptrace/pull/202
- Added `__cdecl` to a terminate handler to appease MSVC under some configurations https://github.com/jeremy-rifkin/cpptrace/issues/197
- Set C++ standard for cmake support checks https://github.com/jeremy-rifkin/cpptrace/issues/200
- Changed hyphens to underscores for cmake component names due to cpack issue https://github.com/jeremy-rifkin/cpptrace/issues/203

# v0.7.4

Added:
- Added `<cpptrace/version.hpp>` header with version macros

Fixes:
- Bumped libdwarf to 0.11.0 which fixes a number of dwarf 5 debug fission issues

Other:
- Various improvements to internal testing setup

# v0.7.3

Fixed:
- Fixed missing include affecting macos https://github.com/jeremy-rifkin/cpptrace/pull/183
- Fixed issue with cmake not using the ccache program found by `find_program` https://github.com/jeremy-rifkin/cpptrace/pull/184
- Fixed missing include and warnings affecting mingw https://github.com/jeremy-rifkin/cpptrace/pull/186
- Fixed issue with identifying inlined call frames when the `DW_TAG_inlined_subroutine` is under a `DW_TAG_lexical_block`
- Fixed a typo in the README
- Improved unittest support on various configurations
- Improved unittest robustness under LTO
- Fixed bug signal_demo in the event `fork()` fails

Added:
- Added color overload for `stacktrace_frame::to_string`
- Added CMake `export()` definition for cpptrace as well as a definition for libdwarf which currently doesn't provide one

Changed:
- Updated documentation surrounding the signal safe API

# v0.7.2

Changes:
- Better support for older CMake with using `FetchContent_Declare` from a URL https://github.com/jeremy-rifkin/cpptrace/pull/176
- Better portability for page size detection https://github.com/jeremy-rifkin/cpptrace/pull/177
- Improved compile times https://github.com/jeremy-rifkin/cpptrace/pull/172
- Split up `cpptrace.hpp` into finer-grained headers for lower compile time impact
- Some minor readme restructuring

# v0.7.1

Added
- Better support for finding libunwind on macos https://github.com/jeremy-rifkin/cpptrace/pull/162
- Support for libbacktrace under mingw https://github.com/jeremy-rifkin/cpptrace/pull/166

Fixed
- Computation of object address for safe object frames https://github.com/jeremy-rifkin/cpptrace/issues/169
- Nested microfmt in cpptrace's namespace due to an ODR problem with libassert https://github.com/jeremy-rifkin/libassert/issues/103
- Compilation on iOS https://github.com/jeremy-rifkin/cpptrace/pull/167
- Compilation on old MSVC https://github.com/jeremy-rifkin/cpptrace/pull/165
- Dbghelp use on 32 bit https://github.com/jeremy-rifkin/cpptrace/issues/170
- Warning in brand new cmake due to `FetchContent_Populate` being deprecated https://github.com/jeremy-rifkin/cpptrace/issues/171

Other changes
- Bumped the buffer size for execinfo and CaptureStackBackTrace to 400 frames
- Switched to execinfo.h for unwinding on clang/apple clang on macos due to `_Unwind` not working with `-fno-exceptions` https://github.com/jeremy-rifkin/cpptrace/issues/161

# v0.7.0

Added
- Added `cpptrace::from_current_exception()` and associated exception handler macros to allow tracing of all exceptions,
  even without cpptrace traced exception objects.

Fixes:
- Fixed issue with using `resolve_safe_object_frame` on `safe_object_frame`s with empty paths
- Fixed handling of dwarf 4 rangelist base addresses when a `DW_AT_low_pc` is not present
- Fixed use of `-g` with MSVC

Other changes:
- Bazel is now supported on linux (https://github.com/jeremy-rifkin/cpptrace/pull/153)
- More work on testing
- Some internal refactoring

# v0.6.3

Added:
- Added a flag to disable inclusion of `<format>` by cpptrace.hpp and the definition of formatter specializations

Fixes:
- Fixed use after free during cleanup of split dwarf information https://github.com/jeremy-rifkin/cpptrace/issues/141
- Fixed an issue with TCO by clang on arm interfering with unwinding skip counts for internal methods
- Fixed issue with incorrect object addresses being reported on macos when debug maps are used
- Fixed issue with handling of split dwarf emitted by clang under dwarf4 mode

Other changes:
- Added note about signal-safe tracing requiring `_dl_find_object` to documentation and fixed errors in the signal-safe
  tracing docs
- Added more configurations to unittest ci setup
- Optimized unittest ci matrix setup
- Added options for zstd and libdwarf sources if FetchContent is being used to bring the dependencies in
- Optimized includes in cpptrace.hpp

# v0.6.2

Fixes:
- Fix an issue with unwinding to collect stack traces during exception creation on arm https://github.com/jeremy-rifkin/cpptrace/issues/134
- Fix issue where `dladdr1` wasn't being used even when detected

Robustness:
- Setup more robust unit tests and added them to CI

# v0.6.1

Fixes:
- Fix for detection of `dladdr1` and `_dl_find_object` support

# v0.6.0

New:
- Added a `cpptrace::system_error` utility
- Added support for musl https://github.com/jeremy-rifkin/cpptrace/issues/128
- Added support for split dwarf / debug fission

Fixes:
- Fixed address formatting in stack traces
- Fixed frame pointer calculation for signal frames from libunwind https://github.com/jeremy-rifkin/cpptrace/issues/123
- Fixed dwarf_ranges handling of lowpc == pc causing erroneous symbol resolution
- Fixed implementation of the exception helper system/reference implementation's `lazy_trace_holder`

# v0.5.4

Fixes:
- Fixed bug with resolving object information when `dladdr` is used and an unexpected `argv[0]` is provided to the
  binary.

# v0.5.3

Fixes:
- Fixed bug with formatting of hex values on MSVC
- Fixed error handling for libbacktrace back-end when debug info is not present
- Fixed bug with cmake resolution of zstd when no zstd cmake config file is installed

Other changes:
- Added error handling for an edge case in the signal tracing demo
- Updated conan recipe to allow libunwind to be chosen
- Improved msvc support in internal formatting system
- Bumped libdwarf to 0.9.2

# v0.5.2

Fixes:
- Fixed bug with resolution of inlined calls

Other changes:
- Improved internal string formatting
- Improved internal error handling

# v0.5.1

Fixes:
- Fix MSVC warning treated as error for 32-bit windows
- Fix MSVC issue with min/max macros
- Fix potential null dereference issue identified by eyalgolan1337

# v0.5.0

New:
- Traces with source code snippets with `cpptrace::stacktrace::print_with_snippets`
- Added `cpptrace::get_snippet` utility
- Added `cpptrace::can_signal_safe_unwind` utility
- Added `stacktrace_frame::get_object_info`

Changes:
- The library is now compiled with position-independent code by default

Fixes:
- Fixed issue with `_dl_find_object` implementation

Misc:
- Various refactoring, cleanup, and improvements

# v0.4.1

Changes:
- Renamed `stacktrace_frame.address` -> `stacktrace_frame.raw_address`
- Added `stacktrace_frame.object_address`
- Fixed segfault due to an edge case with dwarf file table indices
- For the libdwarf back-end: At least show object frame information if resolution fails
- Extremely small performance improvements
- Small documentation updates
- Small fix for conan
- Updated cmake to not FetchContent zstd when using CPPTRACE_USE_EXTERNAL_LIBDWARF
- CI improvements
  - Test the default configuration first before doing the exhaustive and slow matrix of all configurations.
  - Cleanup of duplicated prerequisite installation code
  - Cleanup of built and test python scripts

# v0.4.0

What's new:
- Cpptrace now has a C API! 🎉
- Cpptrace is now able to parse macOS debug maps and resolve stack traces without dSYM files

Most notable improvements:
- Updated cpptrace exception objects to generate traces at the callsite for improved consistency with trace output. As
  part of this cpptrace exception objects have had their constructors updated.
- Improved dwarf back-end robustness
  - Fallback to the compilation-unit cache or walking compilation-units if aranges lookup fails
- Eliminated reliance on a CMake-generated export header
- Added a configuration to control resolution of inlined function calls
- Made architecture selection in Mach-O universal binaries

Other improvements:
- Improved documentation for installation and usage
- Generally improved README content and organization
- Fixed an MSVC workaround producing dozens of warnings
- Better handle compiler color diagnostic arguments if compiler families differ
- Improvements for handling libdwarf's header placement
- Fixed issue with libunwind resolution
- `-Werror` is now used in CI
- More library configurations are now tested in CI
- Updated to libdwarf 9
- Updated the library's CMake to acquire zstd through FetchContent
- Fixed minor issue with stacktrace printing always trying to enable virtual terminal processing, even when not actually
  printing to the terminal.

# v0.3.1

Tiny patch:
- Fix `CPPTRACE_EXPORT` annotations
- Add workaround for [msvc bug][msvc bug] affecting msvc 19.38.

[msvc bug]: https://developercommunity.visualstudio.com/t/MSVC-1938331290-preview-fails-to-comp/10505565

# v0.3.0

Interface Changes:
- Overhauled the API for traced `cpptrace::exception` objects
- Added `cpptrace::isatty` utility
- Added specialized `std::terminate` handler and `cpptrace::register_terminate_handler` utility
- Added `cpptrace::frame_ptr` as an alias for the appropriate type capable of representing an instruction pointer
- Added signal-safe tracing support and a guide for [how to trace safely](signal-safe-tracing.md)
- Added `cpptrace::nullable<T>` utility for better indicating when line / column information is not present
- Added `CPPTRACE_FORCE_NO_INLINE` utility macro to cpptrace.hpp
- Added `CPPTRACE_WRAP` and `CPPTRACE_WRAP_BLOCK` utilities to catch non-`cpptrace::exception`s and rethrow wrapped in a
  traced exception.
- Updated `cpptrace::stacktrace::to_string` to take a `bool color` parameter
- Eliminated uses of `std::uint_least32_t` in favor of other types
- Updated `object_frame` data member names

Other changes:
- Added object resolution with `_dl_find_object` which is much faster than `dladdr`
- Added column support for dwarf
- Added inlined call resolution
  - Added `cpptrace::stacktrace_frame::is_inline`
- Added libunwind as a back-end
- Unbundled libdwarf
- Increased hard max frame count, used by some back-end requiring fixed buffers, from 100 to 200
- Improved libgcc unwind backend
- Improved trace output when information is missing
- Added a lookup table for faster dwarf line information lookup

News:
- The library is now on conan and vcpkg

Minor changes:
- Assorted bug fixes
- Various code quality improvements
- CI improvements
- Documentation improvements
- CMake improvements
- Internal refactoring

# v0.2.1

Patches:
- Fixed uintptr_t implicit conversion issue for msvc
- Better handling for PIC and static linkage in CMake
- Added gcc 5 support
- Various warning fixes
- Added stackwalk64 support for 32-bit x86 mingw/clang and architecture detection
- Added check for stackwalk64 support and CaptureStackBacktrace as a fallback
- Various cmake cleanup and changes to use cpptrace through package managers
- Added sonarlint and implemented some sonarlint fixes

# v0.2.0

Key changes:
- Added libdwarf as a back-end so cpptrace doesn't have to rely on addr2line or libbacktrace
- Overhauled library's public-facing interface to make the library more useful
  - Added `raw_trace` interface
  - Added `object_trace` interface
  - Added `stacktrace` interface
  - Updated `generate_trace` to return a `stacktrace` rather than a vector of frames
  - Added `generate_trace` counterparts for raw and object traces
  - Added `generate_trace` overloads with max_depth
  - Added interface for internal demangling utility
  - Added cache mode configuration
  - Added option to absorb internal trace exceptions (by default it absorbs)
  - Added `cpptrace::exception`, which automatically generates and stores a stacktrace when thrown
  - Added `exception_with_message`
  - Added traced analogs for stdexcept errors: `logic_error`, `domain_error`, `invalid_argument`, `length_error`,
    `out_of_range`, `runtime_error`, `range_error`, `overflow_error`, and `underflow_error`.

Other changes:
- Bundled libdwarf with cpptrace so the library can essentially be self-contained and not have to rely on libraries that
  might not already be on a system
- Added StackWalk64 as an unwinding back-end on windows
- Added system for multiple symbol back-ends to be used, mainly for more complete stack traces on mingw
- Fixed sporadic line number reporting errors due to not adjusting the program counter from the unwinder
- Improved addr2line/atos invocation back-end on macos
- Lots of error handling improvements
- Performance improvements
- Updated default back-ends for most systems
- Removed full tracing backends
- Cleaned up library cmake
- Lots of internal cleanup and refactoring
- Improved library usage instructions in README

# v0.1.1

Fixed:
- Handle errors when object files don't exist or can't be opened for reading
- Handle paths with spaces when using addr2line on windows

# v0.1

Initial release of the library 🎉
