open Core

(* default columns for command *)
let columns_as_string = [ "time"; "alloc"; "percentage" ]

let columns_as_string_for_streaming =
  List.filter columns_as_string ~f:(Fn.non (String.equal "percentage"))
;;

let command_columns ~for_streaming =
  List.map
    ~f:Bench_command_column.of_string
    (if for_streaming then columns_as_string_for_streaming else columns_as_string)
;;

(* how to measure *)
let geometric_scale = 1.01
let stabilize_gc_between_runs = false
let no_compactions = false

(* how long to measure *)
let quota = Quota.Span (Time_float.Span.of_int_sec 10)

(* width of the output table *)
let limit_width_to = 200
let max_name_length = 110

(* Fork each benchmark and run in separate process *)
let fork_each_benchmark = false

(* default display *)
let display_as_string = "short"

let string_to_display =
  let module Display = Ascii_table_kernel.Display in
  function
  | "short" -> Display.short_box
  | "tall" -> Display.tall_box
  | "line" -> Display.line
  | "blank" -> Display.blank
  | "column" -> Display.column_titles
  | s -> failwithf "Invalid display name: %s" s ()
;;

let display = string_to_display display_as_string
