//--- Begin of auto-generated test cases; do not edit
//
// Generated on 2025-04-15, 13:01:25
// by the piecewise polynomial approximation generator (https://jugit.fz-juelich.de/mlz/ppapp)
// Reference: Wuttke and Kleinsorge,
//            "Code generation for piecewise Chebyshev approximation."
//
// clang-format off

// a = 0.125, begin of domain
// b = 12, end of domain
// M = 4, 2^M subdomains per octave
// N = 11, polynomial degree
// nr= 104, total number of subdomains

static const double ppapp_maxrelerr = 2.2; // maximum expected relative error

int test_one(double x, double fref);

int run_tests()
{
    int failed = 0;
// subdomain 0:0 (0.125..0.132812)
    failed += test_one(0x1p-3, 0x1.bf16ef058facfp-1);
    failed += test_one(0x1.085976eab7ddcp-3, 0x1.bd324555128eep-1);
    failed += test_one(0x1.0771f9dfc8863p-3, 0x1.bd6699e4f8db4p-1);
    failed += test_one(0x1.0e278ea370752p-3, 0x1.bbe33d3c03d21p-1);
    failed += test_one(0x1.0368abd1c7326p-3, 0x1.be50a90deba6ap-1);
    failed += test_one(0x1.0ffffffffffffp-3, 0x1.bb790f6349c06p-1);
// subdomain 0:1 (0.132812..0.140625)
    failed += test_one(0x1.1p-3, 0x1.bb790f6349c06p-1);
    failed += test_one(0x1.134e371d76b2dp-3, 0x1.babb46577a829p-1);
    failed += test_one(0x1.1c918bf83698ep-3, 0x1.b8aa2540e6b0dp-1);
    failed += test_one(0x1.196796b023e7p-3, 0x1.b95e6e0abce7ep-1);
    failed += test_one(0x1.15eb8bb0e87cap-3, 0x1.ba25853e4b451p-1);
    failed += test_one(0x1.1ffffffffffffp-3, 0x1.b7e722f1738d7p-1);
// subdomain 0:2 (0.140625..0.148438)
    failed += test_one(0x1.2p-3, 0x1.b7e722f1738d6p-1);
    failed += test_one(0x1.2442f342200c7p-3, 0x1.b6f5b50ddbad9p-1);
    failed += test_one(0x1.2d74bf58552fp-3, 0x1.b4efa14a39ae2p-1);
    failed += test_one(0x1.2bcdbcce5e207p-3, 0x1.b54c73d9e2e4bp-1);
    failed += test_one(0x1.2fb9f8bf0ec02p-3, 0x1.b4704aa46a101p-1);
    failed += test_one(0x1.2ffffffffffffp-3, 0x1.b460f70bb7033p-1);
// subdomain 0:3 (0.148438..0.15625)
    failed += test_one(0x1.3p-3, 0x1.b460f70bb7033p-1);
    failed += test_one(0x1.3e499abc16a68p-3, 0x1.b14520ae39bbp-1);
    failed += test_one(0x1.3312ea56054cdp-3, 0x1.b3b4f89b541ebp-1);
    failed += test_one(0x1.35391a27534d8p-3, 0x1.b33cf8934a731p-1);
    failed += test_one(0x1.3373a3d47f387p-3, 0x1.b39fdc135ca56p-1);
    failed += test_one(0x1.3ffffffffffffp-3, 0x1.b0e65a0b9b0e2p-1);
// subdomain 0:4 (0.15625..0.164062)
    failed += test_one(0x1.4p-3, 0x1.b0e65a0b9b0e2p-1);
    failed += test_one(0x1.416ab28b4f053p-3, 0x1.b0980a0fc8013p-1);
    failed += test_one(0x1.405d441442e7dp-3, 0x1.b0d2349f771fbp-1);
    failed += test_one(0x1.48575fe37e498p-3, 0x1.af1a9119de2e7p-1);
    failed += test_one(0x1.44f2ab139dba2p-3, 0x1.afd53e74a4128p-1);
    failed += test_one(0x1.4ffffffffffffp-3, 0x1.ad771b42dfc7ep-1);
// subdomain 0:5 (0.164062..0.171875)
    failed += test_one(0x1.5p-3, 0x1.ad771b42dfc7ep-1);
    failed += test_one(0x1.5e09704733175p-3, 0x1.aa7cf47111318p-1);
    failed += test_one(0x1.517b100dfe58bp-3, 0x1.ad264e208a9f1p-1);
    failed += test_one(0x1.5875f37aed681p-3, 0x1.abaab22a08587p-1);
    failed += test_one(0x1.51c61355dbd89p-3, 0x1.ad1653a4a5d47p-1);
    failed += test_one(0x1.5ffffffffffffp-3, 0x1.aa130af5fe21fp-1);
// subdomain 0:6 (0.171875..0.179688)
    failed += test_one(0x1.6p-3, 0x1.aa130af5fe21fp-1);
    failed += test_one(0x1.6afc4e2186954p-3, 0x1.a7c5694dfefb6p-1);
    failed += test_one(0x1.62c0cf561c949p-3, 0x1.a97ec9715cddap-1);
    failed += test_one(0x1.6199f42e225b1p-3, 0x1.a9bcc51b86ba2p-1);
    failed += test_one(0x1.6962f7a36a3e6p-3, 0x1.a81ae9d938047p-1);
    failed += test_one(0x1.6ffffffffffffp-3, 0x1.a6b9fa56ca196p-1);
// subdomain 0:7 (0.179688..0.1875)
    failed += test_one(0x1.7p-3, 0x1.a6b9fa56ca195p-1);
    failed += test_one(0x1.7b95f766616eap-3, 0x1.a454214bdb7a2p-1);
    failed += test_one(0x1.78b7a66ab5e92p-3, 0x1.a4eb950f21bffp-1);
    failed += test_one(0x1.712b9d44bc5f8p-3, 0x1.a67bb64b2722ap-1);
    failed += test_one(0x1.7b9d4b0a09319p-3, 0x1.a4529ee409f6cp-1);
    failed += test_one(0x1.7ffffffffffffp-3, 0x1.a36bbb7f3686dp-1);
// subdomain 0:8 (0.1875..0.195312)
    failed += test_one(0x1.8p-3, 0x1.a36bbb7f3686dp-1);
    failed += test_one(0x1.8cade52dfd121p-3, 0x1.a0d4b05a55299p-1);
    failed += test_one(0x1.87c0bc0f83f6cp-3, 0x1.a1d584faacbfdp-1);
    failed += test_one(0x1.8c4ef762dd37ap-3, 0x1.a0e7fc6e3e326p-1);
    failed += test_one(0x1.81b39f5942989p-3, 0x1.a3125c5c50ddcp-1);
    failed += test_one(0x1.8ffffffffffffp-3, 0x1.a028216c39a69p-1);
// subdomain 0:9 (0.195312..0.203125)
    failed += test_one(0x1.9p-3, 0x1.a028216c39a69p-1);
    failed += test_one(0x1.93125badb0a8bp-3, 0x1.9f88e9d73052ap-1);
    failed += test_one(0x1.98e86013a7aecp-3, 0x1.9e5b78f9c9697p-1);
    failed += test_one(0x1.9f53893a24e7ap-3, 0x1.9d1188915003p-1);
    failed += test_one(0x1.9f7d2bd7f8043p-3, 0x1.9d0931e539324p-1);
    failed += test_one(0x1.9ffffffffffffp-3, 0x1.9ceefff8d1798p-1);
// subdomain 0:10 (0.203125..0.210938)
    failed += test_one(0x1.ap-3, 0x1.9ceefff8d1798p-1);
    failed += test_one(0x1.a1c75f7a5e029p-3, 0x1.9c93e7c51f4c4p-1);
    failed += test_one(0x1.a82e4e090deaep-3, 0x1.9b4d18f2de8fep-1);
    failed += test_one(0x1.a08946a312ac6p-3, 0x1.9cd38679cee08p-1);
    failed += test_one(0x1.a0bd65e4073dap-3, 0x1.9cc918b6cc029p-1);
    failed += test_one(0x1.affffffffffffp-3, 0x1.99c02bd927272p-1);
// subdomain 0:11 (0.210938..0.21875)
    failed += test_one(0x1.bp-3, 0x1.99c02bd927272p-1);
    failed += test_one(0x1.b5cdd1047e30ep-3, 0x1.989b1b8e695a3p-1);
    failed += test_one(0x1.b8676bb469d83p-3, 0x1.981840fa81449p-1);
    failed += test_one(0x1.b960d940731c9p-3, 0x1.97e74943235fcp-1);
    failed += test_one(0x1.bde1626105f3p-3, 0x1.970580e5f3da3p-1);
    failed += test_one(0x1.bffffffffffffp-3, 0x1.969b7a95d08eep-1);
// subdomain 0:12 (0.21875..0.226562)
    failed += test_one(0x1.cp-3, 0x1.969b7a95d08eep-1);
    failed += test_one(0x1.c933ff8fb5ab5p-3, 0x1.94d12702150bdp-1);
    failed += test_one(0x1.c7563dd49e2ebp-3, 0x1.952dd3f9c5dd3p-1);
    failed += test_one(0x1.cacbc9a21be9dp-3, 0x1.948227c8e9953p-1);
    failed += test_one(0x1.ca7bf89ea3ebcp-3, 0x1.94919c18ef15ep-1);
    failed += test_one(0x1.cffffffffffffp-3, 0x1.9380c2872f3c8p-1);
// subdomain 0:13 (0.226562..0.234375)
    failed += test_one(0x1.dp-3, 0x1.9380c2872f3c8p-1);
    failed += test_one(0x1.ddc8bd593cb0dp-3, 0x1.90dbfa479df88p-1);
    failed += test_one(0x1.dddc91137a173p-3, 0x1.90d8320485e0bp-1);
    failed += test_one(0x1.d484f7064f035p-3, 0x1.92a210f303f6bp-1);
    failed += test_one(0x1.dd9b41b0cf993p-3, 0x1.90e4a7ae428a4p-1);
    failed += test_one(0x1.dffffffffffffp-3, 0x1.906fdad0ebf92p-1);
// subdomain 0:14 (0.234375..0.242188)
    failed += test_one(0x1.ep-3, 0x1.906fdad0ebf92p-1);
    failed += test_one(0x1.e546c389bcd46p-3, 0x1.8f6f22ff0cbdep-1);
    failed += test_one(0x1.e646bf10ef0b3p-3, 0x1.8f3e9aa7a247bp-1);
    failed += test_one(0x1.ec5de6d27a95ap-3, 0x1.8e17ce8216194p-1);
    failed += test_one(0x1.e99a850379f41p-3, 0x1.8e9d621b53b7fp-1);
    failed += test_one(0x1.effffffffffffp-3, 0x1.8d689b5d8e38dp-1);
// subdomain 0:15 (0.242188..0.25)
    failed += test_one(0x1.fp-3, 0x1.8d689b5d8e38dp-1);
    failed += test_one(0x1.f368e879a370dp-3, 0x1.8cc4a02b3b319p-1);
    failed += test_one(0x1.f2c9f3734becp-3, 0x1.8ce27465684dap-1);
    failed += test_one(0x1.ff639860fe188p-3, 0x1.8a87ee04cd488p-1);
    failed += test_one(0x1.f47c319d53676p-3, 0x1.8c91003502945p-1);
    failed += test_one(0x1.fffffffffffffp-3, 0x1.8a6adcda2ea92p-1);
// subdomain 1:0 (0.25..0.265625)
    failed += test_one(0x1p-2, 0x1.8a6adcda2ea92p-1);
    failed += test_one(0x1.0e0ed65b6dd88p-2, 0x1.853fd4987ffe3p-1);
    failed += test_one(0x1.05044f17944cap-2, 0x1.888f714f71f1bp-1);
    failed += test_one(0x1.0e8031334df89p-2, 0x1.85169e514c5f2p-1);
    failed += test_one(0x1.07bac7fa379c1p-2, 0x1.878fe292e0119p-1);
    failed += test_one(0x1.0ffffffffffffp-2, 0x1.848b490b8a87fp-1);
// subdomain 1:1 (0.265625..0.28125)
    failed += test_one(0x1.1p-2, 0x1.848b490b8a87fp-1);
    failed += test_one(0x1.1ad6e47b5910dp-2, 0x1.80a554420e50cp-1);
    failed += test_one(0x1.16cd107c5c1c2p-2, 0x1.821736174c2dcp-1);
    failed += test_one(0x1.1e1269d0a8f13p-2, 0x1.7f7ee3774aa4cp-1);
    failed += test_one(0x1.13efc96365835p-2, 0x1.831ef1451d113p-1);
    failed += test_one(0x1.1ffffffffffffp-2, 0x1.7ecff36408789p-1);
// subdomain 1:2 (0.28125..0.296875)
    failed += test_one(0x1.2p-2, 0x1.7ecff36408789p-1);
    failed += test_one(0x1.2fcfc35e03244p-2, 0x1.794865ac1703ep-1);
    failed += test_one(0x1.2c72d48e4b797p-2, 0x1.7a72a86bd7ed8p-1);
    failed += test_one(0x1.24c1220f3bc33p-2, 0x1.7d22bf479c65dp-1);
    failed += test_one(0x1.27becfa19b4d1p-2, 0x1.7c16516cd6b2fp-1);
    failed += test_one(0x1.2ffffffffffffp-2, 0x1.7937bb093cf2ep-1);
// subdomain 1:3 (0.296875..0.3125)
    failed += test_one(0x1.3p-2, 0x1.7937bb093cf2ep-1);
    failed += test_one(0x1.373cbd0d6aff3p-2, 0x1.76bb230cceb89p-1);
    failed += test_one(0x1.39219c270f732p-2, 0x1.7615ac91732a6p-1);
    failed += test_one(0x1.34634066a4b5ep-2, 0x1.77b4f60ebe4bbp-1);
    failed += test_one(0x1.32c795f02ab56p-2, 0x1.78426a1cee8bdp-1);
    failed += test_one(0x1.3ffffffffffffp-2, 0x1.73c189ceaedaep-1);
// subdomain 1:4 (0.3125..0.328125)
    failed += test_one(0x1.4p-2, 0x1.73c189ceaedaep-1);
    failed += test_one(0x1.4650681dd3e63p-2, 0x1.71a2e6cdbfdc3p-1);
    failed += test_one(0x1.49cb26fecd6a9p-2, 0x1.707a0b9f9ebb2p-1);
    failed += test_one(0x1.4bc80edaddcc7p-2, 0x1.6fd121a4de77p-1);
    failed += test_one(0x1.480330e9d4f3ep-2, 0x1.7111cf79d8cc1p-1);
    failed += test_one(0x1.4ffffffffffffp-2, 0x1.6e6c53c2e2c44p-1);
// subdomain 1:5 (0.328125..0.34375)
    failed += test_one(0x1.5p-2, 0x1.6e6c53c2e2c44p-1);
    failed += test_one(0x1.5fb33f6978ac2p-2, 0x1.694fc8999db6ep-1);
    failed += test_one(0x1.57df4c754565p-2, 0x1.6bd86afb7442ep-1);
    failed += test_one(0x1.547da8afbca7fp-2, 0x1.6cf2ee4c1290dp-1);
    failed += test_one(0x1.571063d651ee2p-2, 0x1.6c1bd128e319dp-1);
    failed += test_one(0x1.5ffffffffffffp-2, 0x1.693716c1c115fp-1);
// subdomain 1:6 (0.34375..0.359375)
    failed += test_one(0x1.6p-2, 0x1.693716c1c115fp-1);
    failed += test_one(0x1.6b9ee10350009p-2, 0x1.658242eb88788p-1);
    failed += test_one(0x1.6634634af5986p-2, 0x1.673a77703daafp-1);
    failed += test_one(0x1.6ee94b9a4fa98p-2, 0x1.64787f14bbfb5p-1);
    failed += test_one(0x1.65ab02810aeccp-2, 0x1.6766462756aacp-1);
    failed += test_one(0x1.6ffffffffffffp-2, 0x1.6420da0c11896p-1);
// subdomain 1:7 (0.359375..0.375)
    failed += test_one(0x1.7p-2, 0x1.6420da0c11896p-1);
    failed += test_one(0x1.74c5e5589fb62p-2, 0x1.62a23d401473ap-1);
    failed += test_one(0x1.7bb112e6035b8p-2, 0x1.607c547b1d91fp-1);
    failed += test_one(0x1.79240b6d844a5p-2, 0x1.61466fc845e25p-1);
    failed += test_one(0x1.75d09dc5ef233p-2, 0x1.624f130a1d88bp-1);
    failed += test_one(0x1.7ffffffffffffp-2, 0x1.5f28ade3ca4acp-1);
// subdomain 1:8 (0.375..0.390625)
    failed += test_one(0x1.8p-2, 0x1.5f28ade3ca4acp-1);
    failed += test_one(0x1.88b9986b10dbp-2, 0x1.5c7f4adea1a91p-1);
    failed += test_one(0x1.82bafc2d64cfap-2, 0x1.5e5284fdd916ap-1);
    failed += test_one(0x1.8fb282c449de5p-2, 0x1.5a64eb441f4aep-1);
    failed += test_one(0x1.8997bc379d44bp-2, 0x1.5c3bfe9584f43p-1);
    failed += test_one(0x1.8ffffffffffffp-2, 0x1.5a4dab2cf4921p-1);
// subdomain 1:9 (0.390625..0.40625)
    failed += test_one(0x1.9p-2, 0x1.5a4dab2cf492p-1);
    failed += test_one(0x1.9ea161362075bp-2, 0x1.55f5d81d340afp-1);
    failed += test_one(0x1.96262288c4268p-2, 0x1.587789fb70a8fp-1);
    failed += test_one(0x1.9520e16fbece8p-2, 0x1.58c5471faa204p-1);
    failed += test_one(0x1.9fff7ba5a0a3ap-2, 0x1.558f19e07daeap-1);
    failed += test_one(0x1.9ffffffffffffp-2, 0x1.558ef312ebe87p-1);
// subdomain 1:10 (0.40625..0.421875)
    failed += test_one(0x1.ap-2, 0x1.558ef312ebe87p-1);
    failed += test_one(0x1.ab9b620d4d726p-2, 0x1.522efa1cd4081p-1);
    failed += test_one(0x1.a8679a29f0216p-2, 0x1.531bea43371cbp-1);
    failed += test_one(0x1.aa23a0d833e0fp-2, 0x1.529b722cb266dp-1);
    failed += test_one(0x1.abb65cdaeb578p-2, 0x1.5227328e7460cp-1);
    failed += test_one(0x1.affffffffffffp-2, 0x1.50ebaeb1c07acp-1);
// subdomain 1:11 (0.421875..0.4375)
    failed += test_one(0x1.bp-2, 0x1.50ebaeb1c07acp-1);
    failed += test_one(0x1.b71afb30bb9b8p-2, 0x1.4ee505af7466dp-1);
    failed += test_one(0x1.bdc81ad37b76cp-2, 0x1.4d02699020207p-1);
    failed += test_one(0x1.bc7c2d74ddebbp-2, 0x1.4d5fc8b790b14p-1);
    failed += test_one(0x1.b39dd0978b63cp-2, 0x1.4fe30ba6270cdp-1);
    failed += test_one(0x1.bffffffffffffp-2, 0x1.4c630ec387d55p-1);
// subdomain 1:12 (0.4375..0.453125)
    failed += test_one(0x1.cp-2, 0x1.4c630ec387d55p-1);
    failed += test_one(0x1.c02c9a0248453p-2, 0x1.4c56903366988p-1);
    failed += test_one(0x1.c8b070ddb67e6p-2, 0x1.49f7a26de5e6fp-1);
    failed += test_one(0x1.cd6ca114e12f4p-2, 0x1.48a940a82c47p-1);
    failed += test_one(0x1.cdea8491d26f8p-2, 0x1.4886a7369d3b1p-1);
    failed += test_one(0x1.cffffffffffffp-2, 0x1.47f44b516a364p-1);
// subdomain 1:13 (0.453125..0.46875)
    failed += test_one(0x1.dp-2, 0x1.47f44b516a364p-1);
    failed += test_one(0x1.d3c7898bf7b8ep-2, 0x1.46ebf06fd27e4p-1);
    failed += test_one(0x1.d04352f7920e2p-2, 0x1.47e1dab89c4dcp-1);
    failed += test_one(0x1.d5f86bdd1e6aap-2, 0x1.4653545749d0cp-1);
    failed += test_one(0x1.d042be9476677p-2, 0x1.47e2035b3fdfep-1);
    failed += test_one(0x1.dffffffffffffp-2, 0x1.439ea3683d4ccp-1);
// subdomain 1:14 (0.46875..0.484375)
    failed += test_one(0x1.ep-2, 0x1.439ea3683d4ccp-1);
    failed += test_one(0x1.e9daebc2ab867p-2, 0x1.40ff53bae0aep-1);
    failed += test_one(0x1.e46e7eb3fd7dp-2, 0x1.426fa1c00e129p-1);
    failed += test_one(0x1.eb17436aa549dp-2, 0x1.40abcc222d372p-1);
    failed += test_one(0x1.edfbb6478afcp-2, 0x1.3fe8d6f79d44p-1);
    failed += test_one(0x1.effffffffffffp-2, 0x1.3f615cd07fbb1p-1);
// subdomain 1:15 (0.484375..0.5)
    failed += test_one(0x1.fp-2, 0x1.3f615cd07fbbp-1);
    failed += test_one(0x1.f9c6acd1de395p-2, 0x1.3cd5f38853b8cp-1);
    failed += test_one(0x1.f525061a2187dp-2, 0x1.3e0977c21eec8p-1);
    failed += test_one(0x1.f8665913e30f3p-2, 0x1.3d3120ddd3dfdp-1);
    failed += test_one(0x1.f6f31f15da925p-2, 0x1.3d91620dd3df2p-1);
    failed += test_one(0x1.fffffffffffffp-2, 0x1.3b3bc3c98b0f3p-1);
// subdomain 2:0 (0.5..0.53125)
    failed += test_one(0x1p-1, 0x1.3b3bc3c98b0f3p-1);
    failed += test_one(0x1.05135a8600c4bp-1, 0x1.38a63382c2d6fp-1);
    failed += test_one(0x1.0c82b7d96862fp-1, 0x1.34ed7844fc144p-1);
    failed += test_one(0x1.0d41cd83d1f19p-1, 0x1.348ee125ffa06p-1);
    failed += test_one(0x1.09af6961d91cdp-1, 0x1.365541d39d38dp-1);
    failed += test_one(0x1.0ffffffffffffp-1, 0x1.3334ea3613dep-1);
// subdomain 2:1 (0.53125..0.5625)
    failed += test_one(0x1.1p-1, 0x1.3334ea3613dep-1);
    failed += test_one(0x1.1efde805aaab9p-1, 0x1.2bfe78ef39b09p-1);
    failed += test_one(0x1.1d0c0342f59dep-1, 0x1.2ce9d952c6b3fp-1);
    failed += test_one(0x1.15fcda58054b6p-1, 0x1.304a8762259f8p-1);
    failed += test_one(0x1.1327abf20ce7fp-1, 0x1.31aa23932a489p-1);
    failed += test_one(0x1.1ffffffffffffp-1, 0x1.2b84f076e14fcp-1);
// subdomain 2:2 (0.5625..0.59375)
    failed += test_one(0x1.2p-1, 0x1.2b84f076e14fbp-1);
    failed += test_one(0x1.2e074c99a0585p-1, 0x1.250b21c3b1faap-1);
    failed += test_one(0x1.25b9b704fd2a3p-1, 0x1.28d8e564386b3p-1);
    failed += test_one(0x1.2cef8809f45f1p-1, 0x1.258a1536261bdp-1);
    failed += test_one(0x1.23842b22a701cp-1, 0x1.29df9a5e2a1d4p-1);
    failed += test_one(0x1.2ffffffffffffp-1, 0x1.242708751d9a7p-1);
// subdomain 2:3 (0.59375..0.625)
    failed += test_one(0x1.3p-1, 0x1.242708751d9a7p-1);
    failed += test_one(0x1.3860f945fa198p-1, 0x1.206aa79b3d79p-1);
    failed += test_one(0x1.38b5d952b9713p-1, 0x1.20453d8596581p-1);
    failed += test_one(0x1.3645eb962f0e7p-1, 0x1.215908f694775p-1);
    failed += test_one(0x1.3d96926a7f8bfp-1, 0x1.1e227f45d8cep-1);
    failed += test_one(0x1.3ffffffffffffp-1, 0x1.1d16b5809eaf7p-1);
// subdomain 2:4 (0.625..0.65625)
    failed += test_one(0x1.4p-1, 0x1.1d16b5809eaf6p-1);
    failed += test_one(0x1.479fb7c47e103p-1, 0x1.19d31df5a3492p-1);
    failed += test_one(0x1.4e3b4d4818352p-1, 0x1.170c09f117849p-1);
    failed += test_one(0x1.4c5b86cf0a0a7p-1, 0x1.17d47ef4bddcbp-1);
    failed += test_one(0x1.4e83d0715e451p-1, 0x1.16edd35e8430ep-1);
    failed += test_one(0x1.4ffffffffffffp-1, 0x1.164fc6284ab1fp-1);
// subdomain 2:5 (0.65625..0.6875)
    failed += test_one(0x1.5p-1, 0x1.164fc6284ab1ep-1);
    failed += test_one(0x1.5f695b1a00c53p-1, 0x1.100a5f76e6f19p-1);
    failed += test_one(0x1.5cfcfcf0420bfp-1, 0x1.1102ac0329558p-1);
    failed += test_one(0x1.57dc4657b12fp-1, 0x1.13151e9501959p-1);
    failed += test_one(0x1.52ac19e74d678p-1, 0x1.1534e20a60c3ep-1);
    failed += test_one(0x1.5ffffffffffffp-1, 0x1.0fce4e96dd619p-1);
// subdomain 2:6 (0.6875..0.71875)
    failed += test_one(0x1.6p-1, 0x1.0fce4e96dd619p-1);
    failed += test_one(0x1.6ce135775cceap-1, 0x1.0ac19a2b14169p-1);
    failed += test_one(0x1.60a26865c6645p-1, 0x1.0f8da67620a86p-1);
    failed += test_one(0x1.6da2624f9470ap-1, 0x1.0a77262abc12bp-1);
    failed += test_one(0x1.6f02189382696p-1, 0x1.09eff3a3d0debp-1);
    failed += test_one(0x1.6ffffffffffffp-1, 0x1.098ea367ecbcdp-1);
// subdomain 2:7 (0.71875..0.75)
    failed += test_one(0x1.7p-1, 0x1.098ea367ecbccp-1);
    failed += test_one(0x1.7da618b3400fp-1, 0x1.046b74ae4932ap-1);
    failed += test_one(0x1.74f6a35f41f5dp-1, 0x1.07ab39e0a235p-1);
    failed += test_one(0x1.7fa3c28bdfd8ep-1, 0x1.03af49dc4f31ap-1);
    failed += test_one(0x1.71fa7974c8378p-1, 0x1.08cd3cc29c3aep-1);
    failed += test_one(0x1.7ffffffffffffp-1, 0x1.038d54ea3d834p-1);
// subdomain 2:8 (0.75..0.78125)
    failed += test_one(0x1.8p-1, 0x1.038d54ea3d834p-1);
    failed += test_one(0x1.892ab9e0fa674p-1, 0x1.00376862098b1p-1);
    failed += test_one(0x1.821e944e2c6a3p-1, 0x1.02c631e28557ep-1);
    failed += test_one(0x1.8b1ff3ab774e7p-1, 0x1.ff06f6feacfd5p-2);
    failed += test_one(0x1.8dc7b265a0ff1p-1, 0x1.fd21ac6299117p-2);
    failed += test_one(0x1.8ffffffffffffp-1, 0x1.fb8e558b14d91p-2);
// subdomain 2:9 (0.78125..0.8125)
    failed += test_one(0x1.9p-1, 0x1.fb8e558b14d9p-2);
    failed += test_one(0x1.9d0661d26e1ccp-1, 0x1.f27ada6e52798p-2);
    failed += test_one(0x1.95dfa67f75e2ap-1, 0x1.f76d8876c8324p-2);
    failed += test_one(0x1.93ea3ce066cb6p-1, 0x1.f8cc465b132f8p-2);
    failed += test_one(0x1.9ed83787c0c63p-1, 0x1.f13bfe21ae129p-2);
    failed += test_one(0x1.9ffffffffffffp-1, 0x1.f0723ff5acdfap-2);
// subdomain 2:10 (0.8125..0.84375)
    failed += test_one(0x1.ap-1, 0x1.f0723ff5acdf9p-2);
    failed += test_one(0x1.ad56288c54cep-1, 0x1.e781476f4b28bp-2);
    failed += test_one(0x1.ab74bece5bb82p-1, 0x1.e8bfab421ed67p-2);
    failed += test_one(0x1.a4d5cee1a52d3p-1, 0x1.ed2bfd80b861fp-2);
    failed += test_one(0x1.ae7d37be4db4bp-1, 0x1.e6bed5a966099p-2);
    failed += test_one(0x1.affffffffffffp-1, 0x1.e5c0be6e7d145p-2);
// subdomain 2:11 (0.84375..0.875)
    failed += test_one(0x1.bp-1, 0x1.e5c0be6e7d145p-2);
    failed += test_one(0x1.bd411ad0acdcfp-1, 0x1.dd31e9bb86e9ep-2);
    failed += test_one(0x1.ba12fd104eb18p-1, 0x1.df3962674fc61p-2);
    failed += test_one(0x1.b009d028349abp-1, 0x1.e5ba4f1e59aa6p-2);
    failed += test_one(0x1.bafb0c5f46144p-1, 0x1.dea4eb2c806dfp-2);
    failed += test_one(0x1.bffffffffffffp-1, 0x1.db747ee409ac5p-2);
// subdomain 2:12 (0.875..0.90625)
    failed += test_one(0x1.cp-1, 0x1.db747ee409ac5p-2);
    failed += test_one(0x1.cc772f0650374p-1, 0x1.d3b18ea011edp-2);
    failed += test_one(0x1.c24637d4b3c3ap-1, 0x1.da05b276c8f5ap-2);
    failed += test_one(0x1.cac0912ad78b8p-1, 0x1.d4bf466292526p-2);
    failed += test_one(0x1.c2ee27e9356a9p-1, 0x1.d99c415c6de8p-2);
    failed += test_one(0x1.cffffffffffffp-1, 0x1.d188819e7fef8p-2);
// subdomain 2:13 (0.90625..0.9375)
    failed += test_one(0x1.dp-1, 0x1.d188819e7fef8p-2);
    failed += test_one(0x1.d7dcca0876c17p-1, 0x1.ccca2da8742fap-2);
    failed += test_one(0x1.d145a60b0781cp-1, 0x1.d0c28e4ac1313p-2);
    failed += test_one(0x1.d184d1ad7fa7cp-1, 0x1.d09c393838c7dp-2);
    failed += test_one(0x1.d7a8fc8eeb6fcp-1, 0x1.cce92892a33f8p-2);
    failed += test_one(0x1.dffffffffffffp-1, 0x1.c7f81382721fp-2);
// subdomain 2:14 (0.9375..0.96875)
    failed += test_one(0x1.ep-1, 0x1.c7f81382721efp-2);
    failed += test_one(0x1.e598b2d33e52p-1, 0x1.c4b473ed94066p-2);
    failed += test_one(0x1.e54a340ebb5f6p-1, 0x1.c4e1f65c2b458p-2);
    failed += test_one(0x1.e7fc8da54aee5p-1, 0x1.c352ca7184dcp-2);
    failed += test_one(0x1.e6b7109663f04p-1, 0x1.c40eb1027e266p-2);
    failed += test_one(0x1.effffffffffffp-1, 0x1.bebec8c623083p-2);
// subdomain 2:15 (0.96875..1)
    failed += test_one(0x1.fp-1, 0x1.bebec8c623082p-2);
    failed += test_one(0x1.f74c06c0ecb91p-1, 0x1.baa5aec1c074p-2);
    failed += test_one(0x1.f241c9cd54f09p-1, 0x1.bd7877ab64602p-2);
    failed += test_one(0x1.f45b9a0ce66bdp-1, 0x1.bc4a335bda574p-2);
    failed += test_one(0x1.fc078cdd93b58p-1, 0x1.b806532ea3b17p-2);
    failed += test_one(0x1.fffffffffffffp-1, 0x1.b5d8780f956b3p-2);
// subdomain 3:0 (1..1.0625)
    failed += test_one(0x1p+0, 0x1.b5d8780f956b2p-2);
    failed += test_one(0x1.0114030e106b8p+0, 0x1.b4ab8bcf60966p-2);
    failed += test_one(0x1.002f5cd776f3ap+0, 0x1.b5a4badc26f12p-2);
    failed += test_one(0x1.01439a8ec33a3p+0, 0x1.b477cdaed0eedp-2);
    failed += test_one(0x1.027829aaffa3ap+0, 0x1.b3295ba141635p-2);
    failed += test_one(0x1.0ffffffffffffp+0, 0x1.a4f550c5f1a9ap-2);
// subdomain 3:1 (1.0625..1.125)
    failed += test_one(0x1.1p+0, 0x1.a4f550c5f1a99p-2);
    failed += test_one(0x1.1effb2ff2064dp+0, 0x1.9626730c17425p-2);
    failed += test_one(0x1.106f000bb3db1p+0, 0x1.a484492a69a82p-2);
    failed += test_one(0x1.1233338ed3b22p+0, 0x1.a2b9fcaff0be7p-2);
    failed += test_one(0x1.1fe3475a2d2aep+0, 0x1.954d3bb1fd3fdp-2);
    failed += test_one(0x1.1ffffffffffffp+0, 0x1.9531e09b149b6p-2);
// subdomain 3:2 (1.125..1.1875)
    failed += test_one(0x1.2p+0, 0x1.9531e09b149b5p-2);
    failed += test_one(0x1.2b612e05d124ap+0, 0x1.8a9cac1b8244ep-2);
    failed += test_one(0x1.2605c2acb3922p+0, 0x1.8f881a2388d76p-2);
    failed += test_one(0x1.2180bec688c0cp+0, 0x1.93c4a978b3a61p-2);
    failed += test_one(0x1.239e936532299p+0, 0x1.91c63726dffacp-2);
    failed += test_one(0x1.2ffffffffffffp+0, 0x1.8674923c605e2p-2);
// subdomain 3:3 (1.1875..1.25)
    failed += test_one(0x1.3p+0, 0x1.8674923c605e1p-2);
    failed += test_one(0x1.37360bee4e71p+0, 0x1.801f778319edbp-2);
    failed += test_one(0x1.3322fe498bfe2p+0, 0x1.83ad91b59cf7cp-2);
    failed += test_one(0x1.3b3650c0360c7p+0, 0x1.7cb03fb68d9ecp-2);
    failed += test_one(0x1.3a6a5843dc1dap+0, 0x1.7d5e345cdf3aap-2);
    failed += test_one(0x1.3ffffffffffffp+0, 0x1.78a692138767bp-2);
// subdomain 3:4 (1.25..1.3125)
    failed += test_one(0x1.4p+0, 0x1.78a692138767ap-2);
    failed += test_one(0x1.40316a6ad4d4bp+0, 0x1.787d4f6a0344dp-2);
    failed += test_one(0x1.4de26944646edp+0, 0x1.6d5dea382e8a6p-2);
    failed += test_one(0x1.47e1a8c4ff62fp+0, 0x1.722b66d031b3bp-2);
    failed += test_one(0x1.47994543caaefp+0, 0x1.7266094873ceap-2);
    failed += test_one(0x1.4ffffffffffffp+0, 0x1.6bb376a9390cep-2);
// subdomain 3:5 (1.3125..1.375)
    failed += test_one(0x1.5p+0, 0x1.6bb376a9390cdp-2);
    failed += test_one(0x1.5cdec0ca54224p+0, 0x1.61db3a2d29493p-2);
    failed += test_one(0x1.5e42091eb2c8bp+0, 0x1.60d2d82f412bbp-2);
    failed += test_one(0x1.501603161c75bp+0, 0x1.6ba234971b0b3p-2);
    failed += test_one(0x1.5ac81f06b2095p+0, 0x1.636bba99a5af4p-2);
    failed += test_one(0x1.5ffffffffffffp+0, 0x1.5f88f52f3c76cp-2);
// subdomain 3:6 (1.375..1.4375)
    failed += test_one(0x1.6p+0, 0x1.5f88f52f3c76bp-2);
    failed += test_one(0x1.6c28cfbba9eddp+0, 0x1.56c607b6b28fp-2);
    failed += test_one(0x1.637b34b52ade4p+0, 0x1.5cfc3c3e357a7p-2);
    failed += test_one(0x1.6913b20f04e72p+0, 0x1.58f4ef3d652abp-2);
    failed += test_one(0x1.6876ec4758b7bp+0, 0x1.5964be53814dp-2);
    failed += test_one(0x1.6ffffffffffffp+0, 0x1.5416a05961e1dp-2);
// subdomain 3:7 (1.4375..1.5)
    failed += test_one(0x1.7p+0, 0x1.5416a05961e1cp-2);
    failed += test_one(0x1.7f60912ef10d4p+0, 0x1.49b6273622bb7p-2);
    failed += test_one(0x1.784036d122007p+0, 0x1.4e7297ada44a3p-2);
    failed += test_one(0x1.77fffb27c1aa8p+0, 0x1.4e9ddc509fd3bp-2);
    failed += test_one(0x1.7ac77241e772p+0, 0x1.4cc0d3cf2743fp-2);
    failed += test_one(0x1.7ffffffffffffp+0, 0x1.494daffa2ad69p-2);
// subdomain 3:8 (1.5..1.5625)
    failed += test_one(0x1.8p+0, 0x1.494daffa2ad68p-2);
    failed += test_one(0x1.8748433edaebp+0, 0x1.4499800d5ee0dp-2);
    failed += test_one(0x1.831003e8ae8f1p+0, 0x1.474f65f0b1f0dp-2);
    failed += test_one(0x1.8ecb72223edafp+0, 0x1.3fdfe166aecd5p-2);
    failed += test_one(0x1.86f5cc5a32967p+0, 0x1.44ce198f92057p-2);
    failed += test_one(0x1.8ffffffffffffp+0, 0x1.3f20d017f3531p-2);
// subdomain 3:9 (1.5625..1.625)
    failed += test_one(0x1.9p+0, 0x1.3f20d017f353p-2);
    failed += test_one(0x1.935dbbe7494c6p+0, 0x1.3d0f81d9b6c36p-2);
    failed += test_one(0x1.901309643dc57p+0, 0x1.3f150d2dbbd27p-2);
    failed += test_one(0x1.92dfa5bd23bcep+0, 0x1.3d5c8f5c8d0d1p-2);
    failed += test_one(0x1.9e33fbf3d2be4p+0, 0x1.369182431795fp-2);
    failed += test_one(0x1.9ffffffffffffp+0, 0x1.3583f6644327bp-2);
// subdomain 3:10 (1.625..1.6875)
    failed += test_one(0x1.ap+0, 0x1.3583f6644327bp-2);
    failed += test_one(0x1.a7be3a036e213p+0, 0x1.310d7cfccccfdp-2);
    failed += test_one(0x1.acb2d5130c759p+0, 0x1.2e42235199ffdp-2);
    failed += test_one(0x1.ac67e250e2acep+0, 0x1.2e6c105ab4de9p-2);
    failed += test_one(0x1.ad4feaf1015bdp+0, 0x1.2dea6689cdebep-2);
    failed += test_one(0x1.affffffffffffp+0, 0x1.2c6c3d2ac6112p-2);
// subdomain 3:11 (1.6875..1.75)
    failed += test_one(0x1.bp+0, 0x1.2c6c3d2ac6111p-2);
    failed += test_one(0x1.b690e4d1fbd1cp+0, 0x1.28d5325dca23dp-2);
    failed += test_one(0x1.badd9edb0f05ap+0, 0x1.26864ca24dc76p-2);
    failed += test_one(0x1.b8e65f5849762p+0, 0x1.2793658d91a0ep-2);
    failed += test_one(0x1.b6d7a0a7fd21fp+0, 0x1.28aef7bf17d18p-2);
    failed += test_one(0x1.bffffffffffffp+0, 0x1.23cfc2f1dc7e1p-2);
// subdomain 3:12 (1.75..1.8125)
    failed += test_one(0x1.cp+0, 0x1.23cfc2f1dc7ep-2);
    failed += test_one(0x1.ca9cae237dce8p+0, 0x1.1e59302d608adp-2);
    failed += test_one(0x1.cf4e1c3d96f13p+0, 0x1.1bfe12a1db227p-2);
    failed += test_one(0x1.c2691321cd029p+0, 0x1.228dc38d98eb7p-2);
    failed += test_one(0x1.c5cb4a052e7c8p+0, 0x1.20ce145d41a6dp-2);
    failed += test_one(0x1.cffffffffffffp+0, 0x1.1ba58e2518db3p-2);
// subdomain 3:13 (1.8125..1.875)
    failed += test_one(0x1.dp+0, 0x1.1ba58e2518db3p-2);
    failed += test_one(0x1.d74782a6587b2p+0, 0x1.18122de7ac1bap-2);
    failed += test_one(0x1.da8822e7eee28p+0, 0x1.168016fb3f03dp-2);
    failed += test_one(0x1.d6670b3149b2dp+0, 0x1.187f4d096db9ap-2);
    failed += test_one(0x1.d9eda6c876c4cp+0, 0x1.16ca6032bb21ep-2);
    failed += test_one(0x1.dffffffffffffp+0, 0x1.13e5743b60481p-2);
// subdomain 3:14 (1.875..1.9375)
    failed += test_one(0x1.ep+0, 0x1.13e5743b6048p-2);
    failed += test_one(0x1.e2bd3c281524ap+0, 0x1.129bdd0606907p-2);
    failed += test_one(0x1.ee341a7061b42p+0, 0x1.0d57033aac4acp-2);
    failed += test_one(0x1.edca35ff03b09p+0, 0x1.0d86d6d6af4cbp-2);
    failed += test_one(0x1.ef296b712734fp+0, 0x1.0ce873c18aec5p-2);
    failed += test_one(0x1.effffffffffffp+0, 0x1.0c8803dfa92b3p-2);
// subdomain 3:15 (1.9375..2)
    failed += test_one(0x1.fp+0, 0x1.0c8803dfa92b2p-2);
    failed += test_one(0x1.fdf86ed3d79cbp+0, 0x1.0665162f55412p-2);
    failed += test_one(0x1.f59d4177b7d5fp+0, 0x1.0a08885480e74p-2);
    failed += test_one(0x1.f95f295fab7bbp+0, 0x1.0862ba0d05739p-2);
    failed += test_one(0x1.fec7fc3b7f5dp+0, 0x1.060bfb348f8dp-2);
    failed += test_one(0x1.fffffffffffffp+0, 0x1.058671b52c776p-2);
// subdomain 4:0 (2..2.125)
    failed += test_one(0x1p+1, 0x1.058671b52c776p-2);
    failed += test_one(0x1.0d145927448dbp+1, 0x1.f58fea2f9c742p-3);
    failed += test_one(0x1.071f42fbc8d3ep+1, 0x1.ff23e2d9b2e61p-3);
    failed += test_one(0x1.0f44831501de6p+1, 0x1.f220dbf64e716p-3);
    failed += test_one(0x1.0858ae80fb345p+1, 0x1.fd24d6706e7dbp-3);
    failed += test_one(0x1.0ffffffffffffp+1, 0x1.f0fd28fdc20adp-3);
// subdomain 4:1 (2.125..2.25)
    failed += test_one(0x1.1p+1, 0x1.f0fd28fdc20abp-3);
    failed += test_one(0x1.197f0004e465ap+1, 0x1.e2a5a1f4e8cd4p-3);
    failed += test_one(0x1.102d71dd14d35p+1, 0x1.f0b6a50abd3bbp-3);
    failed += test_one(0x1.1ac36973678f4p+1, 0x1.e0cabc15a2bd5p-3);
    failed += test_one(0x1.1856b051741b4p+1, 0x1.e45a6c5079ffbp-3);
    failed += test_one(0x1.1ffffffffffffp+1, 0x1.d94446d627933p-3);
// subdomain 4:2 (2.25..2.375)
    failed += test_one(0x1.2p+1, 0x1.d94446d627932p-3);
    failed += test_one(0x1.2265913dbe6e6p+1, 0x1.d5e570ece4d28p-3);
    failed += test_one(0x1.2564679d3085ap+1, 0x1.d1bf436170dffp-3);
    failed += test_one(0x1.287a73984dc38p+1, 0x1.cd8b55f4f8b79p-3);
    failed += test_one(0x1.2517395fb13a5p+1, 0x1.d2295daafba1ep-3);
    failed += test_one(0x1.2ffffffffffffp+1, 0x1.c3987d04d0b99p-3);
// subdomain 4:3 (2.375..2.5)
    failed += test_one(0x1.3p+1, 0x1.c3987d04d0b98p-3);
    failed += test_one(0x1.309e82d604edcp+1, 0x1.c2cb7613669ffp-3);
    failed += test_one(0x1.352656b2ff71dp+1, 0x1.bd0401e0e567bp-3);
    failed += test_one(0x1.390f06a33f5d6p+1, 0x1.b82430a95f1fp-3);
    failed += test_one(0x1.3782fb66ca5cep+1, 0x1.ba0eecb3abeb2p-3);
    failed += test_one(0x1.3ffffffffffffp+1, 0x1.afbb3f3b7343cp-3);
// subdomain 4:4 (2.5..2.625)
    failed += test_one(0x1.4p+1, 0x1.afbb3f3b7343bp-3);
    failed += test_one(0x1.4fef0489956a9p+1, 0x1.9d89d461175c2p-3);
    failed += test_one(0x1.421c95dc481ap+1, 0x1.ad3bbab17c486p-3);
    failed += test_one(0x1.4c364da43bf2bp+1, 0x1.a1a7cd9a20177p-3);
    failed += test_one(0x1.4415b63cc31fbp+1, 0x1.aaec7e3498868p-3);
    failed += test_one(0x1.4ffffffffffffp+1, 0x1.9d7738e1f4db8p-3);
// subdomain 4:5 (2.625..2.75)
    failed += test_one(0x1.5p+1, 0x1.9d7738e1f4db7p-3);
    failed += test_one(0x1.536e01ee27ad3p+1, 0x1.99bda00275f03p-3);
    failed += test_one(0x1.5236f5fd0b70fp+1, 0x1.9b0d91877a6fp-3);
    failed += test_one(0x1.56889a9174cd3p+1, 0x1.966ca8186b863p-3);
    failed += test_one(0x1.5e5e3e9aeafbfp+1, 0x1.8e4716d6664dbp-3);
    failed += test_one(0x1.5ffffffffffffp+1, 0x1.8c9eb68ff27d8p-3);
// subdomain 4:6 (2.75..2.875)
    failed += test_one(0x1.6p+1, 0x1.8c9eb68ff27d7p-3);
    failed += test_one(0x1.6eef442059d1fp+1, 0x1.7e0a918fcbac4p-3);
    failed += test_one(0x1.62013a63ba102p+1, 0x1.8a99f50974f0cp-3);
    failed += test_one(0x1.6222ae5de7297p+1, 0x1.8a7872ecb28bep-3);
    failed += test_one(0x1.63868469e6566p+1, 0x1.89155691f3609p-3);
    failed += test_one(0x1.6ffffffffffffp+1, 0x1.7d0a5e9dd5711p-3);
// subdomain 4:7 (2.875..3)
    failed += test_one(0x1.7p+1, 0x1.7d0a5e9dd571p-3);
    failed += test_one(0x1.7edc95cd890f7p+1, 0x1.6f965580eab1ep-3);
    failed += test_one(0x1.702c6ddf20803p+1, 0x1.7ce0c18444a7dp-3);
    failed += test_one(0x1.70c38c0e32199p+1, 0x1.7c537818c590fp-3);
    failed += test_one(0x1.7442c1fbdc997p+1, 0x1.79167dc3b0b7bp-3);
    failed += test_one(0x1.7ffffffffffffp+1, 0x1.6e9827d229d2ep-3);
// subdomain 4:8 (3..3.125)
    failed += test_one(0x1.8p+1, 0x1.6e9827d229d2dp-3);
    failed += test_one(0x1.8b28b88bb9fa6p+1, 0x1.6520b5a902685p-3);
    failed += test_one(0x1.85b5cfe9290a1p+1, 0x1.69b0cf97e4944p-3);
    failed += test_one(0x1.836c627673757p+1, 0x1.6ba3a6dac3eb3p-3);
    failed += test_one(0x1.803c0d2ab3a7cp+1, 0x1.6e63f0ff0eab3p-3);
    failed += test_one(0x1.8ffffffffffffp+1, 0x1.612a8125451bep-3);
// subdomain 4:9 (3.125..3.25)
    failed += test_one(0x1.9p+1, 0x1.612a8125451bdp-3);
    failed += test_one(0x1.92289a9217844p+1, 0x1.5f6d393453b42p-3);
    failed += test_one(0x1.9f3e423f33f0bp+1, 0x1.553a2d18f3519p-3);
    failed += test_one(0x1.9b1afd11503c4p+1, 0x1.5863e8bc3ca22p-3);
    failed += test_one(0x1.9563f2167fc0ep+1, 0x1.5cda69fb2ebf3p-3);
    failed += test_one(0x1.9ffffffffffffp+1, 0x1.54a7a08d4bb46p-3);
// subdomain 4:10 (3.25..3.375)
    failed += test_one(0x1.ap+1, 0x1.54a7a08d4bb45p-3);
    failed += test_one(0x1.a1490b9fc3cfdp+1, 0x1.53afd13d6e3bfp-3);
    failed += test_one(0x1.a671b831cf26bp+1, 0x1.4fdabd7a1e41cp-3);
    failed += test_one(0x1.a9af50d5582e6p+1, 0x1.4d7d56540b2b8p-3);
    failed += test_one(0x1.a6950a354d273p+1, 0x1.4fc0cbb7bb595p-3);
    failed += test_one(0x1.affffffffffffp+1, 0x1.48f8f10299b72p-3);
// subdomain 4:11 (3.375..3.5)
    failed += test_one(0x1.bp+1, 0x1.48f8f10299b71p-3);
    failed += test_one(0x1.bbb4c7e7d2c4ep+1, 0x1.40e7b8d4b1bd7p-3);
    failed += test_one(0x1.bde479a2f5081p+1, 0x1.3f70d7decf8d2p-3);
    failed += test_one(0x1.be3e3c6a8b97cp+1, 0x1.3f3507cf2e6b6p-3);
    failed += test_one(0x1.bdc9627a36f38p+1, 0x1.3f82e96daffe3p-3);
    failed += test_one(0x1.bffffffffffffp+1, 0x1.3e0a99a0ee915p-3);
// subdomain 4:12 (3.5..3.625)
    failed += test_one(0x1.cp+1, 0x1.3e0a99a0ee914p-3);
    failed += test_one(0x1.cc1d543786d5fp+1, 0x1.3638facc29ad5p-3);
    failed += test_one(0x1.cb5ef7e20dba4p+1, 0x1.36b115675dddbp-3);
    failed += test_one(0x1.c6cbb04e08974p+1, 0x1.399be7ca246f2p-3);
    failed += test_one(0x1.c4d39788228a6p+1, 0x1.3ae1871be3839p-3);
    failed += test_one(0x1.cffffffffffffp+1, 0x1.33cb19179d7f7p-3);
// subdomain 4:13 (3.625..3.75)
    failed += test_one(0x1.dp+1, 0x1.33cb19179d7f6p-3);
    failed += test_one(0x1.df005641842c9p+1, 0x1.2ac05b219d305p-3);
    failed += test_one(0x1.df4d7ca14c13fp+1, 0x1.2a93357887d3cp-3);
    failed += test_one(0x1.d9242c023a0fep+1, 0x1.2e38a7fa7d34cp-3);
    failed += test_one(0x1.df66040e51258p+1, 0x1.2a84dd9ce4206p-3);
    failed += test_one(0x1.dffffffffffffp+1, 0x1.2a2af19c1493p-3);
// subdomain 4:14 (3.75..3.875)
    failed += test_one(0x1.ep+1, 0x1.2a2af19c1493p-3);
    failed += test_one(0x1.edfe4ea846703p+1, 0x1.22379c52222c8p-3);
    failed += test_one(0x1.ededbfa93b06p+1, 0x1.2240c67fbeec4p-3);
    failed += test_one(0x1.eadfe9942af57p+1, 0x1.23f405bfda25p-3);
    failed += test_one(0x1.e52a1933dfd71p+1, 0x1.272f450625445p-3);
    failed += test_one(0x1.effffffffffffp+1, 0x1.211c625924e34p-3);
// subdomain 4:15 (3.875..4)
    failed += test_one(0x1.fp+1, 0x1.211c625924e34p-3);
    failed += test_one(0x1.f96fc3866df58p+1, 0x1.1c042c8fc8e72p-3);
    failed += test_one(0x1.f343a0b19a0c4p+1, 0x1.1f541ff30518dp-3);
    failed += test_one(0x1.fa537ac4f472cp+1, 0x1.1b8b8b0f4515ep-3);
    failed += test_one(0x1.f21d8cdf75dbcp+1, 0x1.1ff4112f66f5p-3);
    failed += test_one(0x1.fffffffffffffp+1, 0x1.18932bf08e155p-3);
// subdomain 5:0 (4..4.25)
    failed += test_one(0x1p+2, 0x1.18932bf08e154p-3);
    failed += test_one(0x1.000dda52ec664p+2, 0x1.1884d1b2efbbcp-3);
    failed += test_one(0x1.01d61a0b31b64p+2, 0x1.16af384c562d5p-3);
    failed += test_one(0x1.07a4743730d29p+2, 0x1.10de1a1e3ad27p-3);
    failed += test_one(0x1.06aca4821d3a2p+2, 0x1.11d224db4c5bap-3);
    failed += test_one(0x1.0ffffffffffffp+2, 0x1.08e62ce8c89adp-3);
// subdomain 5:1 (4.25..4.5)
    failed += test_one(0x1.1p+2, 0x1.08e62ce8c89adp-3);
    failed += test_one(0x1.155076d606707p+2, 0x1.041093de83b3cp-3);
    failed += test_one(0x1.1902f394b4814p+2, 0x1.00cd52d536cb6p-3);
    failed += test_one(0x1.1035e128f33ccp+2, 0x1.08b44e9cb7aa3p-3);
    failed += test_one(0x1.194dff43194a6p+2, 0x1.008bf96d8eeb9p-3);
    failed += test_one(0x1.1ffffffffffffp+2, 0x1.f5b2a049cf4c7p-4);
// subdomain 5:2 (4.5..4.75)
    failed += test_one(0x1.2p+2, 0x1.f5b2a049cf4c6p-4);
    failed += test_one(0x1.2aa34d875d367p+2, 0x1.e493f22dbf80fp-4);
    failed += test_one(0x1.2288fdda56302p+2, 0x1.f182e08bcf675p-4);
    failed += test_one(0x1.2ba7a5d11eb6p+2, 0x1.e300484b8d14ap-4);
    failed += test_one(0x1.2e06d007b3195p+2, 0x1.df5cd0e166f19p-4);
    failed += test_one(0x1.2ffffffffffffp+2, 0x1.dc603a3e77e9cp-4);
// subdomain 5:3 (4.75..5)
    failed += test_one(0x1.3p+2, 0x1.dc603a3e77e9bp-4);
    failed += test_one(0x1.367b3dd045518p+2, 0x1.d2d1855b4d482p-4);
    failed += test_one(0x1.3ccf1ba8c869ep+2, 0x1.c9d828c0ab307p-4);
    failed += test_one(0x1.341b320ee4ed3p+2, 0x1.d646de8f49dc2p-4);
    failed += test_one(0x1.312b0b9274adep+2, 0x1.daa00524a5305p-4);
    failed += test_one(0x1.3ffffffffffffp+2, 0x1.c57239e943d1bp-4);
// subdomain 5:4 (5..5.25)
    failed += test_one(0x1.4p+2, 0x1.c57239e943d1ap-4);
    failed += test_one(0x1.4f9b8a4c52a7ap+2, 0x1.b114244ecc2c3p-4);
    failed += test_one(0x1.42847bc19f681p+2, 0x1.c208d27d8aa66p-4);
    failed += test_one(0x1.4490e21127569p+2, 0x1.bf4ba260b540cp-4);
    failed += test_one(0x1.4f2cd7ff46e6ep+2, 0x1.b19e6173886aap-4);
    failed += test_one(0x1.4ffffffffffffp+2, 0x1.b096face146ffp-4);
// subdomain 5:5 (5.25..5.5)
    failed += test_one(0x1.5p+2, 0x1.b096face146fep-4);
    failed += test_one(0x1.5afaa9b7d2b5dp+2, 0x1.a3569a96b750cp-4);
    failed += test_one(0x1.5c79ba49e4537p+2, 0x1.a1980c7267d5bp-4);
    failed += test_one(0x1.550a5f620224ep+2, 0x1.aa67b42f0880bp-4);
    failed += test_one(0x1.5a0eb68041028p+2, 0x1.a46b7eae0738cp-4);
    failed += test_one(0x1.5ffffffffffffp+2, 0x1.9d8a8f2284f2dp-4);
// subdomain 5:6 (5.5..5.75)
    failed += test_one(0x1.6p+2, 0x1.9d8a8f2284f2cp-4);
    failed += test_one(0x1.653d9a71da47ep+2, 0x1.97a81601adb3dp-4);
    failed += test_one(0x1.6e78001654106p+2, 0x1.8dafadba9fe63p-4);
    failed += test_one(0x1.618dc781609dbp+2, 0x1.9bc771dd1f879p-4);
    failed += test_one(0x1.6b255df0d8068p+2, 0x1.91386a7a8f6b1p-4);
    failed += test_one(0x1.6ffffffffffffp+2, 0x1.8c14049cd551fp-4);
// subdomain 5:7 (5.75..6)
    failed += test_one(0x1.7p+2, 0x1.8c14049cd551ep-4);
    failed += test_one(0x1.7eb1d442540ffp+2, 0x1.7d466f0c96779p-4);
    failed += test_one(0x1.7ae2f2dc36e6bp+2, 0x1.810165a0df81p-4);
    failed += test_one(0x1.77cf3f863724fp+2, 0x1.841295ba2354ap-4);
    failed += test_one(0x1.7803f8e63dcabp+2, 0x1.83dda4bc98d3fp-4);
    failed += test_one(0x1.7ffffffffffffp+2, 0x1.7c0348489d722p-4);
// subdomain 5:8 (6..6.25)
    failed += test_one(0x1.8p+2, 0x1.7c0348489d721p-4);
    failed += test_one(0x1.8243ca0a23f03p+2, 0x1.79d79913b689bp-4);
    failed += test_one(0x1.8721864265862p+2, 0x1.75429ceca94fep-4);
    failed += test_one(0x1.8a7c619016e1dp+2, 0x1.722a266adcc9ap-4);
    failed += test_one(0x1.83dc3c81c3d6ap+2, 0x1.7853e1c684b39p-4);
    failed += test_one(0x1.8ffffffffffffp+2, 0x1.6d2f811bf7398p-4);
// subdomain 5:9 (6.25..6.5)
    failed += test_one(0x1.9p+2, 0x1.6d2f811bf7397p-4);
    failed += test_one(0x1.982aa096eb351p+2, 0x1.660cd206b01e7p-4);
    failed += test_one(0x1.9365f77816148p+2, 0x1.6a2eb2f74af2ep-4);
    failed += test_one(0x1.913a9fef68b87p+2, 0x1.6c1803a8723b1p-4);
    failed += test_one(0x1.9b5757f56b40ap+2, 0x1.63599ff720fe2p-4);
    failed += test_one(0x1.9ffffffffffffp+2, 0x1.5f75c42e97171p-4);
// subdomain 5:10 (6.5..6.75)
    failed += test_one(0x1.ap+2, 0x1.5f75c42e97171p-4);
    failed += test_one(0x1.aa3c9d28e52c8p+2, 0x1.573399809beccp-4);
    failed += test_one(0x1.a8b29c8f21092p+2, 0x1.586b27fd353adp-4);
    failed += test_one(0x1.a5a4a3adb1c2dp+2, 0x1.5adc056453d28p-4);
    failed += test_one(0x1.a5c373acaadd3p+2, 0x1.5ac33bbc9aea5p-4);
    failed += test_one(0x1.affffffffffffp+2, 0x1.52b80d463c47p-4);
// subdomain 5:11 (6.75..7)
    failed += test_one(0x1.bp+2, 0x1.52b80d463c47p-4);
    failed += test_one(0x1.b7c855fae6966p+2, 0x1.4cd8b7da7ffb9p-4);
    failed += test_one(0x1.b93d1be020226p+2, 0x1.4bc52766c5f65p-4);
    failed += test_one(0x1.b0d5a755c6beap+2, 0x1.52145419a47d7p-4);
    failed += test_one(0x1.b570b4a95f035p+2, 0x1.4e97b74458d1cp-4);
    failed += test_one(0x1.bffffffffffffp+2, 0x1.46dc6bf900f69p-4);
// subdomain 5:12 (7..7.25)
    failed += test_one(0x1.cp+2, 0x1.46dc6bf900f68p-4);
    failed += test_one(0x1.c5f2673391751p+2, 0x1.42a922480d9adp-4);
    failed += test_one(0x1.c113834e898bbp+2, 0x1.4617c614eaacdp-4);
    failed += test_one(0x1.c6948e889f88ep+2, 0x1.423836f9a14ecp-4);
    failed += test_one(0x1.c845e8a7a2d3dp+2, 0x1.410befc6554dcp-4);
    failed += test_one(0x1.cffffffffffffp+2, 0x1.3bcc59a28358dp-4);
// subdomain 5:13 (7.25..7.5)
    failed += test_one(0x1.dp+2, 0x1.3bcc59a28358cp-4);
    failed += test_one(0x1.d80e630ae5d91p+2, 0x1.36811c24238ebp-4);
    failed += test_one(0x1.d043d8b90eab5p+2, 0x1.3b9f09d3da59cp-4);
    failed += test_one(0x1.dbf40f0a3cb33p+2, 0x1.34018ebe182c8p-4);
    failed += test_one(0x1.dc839d4f5a969p+2, 0x1.33a65eef78634p-4);
    failed += test_one(0x1.dffffffffffffp+2, 0x1.31742f4d8d4d3p-4);
// subdomain 5:14 (7.5..7.75)
    failed += test_one(0x1.ep+2, 0x1.31742f4d8d4d3p-4);
    failed += test_one(0x1.e8626e1e8601ap+2, 0x1.2c4c07bf9a269p-4);
    failed += test_one(0x1.eb9cdbdb24faap+2, 0x1.2a5b74239a578p-4);
    failed += test_one(0x1.e613e104ccf5ep+2, 0x1.2db2d12934361p-4);
    failed += test_one(0x1.eecb1974dce52p+2, 0x1.287862e359c48p-4);
    failed += test_one(0x1.effffffffffffp+2, 0x1.27c2b4d2f8988p-4);
// subdomain 5:15 (7.75..8)
    failed += test_one(0x1.fp+2, 0x1.27c2b4d2f8988p-4);
    failed += test_one(0x1.f963394a29cf3p+2, 0x1.225a3209bbde5p-4);
    failed += test_one(0x1.f93339d8aebc5p+2, 0x1.22755af33223dp-4);
    failed += test_one(0x1.ff82ac42ebf4bp+2, 0x1.1eedf158542e1p-4);
    failed += test_one(0x1.ff508da7aa745p+2, 0x1.1f09a4c4b57fbp-4);
    failed += test_one(0x1.fffffffffffffp+2, 0x1.1ea8c4009b45ap-4);
// subdomain 6:0 (8..8.5)
    failed += test_one(0x1p+3, 0x1.1ea8c4009b459p-4);
    failed += test_one(0x1.058a09a6f0f35p+3, 0x1.18ad3346c9e98p-4);
    failed += test_one(0x1.025c0a8cda5aep+3, 0x1.1c1482e13bc8p-4);
    failed += test_one(0x1.0db6f86f2386ep+3, 0x1.104946b15e597p-4);
    failed += test_one(0x1.0fcfb059947fap+3, 0x1.0e36da444675fp-4);
    failed += test_one(0x1.0ffffffffffffp+3, 0x1.0e078051f491ep-4);
// subdomain 6:1 (8.5..9)
    failed += test_one(0x1.1p+3, 0x1.0e078051f491dp-4);
    failed += test_one(0x1.15588e6827c31p+3, 0x1.08e46251871c4p-4);
    failed += test_one(0x1.1dd6150cde91ep+3, 0x1.011ef70a7e6e6p-4);
    failed += test_one(0x1.1f102a8abe4e6p+3, 0x1.00090a611eb86p-4);
    failed += test_one(0x1.1a1c716729d0bp+3, 0x1.04795b2c0efc1p-4);
    failed += test_one(0x1.1ffffffffffffp+3, 0x1.fe6cc4a0f953ap-5);
// subdomain 6:2 (9..9.5)
    failed += test_one(0x1.2p+3, 0x1.fe6cc4a0f9538p-5);
    failed += test_one(0x1.2996aefce650fp+3, 0x1.ee2a92ad5645p-5);
    failed += test_one(0x1.2b2d40ddc34e2p+3, 0x1.eb9282c57b75fp-5);
    failed += test_one(0x1.2acfc96f3dee2p+3, 0x1.ec2a8ed0d6403p-5);
    failed += test_one(0x1.2c0743e0bf391p+3, 0x1.ea31461d4b791p-5);
    failed += test_one(0x1.2ffffffffffffp+3, 0x1.e3db9bbbefcap-5);
// subdomain 6:3 (9.5..10)
    failed += test_one(0x1.3p+3, 0x1.e3db9bbbefc9ep-5);
    failed += test_one(0x1.39f036a66a0b7p+3, 0x1.d4b2ae677feccp-5);
    failed += test_one(0x1.3a043411d0849p+3, 0x1.d4952589b0ad8p-5);
    failed += test_one(0x1.3f8a147b649cbp+3, 0x1.cc904165b15d2p-5);
    failed += test_one(0x1.37dd5098e3e3dp+3, 0x1.d7c866d8688e7p-5);
    failed += test_one(0x1.3ffffffffffffp+3, 0x1.cbe831f997125p-5);
// subdomain 6:4 (10..10.5)
    failed += test_one(0x1.4p+3, 0x1.cbe831f997124p-5);
    failed += test_one(0x1.434c515a75271p+3, 0x1.c742a89af5c2ep-5);
    failed += test_one(0x1.4ed1af812c861p+3, 0x1.b7bcc7c466819p-5);
    failed += test_one(0x1.4e3e2b11558c5p+3, 0x1.b87d1e94ba22p-5);
    failed += test_one(0x1.46e880f3151ddp+3, 0x1.c247b9eec60cdp-5);
    failed += test_one(0x1.4ffffffffffffp+3, 0x1.b634a500659c4p-5);
// subdomain 6:5 (10.5..11)
    failed += test_one(0x1.5p+3, 0x1.b634a500659c3p-5);
    failed += test_one(0x1.58ce0c0d587eap+3, 0x1.ab1c7c1abd535p-5);
    failed += test_one(0x1.599f7abbeb8ap+3, 0x1.aa1bd95d73006p-5);
    failed += test_one(0x1.53ded0f10ac06p+3, 0x1.b1424c16d372ap-5);
    failed += test_one(0x1.5300407062562p+3, 0x1.b25c44a33efb3p-5);
    failed += test_one(0x1.5ffffffffffffp+3, 0x1.a273c57e476cfp-5);
// subdomain 6:6 (11..11.5)
    failed += test_one(0x1.6p+3, 0x1.a273c57e476cep-5);
    failed += test_one(0x1.674f78af27957p+3, 0x1.9a01624d061fap-5);
    failed += test_one(0x1.674a966a17bc4p+3, 0x1.9a06e9f281dep-5);
    failed += test_one(0x1.64e2b85939a3p+3, 0x1.9cc4ed258f4c6p-5);
    failed += test_one(0x1.6c3db3041098cp+3, 0x1.947f65e241f66p-5);
    failed += test_one(0x1.6ffffffffffffp+3, 0x1.90658c4eb57ccp-5);
// subdomain 6:7 (11.5..12)
    failed += test_one(0x1.7p+3, 0x1.90658c4eb57cbp-5);
    failed += test_one(0x1.77f9e73645a96p+3, 0x1.87f6a7f7ccff7p-5);
    failed += test_one(0x1.7289d9fc22709p+3, 0x1.8dac7d99f4c8ap-5);
    failed += test_one(0x1.76c11c1f93201p+3, 0x1.893b7952d439ap-5);
    failed += test_one(0x1.73e8a8232e467p+3, 0x1.8c381d41bfc4ap-5);
    failed += test_one(0x1.7ffffffffffffp+3, 0x1.7fd46c5e0864ep-5);
    return failed;
}

// clang-format on
//--- End of auto-generated test cases
