#!/bin/sh -ex

ci_setup_default() {
    cave sync || true
    cave resolve socat -zx || true
    dev/install_libseccomp.sh -v main -i /usr/host || true
}

ci_setup_alpine() {
    apk add \
        bash \
        cargo \
        gawk \
        gnupg \
        libcap-dev \
        libseccomp-dev \
        libseccomp-static \
        perl \
        python3 \
        socat \
        s3cmd
    addgroup -S paludisbuild
    adduser -S -D -G paludisbuild -s /bin/bash -h /var/tmp/paludis paludisbuild
}

if test -e /etc/alpine-release; then
    ci_setup_alpine
else
    ci_setup_default
fi
