import shallowEqual from "./shallowEqual";
function getLatestDecodedValues(parsedParams, paramConfigMap, decodedParamCache) {
  const decodedValues = {};
  const paramNames = Object.keys(paramConfigMap);
  for (const paramName of paramNames) {
    const paramConfig = paramConfigMap[paramName];
    const encodedValue = parsedParams[paramName];
    let decodedValue;
    if (decodedParamCache.has(paramName, encodedValue, paramConfig.decode)) {
      decodedValue = decodedParamCache.get(paramName);
    } else {
      decodedValue = paramConfig.decode(encodedValue);
      if (paramConfig.equals && decodedParamCache.has(paramName, encodedValue)) {
        const oldDecodedValue = decodedParamCache.get(paramName);
        if (paramConfig.equals(decodedValue, oldDecodedValue)) {
          decodedValue = oldDecodedValue;
        }
      }
      if (decodedValue !== void 0) {
        decodedParamCache.set(
          paramName,
          encodedValue,
          decodedValue,
          paramConfig.decode
        );
      }
    }
    if (decodedValue === void 0 && paramConfig.default !== void 0) {
      decodedValue = paramConfig.default;
    }
    decodedValues[paramName] = decodedValue;
  }
  return decodedValues;
}
function makeStableGetLatestDecodedValues() {
  let prevDecodedValues;
  function stableGetLatest(parsedParams, paramConfigMap, decodedParamCache) {
    const decodedValues = getLatestDecodedValues(
      parsedParams,
      paramConfigMap,
      decodedParamCache
    );
    if (prevDecodedValues != null && shallowEqual(prevDecodedValues, decodedValues)) {
      return prevDecodedValues;
    }
    prevDecodedValues = decodedValues;
    return decodedValues;
  }
  return stableGetLatest;
}
export {
  getLatestDecodedValues,
  makeStableGetLatestDecodedValues
};
//# sourceMappingURL=latestValues.js.map
