import { EncodedValueMap, QueryParamConfigMap } from 'serialize-query-params';
/**
 * Create an alias mapping using the optional `urlName` property on params
 */
export declare function serializeUrlNameMap(paramConfigMap: QueryParamConfigMap): string | undefined;
/**
 * Converts the stringified alias/urlName map back into an object
 */
export declare function deserializeUrlNameMap(urlNameMapStr: string | undefined): Record<string, string> | undefined;
/**
 * converts { searchString: 'foo'} to { q: 'foo'} if the searchString
 * is configured to have "q" as its urlName.
 */
export declare function applyUrlNames(encodedValues: Partial<EncodedValueMap<any>>, paramConfigMap: QueryParamConfigMap): Partial<EncodedValueMap<any>>;
