/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareToIntegerConstant
extends Expression
implements ComparisonExpression {
    private Expression operand;
    private long comparand;
    private int operator;

    public CompareToIntegerConstant(Expression operand, int operator, long comparand) {
        this.operand = operand;
        this.operator = operator;
        this.comparand = comparand;
        this.adoptChildExpression(operand);
    }

    public Expression getOperand() {
        return this.operand;
    }

    public long getComparand() {
        return this.comparand;
    }

    public int getComparisonOperator() {
        return this.operator;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.operand = this.doPromotion(this.operand, offer);
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        return 0x400000;
    }

    @Override
    public int computeDependencies() {
        return this.operand.getDependencies();
    }

    @Override
    public Expression copy() {
        return new CompareToIntegerConstant(this.operand.copy(), this.operator, this.comparand);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(new Operand(this.operand, OperandRole.SINGLE_ATOMIC));
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        if (original == this.operand) {
            this.operand = replacement;
            return true;
        }
        return false;
    }

    @Override
    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        NumericValue n = (NumericValue)this.operand.evaluateItem(context);
        if (n.isNaN()) {
            return this.operator == 51;
        }
        int c = n.compareTo(this.comparand);
        switch (this.operator) {
            case 50: {
                return c == 0;
            }
            case 51: {
                return c != 0;
            }
            case 52: {
                return c > 0;
            }
            case 53: {
                return c < 0;
            }
            case 54: {
                return c >= 0;
            }
            case 55: {
                return c <= 0;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + this.operator);
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextInfo);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        if (this.operand instanceof Literal) {
            Literal lit = Literal.makeLiteral(BooleanValue.get(this.effectiveBooleanValue(null)), this.getContainer());
            ExpressionTool.copyLocationInfo(this, lit);
            return lit;
        }
        return this;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("compareToInteger");
        destination.emitAttribute("op", Token.tokens[this.operator]);
        destination.emitAttribute("value", this.comparand + "");
        this.operand.explain(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.operand) + " " + Token.tokens[this.operator] + " " + this.comparand;
    }

    @Override
    public String toShortString() {
        return this.operand.toShortString() + " " + Token.tokens[this.operator] + " " + this.comparand;
    }

    @Override
    public AtomicComparer getAtomicComparer() {
        return DoubleSortComparer.getInstance();
    }

    @Override
    public int getSingletonOperator() {
        return this.operator;
    }

    @Override
    public Expression[] getOperands() {
        Literal lit = Literal.makeLiteral(Int64Value.makeIntegerValue(this.comparand), this.getContainer());
        return new Expression[]{this.operand, lit};
    }

    @Override
    public boolean convertsUntypedToOther() {
        return true;
    }
}

