'use client';
import { jsx } from 'react/jsx-runtime';
import cx from 'clsx';
import hljs from 'highlight.js';
import { factory, useProps, useStyles, Box } from '@mantine/core';
import _classes from './CodeHighlight.module.css.mjs';
import themeClasses from './CodeHighlight.theme.module.css.mjs';

const classes = { ..._classes, code: cx(_classes.code, themeClasses.theme) };
const defaultProps = {
  language: "tsx"
};
const InlineCodeHighlight = factory((_props, ref) => {
  const props = useProps("InlineCodeHighlight", defaultProps, _props);
  const { classNames, className, style, styles, unstyled, vars, code, language, ...others } = props;
  const getStyles = useStyles({
    name: "InlineCodeHighlight",
    props,
    classes,
    className,
    style,
    classNames,
    styles,
    unstyled,
    rootSelector: "code"
  });
  const highlighted = hljs.highlight(code.trim(), { language }).value;
  return /* @__PURE__ */ jsx(
    Box,
    {
      ...getStyles("code"),
      component: "code",
      ref,
      ...others,
      dangerouslySetInnerHTML: { __html: highlighted }
    }
  );
});
InlineCodeHighlight.displayName = "@mantine/core/InlineCodeHighlight";

export { InlineCodeHighlight };
//# sourceMappingURL=InlineCodeHighlight.mjs.map
