#pragma once
#ifndef MESSMER_FSPP_TEST_FUSE_CREATEANDOPENFILE_TESTUTILS_FUSECREATEANDOPENTEST_H_
#define MESSMER_FSPP_TEST_FUSE_CREATEANDOPENFILE_TESTUTILS_FUSECREATEANDOPENTEST_H_

#include "../../../testutils/FuseTest.h"
#include "../../../testutils/OpenFileHandle.h"

class FuseCreateAndOpenTest: public FuseTest {
public:
  const char *FILENAME = "/myfile";

  void CreateAndOpenFile(const std::string& FILENAME, int flags);
  int CreateAndOpenFileReturnError(const std::string& FILENAME, int flags);
private:
  cpputils::unique_ref<OpenFileHandle> CreateAndOpenFileAllowErrors(const TempTestFS *fs, const std::string &filename, int flags);
};

//NOLINTNEXTLINE(cppcoreguidelines-avoid-const-or-ref-data-members)
MATCHER_P(OpenFlagsEq, expectedFlags, "") {
  return expectedFlags == (O_ACCMODE & arg);
}

#endif
