//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfdictionary?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct CGPDFDictionary {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPDFDictionary {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("CGPDFDictionary", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfdictionaryref?language=objc)
pub type CGPDFDictionaryRef = *mut CGPDFDictionary;

impl CGPDFDictionary {
    /// # Safety
    ///
    /// `dict` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetCount")]
    #[inline]
    pub unsafe fn count(dict: CGPDFDictionaryRef) -> usize {
        extern "C-unwind" {
            fn CGPDFDictionaryGetCount(dict: CGPDFDictionaryRef) -> usize;
        }
        unsafe { CGPDFDictionaryGetCount(dict) }
    }

    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `key` must be a valid pointer.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetObject")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn object(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFObjectRef,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDictionaryGetObject(
                dict: CGPDFDictionaryRef,
                key: NonNull<c_char>,
                value: *mut CGPDFObjectRef,
            ) -> bool;
        }
        unsafe { CGPDFDictionaryGetObject(dict, key, value) }
    }

    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `key` must be a valid pointer.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetBoolean")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn boolean(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFBoolean,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDictionaryGetBoolean(
                dict: CGPDFDictionaryRef,
                key: NonNull<c_char>,
                value: *mut CGPDFBoolean,
            ) -> bool;
        }
        unsafe { CGPDFDictionaryGetBoolean(dict, key, value) }
    }

    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `key` must be a valid pointer.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetInteger")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn integer(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFInteger,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDictionaryGetInteger(
                dict: CGPDFDictionaryRef,
                key: NonNull<c_char>,
                value: *mut CGPDFInteger,
            ) -> bool;
        }
        unsafe { CGPDFDictionaryGetInteger(dict, key, value) }
    }

    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `key` must be a valid pointer.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetNumber")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn number(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFReal,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDictionaryGetNumber(
                dict: CGPDFDictionaryRef,
                key: NonNull<c_char>,
                value: *mut CGPDFReal,
            ) -> bool;
        }
        unsafe { CGPDFDictionaryGetNumber(dict, key, value) }
    }

    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `key` must be a valid pointer.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetName")]
    #[inline]
    pub unsafe fn name(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut *const c_char,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDictionaryGetName(
                dict: CGPDFDictionaryRef,
                key: NonNull<c_char>,
                value: *mut *const c_char,
            ) -> bool;
        }
        unsafe { CGPDFDictionaryGetName(dict, key, value) }
    }

    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `key` must be a valid pointer.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetString")]
    #[cfg(feature = "CGPDFString")]
    #[inline]
    pub unsafe fn string(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFStringRef,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDictionaryGetString(
                dict: CGPDFDictionaryRef,
                key: NonNull<c_char>,
                value: *mut CGPDFStringRef,
            ) -> bool;
        }
        unsafe { CGPDFDictionaryGetString(dict, key, value) }
    }

    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `key` must be a valid pointer.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetArray")]
    #[cfg(feature = "CGPDFArray")]
    #[inline]
    pub unsafe fn array(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFArrayRef,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDictionaryGetArray(
                dict: CGPDFDictionaryRef,
                key: NonNull<c_char>,
                value: *mut CGPDFArrayRef,
            ) -> bool;
        }
        unsafe { CGPDFDictionaryGetArray(dict, key, value) }
    }

    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `key` must be a valid pointer.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetDictionary")]
    #[inline]
    pub unsafe fn dictionary(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFDictionaryRef,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDictionaryGetDictionary(
                dict: CGPDFDictionaryRef,
                key: NonNull<c_char>,
                value: *mut CGPDFDictionaryRef,
            ) -> bool;
        }
        unsafe { CGPDFDictionaryGetDictionary(dict, key, value) }
    }

    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `key` must be a valid pointer.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryGetStream")]
    #[cfg(feature = "CGPDFStream")]
    #[inline]
    pub unsafe fn stream(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFStreamRef,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFDictionaryGetStream(
                dict: CGPDFDictionaryRef,
                key: NonNull<c_char>,
                value: *mut CGPDFStreamRef,
            ) -> bool;
        }
        unsafe { CGPDFDictionaryGetStream(dict, key, value) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfdictionaryapplierfunction?language=objc)
#[cfg(feature = "CGPDFObject")]
pub type CGPDFDictionaryApplierFunction =
    Option<unsafe extern "C-unwind" fn(NonNull<c_char>, CGPDFObjectRef, *mut c_void)>;

impl CGPDFDictionary {
    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `function` must be implemented correctly.
    /// - `info` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryApplyFunction")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn apply_function(
        dict: CGPDFDictionaryRef,
        function: CGPDFDictionaryApplierFunction,
        info: *mut c_void,
    ) {
        extern "C-unwind" {
            fn CGPDFDictionaryApplyFunction(
                dict: CGPDFDictionaryRef,
                function: CGPDFDictionaryApplierFunction,
                info: *mut c_void,
            );
        }
        unsafe { CGPDFDictionaryApplyFunction(dict, function, info) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfdictionaryapplierblock?language=objc)
#[cfg(all(feature = "CGPDFObject", feature = "block2"))]
pub type CGPDFDictionaryApplierBlock =
    *mut block2::DynBlock<dyn Fn(NonNull<c_char>, CGPDFObjectRef, *mut c_void) -> bool>;

impl CGPDFDictionary {
    /// # Safety
    ///
    /// - `dict` must be a valid pointer or null.
    /// - `block` must be a valid pointer or null.
    /// - `info` must be a valid pointer or null.
    #[doc(alias = "CGPDFDictionaryApplyBlock")]
    #[cfg(all(feature = "CGPDFObject", feature = "block2"))]
    #[inline]
    pub unsafe fn apply_block(
        dict: CGPDFDictionaryRef,
        block: CGPDFDictionaryApplierBlock,
        info: *mut c_void,
    ) {
        extern "C-unwind" {
            fn CGPDFDictionaryApplyBlock(
                dict: CGPDFDictionaryRef,
                block: CGPDFDictionaryApplierBlock,
                info: *mut c_void,
            );
        }
        unsafe { CGPDFDictionaryApplyBlock(dict, block, info) }
    }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDictionary::count`"]
    pub fn CGPDFDictionaryGetCount(dict: CGPDFDictionaryRef) -> usize;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFDictionary::object`"]
    pub fn CGPDFDictionaryGetObject(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFObjectRef,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFDictionary::boolean`"]
    pub fn CGPDFDictionaryGetBoolean(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFBoolean,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFDictionary::integer`"]
    pub fn CGPDFDictionaryGetInteger(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFInteger,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFDictionary::number`"]
    pub fn CGPDFDictionaryGetNumber(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFReal,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDictionary::name`"]
    pub fn CGPDFDictionaryGetName(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut *const c_char,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFString")]
    #[deprecated = "renamed to `CGPDFDictionary::string`"]
    pub fn CGPDFDictionaryGetString(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFStringRef,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFArray")]
    #[deprecated = "renamed to `CGPDFDictionary::array`"]
    pub fn CGPDFDictionaryGetArray(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFArrayRef,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFDictionary::dictionary`"]
    pub fn CGPDFDictionaryGetDictionary(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFDictionaryRef,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFStream")]
    #[deprecated = "renamed to `CGPDFDictionary::stream`"]
    pub fn CGPDFDictionaryGetStream(
        dict: CGPDFDictionaryRef,
        key: NonNull<c_char>,
        value: *mut CGPDFStreamRef,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFDictionary::apply_function`"]
    pub fn CGPDFDictionaryApplyFunction(
        dict: CGPDFDictionaryRef,
        function: CGPDFDictionaryApplierFunction,
        info: *mut c_void,
    );
}

extern "C-unwind" {
    #[cfg(all(feature = "CGPDFObject", feature = "block2"))]
    #[deprecated = "renamed to `CGPDFDictionary::apply_block`"]
    pub fn CGPDFDictionaryApplyBlock(
        dict: CGPDFDictionaryRef,
        block: CGPDFDictionaryApplierBlock,
        info: *mut c_void,
    );
}
