"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevkitMigration = void 0;
const migration_1 = require("../update-tool/migration");
class DevkitMigration extends migration_1.Migration {
    /** Prints an informative message with context on the current target. */
    printInfo(text) {
        const targetName = this.context.isTestTarget ? 'test' : 'build';
        this.logger.info(`- ${this.context.projectName}@${targetName}: ${text}`);
    }
}
exports.DevkitMigration = DevkitMigration;
//# sourceMappingURL=data:application/json;base64,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