# Installation

This document assumes the developer has a basic understanding of Python
packaging, and how to install and manage Python on the system executing
Molecule.

## Requirements

A recent version of `ansible-core` that is still under support.

Depending on the driver chosen, you may need to install additional OS
packages.

=== "CentOS"

    ``` bash
    $ sudo dnf install -y gcc python3-pip python3-devel openssl-devel python3-libselinux
    ```

=== "Ubuntu"

    ``` bash
    $ sudo apt update
    $ sudo apt install -y python3-pip libssl-dev
    ```

## Pip

[pip] is the only supported installation method.

{{ install_from_adt("molecule") }}

```bash
$ python3 -m pip install molecule ansible-core
```

Keep in mind that on selinux supporting systems, if you install into a
virtual environment, you may face [issue 34340](https://github.com/ansible/ansible/issues/34340) even if
selinux is not enabled or is configured to be permissive.

It is your responsibility to ensure that soft dependencies of Ansible
are available on your controller or host machines.

!!! warning

    It is highly recommended that you install molecule in a [virtual
    environment]. This
    will provide a modern copy of [setuptools] which is mandatory in order
    for molecule to be installed successfully and function correctly. If you
    cannot use a virtual environment then you can attempt a package upgrade
    with the following:

```bash
$ python3 -m pip install --upgrade --user setuptools
```

### Requirements

Depending on the driver chosen, you may need to install additional
Python packages. See the driver's documentation in that case.

### Install

Install Molecule:

```bash
$ python3 -m pip install --user molecule
```

Molecule does not include ansible-lint (nor does the lint extra), but is
easily installed separately:

```bash
$ python3 -m pip install --user molecule ansible-lint
```

Molecule uses the \"delegated\" driver by default. Other drivers can be
installed separately from PyPI, most of them being included in
[molecule-plugins](https://github.com/ansible-community/molecule-plugins)
package. If you would like to use podman as the molecule driver, the
installation command would look like this:

```bash
$ python3 -m pip install --user "molecule-plugins[podman]"
```

!!! warning

    If you upgrade molecule from previous versions, make sure to remove
    previously installed drivers like for instance `molecule-podman` or
    `molecule-vagrant` since those are now available in the `molecule-plugins`
    package.

Installing molecule package also installed its main script `molecule`,
usually in `PATH`. Users should know that molecule can also be called as
a python module, using `python3 -m molecule ...`. This alternative method
has some benefits:

- allows to explicitly control which Python interpreter is used by
  molecule
- allows molecule installation at the user level without even needing to
  have the script in `PATH`.

## Container

`Molecule` is built into a [container image for Ansible Development Tools
(ADT)](https://ansible.readthedocs.io/projects/dev-tools/container/)

Any questions or bugs related to the use of Molecule from within a container
should be addressed by the ADT project.

## Source

Due to the rapid pace of development on this tool, you might want to
install and update a bleeding-edge version of Molecule from Git.
Follow the instructions below to do the initial install and subsequent
updates.

The package distribution that you'll get installed will be
autogenerated and will contain commit hash information, making it
easier to refer to.

### Requirements

=== "CentOS"

    ``` bash
    $ sudo dnf install -y libffi-devel git
    ```

=== "Ubuntu"

    ``` bash
    $ sudo apt install -y libffi-dev git
    ```

```bash title="Install"
$ python3 -m pip install -U git+https://github.com/ansible-community/molecule
```

[pip]: https://pip.pypa.io/en/stable/installation/
[virtual environment]: https://virtualenv.pypa.io/en/latest/user_guide.html
[setuptools]: https://setuptools.pypa.io/en/latest/
