//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by defaulter-gen. DO NOT EDIT.

package v1beta1

import (
	certificatesv1beta1 "k8s.io/api/certificates/v1beta1"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&certificatesv1beta1.CertificateSigningRequest{}, func(obj interface{}) {
		SetObjectDefaults_CertificateSigningRequest(obj.(*certificatesv1beta1.CertificateSigningRequest))
	})
	scheme.AddTypeDefaultingFunc(&certificatesv1beta1.CertificateSigningRequestList{}, func(obj interface{}) {
		SetObjectDefaults_CertificateSigningRequestList(obj.(*certificatesv1beta1.CertificateSigningRequestList))
	})
	scheme.AddTypeDefaultingFunc(&certificatesv1beta1.PodCertificateRequest{}, func(obj interface{}) {
		SetObjectDefaults_PodCertificateRequest(obj.(*certificatesv1beta1.PodCertificateRequest))
	})
	scheme.AddTypeDefaultingFunc(&certificatesv1beta1.PodCertificateRequestList{}, func(obj interface{}) {
		SetObjectDefaults_PodCertificateRequestList(obj.(*certificatesv1beta1.PodCertificateRequestList))
	})
	return nil
}

func SetObjectDefaults_CertificateSigningRequest(in *certificatesv1beta1.CertificateSigningRequest) {
	SetDefaults_CertificateSigningRequestSpec(&in.Spec)
	for i := range in.Status.Conditions {
		a := &in.Status.Conditions[i]
		SetDefaults_CertificateSigningRequestCondition(a)
	}
}

func SetObjectDefaults_CertificateSigningRequestList(in *certificatesv1beta1.CertificateSigningRequestList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_CertificateSigningRequest(a)
	}
}

func SetObjectDefaults_PodCertificateRequest(in *certificatesv1beta1.PodCertificateRequest) {
	if in.Spec.MaxExpirationSeconds == nil {
		var ptrVar1 int32 = 86400
		in.Spec.MaxExpirationSeconds = &ptrVar1
	}
}

func SetObjectDefaults_PodCertificateRequestList(in *certificatesv1beta1.PodCertificateRequestList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_PodCertificateRequest(a)
	}
}
