/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.InstantiationException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;

public class DynaBeanType
extends AbstractType
implements AbstractComponentType {
    private DynaClass clazz;
    private String[] propertyNames;
    private Type[] propertyTypes;
    private int propertySpan;
    private final Cascades.CascadeStyle[] cascade;
    private final int[] joinedFetch;
    static /* synthetic */ Class class$org$apache$commons$beanutils$DynaBean;

    public DynaBeanType(DynaClass clazz, String[] propertyNames, Type[] propertyTypes, int[] joinedFetch, Cascades.CascadeStyle[] cascade) {
        this.clazz = clazz;
        this.propertyNames = propertyNames;
        this.propertyTypes = propertyTypes;
        this.joinedFetch = joinedFetch;
        this.cascade = cascade;
        this.propertySpan = propertyTypes.length;
    }

    public Cascades.CascadeStyle cascade(int i) {
        return this.cascade[i];
    }

    public int enableJoinedFetch(int i) {
        return this.joinedFetch[i];
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i);
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return this.getPropertyValues(component);
    }

    public Object getPropertyValue(Object component, int i) throws HibernateException {
        return ((DynaBean)component).get(this.propertyNames[i]);
    }

    public Object[] getPropertyValues(Object component) throws HibernateException {
        DynaBean bean = (DynaBean)component;
        Object[] result = new Object[this.propertySpan];
        int i = 0;
        while (i < this.propertySpan) {
            result[i] = bean.get(this.propertyNames[i]);
            ++i;
        }
        return result;
    }

    public Type[] getSubtypes() {
        return this.propertyTypes;
    }

    public Object instantiate() throws HibernateException {
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException("Could no instantiate DynaBean: " + this.clazz.getName(), class$org$apache$commons$beanutils$DynaBean == null ? (class$org$apache$commons$beanutils$DynaBean = DynaBeanType.class$("org.apache.commons.beanutils.DynaBean")) : class$org$apache$commons$beanutils$DynaBean, e);
        }
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        DynaBean bean = (DynaBean)component;
        int i = 0;
        while (i < this.propertySpan) {
            bean.set(this.propertyNames[i], values[i]);
            ++i;
        }
    }

    public Object deepCopy(Object component) throws HibernateException {
        if (component == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(component);
        int i = 0;
        while (i < this.propertySpan) {
            values[i] = this.propertyTypes[i].deepCopy(values[i]);
            ++i;
        }
        Object result = this.instantiate();
        this.setPropertyValues(result, values);
        return result;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        DynaBean xbean = (DynaBean)x;
        DynaBean ybean = (DynaBean)y;
        int i = 0;
        while (i < this.propertySpan) {
            if (!this.propertyTypes[i].equals(xbean.get(this.propertyNames[i]), ybean.get(this.propertyNames[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isDirty(Object x, Object y, SessionImplementor session) throws HibernateException {
        if (x == y) {
            return false;
        }
        if (x == null || y == null) {
            return true;
        }
        DynaBean xbean = (DynaBean)x;
        DynaBean ybean = (DynaBean)y;
        int i = 0;
        while (i < this.propertySpan) {
            if (this.propertyTypes[i].isDirty(xbean.get(this.propertyNames[i]), ybean.get(this.propertyNames[i]), session)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        int span = 0;
        int i = 0;
        while (i < this.propertySpan) {
            span += this.propertyTypes[i].getColumnSpan(mapping);
            ++i;
        }
        return span;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public boolean isMutable() {
        return true;
    }

    private Object[] nullSafeGetValues(Object value) throws HibernateException {
        if (value == null) {
            return new Object[this.propertySpan];
        }
        return this.getPropertyValues(value);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        int begin = 0;
        boolean notNull = false;
        Object[] values = new Object[this.propertySpan];
        int i = 0;
        while (i < this.propertySpan) {
            int length = this.propertyTypes[i].getColumnSpan(session.getFactory());
            String[] range = ArrayHelper.slice(names, begin, length);
            Object val = this.propertyTypes[i].nullSafeGet(rs, range, session, owner);
            if (val != null) {
                notNull = true;
            }
            values[i] = val;
            begin += length;
            ++i;
        }
        if (notNull) {
            DynaBean result = (DynaBean)this.instantiate();
            int i2 = 0;
            while (i2 < this.propertySpan) {
                result.set(this.propertyNames[i2], values[i2]);
                ++i2;
            }
            return result;
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int begin, SessionImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value);
        int i = 0;
        while (i < this.propertySpan) {
            this.propertyTypes[i].nullSafeSet(st, subvalues[i], begin, session);
            begin += this.propertyTypes[i].getColumnSpan(session.getFactory());
            ++i;
        }
    }

    public Class getReturnedClass() {
        return class$org$apache$commons$beanutils$DynaBean == null ? (class$org$apache$commons$beanutils$DynaBean = DynaBeanType.class$("org.apache.commons.beanutils.DynaBean")) : class$org$apache$commons$beanutils$DynaBean;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        int[] sqlTypes = new int[this.getColumnSpan(mapping)];
        int n = 0;
        int i = 0;
        while (i < this.propertySpan) {
            int[] subtypes = this.propertyTypes[i].sqlTypes(mapping);
            int j = 0;
            while (j < subtypes.length) {
                sqlTypes[n++] = subtypes[j];
                ++j;
            }
            ++i;
        }
        return sqlTypes;
    }

    public String toXML(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? null : value.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

