import React from "react";
import PropTypes from "prop-types";

function TextareaWidget(props) {
  var id = props.id,
      options = props.options,
      placeholder = props.placeholder,
      value = props.value,
      required = props.required,
      disabled = props.disabled,
      readonly = props.readonly,
      autofocus = props.autofocus,
      onChange = props.onChange,
      onBlur = props.onBlur,
      onFocus = props.onFocus;

  var _onChange = function _onChange(_ref) {
    var value = _ref.target.value;
    return onChange(value === "" ? options.emptyValue : value);
  };

  return React.createElement("textarea", {
    id: id,
    className: "form-control",
    value: value ? value : "",
    placeholder: placeholder,
    required: required,
    disabled: disabled,
    readOnly: readonly,
    autoFocus: autofocus,
    rows: options.rows,
    onBlur: onBlur && function (event) {
      return onBlur(id, event.target.value);
    },
    onFocus: onFocus && function (event) {
      return onFocus(id, event.target.value);
    },
    onChange: _onChange
  });
}

TextareaWidget.defaultProps = {
  autofocus: false,
  options: {}
};

if (process.env.NODE_ENV !== "production") {
  TextareaWidget.propTypes = {
    schema: PropTypes.object.isRequired,
    id: PropTypes.string.isRequired,
    placeholder: PropTypes.string,
    options: PropTypes.shape({
      rows: PropTypes.number
    }),
    value: PropTypes.string,
    required: PropTypes.bool,
    disabled: PropTypes.bool,
    readonly: PropTypes.bool,
    autofocus: PropTypes.bool,
    onChange: PropTypes.func,
    onBlur: PropTypes.func,
    onFocus: PropTypes.func
  };
}

export default TextareaWidget;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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