Example of illegal code:

```ada
procedure P is
   procedure Local with SPARK_Mode => On;
   procedure Local is null;
begin
  Local;
end P;
```

This error is issued on the use of aspect or pragma `SPARK_Mode` with value
`On` on a local subprogram (that is, not defined at so-called library level),
which violates the rules for `SPARK_Mode` placement from [section D of SPARK
User's Guide].  Only the value `Off` is allowed in that case, to exempt a local
subprogram from being analyzed.

The fix is either to move the aspect to the enclosing library-level subprogram:

```ada
procedure P
  with SPARK_Mode => On
is
   procedure Local;
   procedure Local is null;
begin
  Local;
end P;
```

or to make the local subprogram a library-level subprogram:

```ada
procedure Local with SPARK_Mode => On;
procedure Local is null;

procedure P is
begin
  Local;
end P;
```

[section D of SPARK User's Guide]:
https://docs.adacore.com/live/wave/spark2014/html/spark2014_ug/en/appendix/implementation_defined_pragmas.html#pragma-spark-mode
