/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import okio.ByteString;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.whispersystems.signalservice.api.websocket.HealthMonitor;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.crypto.PrimaryProvisioningCipher;
import org.whispersystems.signalservice.internal.push.ProvisionMessage;
import org.whispersystems.signalservice.internal.push.ProvisioningAddress;
import org.whispersystems.signalservice.internal.websocket.OkHttpWebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.WebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

public class ProvisioningSocket {
    private final WebSocketConnection connection;
    private boolean connected = false;

    public ProvisioningSocket(SignalServiceConfiguration signalServiceConfiguration, String userAgent) {
        this.connection = new OkHttpWebSocketConnection("provisioning", signalServiceConfiguration, Optional.empty(), userAgent, new HealthMonitor(){

            @Override
            public void onKeepAliveResponse(long sentTimestamp, boolean isIdentifiedWebSocket) {
            }

            @Override
            public void onMessageError(int status, boolean isIdentifiedWebSocket) {
            }
        }, "provisioning/", false);
    }

    public ProvisioningAddress getProvisioningUuid() throws TimeoutException, IOException {
        if (!this.connected) {
            this.connection.connect();
            this.connected = true;
        }
        ByteString bytes = this.readRequest();
        ProvisioningAddress msg = (ProvisioningAddress)((Object)ProvisioningAddress.ADAPTER.decode(bytes));
        return msg;
    }

    public ProvisionMessage getProvisioningMessage(IdentityKeyPair tempIdentity) throws TimeoutException, IOException {
        if (!this.connected) {
            throw new IllegalStateException("No UUID requested yet!");
        }
        ByteString bytes = this.readRequest();
        this.connection.disconnect();
        this.connected = false;
        try {
            ProvisionMessage msg = new PrimaryProvisioningCipher(null).decrypt(tempIdentity, bytes.toByteArray());
            return msg;
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ByteString readRequest() throws TimeoutException, IOException {
        WebSocketRequestMessage response = this.connection.readRequest(100000L);
        ByteString bytes = response.body;
        return bytes;
    }
}

