/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.util.List;
import org.asamk.signal.manager.config.ServiceConfig;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.util.KeyUtils;
import org.asamk.signal.manager.util.Utils;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.NetworkResultUtil;
import org.whispersystems.signalservice.api.account.PreKeyUpload;
import org.whispersystems.signalservice.api.keys.OneTimePreKeyCounts;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;

public class PreKeyHelper {
    private static final Logger logger = LoggerFactory.getLogger(PreKeyHelper.class);
    private final SignalAccount account;
    private final SignalDependencies dependencies;

    public PreKeyHelper(SignalAccount account, SignalDependencies dependencies) {
        this.account = account;
        this.dependencies = dependencies;
    }

    public void refreshPreKeysIfNecessary() throws IOException {
        this.refreshPreKeysIfNecessary(ServiceIdType.ACI);
        this.refreshPreKeysIfNecessary(ServiceIdType.PNI);
    }

    public void forceRefreshPreKeys() throws IOException {
        this.forceRefreshPreKeys(ServiceIdType.ACI);
        this.forceRefreshPreKeys(ServiceIdType.PNI);
    }

    public void refreshPreKeysIfNecessary(ServiceIdType serviceIdType) throws IOException {
        IdentityKeyPair identityKeyPair = this.account.getIdentityKeyPair(serviceIdType);
        if (identityKeyPair == null) {
            return;
        }
        ServiceId accountId = this.account.getAccountId(serviceIdType);
        if (accountId == null) {
            return;
        }
        if (this.refreshPreKeysIfNecessary(serviceIdType, identityKeyPair)) {
            this.refreshPreKeysIfNecessary(serviceIdType, identityKeyPair);
        }
    }

    public void forceRefreshPreKeys(ServiceIdType serviceIdType) throws IOException {
        IdentityKeyPair identityKeyPair = this.account.getIdentityKeyPair(serviceIdType);
        if (identityKeyPair == null) {
            return;
        }
        ServiceId accountId = this.account.getAccountId(serviceIdType);
        if (accountId == null) {
            return;
        }
        OneTimePreKeyCounts counts = new OneTimePreKeyCounts(0, 0);
        if (this.refreshPreKeysIfNecessary(serviceIdType, identityKeyPair, counts, true)) {
            this.refreshPreKeysIfNecessary(serviceIdType, identityKeyPair, counts, true);
        }
    }

    private boolean refreshPreKeysIfNecessary(ServiceIdType serviceIdType, IdentityKeyPair identityKeyPair) throws IOException {
        OneTimePreKeyCounts preKeyCounts;
        try {
            preKeyCounts = (OneTimePreKeyCounts)Utils.handleResponseException(this.dependencies.getKeysApi().getAvailablePreKeyCounts(serviceIdType));
        }
        catch (AuthorizationFailedException e) {
            logger.debug("Failed to get pre key count, ignoring: " + ((Object)((Object)e)).getClass().getSimpleName());
            preKeyCounts = new OneTimePreKeyCounts(0, 0);
        }
        return this.refreshPreKeysIfNecessary(serviceIdType, identityKeyPair, preKeyCounts, false);
    }

    private boolean refreshPreKeysIfNecessary(ServiceIdType serviceIdType, IdentityKeyPair identityKeyPair, OneTimePreKeyCounts preKeyCounts, boolean force) throws IOException {
        List<PreKeyRecord> preKeyRecords = null;
        if (force || preKeyCounts.getEcCount() < 10) {
            logger.debug("Refreshing {} ec pre keys, because only {} of min {} pre keys remain", new Object[]{serviceIdType, preKeyCounts.getEcCount(), 10});
            preKeyRecords = this.generatePreKeys(serviceIdType);
        }
        SignedPreKeyRecord signedPreKeyRecord = null;
        if (force || this.signedPreKeyNeedsRefresh(serviceIdType)) {
            logger.debug("Refreshing {} signed pre key.", (Object)serviceIdType);
            signedPreKeyRecord = this.generateSignedPreKey(serviceIdType, identityKeyPair);
        }
        List<KyberPreKeyRecord> kyberPreKeyRecords = null;
        if (force || preKeyCounts.getKyberCount() < 10) {
            logger.debug("Refreshing {} kyber pre keys, because only {} of min {} pre keys remain", new Object[]{serviceIdType, preKeyCounts.getKyberCount(), 10});
            kyberPreKeyRecords = this.generateKyberPreKeys(serviceIdType, identityKeyPair);
        }
        KyberPreKeyRecord lastResortKyberPreKeyRecord = null;
        if (force || this.lastResortKyberPreKeyNeedsRefresh(serviceIdType)) {
            logger.debug("Refreshing {} last resort kyber pre key.", (Object)serviceIdType);
            lastResortKyberPreKeyRecord = this.generateLastResortKyberPreKey(serviceIdType, identityKeyPair, kyberPreKeyRecords == null ? 0 : kyberPreKeyRecords.size());
        }
        if (signedPreKeyRecord == null && preKeyRecords == null && lastResortKyberPreKeyRecord == null && kyberPreKeyRecords == null) {
            return false;
        }
        PreKeyUpload preKeyUpload = new PreKeyUpload(serviceIdType, signedPreKeyRecord, preKeyRecords, lastResortKyberPreKeyRecord, (List)kyberPreKeyRecords);
        boolean needsReset = false;
        try {
            NetworkResultUtil.toPreKeysLegacy((NetworkResult)this.dependencies.getKeysApi().setPreKeys(preKeyUpload));
            try {
                if (preKeyRecords != null) {
                    this.account.addPreKeys(serviceIdType, preKeyRecords);
                }
                if (signedPreKeyRecord != null) {
                    this.account.addSignedPreKey(serviceIdType, signedPreKeyRecord);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to store new pre keys, resetting preKey id offset", (Throwable)e);
                this.account.resetPreKeyOffsets(serviceIdType);
                needsReset = true;
            }
            try {
                if (kyberPreKeyRecords != null) {
                    this.account.addKyberPreKeys(serviceIdType, kyberPreKeyRecords);
                }
                if (lastResortKyberPreKeyRecord != null) {
                    this.account.addLastResortKyberPreKey(serviceIdType, lastResortKyberPreKeyRecord);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to store new kyber pre keys, resetting preKey id offset", (Throwable)e);
                this.account.resetKyberPreKeyOffsets(serviceIdType);
                needsReset = true;
            }
        }
        catch (AuthorizationFailedException e) {
            logger.warn("Failed to updated pre keys: {}", (Object)e.getMessage());
        }
        catch (NonSuccessfulResponseCodeException e) {
            if (serviceIdType != ServiceIdType.PNI || e.code != 422) {
                throw e;
            }
            logger.warn("Failed to set PNI pre keys, ignoring for now. Account needs to be reregistered to fix this.");
        }
        return needsReset;
    }

    public void cleanOldPreKeys() {
        this.cleanOldPreKeys(ServiceIdType.ACI);
        this.cleanOldPreKeys(ServiceIdType.PNI);
    }

    private void cleanOldPreKeys(ServiceIdType serviceIdType) {
        this.cleanSignedPreKeys(serviceIdType);
        this.cleanOneTimePreKeys(serviceIdType);
    }

    private List<PreKeyRecord> generatePreKeys(ServiceIdType serviceIdType) {
        SignalAccount.AccountData<? extends ServiceId> accountData = this.account.getAccountData(serviceIdType);
        int offset = accountData.getPreKeyMetadata().getNextPreKeyId();
        return KeyUtils.generatePreKeyRecords(offset);
    }

    private boolean signedPreKeyNeedsRefresh(ServiceIdType serviceIdType) {
        SignalAccount.AccountData<? extends ServiceId> accountData = this.account.getAccountData(serviceIdType);
        int activeSignedPreKeyId = accountData.getPreKeyMetadata().getActiveSignedPreKeyId();
        if (activeSignedPreKeyId == -1) {
            return true;
        }
        try {
            SignedPreKeyRecord signedPreKeyRecord = accountData.getSignedPreKeyStore().loadSignedPreKey(activeSignedPreKeyId);
            return signedPreKeyRecord.getTimestamp() < System.currentTimeMillis() - ServiceConfig.SIGNED_PREKEY_ROTATE_AGE;
        }
        catch (InvalidKeyIdException e) {
            return true;
        }
    }

    private SignedPreKeyRecord generateSignedPreKey(ServiceIdType serviceIdType, IdentityKeyPair identityKeyPair) {
        SignalAccount.AccountData<? extends ServiceId> accountData = this.account.getAccountData(serviceIdType);
        int signedPreKeyId = accountData.getPreKeyMetadata().getNextSignedPreKeyId();
        return KeyUtils.generateSignedPreKeyRecord(signedPreKeyId, identityKeyPair.getPrivateKey());
    }

    private List<KyberPreKeyRecord> generateKyberPreKeys(ServiceIdType serviceIdType, IdentityKeyPair identityKeyPair) {
        SignalAccount.AccountData<? extends ServiceId> accountData = this.account.getAccountData(serviceIdType);
        int offset = accountData.getPreKeyMetadata().getNextKyberPreKeyId();
        return KeyUtils.generateKyberPreKeyRecords(offset, identityKeyPair.getPrivateKey());
    }

    private boolean lastResortKyberPreKeyNeedsRefresh(ServiceIdType serviceIdType) {
        SignalAccount.AccountData<? extends ServiceId> accountData = this.account.getAccountData(serviceIdType);
        int activeLastResortKyberPreKeyId = accountData.getPreKeyMetadata().getActiveLastResortKyberPreKeyId();
        if (activeLastResortKyberPreKeyId == -1) {
            return true;
        }
        try {
            KyberPreKeyRecord kyberPreKeyRecord = accountData.getKyberPreKeyStore().loadKyberPreKey(activeLastResortKyberPreKeyId);
            return kyberPreKeyRecord.getTimestamp() < System.currentTimeMillis() - ServiceConfig.SIGNED_PREKEY_ROTATE_AGE;
        }
        catch (InvalidKeyIdException e) {
            return true;
        }
    }

    private KyberPreKeyRecord generateLastResortKyberPreKey(ServiceIdType serviceIdType, IdentityKeyPair identityKeyPair, int offset) {
        SignalAccount.AccountData<? extends ServiceId> accountData = this.account.getAccountData(serviceIdType);
        int signedPreKeyId = accountData.getPreKeyMetadata().getNextKyberPreKeyId() + offset;
        return KeyUtils.generateKyberPreKeyRecord(signedPreKeyId, identityKeyPair.getPrivateKey());
    }

    private void cleanSignedPreKeys(ServiceIdType serviceIdType) {
        SignalAccount.AccountData<? extends ServiceId> accountData = this.account.getAccountData(serviceIdType);
        int activeSignedPreKeyId = accountData.getPreKeyMetadata().getActiveSignedPreKeyId();
        accountData.getSignedPreKeyStore().removeOldSignedPreKeys(activeSignedPreKeyId);
        int activeLastResortKyberPreKeyId = accountData.getPreKeyMetadata().getActiveLastResortKyberPreKeyId();
        accountData.getKyberPreKeyStore().removeOldLastResortKyberPreKeys(activeLastResortKyberPreKeyId);
    }

    private void cleanOneTimePreKeys(ServiceIdType serviceIdType) {
        long threshold = System.currentTimeMillis() - ServiceConfig.PREKEY_STALE_AGE;
        int minCount = 200;
        SignalAccount.AccountData<? extends ServiceId> accountData = this.account.getAccountData(serviceIdType);
        accountData.getPreKeyStore().deleteAllStaleOneTimeEcPreKeys(threshold, minCount);
        accountData.getKyberPreKeyStore().deleteAllStaleOneTimeKyberPreKeys(threshold, minCount);
    }
}

