---
title: pixi import
---
<!--- This file is autogenerated. Do not edit manually! -->
# [pixi](../pixi.md) import

Imports a file into an environment in an existing workspace.

--8<-- "docs/reference/cli/pixi/import_extender:description"

## Usage
```
pixi import [OPTIONS] <FILE>
```

## Arguments
- <a id="arg-<FILE>" href="#arg-<FILE>">`<FILE>`</a>
:  File to import into the workspace
<br>**required**: `true`

## Options
- <a id="arg---format" href="#arg---format">`--format <FORMAT>`</a>
:  Which format to interpret the file as
<br>**options**: `conda-env`, `pypi-txt`
- <a id="arg---platform" href="#arg---platform">`--platform (-p) <PLATFORM>`</a>
:  The platforms for the imported environment
<br>May be provided more than once.
- <a id="arg---environment" href="#arg---environment">`--environment (-e) <ENVIRONMENT>`</a>
:  A name for the created environment
- <a id="arg---feature" href="#arg---feature">`--feature (-f) <FEATURE>`</a>
:  A name for the created feature

## Config Options
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---pinning-strategy" href="#arg---pinning-strategy">`--pinning-strategy <PINNING_STRATEGY>`</a>
:  Set pinning strategy
<br>**options**: `semver`, `minor`, `major`, `latest-up`, `exact-version`, `no-pin`
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---run-post-link-scripts" href="#arg---run-post-link-scripts">`--run-post-link-scripts`</a>
:  Run post-link scripts (insecure)
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---tls-root-certs" href="#arg---tls-root-certs">`--tls-root-certs <TLS_ROOT_CERTS>`</a>
:  Which TLS root certificates to use: 'webpki' (bundled Mozilla roots), 'native' (system store), or 'all' (both)
<br>**env**: `PIXI_TLS_ROOT_CERTS`
- <a id="arg---use-environment-activation-cache" href="#arg---use-environment-activation-cache">`--use-environment-activation-cache`</a>
:  Use environment activation cache (experimental)

## Global Options
- <a id="arg---manifest-path" href="#arg---manifest-path">`--manifest-path (-m) <MANIFEST_PATH>`</a>
:  The path to `pixi.toml`, `pyproject.toml`, or the workspace directory

## Description
Imports a file into an environment in an existing workspace.

If `--format` isn't provided, `import` will try each format in turn


--8<-- "docs/reference/cli/pixi/import_extender:example"
