/*
 * Decompiled with CFR 0.152.
 */
package io.spring.githubchangeloggenerator.github.service;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="github")
@ConstructorBinding
public class GitHubProperties {
    private final String apiUrl;
    private final String username;
    private final String password;

    public GitHubProperties(@DefaultValue(value={"https://api.github.com"}) String apiUrl, String username, String password, String token) {
        this.apiUrl = apiUrl;
        this.username = username;
        this.password = StringUtils.hasText((String)token) ? token : password;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

