/*
 * Decompiled with CFR 0.152.
 */
package io.spring.githubchangeloggenerator.github.service;

import io.spring.githubchangeloggenerator.github.payload.Issue;
import io.spring.githubchangeloggenerator.github.payload.Milestone;
import io.spring.githubchangeloggenerator.github.service.GitHubProperties;
import io.spring.githubchangeloggenerator.github.service.Page;
import io.spring.githubchangeloggenerator.github.service.Repository;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class GitHubService {
    private static final Pattern LINK_PATTERN = Pattern.compile("<(.+)>; rel=\"(.+)\"");
    private static final String MILESTONES_URI = "/repos/{owner}/{name}/milestones?state=all&sort=due_on&direction=desc&per_page=50";
    private static final String ISSUES_URI = "/repos/{owner}/{name}/issues?milestone={milestone}&state=closed";
    private static final String ISSUE_URI = "/repos/{owner}/{name}/issues/{issueNumber}";
    private final RestTemplate restTemplate;

    public GitHubService(RestTemplateBuilder builder, GitHubProperties properties) {
        String username = properties.getUsername();
        String password = properties.getPassword();
        if (StringUtils.hasLength((String)username)) {
            builder = builder.basicAuthentication(username, password);
        }
        builder = builder.rootUri(properties.getApiUrl());
        this.restTemplate = builder.build();
    }

    public int getMilestoneNumber(String milestoneTitle, Repository repository) {
        Assert.hasText((String)milestoneTitle, (String)"MilestoneName must not be empty");
        List milestones = this.getAll(Milestone.class, MILESTONES_URI, new Object[]{repository.getOwner(), repository.getName()});
        for (Milestone milestone : milestones) {
            if (!milestoneTitle.equalsIgnoreCase(milestone.getTitle())) continue;
            return milestone.getNumber();
        }
        throw new IllegalStateException("Unable to find milestone with title '" + milestoneTitle + "'");
    }

    public Issue getIssue(String issueNumber, Repository repository) {
        try {
            return (Issue)this.restTemplate.getForObject(ISSUE_URI, Issue.class, new Object[]{repository.getOwner(), repository.getName(), issueNumber});
        }
        catch (RestClientException clientException) {
            return null;
        }
    }

    public List<Issue> getIssuesForMilestone(int milestoneNumber, Repository repository) {
        return this.getAll(Issue.class, ISSUES_URI, new Object[]{repository.getOwner(), repository.getName(), milestoneNumber});
    }

    private <T> List<T> getAll(Class<T> type, String url, Object ... uriVariables) {
        ArrayList all = new ArrayList();
        for (Page page = this.getPage(type, url, uriVariables); page != null; page = page.getNextPage()) {
            all.addAll(page.getContent());
        }
        return all;
    }

    private <T> Page<T> getPage(Class<T> type, String url, Object ... uriVariables) {
        if (!StringUtils.hasText((String)url)) {
            return null;
        }
        ResponseEntity response = this.restTemplate.getForEntity(url, this.arrayType(type), uriVariables);
        return new Page(Arrays.asList((Object[])response.getBody()), () -> this.getPage(type, this.getNextUrl(response.getHeaders()), new Object[0]));
    }

    private <T> Class<T[]> arrayType(Class<T> elementType) {
        return Array.newInstance(elementType, 0).getClass();
    }

    private String getNextUrl(HttpHeaders headers) {
        String links = headers.getFirst("Link");
        for (String link : StringUtils.commaDelimitedListToStringArray((String)links)) {
            Matcher matcher = LINK_PATTERN.matcher(link.trim());
            if (!matcher.matches() || !"next".equals(matcher.group(2))) continue;
            return matcher.group(1);
        }
        return null;
    }
}

