/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.utils.jars;

import io.bazel.kotlin.builder.utils.jars.JarHelper;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lio/bazel/kotlin/builder/utils/jars/JarOwner;", "", "jar", "Ljava/nio/file/Path;", "label", "", "aspect", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)V", "getAspect", "()Ljava/lang/String;", "getJar", "()Ljava/nio/file/Path;", "getLabel", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
public final class JarOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path jar;
    @Nullable
    private final String label;
    @Nullable
    private final String aspect;

    public JarOwner(@NotNull Path jar, @Nullable String label, @Nullable String aspect) {
        Intrinsics.checkNotNullParameter(jar, "jar");
        this.jar = jar;
        this.label = label;
        this.aspect = aspect;
    }

    public /* synthetic */ JarOwner(Path path, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(path, string, string2);
    }

    @NotNull
    public final Path getJar() {
        return this.jar;
    }

    @Nullable
    public final String getLabel() {
        return this.label;
    }

    @Nullable
    public final String getAspect() {
        return this.aspect;
    }

    @NotNull
    public final Path component1() {
        return this.jar;
    }

    @Nullable
    public final String component2() {
        return this.label;
    }

    @Nullable
    public final String component3() {
        return this.aspect;
    }

    @NotNull
    public final JarOwner copy(@NotNull Path jar, @Nullable String label, @Nullable String aspect) {
        Intrinsics.checkNotNullParameter(jar, "jar");
        return new JarOwner(jar, label, aspect);
    }

    public static /* synthetic */ JarOwner copy$default(JarOwner jarOwner, Path path, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            path = jarOwner.jar;
        }
        if ((n & 2) != 0) {
            string = jarOwner.label;
        }
        if ((n & 4) != 0) {
            string2 = jarOwner.aspect;
        }
        return jarOwner.copy(path, string, string2);
    }

    @NotNull
    public String toString() {
        return "JarOwner(jar=" + this.jar + ", label=" + this.label + ", aspect=" + this.aspect + ')';
    }

    public int hashCode() {
        int result = ((Object)this.jar).hashCode();
        result = result * 31 + (this.label == null ? 0 : this.label.hashCode());
        result = result * 31 + (this.aspect == null ? 0 : this.aspect.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JarOwner)) {
            return false;
        }
        JarOwner jarOwner = (JarOwner)other;
        if (!Intrinsics.areEqual(this.jar, jarOwner.jar)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.label, jarOwner.label)) {
            return false;
        }
        return Intrinsics.areEqual(this.aspect, jarOwner.aspect);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/bazel/kotlin/builder/utils/jars/JarOwner$Companion;", "", "()V", "readJarOwnerFromManifest", "Lio/bazel/kotlin/builder/utils/jars/JarOwner;", "jarPath", "Ljava/nio/file/Path;", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final JarOwner readJarOwnerFromManifest(@NotNull Path jarPath) {
            Intrinsics.checkNotNullParameter(jarPath, "jarPath");
            try {
                Closeable closeable = new JarFile(jarPath.toFile());
                Throwable throwable = null;
                try {
                    String string;
                    Manifest manifest;
                    JarFile jarFile = (JarFile)closeable;
                    boolean bl = false;
                    Manifest manifest2 = jarFile.getManifest();
                    if (manifest2 == null) {
                        JarOwner jarOwner = new JarOwner(jarPath, null, null, 6, null);
                        return jarOwner;
                    }
                    Intrinsics.checkNotNullExpressionValue(manifest, "jarFile.manifest ?: return JarOwner(jarPath)");
                    Manifest manifest3 = manifest2;
                    Attributes attributes = manifest3.getMainAttributes();
                    if ((String)attributes.get(JarHelper.Companion.getTARGET_LABEL()) == null) {
                        JarOwner jarOwner = new JarOwner(jarPath, null, null, 6, null);
                        return jarOwner;
                    }
                    String label = string;
                    String injectingRuleKind = (String)attributes.get(JarHelper.Companion.getINJECTING_RULE_KIND());
                    JarOwner jarOwner = new JarOwner(jarPath, label, injectingRuleKind);
                    return jarOwner;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

