import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _typeof from "@babel/runtime/helpers/typeof";
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
import { css as cssEmotion } from '@emotion/react';
import { allSpaceMap, backgroundColorMap, borderColorMap, borderRadiusMap, borderWidthMap, dimensionMap, fontFamilyMap, fontMap, fontWeightMap, layerMap, opacityMap, positiveSpaceMap, shadowMap, textColorMap } from './style-maps.partial';
export var tokensMap = {
  backgroundColor: backgroundColorMap,
  blockSize: dimensionMap,
  borderBlockColor: borderColorMap,
  borderBlockEndColor: borderColorMap,
  borderBlockEndWidth: borderWidthMap,
  borderBlockStartColor: borderColorMap,
  borderBlockStartWidth: borderWidthMap,
  borderBlockWidth: borderWidthMap,
  borderBottomColor: borderColorMap,
  borderBottomLeftRadius: borderRadiusMap,
  borderBottomRightRadius: borderRadiusMap,
  borderBottomWidth: borderWidthMap,
  borderColor: borderColorMap,
  borderEndEndRadius: borderRadiusMap,
  borderEndStartRadius: borderRadiusMap,
  borderInlineColor: borderColorMap,
  borderInlineEndColor: borderColorMap,
  borderInlineEndWidth: borderWidthMap,
  borderInlineStartColor: borderColorMap,
  borderInlineStartWidth: borderWidthMap,
  borderInlineWidth: borderWidthMap,
  borderLeftColor: borderColorMap,
  borderLeftWidth: borderWidthMap,
  borderRadius: borderRadiusMap,
  borderRightColor: borderColorMap,
  borderRightWidth: borderWidthMap,
  borderStartEndRadius: borderRadiusMap,
  borderStartStartRadius: borderRadiusMap,
  borderTopColor: borderColorMap,
  borderTopLeftRadius: borderRadiusMap,
  borderTopRightRadius: borderRadiusMap,
  borderTopWidth: borderWidthMap,
  borderWidth: borderWidthMap,
  bottom: allSpaceMap,
  boxShadow: shadowMap,
  color: textColorMap,
  columnGap: positiveSpaceMap,
  font: fontMap,
  fontFamily: fontFamilyMap,
  fontWeight: fontWeightMap,
  gap: positiveSpaceMap,
  height: dimensionMap,
  inlineSize: dimensionMap,
  inset: allSpaceMap,
  insetBlock: allSpaceMap,
  insetBlockEnd: allSpaceMap,
  insetBlockStart: allSpaceMap,
  insetInline: allSpaceMap,
  insetInlineEnd: allSpaceMap,
  insetInlineStart: allSpaceMap,
  left: allSpaceMap,
  margin: allSpaceMap,
  marginBlock: allSpaceMap,
  marginBlockEnd: allSpaceMap,
  marginBlockStart: allSpaceMap,
  marginBottom: allSpaceMap,
  marginInline: allSpaceMap,
  marginInlineEnd: allSpaceMap,
  marginInlineStart: allSpaceMap,
  marginLeft: allSpaceMap,
  marginRight: allSpaceMap,
  marginTop: allSpaceMap,
  maxBlockSize: dimensionMap,
  maxHeight: dimensionMap,
  maxInlineSize: dimensionMap,
  maxWidth: dimensionMap,
  minBlockSize: dimensionMap,
  minHeight: dimensionMap,
  minInlineSize: dimensionMap,
  minWidth: dimensionMap,
  opacity: opacityMap,
  outlineColor: borderColorMap,
  outlineOffset: allSpaceMap,
  outlineWidth: borderWidthMap,
  padding: positiveSpaceMap,
  paddingBlock: positiveSpaceMap,
  paddingBlockEnd: positiveSpaceMap,
  paddingBlockStart: positiveSpaceMap,
  paddingBottom: positiveSpaceMap,
  paddingInline: positiveSpaceMap,
  paddingInlineEnd: positiveSpaceMap,
  paddingInlineStart: positiveSpaceMap,
  paddingLeft: positiveSpaceMap,
  paddingRight: positiveSpaceMap,
  paddingTop: positiveSpaceMap,
  right: allSpaceMap,
  rowGap: positiveSpaceMap,
  top: allSpaceMap,
  width: dimensionMap,
  zIndex: layerMap
};
var uniqueSymbol = Symbol('UNSAFE_INTERNAL_styles');
var isSafeEnvToThrow = function isSafeEnvToThrow() {
  return (typeof process === "undefined" ? "undefined" : _typeof(process)) === 'object' && _typeof(process.env) === 'object' && process.env.NODE_ENV !== 'production';
};
var reNestedSelectors = /(\.|\s|&+|\*\>|#|\[.*\])/;
var safeSelectors = /^@media .*$|^::?.*$|^@supports .*$/;
var _transformStyles = function transformStyles(styleObj) {
  if (!styleObj || _typeof(styleObj) !== 'object') {
    return styleObj;
  }

  // If styles are defined as a CSSObject[], recursively call on each element until we reach CSSObject
  if (Array.isArray(styleObj)) {
    return styleObj.map(_transformStyles);
  }

  // Modifies styleObj in place. Be careful.
  Object.entries(styleObj).forEach(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
      key = _ref2[0],
      value = _ref2[1];
    // If key is a pseudo class or a pseudo element, then value should be an object.
    // So, call transformStyles on the value
    if (_typeof(value) === 'object' && safeSelectors.test(key)) {
      styleObj[key] = _transformStyles(value);
      return;
    }
    if (isSafeEnvToThrow()) {
      // We don't support `.class`, `[data-testid]`, `> *`, `#some-id`
      if (reNestedSelectors.test(key)) {
        throw new Error("Styles not supported for key '".concat(key, "'."));
      }
    }

    // We have now dealt with all the special cases, so,
    // check whether what remains is a style property
    // that can be transformed.
    if (!(key in tokensMap)) {
      return;
    }
    var tokenValue = tokensMap[key][value];
    styleObj[key] = tokenValue !== null && tokenValue !== void 0 ? tokenValue : value;
  });
  return styleObj;
};
var baseXcss = function baseXcss(style) {
  var transformedStyles = _transformStyles(style);
  return _defineProperty({}, uniqueSymbol, cssEmotion(transformedStyles));
};

/**
 * Picks out runtime XCSS objects and build-time XCSS strings. This is needed
 * to supported both Emotion and Compiled styles until we've fully migrated
 * to Compiled.
 *
 * @private
 * @deprecated
 */
var _parseXcss = function parseXcss(args) {
  if (Array.isArray(args)) {
    var emotion = [];
    var staticArr = [];
    var _iterator = _createForOfIteratorHelper(args),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var arg = _step.value;
        var result = _parseXcss(arg);
        if (result.emotion) {
          emotion.push.apply(emotion, _toConsumableArray(result.emotion));
        }
        if (result.static) {
          staticArr.push(result.static);
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    return {
      emotion: emotion,
      static: staticArr.join(' ')
    };
  }
  var objArgs = args;
  var _ref4 = objArgs || {},
    styles = _ref4[uniqueSymbol];
  if (styles) {
    return {
      emotion: [styles]
    };
  }
  if (args) {
    // We use string interpolation here instead of .toString() just
    // in case the resulting object doesn't have the method available.
    var stringifiedArgs = "".concat(args);
    if (stringifiedArgs) {
      return {
        static: stringifiedArgs
      };
    }
  }
  return {};
};
export { _parseXcss as parseXcss }; // Media queries should not contain nested media queries
// Allow only a specific subset of chained selectors to maintain workable TypeScript performance
// Pseudos should not contain nested pseudos, or media queries
/**
 * ### xcss
 *
 * `xcss` is a safer, tokens-first approach to CSS-in-JS. It allows token-backed values for
 * CSS application.
 *
 * ```tsx
 * const styles = xcss({
 *   padding: 'space.100'
 * })
 * ```
 */
export function xcss(style) {
  return baseXcss(style);
}