import React from 'react';
import { analyzeCssInDev } from './dev-warnings';
import { isServerEnvironment } from './is-server-environment';
import insertRule, { getStyleBucketName, styleBucketOrdering } from './sheet';
import { useCache } from './style-cache';
export default function Style(props) {
    const inserted = useCache();
    if (process.env.NODE_ENV === 'development') {
        props.children.forEach(analyzeCssInDev);
    }
    if (props.children.length) {
        if (false) {
            const bucketedSheets = {};
            let hasSheets = false;
            for (let i = 0; i < props.children.length; i++) {
                const sheet = props.children[i];
                if (inserted[sheet]) {
                    continue;
                }
                else {
                    inserted[sheet] = true;
                    hasSheets = true;
                }
                const bucketName = getStyleBucketName(sheet);
                bucketedSheets[bucketName] = (bucketedSheets[bucketName] || '') + sheet;
            }
            if (!hasSheets) {
                return null;
            }
            return (React.createElement("style", { "data-cmpld": true, nonce: props.nonce, dangerouslySetInnerHTML: {
                    __html: styleBucketOrdering.map((bucket) => bucketedSheets[bucket]).join(''),
                } }));
        }
        else {
            for (let i = 0; i < props.children.length; i++) {
                const sheet = props.children[i];
                if (inserted[sheet]) {
                    continue;
                }
                inserted[sheet] = true;
                insertRule(sheet, props);
            }
        }
    }
    return null;
}
//# sourceMappingURL=style.js.map