/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Vector;

public class Book
implements Pageable {
    private Vector mPages = new Vector();

    @Override
    public int getNumberOfPages() {
        return this.mPages.size();
    }

    @Override
    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.getPage(n).getPageFormat();
    }

    @Override
    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this.getPage(n).getPrintable();
    }

    public void setPage(int n, Printable printable, PageFormat pageFormat) throws IndexOutOfBoundsException {
        if (printable == null) {
            throw new NullPointerException("painter is null");
        }
        if (pageFormat == null) {
            throw new NullPointerException("page is null");
        }
        this.mPages.setElementAt(new BookPage(printable, pageFormat), n);
    }

    public void append(Printable printable, PageFormat pageFormat) {
        this.mPages.addElement(new BookPage(printable, pageFormat));
    }

    public void append(Printable printable, PageFormat pageFormat, int n) {
        BookPage bookPage = new BookPage(printable, pageFormat);
        int n2 = this.mPages.size();
        int n3 = n2 + n;
        this.mPages.setSize(n3);
        for (int i = n2; i < n3; ++i) {
            this.mPages.setElementAt(bookPage, i);
        }
    }

    private BookPage getPage(int n) throws ArrayIndexOutOfBoundsException {
        return (BookPage)this.mPages.elementAt(n);
    }

    private class BookPage {
        private PageFormat mFormat;
        private Printable mPainter;

        BookPage(Printable printable, PageFormat pageFormat) {
            if (printable == null || pageFormat == null) {
                throw new NullPointerException();
            }
            this.mFormat = pageFormat;
            this.mPainter = printable;
        }

        Printable getPrintable() {
            return this.mPainter;
        }

        PageFormat getPageFormat() {
            return this.mFormat;
        }
    }
}

