#!/bin/sh
set -e
set -x

#install dependencies
xbps-install -Suy python3
./contrib/ci/fwupd_setup_helpers.py install-dependencies --yes -o void

#clone test firmware if necessary
. ./contrib/ci/get_test_firmware.sh

# regenerate the example plugin
./contrib/create-plugin.py \
 --vendor Vendor \
 --example Example \
 --parent Usb \
 --author "Author" \
 --email "autogenerated@localhost"

#build
rm -rf build
meson build \
 -Dconsolekit=disabled \
 -Dsystemd=disabled \
 -Dplugin_vendor_example=true \
 -Delogind=enabled
ninja -C build test -v
