/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class BranchTargetFinder
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    public static final int UNKNOWN = -1;
    public static final int NO_SUBROUTINE = -2;
    private static final short INSTRUCTION = 1;
    private static final short CREATION = 2;
    private static final short INITIALIZER = 4;
    private static final short BRANCH_ORIGIN = 8;
    private static final short BRANCH_TARGET = 16;
    private static final short AFTER_BRANCH = 32;
    private static final short EXCEPTION_START = 64;
    private static final short EXCEPTION_END = 128;
    private static final short EXCEPTION_HANDLER = 256;
    private static final short SUBROUTINE_INVOCATION = 512;
    private static final short SUBROUTINE_RETURNING = 1024;
    private short[] instructionMarks = new short[8097];
    private int[] subroutineStarts = new int[8096];
    private int[] subroutineEnds = new int[8096];
    private boolean containsSubroutines;
    private boolean repeat;
    private int currentSubroutineStart;
    private boolean isInitializer;

    public boolean isInstruction(int offset) {
        return (this.instructionMarks[offset] & 1) != 0;
    }

    public boolean isCreation(int offset) {
        return (this.instructionMarks[offset] & 2) != 0;
    }

    public boolean isInitializer(int offset) {
        return (this.instructionMarks[offset] & 4) != 0;
    }

    public boolean isTarget(int offset) {
        return offset == 0 || (this.instructionMarks[offset] & 0x1D0) != 0;
    }

    public boolean isBranchOrigin(int offset) {
        return (this.instructionMarks[offset] & 8) != 0;
    }

    public boolean isBranchTarget(int offset) {
        return (this.instructionMarks[offset] & 0x10) != 0;
    }

    public boolean isAfterBranch(int offset) {
        return (this.instructionMarks[offset] & 0x20) != 0;
    }

    public boolean isExceptionStart(int offset) {
        return (this.instructionMarks[offset] & 0x40) != 0;
    }

    public boolean isExceptionEnd(int offset) {
        return (this.instructionMarks[offset] & 0x80) != 0;
    }

    public boolean isExceptionHandler(int offset) {
        return (this.instructionMarks[offset] & 0x100) != 0;
    }

    public boolean isSubroutineInvocation(int offset) {
        return (this.instructionMarks[offset] & 0x200) != 0;
    }

    public boolean isSubroutineStart(int offset) {
        return this.subroutineStarts[offset] == offset;
    }

    public boolean isSubroutine(int offset) {
        return this.subroutineStarts[offset] >= 0;
    }

    public boolean isSubroutineReturning(int offset) {
        return (this.instructionMarks[offset] & 0x400) != 0;
    }

    public int subroutineStart(int offset) {
        return this.subroutineStarts[offset];
    }

    public int subroutineEnd(int offset) {
        return this.subroutineEnds[offset];
    }

    public boolean containsSubroutines() {
        return this.containsSubroutines;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        if (this.subroutineStarts.length < codeLength) {
            this.instructionMarks = new short[codeLength + 1];
            this.subroutineStarts = new int[codeLength];
            this.subroutineEnds = new int[codeLength];
            Arrays.fill(this.subroutineStarts, 0, codeLength, -1);
            Arrays.fill(this.subroutineEnds, 0, codeLength, -1);
        } else {
            Arrays.fill(this.instructionMarks, 0, codeLength, (short)0);
            Arrays.fill(this.subroutineStarts, 0, codeLength, -1);
            Arrays.fill(this.subroutineEnds, 0, codeLength, -1);
            this.instructionMarks[codeLength] = 0;
        }
        this.containsSubroutines = false;
        do {
            this.repeat = false;
            this.currentSubroutineStart = -2;
            codeAttribute.instructionsAccept(clazz, method, this);
            codeAttribute.exceptionsAccept(clazz, method, this);
        } while (this.repeat);
        this.instructionMarks[codeLength] = 16;
        if (this.containsSubroutines) {
            int subroutineStart;
            int offset;
            int previousSubroutineStart = -2;
            for (offset = 0; offset < codeLength; ++offset) {
                if (!this.isInstruction(offset)) continue;
                subroutineStart = this.subroutineStarts[offset];
                if (subroutineStart >= 0 && this.isSubroutineReturning(offset)) {
                    int n = subroutineStart;
                    this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x400);
                }
                if (previousSubroutineStart >= 0) {
                    this.subroutineEnds[previousSubroutineStart] = offset;
                }
                previousSubroutineStart = subroutineStart;
            }
            if (previousSubroutineStart >= 0) {
                this.subroutineEnds[previousSubroutineStart] = codeLength;
            }
            for (offset = 0; offset < codeLength; ++offset) {
                if (!this.isSubroutine(offset)) continue;
                subroutineStart = this.subroutineStarts[offset];
                if (this.isSubroutineReturning(subroutineStart)) {
                    int n = offset;
                    this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x400);
                }
                this.subroutineEnds[offset] = this.subroutineEnds[subroutineStart];
            }
        }
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 1);
        this.checkSubroutine(offset);
        byte opcode = simpleInstruction.opcode;
        if (opcode == -84 || opcode == -83 || opcode == -82 || opcode == -81 || opcode == -80 || opcode == -79 || opcode == -65) {
            this.markBranchOrigin(offset);
            this.markAfterBranchOrigin(offset + simpleInstruction.length(offset));
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 1);
        this.checkSubroutine(offset);
        byte opcode = constantInstruction.opcode;
        if (opcode == -69) {
            int n2 = offset;
            this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 2);
        } else if (opcode == -73) {
            this.isInitializer = false;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            if (this.isInitializer) {
                int n3 = offset;
                this.instructionMarks[n3] = (short)(this.instructionMarks[n3] | 4);
            }
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 1);
        this.checkSubroutine(offset);
        if (variableInstruction.opcode == -87) {
            this.containsSubroutines = true;
            this.markBranchOrigin(offset);
            int n2 = offset;
            this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 0x400);
            this.markAfterBranchOrigin(offset + variableInstruction.length(offset));
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        int branchOffset = branchInstruction.branchOffset;
        int targetOffset = offset + branchOffset;
        this.markBranchOrigin(offset);
        this.checkSubroutine(offset);
        this.markBranchTarget(offset, branchOffset);
        byte opcode = branchInstruction.opcode;
        if (opcode == -88 || opcode == -55) {
            this.containsSubroutines = true;
            int n = offset;
            this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x200);
            this.markBranchSubroutineStart(offset, branchOffset, targetOffset);
        } else if (this.currentSubroutineStart != -1) {
            this.markBranchSubroutineStart(offset, branchOffset, this.currentSubroutineStart);
        }
        if (opcode == -89 || opcode == -56) {
            this.markAfterBranchOrigin(offset + branchInstruction.length(offset));
        }
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        this.markBranchOrigin(offset);
        this.checkSubroutine(offset);
        this.markBranch(offset, switchInstruction.defaultOffset);
        this.markBranches(offset, switchInstruction.jumpOffsets);
        this.markAfterBranchOrigin(offset + switchInstruction.length(offset));
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.isInitializer = methodrefConstant.getName(clazz).equals("<init>");
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int startPC = exceptionInfo.u2startPC;
        int endPC = exceptionInfo.u2endPC;
        int handlerPC = exceptionInfo.u2handlerPC;
        int n = startPC;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x40);
        int n2 = endPC;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 0x80);
        int n3 = handlerPC;
        this.instructionMarks[n3] = (short)(this.instructionMarks[n3] | 0x100);
        if (this.subroutineStarts[handlerPC] == -1 && this.subroutineStarts[startPC] != -1) {
            this.subroutineStarts[handlerPC] = this.subroutineStarts[startPC];
            this.repeat = true;
        }
    }

    private void markBranches(int offset, int[] jumpOffsets) {
        for (int index = 0; index < jumpOffsets.length; ++index) {
            this.markBranch(offset, jumpOffsets[index]);
        }
    }

    private void markBranch(int offset, int jumpOffset) {
        this.markBranchTarget(offset, jumpOffset);
        if (this.currentSubroutineStart != -1) {
            this.markBranchSubroutineStart(offset, jumpOffset, this.currentSubroutineStart);
        }
    }

    private void markBranchOrigin(int offset) {
        int n = offset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 9);
    }

    private void markBranchTarget(int offset, int jumpOffset) {
        int targetOffset;
        int n = targetOffset = offset + jumpOffset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x10);
    }

    private void markBranchSubroutineStart(int offset, int jumpOffset, int subroutineStart) {
        int targetOffset = offset + jumpOffset;
        if (this.subroutineStarts[targetOffset] == -1) {
            if (jumpOffset < 0) {
                if (subroutineStart > targetOffset) {
                    subroutineStart = targetOffset;
                }
                this.repeat = true;
            }
            this.subroutineStarts[targetOffset] = subroutineStart;
        }
    }

    private void markAfterBranchOrigin(int nextOffset) {
        int n = nextOffset;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x20);
        this.currentSubroutineStart = -1;
    }

    private void checkSubroutine(int offset) {
        if (this.subroutineStarts[offset] != -1) {
            this.currentSubroutineStart = this.subroutineStarts[offset];
        } else if (this.currentSubroutineStart != -1) {
            this.subroutineStarts[offset] = this.currentSubroutineStart;
        }
    }
}

