/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.ZipOutput;
import proguard.util.StringMatcher;

public class ZipWriter
implements DataEntryWriter {
    private final StringMatcher uncompressedFilter;
    private final int uncompressedAlignment;
    private final boolean useZip64;
    private final StringMatcher extraUncompressedAlignmentFilter;
    private final int extraUncompressedAlignment;
    private final int modificationTime;
    private final byte[] header;
    private final DataEntryWriter dataEntryWriter;
    private DataEntry currentParentEntry;
    public ZipOutput currentZipOutput;

    public ZipWriter(DataEntryWriter dataEntryWriter) {
        this(null, 1, false, 0, dataEntryWriter);
    }

    public ZipWriter(StringMatcher uncompressedFilter, int uncompressedAlignment, boolean useZip64, int modificationTime, DataEntryWriter dataEntryWriter) {
        this(uncompressedFilter, uncompressedAlignment, useZip64, null, 1, modificationTime, dataEntryWriter);
    }

    public ZipWriter(StringMatcher uncompressedFilter, int uncompressedAlignment, boolean useZip64, StringMatcher extraUncompressedAlignmentFilter, int extraUncompressedAlignment, int modificationTime, DataEntryWriter dataEntryWriter) {
        this.uncompressedFilter = uncompressedFilter;
        this.uncompressedAlignment = uncompressedAlignment;
        this.useZip64 = useZip64;
        this.extraUncompressedAlignmentFilter = extraUncompressedAlignmentFilter;
        this.extraUncompressedAlignment = extraUncompressedAlignment;
        this.modificationTime = modificationTime;
        this.header = null;
        this.dataEntryWriter = dataEntryWriter;
    }

    public ZipWriter(StringMatcher uncompressedFilter, int uncompressedAlignment, boolean useZip64, int modificationTime, byte[] header, DataEntryWriter dataEntryWriter) {
        this(uncompressedFilter, uncompressedAlignment, useZip64, null, 1, modificationTime, header, dataEntryWriter);
    }

    public ZipWriter(StringMatcher uncompressedFilter, int uncompressedAlignment, StringMatcher extraUncompressedAlignmentFilter, int extraUncompressedAlignment, int modificationTime, byte[] header, DataEntryWriter dataEntryWriter) {
        this.uncompressedFilter = uncompressedFilter;
        this.uncompressedAlignment = uncompressedAlignment;
        this.useZip64 = false;
        this.extraUncompressedAlignmentFilter = extraUncompressedAlignmentFilter;
        this.extraUncompressedAlignment = extraUncompressedAlignment;
        this.modificationTime = modificationTime;
        this.header = header;
        this.dataEntryWriter = dataEntryWriter;
    }

    public ZipWriter(StringMatcher uncompressedFilter, int uncompressedAlignment, boolean useZip64, StringMatcher extraUncompressedAlignmentFilter, int extraUncompressedAlignment, int modificationTime, byte[] header, DataEntryWriter dataEntryWriter) {
        this.uncompressedFilter = uncompressedFilter;
        this.uncompressedAlignment = uncompressedAlignment;
        this.useZip64 = useZip64;
        this.extraUncompressedAlignmentFilter = extraUncompressedAlignmentFilter;
        this.extraUncompressedAlignment = extraUncompressedAlignment;
        this.modificationTime = modificationTime;
        this.header = header;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        this.finishIfNecessary(dataEntry);
        this.setUp(dataEntry);
        if (this.currentZipOutput == null) {
            return false;
        }
        String name = dataEntry.getName() + '/';
        OutputStream outputStream = this.currentZipOutput.createOutputStream(name, false, this.modificationTime);
        outputStream.close();
        return true;
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return dataEntry1 != null && dataEntry2 != null && dataEntry1.getName().equals(dataEntry2.getName()) && this.dataEntryWriter.sameOutputStream(dataEntry1.getParent(), dataEntry2.getParent());
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        this.finishIfNecessary(dataEntry);
        this.setUp(dataEntry);
        if (this.currentZipOutput == null) {
            return null;
        }
        String name = dataEntry.getName();
        String originalName = dataEntry.getOriginalName();
        boolean compress1 = this.uncompressedFilter == null || !this.uncompressedFilter.matches(originalName);
        boolean compress2 = this.extraUncompressedAlignmentFilter == null || !this.extraUncompressedAlignmentFilter.matches(originalName);
        int uncompressedAlignment = this.extraUncompressedAlignmentFilter == null || compress2 ? this.uncompressedAlignment : this.extraUncompressedAlignment;
        return this.currentZipOutput.createOutputStream(name, compress1 && compress2, uncompressedAlignment, this.modificationTime);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "ZipWriter (uncompressed filter = " + this.uncompressedFilter + ", alignment = " + this.uncompressedAlignment + ", extraAlignmentFilter = " + this.extraUncompressedAlignmentFilter + ", extraAlignment = " + this.extraUncompressedAlignment + ")");
        this.dataEntryWriter.println(pw, prefix + "  ");
    }

    private void setUp(DataEntry dataEntry) throws IOException {
        if (this.currentZipOutput == null) {
            this.currentParentEntry = dataEntry.getParent();
            this.currentZipOutput = this.createZipOutput(this.dataEntryWriter.createOutputStream(this.currentParentEntry), this.header, this.uncompressedAlignment, this.useZip64, null);
        }
    }

    protected ZipOutput createZipOutput(OutputStream outputStream, byte[] header, int uncompressedAlignment, boolean useZip64, String comment) throws IOException {
        return new ZipOutput(outputStream, header, uncompressedAlignment, useZip64, comment);
    }

    private void finishIfNecessary(DataEntry dataEntry) throws IOException {
        if (this.currentParentEntry != null && !this.dataEntryWriter.sameOutputStream(this.currentParentEntry, dataEntry.getParent())) {
            this.finish();
        }
    }

    private void finish() throws IOException {
        if (this.currentZipOutput != null) {
            this.currentZipOutput.close();
            this.currentParentEntry = null;
            this.currentZipOutput = null;
        }
    }
}

