/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.ClassMemberPair;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.CalledMemberVisitor;
import proguard.optimize.ReverseDependencyStore;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.util.MultiValueMap;

public class ReverseDependencyCalculator {
    private static final Logger logger = LogManager.getFormatterLogger(ReverseDependencyCalculator.class);
    private final ClassPool classPool;

    public ReverseDependencyCalculator(ClassPool classPool) {
        this.classPool = classPool;
    }

    public ReverseDependencyStore reverseDependencyStore() {
        long start = System.currentTimeMillis();
        ReverseDependencyStore out = new ReverseDependencyStore(this.isCalledBy(), this.methodsByProgramMethodOptimizationInfo());
        long end = System.currentTimeMillis();
        logger.trace("Calculating Reverse Dependencies................ took: %6d ms", (Object)(end - start));
        return out;
    }

    private MultiValueMap<Method, ClassMemberPair> isCalledBy() {
        MultiValueMap<Method, ClassMemberPair> isCalledBy = new MultiValueMap<Method, ClassMemberPair>();
        this.classPool.classesAccept(new AllMethodVisitor(new AddDependencies(isCalledBy)));
        return isCalledBy;
    }

    private MultiValueMap<ProgramMethodOptimizationInfo, Method> methodsByProgramMethodOptimizationInfo() {
        MultiValueMap<ProgramMethodOptimizationInfo, Method> map = new MultiValueMap<ProgramMethodOptimizationInfo, Method>();
        this.classPool.classesAccept(new AllMethodVisitor(new FillMethodsByProgramMethodOptimizationInfo(map)));
        return map;
    }

    private static class AddDependencies
    implements MemberVisitor {
        private final MultiValueMap<Method, ClassMemberPair> isCalledBy;

        AddDependencies(MultiValueMap<Method, ClassMemberPair> isCalledBy) {
            this.isCalledBy = isCalledBy;
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
            member.accept(clazz, new AllAttributeVisitor(new AllInstructionVisitor(new CalledMemberVisitor(new Adder(new ClassMemberPair(clazz, member))))));
        }

        private class Adder
        implements MemberVisitor {
            private final ClassMemberPair source;

            Adder(ClassMemberPair source) {
                this.source = source;
            }

            @Override
            public void visitAnyMember(Clazz clazz, Member member) {
            }

            @Override
            public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
                AddDependencies.this.isCalledBy.put(programMethod, this.source);
            }
        }
    }

    private static class FillMethodsByProgramMethodOptimizationInfo
    implements MemberVisitor {
        private final MultiValueMap<ProgramMethodOptimizationInfo, Method> map;

        public FillMethodsByProgramMethodOptimizationInfo(MultiValueMap<ProgramMethodOptimizationInfo, Method> map) {
            this.map = map;
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(programMethod);
            if (methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
                this.map.put((ProgramMethodOptimizationInfo)methodOptimizationInfo, programMethod);
            }
        }

        @Override
        public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        }

        @Override
        public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        }
    }
}

