/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.asamk.Signal;
import org.asamk.signal.BaseConfig;
import org.asamk.signal.dbus.DbusInterfacePropertiesHandler;
import org.asamk.signal.dbus.DbusProperties;
import org.asamk.signal.dbus.DbusProperty;
import org.asamk.signal.dbus.DbusReceiveMessageHandler;
import org.asamk.signal.dbus.DbusUtils;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.AttachmentInvalidException;
import org.asamk.signal.manager.api.CaptchaRejectedException;
import org.asamk.signal.manager.api.Configuration;
import org.asamk.signal.manager.api.Device;
import org.asamk.signal.manager.api.DeviceLimitExceededException;
import org.asamk.signal.manager.api.DeviceLinkUrl;
import org.asamk.signal.manager.api.Group;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupInviteLinkUrl;
import org.asamk.signal.manager.api.GroupLinkState;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupPermission;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.Identity;
import org.asamk.signal.manager.api.IdentityVerificationCode;
import org.asamk.signal.manager.api.InactiveGroupLinkException;
import org.asamk.signal.manager.api.InvalidDeviceLinkException;
import org.asamk.signal.manager.api.InvalidNumberException;
import org.asamk.signal.manager.api.InvalidStickerException;
import org.asamk.signal.manager.api.LastGroupAdminException;
import org.asamk.signal.manager.api.Message;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PendingAdminApprovalException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendGroupMessageResults;
import org.asamk.signal.manager.api.SendMessageResult;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.manager.api.StickerPackInvalidException;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.api.TypingAction;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.manager.api.UpdateGroup;
import org.asamk.signal.manager.api.UpdateProfile;
import org.asamk.signal.manager.api.UserStatus;
import org.asamk.signal.util.DateUtils;
import org.asamk.signal.util.SendMessageResultUtils;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.types.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbusSignalImpl
implements Signal,
AutoCloseable {
    private final Manager m;
    private final DBusConnection connection;
    private final String objectPath;
    private final boolean noReceiveOnStart;
    private DBusPath thisDevice;
    private final List<Signal.StructDevice> devices = new ArrayList<Signal.StructDevice>();
    private final List<Signal.StructGroup> groups = new ArrayList<Signal.StructGroup>();
    private final List<Signal.StructIdentity> identities = new ArrayList<Signal.StructIdentity>();
    private DbusReceiveMessageHandler dbusMessageHandler;
    private int subscriberCount;
    private static final Logger logger = LoggerFactory.getLogger(DbusSignalImpl.class);

    public DbusSignalImpl(Manager m, DBusConnection connection, String objectPath, boolean noReceiveOnStart) {
        this.m = m;
        this.connection = connection;
        this.objectPath = objectPath;
        this.noReceiveOnStart = noReceiveOnStart;
        m.addAddressChangedListener(() -> {
            this.unExportObjects();
            this.exportObjects();
        });
    }

    public void initObjects() {
        this.exportObjects();
        if (!this.noReceiveOnStart) {
            this.subscribeReceive();
        }
    }

    private void exportObjects() {
        this.exportObject(this);
        this.updateDevices();
        this.updateGroups();
        this.updateConfiguration();
        this.updateIdentities();
    }

    @Override
    public void close() {
        if (this.dbusMessageHandler != null) {
            this.m.removeReceiveHandler((Manager.ReceiveMessageHandler)this.dbusMessageHandler);
            this.dbusMessageHandler = null;
        }
        this.unExportObjects();
    }

    private void unExportObjects() {
        this.unExportDevices();
        this.unExportGroups();
        this.unExportConfiguration();
        this.unExportIdentities();
        this.connection.unExportObject(this.objectPath);
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    @Override
    public String getSelfNumber() {
        return this.m.getSelfNumber();
    }

    @Override
    public void subscribeReceive() {
        if (this.dbusMessageHandler == null) {
            this.dbusMessageHandler = new DbusReceiveMessageHandler(this.connection, this.objectPath);
            this.m.addReceiveHandler((Manager.ReceiveMessageHandler)this.dbusMessageHandler);
        }
        ++this.subscriberCount;
    }

    @Override
    public void unsubscribeReceive() {
        this.subscriberCount = Math.max(0, this.subscriberCount - 1);
        if (this.subscriberCount == 0 && this.dbusMessageHandler != null) {
            this.m.removeReceiveHandler((Manager.ReceiveMessageHandler)this.dbusMessageHandler);
            this.dbusMessageHandler = null;
        }
    }

    @Override
    public void submitRateLimitChallenge(String challenge, String captcha) {
        try {
            this.m.submitRateLimitRecaptchaChallenge(challenge, captcha);
        }
        catch (IOException e) {
            throw new Signal.Error.Failure("Submit challenge error: " + e.getMessage());
        }
        catch (CaptchaRejectedException e) {
            throw new Signal.Error.Failure("Captcha rejected, it may be outdated, already used or solved from a different IP address.");
        }
    }

    @Override
    public void unregister() throws Signal.Error.Failure {
        try {
            this.m.unregister();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure("Failed to unregister: " + e.getMessage());
        }
    }

    @Override
    public void deleteAccount() throws Signal.Error.Failure {
        try {
            this.m.deleteAccount();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure("Failed to delete account: " + e.getMessage());
        }
    }

    @Override
    public void addDevice(String uri) {
        try {
            DeviceLinkUrl deviceLinkUrl = DeviceLinkUrl.parseDeviceLinkUri((URI)new URI(uri));
            this.m.addDeviceLink(deviceLinkUrl);
        }
        catch (IOException | DeviceLimitExceededException | InvalidDeviceLinkException e) {
            throw new Signal.Error.Failure(e.getClass().getSimpleName() + " Add device link failed. " + e.getMessage());
        }
        catch (NotPrimaryDeviceException e) {
            throw new Signal.Error.Failure("This command doesn't work on linked devices.");
        }
        catch (URISyntaxException e) {
            throw new Signal.Error.InvalidUri(e.getClass().getSimpleName() + " Device link uri has invalid format: " + e.getMessage());
        }
    }

    @Override
    public DBusPath getDevice(long deviceId) {
        this.updateDevices();
        Optional<Signal.StructDevice> deviceOptional = this.devices.stream().filter(g -> g.getId().equals(deviceId)).findFirst();
        if (deviceOptional.isEmpty()) {
            throw new Signal.Error.DeviceNotFound("Device not found");
        }
        return deviceOptional.get().getObjectPath();
    }

    @Override
    public List<Signal.StructDevice> listDevices() {
        this.updateDevices();
        return this.devices;
    }

    @Override
    public DBusPath getThisDevice() {
        this.updateDevices();
        return this.thisDevice;
    }

    @Override
    public long sendMessage(String message, List<String> attachments, String recipient) {
        return this.sendMessage(message, attachments, List.of(recipient));
    }

    @Override
    public long sendMessage(String messageText, List<String> attachments, List<String> recipients) {
        try {
            Message message = new Message(messageText, attachments, List.of(), Optional.empty(), Optional.empty(), List.of(), Optional.empty(), List.of());
            Set recipientIdentifiers = DbusSignalImpl.getSingleRecipientIdentifiers(recipients, this.m.getSelfNumber()).stream().map(RecipientIdentifier.class::cast).collect(Collectors.toSet());
            SendMessageResults results = this.m.sendMessage(message, recipientIdentifiers, false);
            this.checkSendMessageResults(results);
            return results.timestamp();
        }
        catch (AttachmentInvalidException e) {
            throw new Signal.Error.AttachmentInvalid(e.getMessage());
        }
        catch (IOException | InvalidStickerException e) {
            throw new Signal.Error.Failure((Exception)e);
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    public long sendRemoteDeleteMessage(long targetSentTimestamp, String recipient) {
        return this.sendRemoteDeleteMessage(targetSentTimestamp, List.of(recipient));
    }

    @Override
    public long sendRemoteDeleteMessage(long targetSentTimestamp, List<String> recipients) {
        try {
            SendMessageResults results = this.m.sendRemoteDeleteMessage(targetSentTimestamp, DbusSignalImpl.getSingleRecipientIdentifiers(recipients, this.m.getSelfNumber()).stream().map(RecipientIdentifier.class::cast).collect(Collectors.toSet()));
            this.checkSendMessageResults(results);
            return results.timestamp();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
    }

    @Override
    public long sendMessageReaction(String emoji, boolean remove, String targetAuthor, long targetSentTimestamp, String recipient) {
        return this.sendMessageReaction(emoji, remove, targetAuthor, targetSentTimestamp, List.of(recipient));
    }

    @Override
    public long sendMessageReaction(String emoji, boolean remove, String targetAuthor, long targetSentTimestamp, List<String> recipients) {
        try {
            SendMessageResults results = this.m.sendMessageReaction(emoji, remove, DbusSignalImpl.getSingleRecipientIdentifier(targetAuthor, this.m.getSelfNumber()), targetSentTimestamp, DbusSignalImpl.getSingleRecipientIdentifiers(recipients, this.m.getSelfNumber()).stream().map(RecipientIdentifier.class::cast).collect(Collectors.toSet()), false);
            this.checkSendMessageResults(results);
            return results.timestamp();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    public long sendPaymentNotification(byte[] receipt, String note, String recipient) throws Signal.Error.Failure {
        try {
            SendMessageResults results = this.m.sendPaymentNotificationMessage(receipt, note, DbusSignalImpl.getSingleRecipientIdentifier(recipient, this.m.getSelfNumber()));
            this.checkSendMessageResults(results);
            return results.timestamp();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
    }

    @Override
    public void sendTyping(String recipient, boolean stop) throws Signal.Error.Failure, Signal.Error.GroupNotFound, Signal.Error.UntrustedIdentity {
        try {
            SendMessageResults results = this.m.sendTypingMessage(stop ? TypingAction.STOP : TypingAction.START, DbusSignalImpl.getSingleRecipientIdentifiers(List.of(recipient), this.m.getSelfNumber()).stream().map(RecipientIdentifier.class::cast).collect(Collectors.toSet()));
            this.checkSendMessageResults(results);
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
    }

    @Override
    public void sendReadReceipt(String recipient, List<Long> messageIds) throws Signal.Error.Failure, Signal.Error.UntrustedIdentity {
        SendMessageResults results = this.m.sendReadReceipt(DbusSignalImpl.getSingleRecipientIdentifier(recipient, this.m.getSelfNumber()), messageIds);
        this.checkSendMessageResults(results);
    }

    @Override
    public void sendViewedReceipt(String recipient, List<Long> messageIds) throws Signal.Error.Failure, Signal.Error.UntrustedIdentity {
        SendMessageResults results = this.m.sendViewedReceipt(DbusSignalImpl.getSingleRecipientIdentifier(recipient, this.m.getSelfNumber()), messageIds);
        this.checkSendMessageResults(results);
    }

    @Override
    public void sendContacts() {
        try {
            this.m.sendContacts();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure("SendContacts error: " + e.getMessage());
        }
    }

    @Override
    public void sendSyncRequest() {
        try {
            this.m.requestAllSyncData();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure("Request sync data error: " + e.getMessage());
        }
    }

    @Override
    public long sendNoteToSelfMessage(String messageText, List<String> attachments) throws Signal.Error.AttachmentInvalid, Signal.Error.Failure, Signal.Error.UntrustedIdentity {
        try {
            Message message = new Message(messageText, attachments, List.of(), Optional.empty(), Optional.empty(), List.of(), Optional.empty(), List.of());
            SendMessageResults results = this.m.sendMessage(message, Set.of(RecipientIdentifier.NoteToSelf.INSTANCE), false);
            this.checkSendMessageResults(results);
            return results.timestamp();
        }
        catch (AttachmentInvalidException e) {
            throw new Signal.Error.AttachmentInvalid(e.getMessage());
        }
        catch (IOException | InvalidStickerException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    public void sendEndSessionMessage(List<String> recipients) {
        try {
            SendMessageResults results = this.m.sendEndSessionMessage(DbusSignalImpl.getSingleRecipientIdentifiers(recipients, this.m.getSelfNumber()));
            this.checkSendMessageResults(results);
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
    }

    @Override
    public void deleteRecipient(String recipient) throws Signal.Error.Failure {
        this.m.deleteRecipient(DbusSignalImpl.getSingleRecipientIdentifier(recipient, this.m.getSelfNumber()));
    }

    @Override
    public void deleteContact(String recipient) throws Signal.Error.Failure {
        this.m.deleteContact(DbusSignalImpl.getSingleRecipientIdentifier(recipient, this.m.getSelfNumber()));
    }

    @Override
    public long sendGroupMessage(String messageText, List<String> attachments, byte[] groupId) {
        try {
            Message message = new Message(messageText, attachments, List.of(), Optional.empty(), Optional.empty(), List.of(), Optional.empty(), List.of());
            SendMessageResults results = this.m.sendMessage(message, Set.of(this.getGroupRecipientIdentifier(groupId)), false);
            this.checkSendMessageResults(results);
            return results.timestamp();
        }
        catch (IOException | InvalidStickerException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
        catch (AttachmentInvalidException e) {
            throw new Signal.Error.AttachmentInvalid(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    public void sendGroupTyping(byte[] groupId, boolean stop) throws Signal.Error.Failure, Signal.Error.GroupNotFound, Signal.Error.UntrustedIdentity {
        try {
            SendMessageResults results = this.m.sendTypingMessage(stop ? TypingAction.STOP : TypingAction.START, Set.of(this.getGroupRecipientIdentifier(groupId)));
            this.checkSendMessageResults(results);
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
    }

    @Override
    public long sendGroupRemoteDeleteMessage(long targetSentTimestamp, byte[] groupId) {
        try {
            SendMessageResults results = this.m.sendRemoteDeleteMessage(targetSentTimestamp, Set.of(this.getGroupRecipientIdentifier(groupId)));
            this.checkSendMessageResults(results);
            return results.timestamp();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
    }

    @Override
    public long sendGroupMessageReaction(String emoji, boolean remove, String targetAuthor, long targetSentTimestamp, byte[] groupId) {
        try {
            SendMessageResults results = this.m.sendMessageReaction(emoji, remove, DbusSignalImpl.getSingleRecipientIdentifier(targetAuthor, this.m.getSelfNumber()), targetSentTimestamp, Set.of(this.getGroupRecipientIdentifier(groupId)), false);
            this.checkSendMessageResults(results);
            return results.timestamp();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    public String getContactName(String number) {
        String name = this.m.getContactOrProfileName(DbusSignalImpl.getSingleRecipientIdentifier(number, this.m.getSelfNumber()));
        return name == null ? "" : name;
    }

    @Override
    public void setContactName(String number, String name) {
        try {
            this.m.setContactName(DbusSignalImpl.getSingleRecipientIdentifier(number, this.m.getSelfNumber()), name, "");
        }
        catch (NotPrimaryDeviceException e) {
            throw new Signal.Error.Failure("This command doesn't work on linked devices.");
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    public void setExpirationTimer(String number, int expiration) {
        try {
            this.m.setExpirationTimer(DbusSignalImpl.getSingleRecipientIdentifier(number, this.m.getSelfNumber()), expiration);
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    public void setContactBlocked(String number, boolean blocked) {
        try {
            this.m.setContactsBlocked(List.of(DbusSignalImpl.getSingleRecipientIdentifier(number, this.m.getSelfNumber())), blocked);
        }
        catch (NotPrimaryDeviceException e) {
            throw new Signal.Error.Failure("This command doesn't work on linked devices.");
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    @Deprecated
    public void setGroupBlocked(byte[] groupId, boolean blocked) {
        try {
            this.m.setGroupsBlocked(List.of(DbusSignalImpl.getGroupId(groupId)), blocked);
        }
        catch (NotPrimaryDeviceException e) {
            throw new Signal.Error.Failure("This command doesn't work on linked devices.");
        }
        catch (GroupNotFoundException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
    }

    @Override
    @Deprecated
    public List<byte[]> getGroupIds() {
        List groups = this.m.getGroups();
        return groups.stream().map(g -> g.groupId().serialize()).toList();
    }

    @Override
    public DBusPath getGroup(byte[] groupId) {
        this.updateGroups();
        Optional<Signal.StructGroup> groupOptional = this.groups.stream().filter(g -> Arrays.equals(g.getId(), groupId)).findFirst();
        if (groupOptional.isEmpty()) {
            throw new Signal.Error.GroupNotFound("Group not found");
        }
        return groupOptional.get().getObjectPath();
    }

    @Override
    public List<Signal.StructGroup> listGroups() {
        this.updateGroups();
        return this.groups;
    }

    @Override
    @Deprecated
    public String getGroupName(byte[] groupId) {
        Group group = this.m.getGroup(DbusSignalImpl.getGroupId(groupId));
        if (group == null || group.title() == null) {
            return "";
        }
        return group.title();
    }

    @Override
    @Deprecated
    public List<String> getGroupMembers(byte[] groupId) {
        Group group = this.m.getGroup(DbusSignalImpl.getGroupId(groupId));
        if (group == null) {
            return List.of();
        }
        Set members = group.members();
        return DbusSignalImpl.getRecipientStrings(members);
    }

    @Override
    public byte[] createGroup(String name, List<String> members, String avatar) throws Signal.Error.AttachmentInvalid, Signal.Error.Failure, Signal.Error.InvalidNumber {
        return this.updateGroupInternal(new byte[0], name, members, avatar);
    }

    @Override
    @Deprecated
    public byte[] updateGroup(byte[] groupId, String name, List<String> members, String avatar) {
        return this.updateGroupInternal(groupId, name, members, avatar);
    }

    public byte[] updateGroupInternal(byte[] groupId, String name, List<String> members, String avatar) {
        try {
            groupId = this.nullIfEmpty(groupId);
            name = this.nullIfEmpty(name);
            avatar = this.nullIfEmpty(avatar);
            Set<RecipientIdentifier.Single> memberIdentifiers = DbusSignalImpl.getSingleRecipientIdentifiers(members, this.m.getSelfNumber());
            if (groupId == null) {
                Pair results = this.m.createGroup(name, memberIdentifiers, avatar);
                this.updateGroups();
                DbusSignalImpl.checkGroupSendMessageResults(((SendGroupMessageResults)results.second()).timestamp(), ((SendGroupMessageResults)results.second()).results());
                return ((GroupId)results.first()).serialize();
            }
            SendGroupMessageResults results = this.m.updateGroup(DbusSignalImpl.getGroupId(groupId), UpdateGroup.newBuilder().withName(name).withMembers(memberIdentifiers).withAvatarFile(avatar).build());
            if (results != null) {
                DbusSignalImpl.checkGroupSendMessageResults(results.timestamp(), results.results());
            }
            return groupId;
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
        catch (AttachmentInvalidException e) {
            throw new Signal.Error.AttachmentInvalid(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    @Deprecated
    public boolean isRegistered() {
        return true;
    }

    @Override
    public boolean isRegistered(String number) {
        List<Boolean> result = this.isRegistered(List.of(number));
        return result.getFirst();
    }

    @Override
    public List<Boolean> isRegistered(List<String> numbers) {
        Map registered;
        if (numbers.isEmpty()) {
            return List.of();
        }
        try {
            registered = this.m.getUserStatus(new HashSet<String>(numbers));
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (RateLimitException e) {
            throw new Signal.Error.Failure(e.getMessage() + ", retry at " + DateUtils.formatTimestamp(e.getNextAttemptTimestamp()));
        }
        return numbers.stream().map(number -> ((UserStatus)registered.get(number)).uuid() != null).toList();
    }

    @Override
    public void updateProfile(String givenName, String familyName, String about, String aboutEmoji, String avatarPath, boolean removeAvatar) {
        try {
            givenName = this.nullIfEmpty(givenName);
            familyName = this.nullIfEmpty(familyName);
            about = this.nullIfEmpty(about);
            aboutEmoji = this.nullIfEmpty(aboutEmoji);
            avatarPath = this.nullIfEmpty(avatarPath);
            String avatarFile = removeAvatar || avatarPath == null ? null : avatarPath;
            this.m.updateProfile(UpdateProfile.newBuilder().withGivenName(givenName).withFamilyName(familyName).withAbout(about).withAboutEmoji(aboutEmoji).withAvatar(avatarFile).withDeleteAvatar(removeAvatar).build());
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
    }

    @Override
    public void updateProfile(String name, String about, String aboutEmoji, String avatarPath, boolean removeAvatar) {
        this.updateProfile(name, "", about, aboutEmoji, avatarPath, removeAvatar);
    }

    @Override
    public void removePin() {
        try {
            this.m.setRegistrationLockPin(Optional.empty());
        }
        catch (IOException e) {
            throw new Signal.Error.Failure("Remove pin error: " + e.getMessage());
        }
        catch (NotPrimaryDeviceException e) {
            throw new Signal.Error.Failure("This command doesn't work on linked devices.");
        }
    }

    @Override
    public void setPin(String registrationLockPin) {
        try {
            this.m.setRegistrationLockPin(Optional.of(registrationLockPin));
        }
        catch (IOException e) {
            throw new Signal.Error.Failure("Set pin error: " + e.getMessage());
        }
        catch (NotPrimaryDeviceException e) {
            throw new Signal.Error.Failure("This command doesn't work on linked devices.");
        }
    }

    @Override
    public String version() {
        return BaseConfig.PROJECT_VERSION;
    }

    @Override
    public List<String> listNumbers() {
        return this.m.getRecipients(false, Optional.empty(), Set.of(), Optional.empty()).stream().map(r -> r.getAddress().number().orElse(null)).filter(Objects::nonNull).distinct().toList();
    }

    @Override
    public List<String> getContactNumber(String name) {
        return this.m.getRecipients(false, Optional.empty(), Set.of(), Optional.of(name)).stream().map(r -> r.getAddress().getLegacyIdentifier()).toList();
    }

    @Override
    @Deprecated
    public void quitGroup(byte[] groupId) {
        GroupId group = DbusSignalImpl.getGroupId(groupId);
        try {
            this.m.quitGroup(group, Set.of());
        }
        catch (GroupNotFoundException | NotAGroupMemberException e) {
            throw new Signal.Error.GroupNotFound(e.getMessage());
        }
        catch (IOException | LastGroupAdminException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
        }
    }

    @Override
    public byte[] joinGroup(String groupLink) {
        try {
            GroupInviteLinkUrl linkUrl = GroupInviteLinkUrl.fromUri((String)groupLink);
            if (linkUrl == null) {
                throw new Signal.Error.Failure("Group link is invalid:");
            }
            Pair result = this.m.joinGroup(linkUrl);
            return ((GroupId)result.first()).serialize();
        }
        catch (PendingAdminApprovalException e) {
            throw new Signal.Error.Failure("Pending admin approval: " + e.getMessage());
        }
        catch (GroupInviteLinkUrl.InvalidGroupLinkException | InactiveGroupLinkException e) {
            throw new Signal.Error.Failure("Group link is invalid: " + e.getMessage());
        }
        catch (GroupInviteLinkUrl.UnknownGroupLinkVersionException e) {
            throw new Signal.Error.Failure("Group link was created with an incompatible version: " + e.getMessage());
        }
        catch (IOException e) {
            throw new Signal.Error.Failure(e.getMessage());
        }
    }

    @Override
    public boolean isContactBlocked(String number) {
        return this.m.isContactBlocked(DbusSignalImpl.getSingleRecipientIdentifier(number, this.m.getSelfNumber()));
    }

    @Override
    @Deprecated
    public boolean isGroupBlocked(byte[] groupId) {
        Group group = this.m.getGroup(DbusSignalImpl.getGroupId(groupId));
        if (group == null) {
            return false;
        }
        return group.isBlocked();
    }

    @Override
    @Deprecated
    public boolean isMember(byte[] groupId) {
        Group group = this.m.getGroup(DbusSignalImpl.getGroupId(groupId));
        if (group == null) {
            return false;
        }
        return group.isMember();
    }

    @Override
    public String uploadStickerPack(String stickerPackPath) {
        File path = new File(stickerPackPath);
        try {
            return this.m.uploadStickerPack(path).toString();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure("Upload error (maybe image size is too large):" + e.getMessage());
        }
        catch (StickerPackInvalidException e) {
            throw new Signal.Error.Failure("Invalid sticker pack: " + e.getMessage());
        }
    }

    private static void checkSendMessageResult(long timestamp, SendMessageResult result) throws DBusExecutionException {
        String error = SendMessageResultUtils.getErrorMessageFromSendMessageResult(result);
        if (error == null) {
            return;
        }
        String message = "\nFailed to send message:\n" + error + "\n" + timestamp;
        if (result.isIdentityFailure()) {
            throw new Signal.Error.UntrustedIdentity(message);
        }
        throw new Signal.Error.Failure(message);
    }

    private void checkSendMessageResults(SendMessageResults results) {
        Optional sendMessageResults = results.results().values().stream().findFirst();
        if (results.results().size() == 1 && ((List)sendMessageResults.get()).size() == 1) {
            DbusSignalImpl.checkSendMessageResult(results.timestamp(), (SendMessageResult)((List)sendMessageResults.get()).stream().findFirst().get());
            return;
        }
        if (results.hasSuccess()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("Failed to send messages:\n");
        List<String> errors = SendMessageResultUtils.getErrorMessagesFromSendMessageResults(results.results());
        for (String error : errors) {
            message.append(error).append('\n');
        }
        message.append(results.timestamp());
        throw new Signal.Error.Failure(message.toString());
    }

    private static void checkGroupSendMessageResults(long timestamp, Collection<SendMessageResult> results) throws DBusExecutionException {
        if (results.size() == 1) {
            DbusSignalImpl.checkSendMessageResult(timestamp, results.stream().findFirst().get());
            return;
        }
        List<String> errors = SendMessageResultUtils.getErrorMessagesFromSendMessageResults(results);
        if (errors.isEmpty() || errors.size() < results.size()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append("Failed to send message:\n");
        for (String error : errors) {
            message.append(error).append('\n');
        }
        message.append(timestamp);
        throw new Signal.Error.Failure(message.toString());
    }

    private static List<String> getRecipientStrings(Set<RecipientAddress> members) {
        return members.stream().map(RecipientAddress::getLegacyIdentifier).toList();
    }

    private static Set<RecipientIdentifier.Single> getSingleRecipientIdentifiers(Collection<String> recipientStrings, String localNumber) throws DBusExecutionException {
        HashSet<RecipientIdentifier.Single> identifiers = new HashSet<RecipientIdentifier.Single>();
        for (String recipientString : recipientStrings) {
            identifiers.add(DbusSignalImpl.getSingleRecipientIdentifier(recipientString, localNumber));
        }
        return identifiers;
    }

    private static RecipientIdentifier.Single getSingleRecipientIdentifier(String recipientString, String localNumber) throws DBusExecutionException {
        try {
            return RecipientIdentifier.Single.fromString((String)recipientString, (String)localNumber);
        }
        catch (InvalidNumberException e) {
            throw new Signal.Error.InvalidNumber(e.getMessage());
        }
    }

    private RecipientIdentifier.Group getGroupRecipientIdentifier(byte[] groupId) {
        return new RecipientIdentifier.Group(DbusSignalImpl.getGroupId(groupId));
    }

    private static GroupId getGroupId(byte[] groupId) throws DBusExecutionException {
        try {
            return GroupId.unknownVersion((byte[])groupId);
        }
        catch (Throwable e) {
            throw new Signal.Error.InvalidGroupId("Invalid group id: " + e.getMessage());
        }
    }

    private byte[] nullIfEmpty(byte[] array) {
        return array.length == 0 ? null : array;
    }

    private String nullIfEmpty(String name) {
        return name.isEmpty() ? null : name;
    }

    private String emptyIfNull(String string) {
        return string == null ? "" : string;
    }

    private static String getDeviceObjectPath(String basePath, long deviceId) {
        return basePath + "/Devices/" + deviceId;
    }

    private void updateDevices() {
        List linkedDevices;
        try {
            linkedDevices = this.m.getLinkedDevices();
        }
        catch (IOException e) {
            throw new Signal.Error.Failure("Failed to get linked devices: " + e.getMessage());
        }
        this.unExportDevices();
        linkedDevices.forEach(d -> {
            DbusSignalDeviceImpl object = new DbusSignalDeviceImpl((Device)d);
            String deviceObjectPath = object.getObjectPath();
            this.exportObject(object);
            if (d.isThisDevice()) {
                this.thisDevice = new DBusPath(deviceObjectPath);
            }
            this.devices.add(new Signal.StructDevice(new DBusPath(deviceObjectPath), Long.valueOf(d.id()), this.emptyIfNull(d.name())));
        });
    }

    private void unExportDevices() {
        this.devices.stream().map(Signal.StructDevice::getObjectPath).map(DBusPath::getPath).forEach(arg_0 -> ((DBusConnection)this.connection).unExportObject(arg_0));
        this.devices.clear();
    }

    private static String getGroupObjectPath(String basePath, byte[] groupId) {
        return basePath + "/Groups/" + DbusUtils.makeValidObjectPathElement(Base64.getEncoder().encodeToString(groupId));
    }

    private void updateGroups() {
        List groups = this.m.getGroups();
        this.unExportGroups();
        groups.forEach(g -> {
            DbusSignalGroupImpl object = new DbusSignalGroupImpl(g.groupId());
            this.exportObject(object);
            this.groups.add(new Signal.StructGroup(new DBusPath(object.getObjectPath()), g.groupId().serialize(), this.emptyIfNull(g.title())));
        });
    }

    private void unExportGroups() {
        this.groups.stream().map(Signal.StructGroup::getObjectPath).map(DBusPath::getPath).forEach(arg_0 -> ((DBusConnection)this.connection).unExportObject(arg_0));
        this.groups.clear();
    }

    private static String getConfigurationObjectPath(String basePath) {
        return basePath + "/Configuration";
    }

    private void updateConfiguration() {
        this.unExportConfiguration();
        DbusSignalConfigurationImpl object = new DbusSignalConfigurationImpl();
        this.exportObject(object);
    }

    private void unExportConfiguration() {
        String objectPath = DbusSignalImpl.getConfigurationObjectPath(this.objectPath);
        this.connection.unExportObject(objectPath);
    }

    private void exportObject(DBusInterface object) {
        try {
            this.connection.exportObject(object);
            logger.debug("Exported dbus object: " + object.getObjectPath());
        }
        catch (DBusException e) {
            logger.warn("Failed to export dbus object (" + object.getObjectPath() + "): " + e.getMessage());
        }
    }

    private void updateIdentities() {
        List identities = this.m.getIdentities();
        this.unExportIdentities();
        identities.forEach(i -> {
            DbusSignalIdentityImpl object = new DbusSignalIdentityImpl((Identity)i);
            this.exportObject(object);
            this.identities.add(new Signal.StructIdentity(new DBusPath(object.getObjectPath()), i.recipient().uuid().map(UUID::toString).orElse(""), i.recipient().number().orElse("")));
        });
    }

    private static String getIdentityObjectPath(String basePath, String id) {
        return basePath + "/Identities/" + DbusUtils.makeValidObjectPathElement(id);
    }

    private void unExportIdentities() {
        this.identities.stream().map(Signal.StructIdentity::getObjectPath).map(DBusPath::getPath).forEach(arg_0 -> ((DBusConnection)this.connection).unExportObject(arg_0));
        this.identities.clear();
    }

    @Override
    public DBusPath getIdentity(String number) throws Signal.Error.Failure {
        Optional<Signal.StructIdentity> found = this.identities.stream().filter(identity -> identity.getNumber().equals(number) || identity.getUuid().equals(number)).findFirst();
        if (found.isEmpty()) {
            throw new Signal.Error.Failure("Identity for " + number + " unknown");
        }
        return found.get().getObjectPath();
    }

    @Override
    public List<Signal.StructIdentity> listIdentities() {
        this.updateIdentities();
        return this.identities;
    }

    public class DbusSignalConfigurationImpl
    extends DbusProperties
    implements Signal.Configuration {
        public DbusSignalConfigurationImpl() {
            super.addPropertiesHandler(new DbusInterfacePropertiesHandler("org.asamk.Signal.Configuration", List.of(new DbusProperty<Boolean>("ReadReceipts", this::getReadReceipts, this::setReadReceipts), new DbusProperty<Boolean>("UnidentifiedDeliveryIndicators", this::getUnidentifiedDeliveryIndicators, this::setUnidentifiedDeliveryIndicators), new DbusProperty<Boolean>("TypingIndicators", this::getTypingIndicators, this::setTypingIndicators), new DbusProperty<Boolean>("LinkPreviews", this::getLinkPreviews, this::setLinkPreviews))));
        }

        public String getObjectPath() {
            return DbusSignalImpl.getConfigurationObjectPath(DbusSignalImpl.this.objectPath);
        }

        public void setReadReceipts(Boolean readReceipts) {
            this.setConfiguration(readReceipts, null, null, null);
        }

        public void setUnidentifiedDeliveryIndicators(Boolean unidentifiedDeliveryIndicators) {
            this.setConfiguration(null, unidentifiedDeliveryIndicators, null, null);
        }

        public void setTypingIndicators(Boolean typingIndicators) {
            this.setConfiguration(null, null, typingIndicators, null);
        }

        public void setLinkPreviews(Boolean linkPreviews) {
            this.setConfiguration(null, null, null, linkPreviews);
        }

        private void setConfiguration(Boolean readReceipts, Boolean unidentifiedDeliveryIndicators, Boolean typingIndicators, Boolean linkPreviews) {
            try {
                DbusSignalImpl.this.m.updateConfiguration(new Configuration(Optional.ofNullable(readReceipts), Optional.ofNullable(unidentifiedDeliveryIndicators), Optional.ofNullable(typingIndicators), Optional.ofNullable(linkPreviews)));
            }
            catch (NotPrimaryDeviceException e) {
                throw new Signal.Error.Failure("This command doesn't work on linked devices.");
            }
        }

        private boolean getReadReceipts() {
            return DbusSignalImpl.this.m.getConfiguration().readReceipts().orElse(false);
        }

        private boolean getUnidentifiedDeliveryIndicators() {
            return DbusSignalImpl.this.m.getConfiguration().unidentifiedDeliveryIndicators().orElse(false);
        }

        private boolean getTypingIndicators() {
            return DbusSignalImpl.this.m.getConfiguration().typingIndicators().orElse(false);
        }

        private boolean getLinkPreviews() {
            return DbusSignalImpl.this.m.getConfiguration().linkPreviews().orElse(false);
        }
    }

    public class DbusSignalIdentityImpl
    extends DbusProperties
    implements Signal.Identity {
        private final Identity identity;

        public DbusSignalIdentityImpl(Identity identity) {
            this.identity = identity;
            super.addPropertiesHandler(new DbusInterfacePropertiesHandler("org.asamk.Signal.Identity", List.of(new DbusProperty<String>("Number", () -> identity.recipient().number().orElse("")), new DbusProperty<String>("Uuid", () -> identity.recipient().uuid().map(UUID::toString).orElse("")), new DbusProperty<byte[]>("Fingerprint", () -> ((Identity)identity).fingerprint()), new DbusProperty<String>("SafetyNumber", () -> ((Identity)identity).safetyNumber()), new DbusProperty<byte[]>("ScannableSafetyNumber", () -> ((Identity)identity).scannableSafetyNumber()), new DbusProperty<TrustLevel>("TrustLevel", () -> ((Identity)identity).trustLevel()), new DbusProperty<Long>("AddedDate", () -> ((Identity)identity).dateAddedTimestamp()))));
        }

        public String getObjectPath() {
            return DbusSignalImpl.getIdentityObjectPath(DbusSignalImpl.this.objectPath, this.identity.recipient().getLegacyIdentifier() + "_" + this.identity.recipient().getIdentifier());
        }

        @Override
        public void trust() throws Signal.Error.Failure {
            RecipientIdentifier.Single recipient = RecipientIdentifier.Single.fromAddress((RecipientAddress)this.identity.recipient());
            try {
                DbusSignalImpl.this.m.trustIdentityAllKeys(recipient);
            }
            catch (UnregisteredRecipientException e) {
                throw new Signal.Error.Failure("The user " + e.getSender().getIdentifier() + " is not registered.");
            }
            DbusSignalImpl.this.updateIdentities();
        }

        @Override
        public void trustVerified(String safetyNumber) throws Signal.Error.Failure {
            IdentityVerificationCode verificationCode;
            RecipientIdentifier.Single recipient = RecipientIdentifier.Single.fromAddress((RecipientAddress)this.identity.recipient());
            if (safetyNumber == null) {
                throw new Signal.Error.Failure("You need to specify a fingerprint/safety number");
            }
            try {
                verificationCode = IdentityVerificationCode.parse((String)safetyNumber);
            }
            catch (Exception e) {
                throw new Signal.Error.Failure("Safety number has invalid format, either specify the old hex fingerprint or the new safety number");
            }
            try {
                boolean res = DbusSignalImpl.this.m.trustIdentityVerified(recipient, verificationCode);
                if (!res) {
                    throw new Signal.Error.Failure("Failed to set the trust for this number, make sure the number and the fingerprint/safety number are correct.");
                }
            }
            catch (UnregisteredRecipientException e) {
                throw new Signal.Error.Failure("The user " + e.getSender().getIdentifier() + " is not registered.");
            }
            DbusSignalImpl.this.updateIdentities();
        }
    }

    public class DbusSignalGroupImpl
    extends DbusProperties
    implements Signal.Group {
        private final GroupId groupId;

        public DbusSignalGroupImpl(GroupId groupId) {
            this.groupId = groupId;
            DbusProperty[] dbusPropertyArray = new DbusProperty[17];
            dbusPropertyArray[0] = new DbusProperty<byte[]>("Id", () -> ((GroupId)groupId).serialize());
            dbusPropertyArray[1] = new DbusProperty<String>("Name", () -> DbusSignalImpl.this.emptyIfNull(this.getGroup().title()), this::setGroupName);
            dbusPropertyArray[2] = new DbusProperty<String>("Description", () -> DbusSignalImpl.this.emptyIfNull(this.getGroup().description()), this::setGroupDescription);
            dbusPropertyArray[3] = new DbusProperty<String>("Avatar", this::setGroupAvatar);
            dbusPropertyArray[4] = new DbusProperty<Boolean>("IsBlocked", () -> this.getGroup().isBlocked(), this::setIsBlocked);
            dbusPropertyArray[5] = new DbusProperty<Boolean>("IsMember", () -> this.getGroup().isMember());
            dbusPropertyArray[6] = new DbusProperty<Boolean>("IsAdmin", () -> this.getGroup().isAdmin());
            dbusPropertyArray[7] = new DbusProperty<Integer>("MessageExpirationTimer", () -> this.getGroup().messageExpirationTimer(), this::setMessageExpirationTime);
            dbusPropertyArray[8] = new DbusProperty<Variant>("Members", () -> new Variant(DbusSignalImpl.getRecipientStrings(this.getGroup().members()), "as"));
            dbusPropertyArray[9] = new DbusProperty<Variant>("PendingMembers", () -> new Variant(DbusSignalImpl.getRecipientStrings(this.getGroup().pendingMembers()), "as"));
            dbusPropertyArray[10] = new DbusProperty<Variant>("RequestingMembers", () -> new Variant(DbusSignalImpl.getRecipientStrings(this.getGroup().requestingMembers()), "as"));
            dbusPropertyArray[11] = new DbusProperty<Variant>("Admins", () -> new Variant(DbusSignalImpl.getRecipientStrings(this.getGroup().adminMembers()), "as"));
            dbusPropertyArray[12] = new DbusProperty<Variant>("Banned", () -> new Variant(DbusSignalImpl.getRecipientStrings(this.getGroup().bannedMembers()), "as"));
            dbusPropertyArray[13] = new DbusProperty<String>("PermissionAddMember", () -> this.getGroup().permissionAddMember().name(), this::setGroupPermissionAddMember);
            dbusPropertyArray[14] = new DbusProperty<String>("PermissionEditDetails", () -> this.getGroup().permissionEditDetails().name(), this::setGroupPermissionEditDetails);
            dbusPropertyArray[15] = new DbusProperty<String>("PermissionSendMessage", () -> this.getGroup().permissionSendMessage().name(), this::setGroupPermissionSendMessage);
            dbusPropertyArray[16] = new DbusProperty<String>("GroupInviteLink", () -> {
                GroupInviteLinkUrl groupInviteLinkUrl = this.getGroup().groupInviteLinkUrl();
                return groupInviteLinkUrl == null ? "" : groupInviteLinkUrl.getUrl();
            });
            super.addPropertiesHandler(new DbusInterfacePropertiesHandler("org.asamk.Signal.Group", List.of(dbusPropertyArray)));
        }

        public String getObjectPath() {
            return DbusSignalImpl.getGroupObjectPath(DbusSignalImpl.this.objectPath, this.groupId.serialize());
        }

        @Override
        public void quitGroup() throws Signal.Error.Failure {
            try {
                DbusSignalImpl.this.m.quitGroup(this.groupId, Set.of());
            }
            catch (GroupNotFoundException e) {
                throw new Signal.Error.GroupNotFound(e.getMessage());
            }
            catch (NotAGroupMemberException e) {
                throw new Signal.Error.NotAGroupMember(e.getMessage());
            }
            catch (IOException e) {
                throw new Signal.Error.Failure(e.getMessage());
            }
            catch (LastGroupAdminException e) {
                throw new Signal.Error.LastGroupAdmin(e.getMessage());
            }
            catch (UnregisteredRecipientException e) {
                throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
            }
        }

        @Override
        public void deleteGroup() throws Signal.Error.Failure, Signal.Error.LastGroupAdmin {
            try {
                DbusSignalImpl.this.m.deleteGroup(this.groupId);
            }
            catch (IOException e) {
                throw new Signal.Error.Failure(e.getMessage());
            }
            DbusSignalImpl.this.updateGroups();
        }

        @Override
        public void addMembers(List<String> recipients) throws Signal.Error.Failure {
            Set<RecipientIdentifier.Single> memberIdentifiers = DbusSignalImpl.getSingleRecipientIdentifiers(recipients, DbusSignalImpl.this.m.getSelfNumber());
            this.updateGroup(UpdateGroup.newBuilder().withMembers(memberIdentifiers).build());
        }

        @Override
        public void removeMembers(List<String> recipients) throws Signal.Error.Failure {
            Set<RecipientIdentifier.Single> memberIdentifiers = DbusSignalImpl.getSingleRecipientIdentifiers(recipients, DbusSignalImpl.this.m.getSelfNumber());
            this.updateGroup(UpdateGroup.newBuilder().withRemoveMembers(memberIdentifiers).build());
        }

        @Override
        public void addAdmins(List<String> recipients) throws Signal.Error.Failure {
            Set<RecipientIdentifier.Single> memberIdentifiers = DbusSignalImpl.getSingleRecipientIdentifiers(recipients, DbusSignalImpl.this.m.getSelfNumber());
            this.updateGroup(UpdateGroup.newBuilder().withAdmins(memberIdentifiers).build());
        }

        @Override
        public void removeAdmins(List<String> recipients) throws Signal.Error.Failure {
            Set<RecipientIdentifier.Single> memberIdentifiers = DbusSignalImpl.getSingleRecipientIdentifiers(recipients, DbusSignalImpl.this.m.getSelfNumber());
            this.updateGroup(UpdateGroup.newBuilder().withRemoveAdmins(memberIdentifiers).build());
        }

        @Override
        public void resetLink() throws Signal.Error.Failure {
            this.updateGroup(UpdateGroup.newBuilder().withResetGroupLink(true).build());
        }

        @Override
        public void disableLink() throws Signal.Error.Failure {
            this.updateGroup(UpdateGroup.newBuilder().withGroupLinkState(GroupLinkState.DISABLED).build());
        }

        @Override
        public void enableLink(boolean requiresApproval) throws Signal.Error.Failure {
            this.updateGroup(UpdateGroup.newBuilder().withGroupLinkState(requiresApproval ? GroupLinkState.ENABLED_WITH_APPROVAL : GroupLinkState.ENABLED).build());
        }

        private Group getGroup() {
            return DbusSignalImpl.this.m.getGroup(this.groupId);
        }

        private void setGroupName(String name) {
            this.updateGroup(UpdateGroup.newBuilder().withName(name).build());
        }

        private void setGroupDescription(String description) {
            this.updateGroup(UpdateGroup.newBuilder().withDescription(description).build());
        }

        private void setGroupAvatar(String avatar) {
            this.updateGroup(UpdateGroup.newBuilder().withAvatarFile(avatar).build());
        }

        private void setMessageExpirationTime(int expirationTime) {
            this.updateGroup(UpdateGroup.newBuilder().withExpirationTimer(Integer.valueOf(expirationTime)).build());
        }

        private void setGroupPermissionAddMember(String permission) {
            this.updateGroup(UpdateGroup.newBuilder().withAddMemberPermission(GroupPermission.valueOf((String)permission)).build());
        }

        private void setGroupPermissionEditDetails(String permission) {
            this.updateGroup(UpdateGroup.newBuilder().withEditDetailsPermission(GroupPermission.valueOf((String)permission)).build());
        }

        private void setGroupPermissionSendMessage(String permission) {
            this.updateGroup(UpdateGroup.newBuilder().withIsAnnouncementGroup(Boolean.valueOf(GroupPermission.valueOf((String)permission) == GroupPermission.ONLY_ADMINS)).build());
        }

        private void setIsBlocked(boolean isBlocked) {
            try {
                DbusSignalImpl.this.m.setGroupsBlocked(List.of(this.groupId), isBlocked);
            }
            catch (NotPrimaryDeviceException e) {
                throw new Signal.Error.Failure("This command doesn't work on linked devices.");
            }
            catch (GroupNotFoundException e) {
                throw new Signal.Error.GroupNotFound(e.getMessage());
            }
            catch (IOException e) {
                throw new Signal.Error.Failure(e.getMessage());
            }
        }

        private void updateGroup(UpdateGroup updateGroup) {
            try {
                DbusSignalImpl.this.m.updateGroup(this.groupId, updateGroup);
            }
            catch (IOException e) {
                throw new Signal.Error.Failure(e.getMessage());
            }
            catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
                throw new Signal.Error.GroupNotFound(e.getMessage());
            }
            catch (AttachmentInvalidException e) {
                throw new Signal.Error.AttachmentInvalid(e.getMessage());
            }
            catch (UnregisteredRecipientException e) {
                throw new Signal.Error.UntrustedIdentity(e.getSender().getIdentifier() + " is not registered.");
            }
        }
    }

    public class DbusSignalDeviceImpl
    extends DbusProperties
    implements Signal.Device {
        private final Device device;

        public DbusSignalDeviceImpl(Device device) {
            super.addPropertiesHandler(new DbusInterfacePropertiesHandler("org.asamk.Signal.Device", List.of(new DbusProperty<Integer>("Id", () -> ((Device)device).id()), new DbusProperty<String>("Name", () -> DbusSignalImpl.this.emptyIfNull(device.name()), this::setDeviceName), new DbusProperty<Long>("Created", () -> ((Device)device).created()), new DbusProperty<Long>("LastSeen", () -> ((Device)device).lastSeen()))));
            this.device = device;
        }

        public String getObjectPath() {
            return DbusSignalImpl.getDeviceObjectPath(DbusSignalImpl.this.objectPath, this.device.id());
        }

        @Override
        public void removeDevice() throws Signal.Error.Failure {
            try {
                DbusSignalImpl.this.m.removeLinkedDevices(this.device.id());
                DbusSignalImpl.this.updateDevices();
            }
            catch (NotPrimaryDeviceException e) {
                throw new Signal.Error.Failure("This command doesn't work on linked devices.");
            }
            catch (IOException e) {
                throw new Signal.Error.Failure(e.getMessage());
            }
        }

        private void setDeviceName(String name) {
            if (!this.device.isThisDevice()) {
                throw new Signal.Error.Failure("Only the name of this device can be changed");
            }
            try {
                DbusSignalImpl.this.m.updateAccountAttributes(name, null, null, null);
                DbusSignalImpl.this.updateDevices();
            }
            catch (IOException e) {
                throw new Signal.Error.Failure(e.getMessage());
            }
        }
    }
}

