/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.asamk.signal.manager.actions.HandleAction;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.whispersystems.signalservice.api.messages.SignalServiceReceiptMessage;

public class SendReceiptAction
implements HandleAction {
    private final RecipientId recipientId;
    private final SignalServiceReceiptMessage.Type type;
    private final List<Long> timestamps = new ArrayList<Long>();

    public SendReceiptAction(RecipientId recipientId, SignalServiceReceiptMessage.Type type, long timestamp) {
        this.recipientId = recipientId;
        this.type = type;
        this.timestamps.add(timestamp);
    }

    @Override
    public void execute(Context context) throws Throwable {
        SignalServiceReceiptMessage receiptMessage = new SignalServiceReceiptMessage(this.type, this.timestamps, System.currentTimeMillis());
        context.getSendHelper().sendReceiptMessage(receiptMessage, this.recipientId);
    }

    @Override
    public void mergeOther(HandleAction action) {
        if (action instanceof SendReceiptAction) {
            SendReceiptAction sendReceiptAction = (SendReceiptAction)action;
            this.timestamps.addAll(sendReceiptAction.timestamps);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendReceiptAction that = (SendReceiptAction)o;
        return this.recipientId.equals(that.recipientId) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.recipientId, this.type);
    }
}

