/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.groups;

import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.whispersystems.signalservice.api.messages.SignalServiceDataMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceGroup;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupContext;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;

public class GroupUtils {
    public static void setGroupContext(SignalServiceDataMessage.Builder messageBuilder, GroupInfo groupInfo) {
        if (groupInfo instanceof GroupInfoV1) {
            SignalServiceGroup group = SignalServiceGroup.newBuilder((SignalServiceGroup.Type)SignalServiceGroup.Type.DELIVER).withId(groupInfo.getGroupId().serialize()).build();
            messageBuilder.asGroupMessage(group);
        } else {
            GroupInfoV2 groupInfoV2 = (GroupInfoV2)groupInfo;
            SignalServiceGroupV2 group = SignalServiceGroupV2.newBuilder((GroupMasterKey)groupInfoV2.getMasterKey()).withRevision(groupInfoV2.getGroup() == null ? 0 : groupInfoV2.getGroup().revision).build();
            messageBuilder.asGroupMessage(group);
        }
    }

    public static GroupId getGroupId(SignalServiceGroupContext context) {
        if (context.getGroupV1().isPresent()) {
            return GroupId.v1(((SignalServiceGroup)context.getGroupV1().get()).getGroupId());
        }
        if (context.getGroupV2().isPresent()) {
            return GroupUtils.getGroupIdV2(((SignalServiceGroupV2)context.getGroupV2().get()).getMasterKey());
        }
        return null;
    }

    public static GroupIdV2 getGroupIdV2(GroupSecretParams groupSecretParams) {
        return GroupId.v2(groupSecretParams.getPublicParams().getGroupIdentifier().serialize());
    }

    public static GroupIdV2 getGroupIdV2(GroupMasterKey groupMasterKey) {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey);
        return GroupUtils.getGroupIdV2(groupSecretParams);
    }

    public static GroupIdV2 getGroupIdV2(GroupIdV1 groupIdV1) {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)GroupUtils.deriveV2MigrationMasterKey(groupIdV1));
        return GroupUtils.getGroupIdV2(groupSecretParams);
    }

    private static GroupMasterKey deriveV2MigrationMasterKey(GroupIdV1 groupIdV1) {
        try {
            return new GroupMasterKey(HKDF.deriveSecrets((byte[])groupIdV1.serialize(), (byte[])"GV2 Migration".getBytes(), (int)32));
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

