/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.sessions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.helper.RecipientAddressResolver;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.asamk.signal.manager.storage.sessions.SessionStore;
import org.asamk.signal.manager.util.IOUtils;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.ServiceId;

public class LegacySessionStore {
    private static final Logger logger = LoggerFactory.getLogger(LegacySessionStore.class);
    static final Pattern sessionFileNamePattern = Pattern.compile("(\\d+)_(\\d+)");

    public static void migrate(File sessionsPath, RecipientResolver resolver, RecipientAddressResolver addressResolver, SessionStore sessionStore) {
        Collection<Key> keys = LegacySessionStore.getKeysLocked(sessionsPath, resolver);
        List<Pair<SessionStore.Key, SessionRecord>> sessions = keys.stream().map(key -> {
            SessionRecord record = LegacySessionStore.loadSessionLocked(key, sessionsPath);
            Optional<ServiceId> serviceId = addressResolver.resolveRecipientAddress(key.recipientId).serviceId();
            if (record == null || serviceId.isEmpty()) {
                return null;
            }
            return new Pair<SessionStore.Key, SessionRecord>(new SessionStore.Key(serviceId.get().toString(), key.deviceId()), record);
        }).filter(Objects::nonNull).toList();
        sessionStore.addLegacySessions(sessions);
        LegacySessionStore.deleteAllSessions(sessionsPath);
    }

    private static void deleteAllSessions(File sessionsPath) {
        File[] files = sessionsPath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.error("Failed to delete session file {}: {}", (Object)file, (Object)e.getMessage());
            }
        }
        try {
            Files.delete(sessionsPath.toPath());
        }
        catch (IOException e) {
            logger.error("Failed to delete session directory {}: {}", (Object)sessionsPath, (Object)e.getMessage());
        }
    }

    private static Collection<Key> getKeysLocked(File sessionsPath, RecipientResolver resolver) {
        File[] files = sessionsPath.listFiles();
        if (files == null) {
            return List.of();
        }
        return LegacySessionStore.parseFileNames(files, resolver);
    }

    private static List<Key> parseFileNames(File[] files, RecipientResolver resolver) {
        return Arrays.stream(files).map(f -> sessionFileNamePattern.matcher(f.getName())).filter(Matcher::matches).map(matcher -> {
            RecipientId recipientId = resolver.resolveRecipient(Long.parseLong(matcher.group(1)));
            if (recipientId == null) {
                return null;
            }
            return new Key(recipientId, Integer.parseInt(matcher.group(2)));
        }).filter(Objects::nonNull).toList();
    }

    private static File getSessionFile(Key key, File sessionsPath) {
        try {
            IOUtils.createPrivateDirectories(sessionsPath);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to create sessions path", e);
        }
        return new File(sessionsPath, key.recipientId().id() + "_" + key.deviceId());
    }

    private static SessionRecord loadSessionLocked(Key key, File sessionsPath) {
        SessionRecord sessionRecord;
        File file = LegacySessionStore.getSessionFile(key, sessionsPath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(file);
        try {
            sessionRecord = new SessionRecord(inputStream.readAllBytes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.warn("Failed to load session, resetting session: {}", (Object)e.getMessage());
                return null;
            }
        }
        inputStream.close();
        return sessionRecord;
    }

    record Key(RecipientId recipientId, int deviceId) {
    }
}

