/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import okio.ByteString;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.internal.push.PaymentAddress;

public class PaymentUtils {
    private static final Logger logger = LoggerFactory.getLogger(PaymentUtils.class);

    private PaymentUtils() {
    }

    public static PaymentAddress signPaymentsAddress(byte[] publicAddressBytes, ECPrivateKey privateKey) {
        byte[] signature = privateKey.calculateSignature(publicAddressBytes);
        return new PaymentAddress.Builder().mobileCoinAddress(new PaymentAddress.MobileCoinAddress.Builder().address(ByteString.of((byte[])publicAddressBytes)).signature(ByteString.of((byte[])signature)).build()).build();
    }

    public static byte[] verifyPaymentsAddress(PaymentAddress paymentAddress, ECPublicKey publicKey) {
        PaymentAddress.MobileCoinAddress mobileCoinAddress = paymentAddress.mobileCoinAddress;
        if (mobileCoinAddress == null || mobileCoinAddress.address == null || mobileCoinAddress.signature == null) {
            logger.debug("Got payment address without mobile coin address, ignoring.");
            return null;
        }
        byte[] bytes = mobileCoinAddress.address.toByteArray();
        byte[] signature = mobileCoinAddress.signature.toByteArray();
        if (signature.length != 64 || !publicKey.verifySignature(bytes, signature)) {
            logger.debug("Got mobile coin address with invalid signature, ignoring.");
            return null;
        }
        return bytes;
    }
}

