/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import io.reactivex.rxjava3.functions.Function;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.SignalWebSocket;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.PushNetworkException;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001f*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0007\u001e\u001f !\"#$B+\b\u0004\u0012\"\b\u0002\u0010\u0003\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0\u0004\u00a2\u0006\u0002\u0010\tJ6\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0000\"\u0004\b\u0001\u0010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00120\u0005J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0005J5\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002 \u0010\u0017\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0\u0018H\u0000\u00a2\u0006\u0002\b\u0019J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001a\u0010\u001a\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bJ\u000b\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ,\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0000\"\u0004\b\u0001\u0010\u00122\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00000\u0005R(\u0010\u0003\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0004%&\u0006'\u00a8\u0006("}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult;", "T", "", "statusCodeErrorActions", "", "Lkotlin/Function1;", "Lorg/whispersystems/signalservice/api/NetworkResult$StatusCodeError;", "", "Lorg/whispersystems/signalservice/api/StatusCodeErrorAction;", "(Ljava/util/Set;)V", "fallbackToFetch", "unless", "", "fallback", "Lorg/whispersystems/signalservice/api/NetworkResult$Fetcher;", "getCause", "", "map", "R", "transform", "runIfSuccessful", "result", "runOnStatusCodeError", "actions", "", "runOnStatusCodeError$signal_service_java", "action", "successOrThrow", "()Ljava/lang/Object;", "then", "ApplicationError", "Companion", "Fetcher", "NetworkError", "StatusCodeError", "Success", "WebSocketResponseConverter", "Lorg/whispersystems/signalservice/api/NetworkResult$ApplicationError;", "Lorg/whispersystems/signalservice/api/NetworkResult$NetworkError;", "Lorg/whispersystems/signalservice/api/NetworkResult$Success;", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nNetworkResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkResult.kt\norg/whispersystems/signalservice/api/NetworkResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n1855#2,2:274\n*S KotlinDebug\n*F\n+ 1 NetworkResult.kt\norg/whispersystems/signalservice/api/NetworkResult\n*L\n256#1:274,2\n*E\n"})
public abstract class NetworkResult<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Function1<StatusCodeError<?>, Unit>> statusCodeErrorActions;

    private NetworkResult(Set<Function1<StatusCodeError<?>, Unit>> statusCodeErrorActions) {
        this.statusCodeErrorActions = statusCodeErrorActions;
    }

    public /* synthetic */ NetworkResult(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        this(set, null);
    }

    public final T successOrThrow() {
        NetworkResult networkResult = this;
        if (networkResult instanceof Success) {
            return ((Success)this).getResult();
        }
        if (networkResult instanceof NetworkError) {
            throw ((NetworkError)this).getException();
        }
        if (networkResult instanceof StatusCodeError) {
            throw ((StatusCodeError)this).getException();
        }
        if (networkResult instanceof ApplicationError) {
            throw ((ApplicationError)this).getThrowable();
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    public final Throwable getCause() {
        Throwable throwable;
        NetworkResult networkResult = this;
        if (networkResult instanceof Success) {
            throwable = null;
        } else if (networkResult instanceof NetworkError) {
            throwable = ((NetworkError)this).getException();
        } else if (networkResult instanceof StatusCodeError) {
            throwable = ((StatusCodeError)this).getException();
        } else if (networkResult instanceof ApplicationError) {
            throwable = ((ApplicationError)this).getThrowable();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return throwable;
    }

    @NotNull
    public final <R> NetworkResult<R> map(@NotNull Function1<? super T, ? extends R> transform) {
        NetworkResult<T> networkResult;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        NetworkResult networkResult2 = this;
        if (networkResult2 instanceof Success) {
            networkResult = new Success<Object>(transform.invoke(((Success)this).getResult())).runOnStatusCodeError$signal_service_java((Collection)this.statusCodeErrorActions);
        } else if (networkResult2 instanceof NetworkError) {
            networkResult = new NetworkError(((NetworkError)this).getException()).runOnStatusCodeError$signal_service_java((Collection)this.statusCodeErrorActions);
        } else if (networkResult2 instanceof ApplicationError) {
            networkResult = new ApplicationError(((ApplicationError)this).getThrowable()).runOnStatusCodeError$signal_service_java((Collection)this.statusCodeErrorActions);
        } else if (networkResult2 instanceof StatusCodeError) {
            networkResult = new StatusCodeError(((StatusCodeError)this).getCode(), ((StatusCodeError)this).getBody(), ((StatusCodeError)this).getException()).runOnStatusCodeError$signal_service_java((Collection)this.statusCodeErrorActions);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return networkResult;
    }

    @NotNull
    public final NetworkResult<T> fallbackToFetch(@NotNull Function1<? super NetworkResult<T>, Boolean> unless, @NotNull Fetcher<T> fallback) {
        Intrinsics.checkNotNullParameter(unless, (String)"unless");
        Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
        if (this instanceof Success) {
            return this;
        }
        return (Boolean)unless.invoke((Object)this) != false ? Companion.fromFetch(fallback) : this;
    }

    public static /* synthetic */ NetworkResult fallbackToFetch$default(NetworkResult networkResult, Function1 function1, Fetcher fetcher, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fallbackToFetch");
        }
        if ((n & 1) != 0) {
            function1 = fallbackToFetch.1.INSTANCE;
        }
        return networkResult.fallbackToFetch(function1, fetcher);
    }

    @NotNull
    public final <R> NetworkResult<R> then(@NotNull Function1<? super T, ? extends NetworkResult<R>> result2) {
        NetworkResult<T> networkResult;
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NetworkResult networkResult2 = this;
        if (networkResult2 instanceof Success) {
            networkResult = ((NetworkResult)result2.invoke(((Success)this).getResult())).runOnStatusCodeError$signal_service_java((Collection)this.statusCodeErrorActions);
        } else if (networkResult2 instanceof NetworkError) {
            networkResult = new NetworkError(((NetworkError)this).getException()).runOnStatusCodeError$signal_service_java((Collection)this.statusCodeErrorActions);
        } else if (networkResult2 instanceof ApplicationError) {
            networkResult = new ApplicationError(((ApplicationError)this).getThrowable()).runOnStatusCodeError$signal_service_java((Collection)this.statusCodeErrorActions);
        } else if (networkResult2 instanceof StatusCodeError) {
            networkResult = new StatusCodeError(((StatusCodeError)this).getCode(), ((StatusCodeError)this).getBody(), ((StatusCodeError)this).getException()).runOnStatusCodeError$signal_service_java((Collection)this.statusCodeErrorActions);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return networkResult;
    }

    @NotNull
    public final NetworkResult<T> runIfSuccessful(@NotNull Function1<? super T, Unit> result2) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (this instanceof Success) {
            result2.invoke(((Success)this).getResult());
        }
        return this;
    }

    @NotNull
    public final NetworkResult<T> runOnStatusCodeError(@NotNull Function1<? super StatusCodeError<?>, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.runOnStatusCodeError$signal_service_java(SetsKt.setOf(action));
    }

    @NotNull
    public final NetworkResult<T> runOnStatusCodeError$signal_service_java(@NotNull Collection<? extends Function1<? super StatusCodeError<?>, Unit>> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        if (actions.isEmpty()) {
            return this;
        }
        CollectionsKt.addAll((Collection)this.statusCodeErrorActions, (Iterable)actions);
        if (this instanceof StatusCodeError) {
            Iterable $this$forEach$iv = this.statusCodeErrorActions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)this);
            }
            this.statusCodeErrorActions.clear();
        }
        return this;
    }

    @JvmStatic
    @NotNull
    public static final <T> NetworkResult<T> fromFetch(@NotNull Fetcher<T> fetcher) {
        return Companion.fromFetch(fetcher);
    }

    @JvmStatic
    @NotNull
    public static final <T> NetworkResult<T> fromWebSocketRequest(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request, @NotNull KClass<T> clazz) {
        return Companion.fromWebSocketRequest(signalWebSocket, request, clazz);
    }

    @JvmStatic
    @NotNull
    public static final <T> NetworkResult<T> fromWebSocketRequest(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request, @NotNull WebSocketResponseConverter<T> webSocketResponseConverter) {
        return Companion.fromWebSocketRequest(signalWebSocket, request, webSocketResponseConverter);
    }

    public /* synthetic */ NetworkResult(Set statusCodeErrorActions, DefaultConstructorMarker $constructor_marker) {
        this(statusCodeErrorActions);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$ApplicationError;", "T", "Lorg/whispersystems/signalservice/api/NetworkResult;", "throwable", "", "(Ljava/lang/Throwable;)V", "getThrowable", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
    public static final class ApplicationError<T>
    extends NetworkResult<T> {
        @NotNull
        private final Throwable throwable;

        public ApplicationError(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            super(null, 1, null);
            this.throwable = throwable;
        }

        @NotNull
        public final Throwable getThrowable() {
            return this.throwable;
        }

        @NotNull
        public final Throwable component1() {
            return this.throwable;
        }

        @NotNull
        public final ApplicationError<T> copy(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            return new ApplicationError<T>(throwable);
        }

        public static /* synthetic */ ApplicationError copy$default(ApplicationError applicationError, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                throwable = applicationError.throwable;
            }
            return applicationError.copy(throwable);
        }

        @NotNull
        public String toString() {
            return "ApplicationError(throwable=" + this.throwable + ")";
        }

        public int hashCode() {
            return this.throwable.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ApplicationError)) {
                return false;
            }
            ApplicationError applicationError = (ApplicationError)other;
            return Intrinsics.areEqual((Object)this.throwable, (Object)applicationError.throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0007J6\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000eH\u0007J6\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$Companion;", "", "()V", "fromFetch", "Lorg/whispersystems/signalservice/api/NetworkResult;", "T", "fetcher", "Lorg/whispersystems/signalservice/api/NetworkResult$Fetcher;", "fromWebSocketRequest", "signalWebSocket", "Lorg/whispersystems/signalservice/api/SignalWebSocket;", "request", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "clazz", "Lkotlin/reflect/KClass;", "webSocketResponseConverter", "Lorg/whispersystems/signalservice/api/NetworkResult$WebSocketResponseConverter;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> NetworkResult<T> fromFetch(@NotNull Fetcher<T> fetcher) {
            NetworkResult networkResult;
            Intrinsics.checkNotNullParameter(fetcher, (String)"fetcher");
            try {
                networkResult = new Success<T>(fetcher.fetch());
            }
            catch (NonSuccessfulResponseCodeException e) {
                networkResult = new StatusCodeError(e);
            }
            catch (IOException e) {
                networkResult = new NetworkError(e);
            }
            catch (Throwable e) {
                networkResult = new ApplicationError(e);
            }
            return networkResult;
        }

        @JvmStatic
        @NotNull
        public final <T> NetworkResult<T> fromWebSocketRequest(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request, @NotNull KClass<T> clazz) {
            NetworkResult networkResult;
            Intrinsics.checkNotNullParameter((Object)signalWebSocket, (String)"signalWebSocket");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            try {
                Object result2;
                Object object = signalWebSocket.request(request).map(new Function(clazz){
                    final /* synthetic */ KClass<T> $clazz;
                    {
                        this.$clazz = $clazz;
                    }

                    @NotNull
                    public final Object apply-IoAF18A(@NotNull WebsocketResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        return Result.constructor-impl(JsonUtil.fromJson(response.getBody(), JvmClassMappingKt.getJavaClass(this.$clazz)));
                    }
                }).onErrorReturn(Companion::fromWebSocketRequest$lambda$0).blockingGet();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"blockingGet(...)");
                Object object2 = result2 = ((Result)object).unbox-impl();
                ResultKt.throwOnFailure((Object)object2);
                networkResult = new Success<Object>(object2);
            }
            catch (NonSuccessfulResponseCodeException e) {
                networkResult = new StatusCodeError(e);
            }
            catch (IOException e) {
                networkResult = new NetworkError(e);
            }
            catch (TimeoutException e) {
                networkResult = new NetworkError(new PushNetworkException(e));
            }
            catch (Throwable e) {
                networkResult = new ApplicationError(e);
            }
            return networkResult;
        }

        @JvmStatic
        @NotNull
        public final <T> NetworkResult<T> fromWebSocketRequest(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request, @NotNull WebSocketResponseConverter<T> webSocketResponseConverter) {
            NetworkResult networkResult;
            Intrinsics.checkNotNullParameter((Object)signalWebSocket, (String)"signalWebSocket");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            Intrinsics.checkNotNullParameter(webSocketResponseConverter, (String)"webSocketResponseConverter");
            try {
                Object object = signalWebSocket.request(request).map(new Function(webSocketResponseConverter){
                    final /* synthetic */ WebSocketResponseConverter<T> $webSocketResponseConverter;
                    {
                        this.$webSocketResponseConverter = $webSocketResponseConverter;
                    }

                    @NotNull
                    public final T apply(@NotNull WebsocketResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        return this.$webSocketResponseConverter.convert(response);
                    }
                }).blockingGet();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"blockingGet(...)");
                Object result2 = object;
                networkResult = new Success<Object>(result2);
            }
            catch (NonSuccessfulResponseCodeException e) {
                networkResult = new StatusCodeError(e);
            }
            catch (IOException e) {
                networkResult = new NetworkError(e);
            }
            catch (Throwable e) {
                networkResult = new ApplicationError(e);
            }
            return networkResult;
        }

        private static final Result fromWebSocketRequest$lambda$0(Throwable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\r\u0010\u0003\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$Fetcher;", "T", "", "fetch", "()Ljava/lang/Object;", "signal-service-java"})
    public static interface Fetcher<T> {
        public T fetch() throws Exception;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$NetworkError;", "T", "Lorg/whispersystems/signalservice/api/NetworkResult;", "exception", "Ljava/io/IOException;", "(Ljava/io/IOException;)V", "getException", "()Ljava/io/IOException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
    public static final class NetworkError<T>
    extends NetworkResult<T> {
        @NotNull
        private final IOException exception;

        public NetworkError(@NotNull IOException exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            super(null, 1, null);
            this.exception = exception;
        }

        @NotNull
        public final IOException getException() {
            return this.exception;
        }

        @NotNull
        public final IOException component1() {
            return this.exception;
        }

        @NotNull
        public final NetworkError<T> copy(@NotNull IOException exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            return new NetworkError<T>(exception);
        }

        public static /* synthetic */ NetworkError copy$default(NetworkError networkError, IOException iOException, int n, Object object) {
            if ((n & 1) != 0) {
                iOException = networkError.exception;
            }
            return networkError.copy(iOException);
        }

        @NotNull
        public String toString() {
            return "NetworkError(exception=" + this.exception + ")";
        }

        public int hashCode() {
            return this.exception.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NetworkError)) {
                return false;
            }
            NetworkError networkError = (NetworkError)other;
            return Intrinsics.areEqual((Object)this.exception, (Object)networkError.exception);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J/\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$StatusCodeError;", "T", "Lorg/whispersystems/signalservice/api/NetworkResult;", "e", "Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "(Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;)V", "code", "", "body", "", "exception", "(ILjava/lang/String;Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;)V", "getBody", "()Ljava/lang/String;", "getCode", "()I", "getException", "()Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "signal-service-java"})
    public static final class StatusCodeError<T>
    extends NetworkResult<T> {
        private final int code;
        @Nullable
        private final String body;
        @NotNull
        private final NonSuccessfulResponseCodeException exception;

        public StatusCodeError(int code, @Nullable String body, @NotNull NonSuccessfulResponseCodeException exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            super(null, 1, null);
            this.code = code;
            this.body = body;
            this.exception = exception;
        }

        public final int getCode() {
            return this.code;
        }

        @Nullable
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final NonSuccessfulResponseCodeException getException() {
            return this.exception;
        }

        public StatusCodeError(@NotNull NonSuccessfulResponseCodeException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this(e.getCode(), e.getBody(), e);
        }

        public final int component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.body;
        }

        @NotNull
        public final NonSuccessfulResponseCodeException component3() {
            return this.exception;
        }

        @NotNull
        public final StatusCodeError<T> copy(int code, @Nullable String body, @NotNull NonSuccessfulResponseCodeException exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            return new StatusCodeError<T>(code, body, exception);
        }

        public static /* synthetic */ StatusCodeError copy$default(StatusCodeError statusCodeError, int n, String string, NonSuccessfulResponseCodeException nonSuccessfulResponseCodeException, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = statusCodeError.code;
            }
            if ((n2 & 2) != 0) {
                string = statusCodeError.body;
            }
            if ((n2 & 4) != 0) {
                nonSuccessfulResponseCodeException = statusCodeError.exception;
            }
            return statusCodeError.copy(n, string, nonSuccessfulResponseCodeException);
        }

        @NotNull
        public String toString() {
            return "StatusCodeError(code=" + this.code + ", body=" + this.body + ", exception=" + this.exception + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.code);
            result2 = result2 * 31 + (this.body == null ? 0 : this.body.hashCode());
            result2 = result2 * 31 + this.exception.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StatusCodeError)) {
                return false;
            }
            StatusCodeError statusCodeError = (StatusCodeError)other;
            if (this.code != statusCodeError.code) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.body, (Object)statusCodeError.body)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.exception, (Object)statusCodeError.exception);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$Success;", "T", "Lorg/whispersystems/signalservice/api/NetworkResult;", "result", "(Ljava/lang/Object;)V", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lorg/whispersystems/signalservice/api/NetworkResult$Success;", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
    public static final class Success<T>
    extends NetworkResult<T> {
        private final T result;

        public Success(T result2) {
            super(null, 1, null);
            this.result = result2;
        }

        public final T getResult() {
            return this.result;
        }

        public final T component1() {
            return this.result;
        }

        @NotNull
        public final Success<T> copy(T result2) {
            return new Success<T>(result2);
        }

        public static /* synthetic */ Success copy$default(Success success, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = success.result;
            }
            return success.copy(object);
        }

        @NotNull
        public String toString() {
            return "Success(result=" + this.result + ")";
        }

        public int hashCode() {
            return this.result == null ? 0 : this.result.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            return Intrinsics.areEqual(this.result, success.result);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00012\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$WebSocketResponseConverter;", "T", "", "convert", "response", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "(Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;)Ljava/lang/Object;", "signal-service-java"})
    public static interface WebSocketResponseConverter<T> {
        public T convert(@NotNull WebsocketResponse var1) throws Exception;
    }
}

