/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * XenodreambuieV2
 * @reference
 *https://fractalforums.org/share-a-fractal/22/new-mandelbulb-variant/5083

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_xenodreambuie_v3.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 XenodreambuieV3Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL t; // temp
	if (fractal->transformCommon.functionEnabledPFalse
			&& aux->i >= fractal->transformCommon.startIterationsP
			&& aux->i < fractal->transformCommon.stopIterationsP)
	{
		if (fractal->transformCommon.functionEnabledCxFalse) z.x = fabs(z.x);
		if (fractal->transformCommon.functionEnabledCyFalse) z.y = fabs(z.y);
		if (fractal->transformCommon.functionEnabledCzFalse) z.z = fabs(z.z);
		z += fractal->transformCommon.offsetA000;

		if (fractal->transformCommon.functionEnabledTFalse)
		{
			aux->r = length(z);
		}
	}

	// cartesian to polar, rotate and scale
	if (!fractal->transformCommon.functionEnabledSwFalse)
		t = asin(z.z / aux->r);
	else
		t = acos(z.z / aux->r);
	t = (t + fractal->bulb.betaAngleOffset);
	REAL th = t * fractal->bulb.power * fractal->transformCommon.scaleA1;

	REAL ph = (atan2(z.y, z.x) + fractal->bulb.alphaAngleOffset) * fractal->bulb.power
						* fractal->transformCommon.scaleB1;

	REAL rp = pow(aux->r, fractal->bulb.power - fractal->transformCommon.offset1);
	aux->DE = rp * aux->DE * fabs(fractal->bulb.power) + fractal->analyticDE.offset1;
	rp *= aux->r;

	// xenodreambuie conditional variations
	if (fractal->transformCommon.functionEnabledXFalse
			&& aux->i >= fractal->transformCommon.startIterationsX
			&& aux->i < fractal->transformCommon.stopIterationsX)
	{
		if (native_cos(th) < 0.0f) ph = ph + M_PI_F;
	}

	if (fractal->transformCommon.functionEnabledYFalse
			&& aux->i >= fractal->transformCommon.startIterationsY
			&& aux->i < fractal->transformCommon.stopIterationsY)
	{
		if (fabs(t) > 0.5f * M_PI_F) t = sign(t) * M_PI_F - t;
		th = t * fractal->bulb.power * fractal->transformCommon.scaleA1;
	}

	// polar to cartesian
	if (!fractal->transformCommon.functionEnabledDFalse)
	{
		REAL cth = native_cos(th);
		z.x = cth * native_cos(ph) * rp;
		z.y = cth * native_sin(ph) * rp;
		z.z = native_sin(th) * rp;
	}
	else
	{
		REAL sth = native_sin(th);
		z.x = sth * native_cos(ph) * rp;
		z.y = sth * native_sin(ph) * rp;
		z.z = native_cos(th) * rp;
	}

	// minimum signed offset
	if (fractal->transformCommon.functionEnabledAxFalse)
	{
		if (!fractal->transformCommon.functionEnabledAyFalse)
		{
			z.x = sign(z.x) * min(fabs(z.x), fractal->transformCommon.offsetA0 - fabs(z.x));
			z.y = sign(z.y) * min(fabs(z.y), fractal->transformCommon.offsetA0 - fabs(z.y));
		}
		else
		{
			z.x = sign(aux->const_c.x) * min(fabs(z.x), fractal->transformCommon.offsetA0 - fabs(z.x));
			z.y = sign(aux->const_c.y) * min(fabs(z.y), fractal->transformCommon.offsetA0 - fabs(z.y));
		}
	}
	if (fractal->transformCommon.functionEnabledBxFalse)
	{
		if (!fractal->transformCommon.functionEnabledByFalse)
		{
			z.z = sign(z.z) * min((z.z), fractal->transformCommon.offsetB0 - (z.z));
		}
		else
		{
			z.z = sign(aux->const_c.z) * min((z.z), fractal->transformCommon.offsetB0 - (z.z));
		}
	}

	z += fractal->transformCommon.offset000; // julia

	z *= fractal->transformCommon.scaleC1;
	aux->DE *= fabs(fractal->transformCommon.scaleC1);

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;

	if (fractal->transformCommon.functionEnabledCFalse)
	{
		aux->DE0 = length(z);

		if (aux->DE0 > 1.0f)
		{
			aux->DE0 = 0.5f * log(aux->DE0) * aux->DE0 / (aux->DE);
		}
		else
		{
			aux->DE0 = 0.0f; // 0.01f artifacts in openCL
		}
		aux->dist = aux->DE0;
	}
	return z;
}