// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#ifndef GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_GOLDEN_THING_ADMIN_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_GOLDEN_THING_ADMIN_CONNECTION_H

#include "generator/integration_tests/golden/v1/golden_thing_admin_connection_idempotency_policy.h"
#include "generator/integration_tests/golden/v1/internal/golden_thing_admin_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <generator/integration_tests/backup.pb.h>
#include <generator/integration_tests/test.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `GoldenThingAdminConnection`.
class GoldenThingAdminRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<GoldenThingAdminRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `GoldenThingAdminConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kDeadlineExceeded`](@ref google::cloud::StatusCode)
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class GoldenThingAdminLimitedErrorCountRetryPolicy : public GoldenThingAdminRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit GoldenThingAdminLimitedErrorCountRetryPolicy(int maximum_failures)
    : impl_(maximum_failures) {}

  GoldenThingAdminLimitedErrorCountRetryPolicy(
      GoldenThingAdminLimitedErrorCountRetryPolicy&& rhs) noexcept
    : GoldenThingAdminLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  GoldenThingAdminLimitedErrorCountRetryPolicy(
      GoldenThingAdminLimitedErrorCountRetryPolicy const& rhs) noexcept
    : GoldenThingAdminLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<GoldenThingAdminRetryPolicy> clone() const override {
    return std::make_unique<GoldenThingAdminLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = GoldenThingAdminRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<golden_v1_internal::GoldenThingAdminRetryTraits> impl_;
};

/**
 * A retry policy for `GoldenThingAdminConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kDeadlineExceeded`](@ref google::cloud::StatusCode)
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class GoldenThingAdminLimitedTimeRetryPolicy : public GoldenThingAdminRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit GoldenThingAdminLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
    : impl_(maximum_duration) {}

  GoldenThingAdminLimitedTimeRetryPolicy(GoldenThingAdminLimitedTimeRetryPolicy&& rhs) noexcept
    : GoldenThingAdminLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  GoldenThingAdminLimitedTimeRetryPolicy(GoldenThingAdminLimitedTimeRetryPolicy const& rhs) noexcept
    : GoldenThingAdminLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<GoldenThingAdminRetryPolicy> clone() const override {
    return std::make_unique<GoldenThingAdminLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = GoldenThingAdminRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<golden_v1_internal::GoldenThingAdminRetryTraits> impl_;
};

/**
 * The `GoldenThingAdminConnection` object for `GoldenThingAdminClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `GoldenThingAdminClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `GoldenThingAdminClient`.
 *
 * To create a concrete instance, see `MakeGoldenThingAdminConnection()`.
 *
 * For mocking, see `golden_v1_mocks::MockGoldenThingAdminConnection`.
 */
class GoldenThingAdminConnection {
 public:
  virtual ~GoldenThingAdminConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::test::admin::database::v1::Database>
  ListDatabases(google::test::admin::database::v1::ListDatabasesRequest request);

  virtual future<StatusOr<google::test::admin::database::v1::Database>>
  CreateDatabase(google::test::admin::database::v1::CreateDatabaseRequest const& request);

  virtual StatusOr<google::longrunning::Operation>
  CreateDatabase(NoAwaitTag, google::test::admin::database::v1::CreateDatabaseRequest const& request);

  virtual future<StatusOr<google::test::admin::database::v1::Database>>
  CreateDatabase( google::longrunning::Operation const& operation);

  virtual StatusOr<google::test::admin::database::v1::Database>
  GetDatabase(google::test::admin::database::v1::GetDatabaseRequest const& request);

  virtual future<StatusOr<google::test::admin::database::v1::UpdateDatabaseDdlMetadata>>
  UpdateDatabaseDdl(google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request);

  virtual StatusOr<google::longrunning::Operation>
  UpdateDatabaseDdl(NoAwaitTag, google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request);

  virtual future<StatusOr<google::test::admin::database::v1::UpdateDatabaseDdlMetadata>>
  UpdateDatabaseDdl( google::longrunning::Operation const& operation);

  virtual Status
  DropDatabase(google::test::admin::database::v1::DropDatabaseRequest const& request);

  virtual StatusOr<google::test::admin::database::v1::GetDatabaseDdlResponse>
  GetDatabaseDdl(google::test::admin::database::v1::GetDatabaseDdlRequest const& request);

  virtual StatusOr<google::iam::v1::Policy>
  SetIamPolicy(google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy>
  GetIamPolicy(google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);

  virtual future<StatusOr<google::test::admin::database::v1::Backup>>
  CreateBackup(google::test::admin::database::v1::CreateBackupRequest const& request);

  virtual StatusOr<google::longrunning::Operation>
  CreateBackup(NoAwaitTag, google::test::admin::database::v1::CreateBackupRequest const& request);

  virtual future<StatusOr<google::test::admin::database::v1::Backup>>
  CreateBackup( google::longrunning::Operation const& operation);

  virtual StatusOr<google::test::admin::database::v1::Backup>
  GetBackup(google::test::admin::database::v1::GetBackupRequest const& request);

  virtual StatusOr<google::test::admin::database::v1::Backup>
  UpdateBackup(google::test::admin::database::v1::UpdateBackupRequest const& request);

  virtual Status
  DeleteBackup(google::test::admin::database::v1::DeleteBackupRequest const& request);

  virtual StreamRange<google::test::admin::database::v1::Backup>
  ListBackups(google::test::admin::database::v1::ListBackupsRequest request);

  virtual future<StatusOr<google::test::admin::database::v1::Database>>
  RestoreDatabase(google::test::admin::database::v1::RestoreDatabaseRequest const& request);

  virtual StatusOr<google::longrunning::Operation>
  RestoreDatabase(NoAwaitTag, google::test::admin::database::v1::RestoreDatabaseRequest const& request);

  virtual future<StatusOr<google::test::admin::database::v1::Database>>
  RestoreDatabase( google::longrunning::Operation const& operation);

  virtual StreamRange<google::longrunning::Operation>
  ListDatabaseOperations(google::test::admin::database::v1::ListDatabaseOperationsRequest request);

  virtual StreamRange<google::longrunning::Operation>
  ListBackupOperations(google::test::admin::database::v1::ListBackupOperationsRequest request);

  virtual future<StatusOr<google::test::admin::database::v1::Database>>
  LongRunningWithoutRouting(google::test::admin::database::v1::RestoreDatabaseRequest const& request);

  virtual StatusOr<google::longrunning::Operation>
  LongRunningWithoutRouting(NoAwaitTag, google::test::admin::database::v1::RestoreDatabaseRequest const& request);

  virtual future<StatusOr<google::test::admin::database::v1::Database>>
  LongRunningWithoutRouting( google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::test::admin::database::v1::Database>>
  AsyncGetDatabase(google::test::admin::database::v1::GetDatabaseRequest const& request);

  virtual future<Status>
  AsyncDropDatabase(google::test::admin::database::v1::DropDatabaseRequest const& request);
};

/**
 * A factory function to construct an object of type `GoldenThingAdminConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of GoldenThingAdminClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `GoldenThingAdminConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::golden_v1::GoldenThingAdminPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `GoldenThingAdminConnection` created by
 * this function.
 */
std::shared_ptr<GoldenThingAdminConnection> MakeGoldenThingAdminConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_GOLDEN_THING_ADMIN_CONNECTION_H
