// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/automl/v1/service.proto

#include "google/cloud/automl/v1/auto_ml_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace automl_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AutoMlConnectionIdempotencyPolicy::~AutoMlConnectionIdempotencyPolicy() =
    default;

std::unique_ptr<AutoMlConnectionIdempotencyPolicy>
AutoMlConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AutoMlConnectionIdempotencyPolicy>(*this);
}

Idempotency AutoMlConnectionIdempotencyPolicy::CreateDataset(
    google::cloud::automl::v1::CreateDatasetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::GetDataset(
    google::cloud::automl::v1::GetDatasetRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::ListDatasets(
    google::cloud::automl::v1::ListDatasetsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::UpdateDataset(
    google::cloud::automl::v1::UpdateDatasetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::DeleteDataset(
    google::cloud::automl::v1::DeleteDatasetRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::ImportData(
    google::cloud::automl::v1::ImportDataRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::ExportData(
    google::cloud::automl::v1::ExportDataRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::GetAnnotationSpec(
    google::cloud::automl::v1::GetAnnotationSpecRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::CreateModel(
    google::cloud::automl::v1::CreateModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::GetModel(
    google::cloud::automl::v1::GetModelRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::ListModels(
    google::cloud::automl::v1::ListModelsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::DeleteModel(
    google::cloud::automl::v1::DeleteModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::UpdateModel(
    google::cloud::automl::v1::UpdateModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::DeployModel(
    google::cloud::automl::v1::DeployModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::UndeployModel(
    google::cloud::automl::v1::UndeployModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::ExportModel(
    google::cloud::automl::v1::ExportModelRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::GetModelEvaluation(
    google::cloud::automl::v1::GetModelEvaluationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AutoMlConnectionIdempotencyPolicy::ListModelEvaluations(
    google::cloud::automl::v1::ListModelEvaluationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<AutoMlConnectionIdempotencyPolicy>
MakeDefaultAutoMlConnectionIdempotencyPolicy() {
  return std::make_unique<AutoMlConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace automl_v1
}  // namespace cloud
}  // namespace google
