// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/cloudquotas/v1/cloudquotas.proto

#include "google/cloud/cloudquotas/v1/internal/cloud_quotas_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudquotas_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudQuotasTracingStub::CloudQuotasTracingStub(
    std::shared_ptr<CloudQuotasStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::api::cloudquotas::v1::ListQuotaInfosResponse>
CloudQuotasTracingStub::ListQuotaInfos(
    grpc::ClientContext& context, Options const& options,
    google::api::cloudquotas::v1::ListQuotaInfosRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.api.cloudquotas.v1.CloudQuotas",
                                     "ListQuotaInfos");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListQuotaInfos(context, options, request));
}

StatusOr<google::api::cloudquotas::v1::QuotaInfo>
CloudQuotasTracingStub::GetQuotaInfo(
    grpc::ClientContext& context, Options const& options,
    google::api::cloudquotas::v1::GetQuotaInfoRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.api.cloudquotas.v1.CloudQuotas",
                                     "GetQuotaInfo");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetQuotaInfo(context, options, request));
}

StatusOr<google::api::cloudquotas::v1::ListQuotaPreferencesResponse>
CloudQuotasTracingStub::ListQuotaPreferences(
    grpc::ClientContext& context, Options const& options,
    google::api::cloudquotas::v1::ListQuotaPreferencesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.api.cloudquotas.v1.CloudQuotas",
                                     "ListQuotaPreferences");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListQuotaPreferences(context, options, request));
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasTracingStub::GetQuotaPreference(
    grpc::ClientContext& context, Options const& options,
    google::api::cloudquotas::v1::GetQuotaPreferenceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.api.cloudquotas.v1.CloudQuotas",
                                     "GetQuotaPreference");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetQuotaPreference(context, options, request));
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasTracingStub::CreateQuotaPreference(
    grpc::ClientContext& context, Options const& options,
    google::api::cloudquotas::v1::CreateQuotaPreferenceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.api.cloudquotas.v1.CloudQuotas",
                                     "CreateQuotaPreference");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateQuotaPreference(context, options, request));
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasTracingStub::UpdateQuotaPreference(
    grpc::ClientContext& context, Options const& options,
    google::api::cloudquotas::v1::UpdateQuotaPreferenceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.api.cloudquotas.v1.CloudQuotas",
                                     "UpdateQuotaPreference");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateQuotaPreference(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<CloudQuotasStub> MakeCloudQuotasTracingStub(
    std::shared_ptr<CloudQuotasStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<CloudQuotasTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudquotas_v1_internal
}  // namespace cloud
}  // namespace google
