// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/group_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_INTERNAL_GROUP_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_INTERNAL_GROUP_CONNECTION_IMPL_H

#include "google/cloud/monitoring/v3/group_connection.h"
#include "google/cloud/monitoring/v3/group_connection_idempotency_policy.h"
#include "google/cloud/monitoring/v3/group_options.h"
#include "google/cloud/monitoring/v3/internal/group_retry_traits.h"
#include "google/cloud/monitoring/v3/internal/group_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GroupServiceConnectionImpl
    : public monitoring_v3::GroupServiceConnection {
 public:
  ~GroupServiceConnectionImpl() override = default;

  GroupServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<monitoring_v3_internal::GroupServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::monitoring::v3::Group> ListGroups(
      google::monitoring::v3::ListGroupsRequest request) override;

  StatusOr<google::monitoring::v3::Group> GetGroup(
      google::monitoring::v3::GetGroupRequest const& request) override;

  StatusOr<google::monitoring::v3::Group> CreateGroup(
      google::monitoring::v3::CreateGroupRequest const& request) override;

  StatusOr<google::monitoring::v3::Group> UpdateGroup(
      google::monitoring::v3::UpdateGroupRequest const& request) override;

  Status DeleteGroup(
      google::monitoring::v3::DeleteGroupRequest const& request) override;

  StreamRange<google::api::MonitoredResource> ListGroupMembers(
      google::monitoring::v3::ListGroupMembersRequest request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<monitoring_v3_internal::GroupServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MONITORING_V3_INTERNAL_GROUP_CONNECTION_IMPL_H
